/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.weight.lily;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.DungeonsWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.WeightStruct;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Map;

public class LilyDungeonsWeight
extends DungeonsWeight {
    private final JsonObject profileJson;

    public LilyDungeonsWeight(Map<String, ProfileViewer.Level> player, JsonObject profileJson) {
        super(player);
        this.profileJson = profileJson;
    }

    @Override
    public void getDungeonWeight() {
        ProfileViewer.Level catacombs = (ProfileViewer.Level)this.player.get("catacombs");
        double extra = 0.0;
        double n = 0.0;
        if (catacombs.totalXp < 5.6980966E8f) {
            n = 0.2 * Math.pow(catacombs.level / 50.0f, 1.538679118869934);
        } else {
            extra = 500.0 * Math.pow((double)(catacombs.totalXp - 5.6980966E8f) / 1.4245241E8, 0.5611906023908191);
        }
        if (catacombs.level != 0.0f) {
            if (catacombs.totalXp < 5.6980966E8f) {
                this.weightStruct.add(new WeightStruct(Utils.getElement(Constants.WEIGHT, "lily.dungeons.overall").getAsDouble() * ((Math.pow(1.1834040128616405, catacombs.level + 1.0f) - 1.05994990217254) * (1.0 + n))));
            } else {
                this.weightStruct.add(new WeightStruct((4100.0 + extra) * 2.0));
            }
        }
    }

    public void getDungeonCompletionWeight(String cataMode) {
        JsonObject dungeonsCompletionWorth = Utils.getElement(Constants.WEIGHT, "lily.dungeons.completion_worth").getAsJsonObject();
        JsonObject dungeonsCompletionBuffs = Utils.getElement(Constants.WEIGHT, "lily.dungeons.completion_buffs").getAsJsonObject();
        double max1000 = 0.0;
        double mMax1000 = 0.0;
        for (Map.Entry<String, JsonElement> dcwEntry : dungeonsCompletionWorth.entrySet()) {
            if (dcwEntry.getKey().startsWith("catacombs_")) {
                max1000 += dcwEntry.getValue().getAsDouble();
                continue;
            }
            mMax1000 += dcwEntry.getValue().getAsDouble();
        }
        max1000 *= 1000.0;
        mMax1000 *= 1000.0;
        double upperBound = 1500.0;
        double score = 0.0;
        if (cataMode.equals("normal")) {
            if (Utils.getElement(this.profileJson, "dungeons.dungeon_types.catacombs.tier_completions") == null) {
                return;
            }
            for (Map.Entry<String, JsonElement> normalFloor : Utils.getElement(this.profileJson, "dungeons.dungeon_types.catacombs.tier_completions").getAsJsonObject().entrySet()) {
                if (!dungeonsCompletionWorth.has("catacombs_" + normalFloor.getKey())) continue;
                int amount = normalFloor.getValue().getAsInt();
                double excess = 0.0;
                if (amount > 1000) {
                    excess = amount - 1000;
                    amount = 1000;
                }
                double floorScore = (double)amount * dungeonsCompletionWorth.get("catacombs_" + normalFloor.getKey()).getAsDouble();
                if (excess > 0.0) {
                    floorScore *= Math.log(excess / 1000.0 + 1.0) / Math.log(7.5) + 1.0;
                }
                score += floorScore;
            }
            this.weightStruct.add(new WeightStruct(score / max1000 * upperBound * 2.0));
        } else {
            if (Utils.getElement(this.profileJson, "dungeons.dungeon_types.master_catacombs.tier_completions") == null) {
                return;
            }
            for (Map.Entry<String, JsonElement> masterFloor : Utils.getElement(this.profileJson, "dungeons.dungeon_types.master_catacombs.tier_completions").getAsJsonObject().entrySet()) {
                int amount;
                if (dungeonsCompletionBuffs.has(masterFloor.getKey())) {
                    double threshold;
                    amount = masterFloor.getValue().getAsInt();
                    upperBound = (double)amount >= (threshold = 20.0) ? (upperBound += (double)dungeonsCompletionBuffs.get(masterFloor.getKey()).getAsInt()) : (upperBound += (double)dungeonsCompletionBuffs.get(masterFloor.getKey()).getAsInt() * Math.pow((double)amount / threshold, 1.840896416));
                }
                if (!dungeonsCompletionWorth.has("master_catacombs_" + masterFloor.getKey())) continue;
                amount = masterFloor.getValue().getAsInt();
                double excess = 0.0;
                if (amount > 1000) {
                    excess = amount - 1000;
                    amount = 1000;
                }
                double floorScore = (double)amount * dungeonsCompletionWorth.get("master_catacombs_" + masterFloor.getKey()).getAsDouble();
                if (excess > 0.0) {
                    floorScore *= Math.log(excess / 1000.0 + 1.0) / Math.log(6.0) + 1.0;
                }
                score += floorScore;
            }
            this.weightStruct.add(new WeightStruct(score / mMax1000 * upperBound * 2.0));
        }
    }
}

