/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.rift;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.ArrowPagesUtils;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class RiftPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_rift = new ResourceLocation("notenoughupdates:pv_rift.png");
    int pages = 0;
    int onPage = 0;
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    boolean inInventory = true;
    int guiLeft;
    int guiTop;
    private final ItemStack fillerStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), 1, 15);

    public RiftPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        block39: {
            List<JsonObject> inventoryContents;
            int inventoryY;
            int inventoryX;
            JsonObject riftInventory;
            APIDataJson.Rift rift;
            block40: {
                List<JsonObject> enderChestContents;
                List<JsonObject> equipmentData;
                APIDataJson.Rift.RiftInventory.Inventory riftEquipment;
                List<JsonObject> armorData;
                this.guiLeft = GuiProfileViewer.getGuiLeft();
                this.guiTop = GuiProfileViewer.getGuiTop();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_rift);
                Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
                SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
                if (selectedProfile == null) {
                    this.drawErrorMessage();
                    return;
                }
                JsonObject profileInfo2 = selectedProfile.getProfileJson();
                APIDataJson data = selectedProfile.getAPIDataJson();
                if (!profileInfo2.has("rift") || data == null || data.rift == null) {
                    this.drawErrorMessage();
                    return;
                }
                rift = data.rift;
                JsonObject riftData = profileInfo2.getAsJsonObject("rift");
                riftInventory = riftData.getAsJsonObject("inventory");
                APIDataJson.Rift.RiftInventory.Inventory riftArmor = rift.inventory.inv_armor;
                if (riftArmor != null && (armorData = riftArmor.readItems()) != null) {
                    this.drawArmorAndEquipment(armorData, this.guiLeft, this.guiTop, 27, 64, mouseX, mouseY, true);
                }
                if ((riftEquipment = rift.inventory.equipment_contents) != null && (equipmentData = riftEquipment.readItems()) != null) {
                    this.drawArmorAndEquipment(equipmentData, this.guiLeft, this.guiTop, 46, 64, mouseX, mouseY, false);
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                Utils.drawTexturedRect(this.guiLeft + 35, this.guiTop + 156, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                APIDataJson.Rift.RiftDeadCats deadCats = rift.dead_cats;
                if (deadCats != null && deadCats.found_cats != null) {
                    List<String> foundCats = deadCats.found_cats;
                    int size = foundCats.size();
                    int riftTime = size * 15;
                    int manaRegen = size * 2;
                    APIDataJson.Rift.RiftDeadCats.Pet montezuma = deadCats.montezuma;
                    if (montezuma != null && !"UNKNOWN".equals(montezuma.type)) {
                        PetInfoOverlay.Pet pet = new PetInfoOverlay.Pet();
                        pet.petLevel = new PetLeveling.PetLevel(100, 100, 0L, 0L, 0.0f, montezuma.exp.longValue());
                        pet.rarity = PetInfoOverlay.Rarity.valueOf(montezuma.tier);
                        pet.petType = montezuma.type;
                        pet.candyUsed = montezuma.candyUsed;
                        ItemStack petItemStackFromPetInfo = ItemUtils.createPetItemstackFromPetInfo(pet);
                        Utils.drawItemStack(petItemStackFromPetInfo, this.guiLeft + 37, this.guiTop + 158, true);
                        if (mouseX > this.guiLeft + 37 && mouseX < this.guiLeft + 37 + 20 && mouseY > this.guiTop + 158 && mouseY < this.guiTop + 158 + 20) {
                            List tooltip = petItemStackFromPetInfo.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                            ListIterator<String> iterator = tooltip.listIterator();
                            while (iterator.hasNext()) {
                                String next2 = (String)iterator.next();
                                if (next2.startsWith("\u00a77Found: \u00a79")) {
                                    iterator.set("\u00a77Found: \u00a79" + size + "/9 Soul Pieces");
                                    continue;
                                }
                                if (next2.startsWith("\u00a77Rift Time: \u00a7a+")) {
                                    iterator.set("\u00a77Rift Time: \u00a7a+" + riftTime + "s");
                                    continue;
                                }
                                if (!next2.startsWith("\u00a77Mana Regen: \u00a7a") || pet.rarity != PetInfoOverlay.Rarity.EPIC) continue;
                                iterator.set("\u00a77Mana Regen: \u00a7a+" + manaRegen + "%");
                            }
                            this.getInstance().tooltipToDisplay = tooltip;
                        }
                    } else if (size > 0) {
                        String montezumaError = EnumChatFormatting.RED + "Could not get pet";
                        Utils.drawStringCentered(montezumaError, (float)this.guiLeft + 45.5f, (float)(this.guiTop + 158 + 10), true, 0);
                    }
                }
                float motesPurse = data.currencies.motes_purse;
                Utils.drawStringCenteredScaledMaxWidth("\u00a7dMotes: \u00a7f" + Utils.shortNumberFormat(motesPurse, 0), this.guiLeft + 45, this.guiTop + 16, true, 84, 0);
                if (mouseX > this.guiLeft + 3 && mouseX < this.guiLeft + 90 && mouseY > this.guiTop + 3 && mouseY < this.guiTop + 25) {
                    int stats = data.player_stats.rift.lifetime_motes_earned;
                    this.getInstance().tooltipToDisplay = Collections.singletonList("\u00a7dLifetime Motes: \u00a7f" + Utils.shortNumberFormat(stats, 0));
                }
                if (rift.gallery != null && rift.gallery.secured_trophies != null) {
                    JsonArray timecharm = rift.gallery.secured_trophies;
                    Utils.renderAlignedString(EnumChatFormatting.RED + "Timecharms:", EnumChatFormatting.WHITE.toString() + timecharm.size() + "/7", this.guiLeft + 336, this.guiTop + 39, 83);
                    if (mouseX > this.guiLeft + 336 && mouseX < this.guiLeft + 336 + 80 && mouseY > this.guiTop + 39 && mouseY < this.guiTop + 39 + 15) {
                        ArrayList<String> displayNames = new ArrayList<String>();
                        for (JsonElement jsonElement : timecharm) {
                            String timecharmType = jsonElement.getAsJsonObject().get("type").getAsString().toUpperCase(Locale.ROOT);
                            ItemStack timecharmItem = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName("RIFT_TROPHY_" + timecharmType).resolveToItemStack();
                            if (timecharmItem != null) {
                                displayNames.add(timecharmItem.func_82833_r() + "\u00a77: \u00a7a\u2714");
                                continue;
                            }
                            displayNames.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.BOLD + "ERROR LOADING TIMECHARM!");
                            displayNames.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.BOLD + "PLEASE REPORT THIS AT " + EnumChatFormatting.GOLD + "discord.gg/moulberry");
                            displayNames.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.BOLD + "WITH THE FOLLOWING TEXT: " + EnumChatFormatting.AQUA + timecharmType);
                        }
                        this.getInstance().tooltipToDisplay = displayNames;
                    }
                    this.renderItem("GLASS", 316, 36, this.guiLeft, this.guiTop);
                }
                int grubberStacks = rift.castle.grubber_stacks;
                Utils.renderAlignedString(EnumChatFormatting.GOLD + "Burger:", EnumChatFormatting.WHITE.toString() + grubberStacks + "/5", this.guiLeft + 331, this.guiTop + 87, 83);
                this.renderItem("MCGRUBBER_BURGER", 314, 84, this.guiLeft, this.guiTop);
                ProfileViewer.Level vampire = selectedProfile.getLevelingInfo().get("vampire");
                Utils.renderAlignedString("\u00a76Vampire", EnumChatFormatting.WHITE.toString() + (int)vampire.level, this.guiLeft + 336, this.guiTop + 61, 60);
                if (vampire.maxed) {
                    this.getInstance().renderGoldBar(this.guiLeft + 320, this.guiTop + 71, 90.0f);
                } else {
                    this.getInstance().renderBar(this.guiLeft + 320, this.guiTop + 71, 90.0f, vampire.level % 1.0f);
                }
                if (mouseX > this.guiLeft + 300 && mouseX < this.guiLeft + 410 && mouseY > this.guiTop + 58 && mouseY < this.guiTop + 80) {
                    List<String> tooltipToDisplay = this.getInstance().tooltipToDisplay = new ArrayList<String>();
                    tooltipToDisplay.add("\u00a76Vampire Slayer");
                    if (vampire.maxed) {
                        tooltipToDisplay.add(EnumChatFormatting.GRAY + "Progress: " + EnumChatFormatting.GOLD + "MAXED!");
                    } else {
                        int maxXp = (int)vampire.maxXpForLevel;
                        this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GRAY + "Progress: " + EnumChatFormatting.DARK_PURPLE + StringUtils.shortNumberFormat(Math.round(vampire.level % 1.0f * (float)maxXp)) + "/" + StringUtils.shortNumberFormat(maxXp));
                    }
                }
                if (rift.enigma != null && rift.enigma.found_souls != null) {
                    int foundSouls = rift.enigma.found_souls.size();
                    Utils.renderAlignedString(EnumChatFormatting.DARK_PURPLE + "Enigma Souls:", EnumChatFormatting.WHITE.toString() + foundSouls + "/42", this.guiLeft + 331, this.guiTop + 110, 83);
                    this.renderItem("SKYBLOCK_ENIGMA_SOUL", 314, 106, this.guiLeft, this.guiTop);
                }
                if (riftInventory == null) {
                    String message = EnumChatFormatting.RED + "Inventory API not enabled!";
                    Utils.drawStringCentered(message, (float)this.guiLeft + 215.5f, (float)(this.guiTop + 61), true, 0);
                }
                if (riftInventory == null) break block39;
                this.addInventoryButton(156, 16, this.guiLeft, this.guiTop, mouseX, mouseY, "\u00a77Inventory", "CHEST");
                this.addInventoryButton(222, 16, this.guiLeft, this.guiTop, mouseX, mouseY, "\u00a77Ender Chest", "ENDER_CHEST");
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
                int inventoryRows = this.inInventory ? 4 : 5;
                int invSizeY = inventoryRows * 18 + 17 + 7;
                inventoryX = this.guiLeft + 203 - 88;
                inventoryY = this.guiTop + 130 - invSizeY / 2;
                this.getInstance().func_73729_b(inventoryX, inventoryY, 0, 0, 176, inventoryRows * 18 + 17);
                this.getInstance().func_73729_b(inventoryX, inventoryY + inventoryRows * 18 + 17, 0, 215, 176, 7);
                Utils.drawStringF(this.inInventory ? "Inventory" : "Ender Chest", this.guiLeft + 122, this.inInventory ? (float)(this.guiTop + 87 + 1) : (float)(this.guiTop + 79), false, 0x404040);
                if (this.inInventory) break block40;
                if (!riftInventory.has("ender_chest_contents")) {
                    this.drawErrorMessage();
                    return;
                }
                APIDataJson.Rift.RiftInventory.Inventory riftEnderChest = rift.inventory.ender_chest_contents;
                if (riftEnderChest == null || (enderChestContents = riftEnderChest.readItems()) == null) break block39;
                this.pages = (int)Math.ceil((double)enderChestContents.size() / 45.0);
                this.drawArrows(this.onPage, this.pages, 190, 77);
                for (int i = 0; i <= this.pages; ++i) {
                    if (i != this.onPage) continue;
                    List<JsonObject> page = enderChestContents.subList(Math.min(i == 0 ? 0 : i * 45, enderChestContents.size() - 45), i == 0 ? 45 : enderChestContents.size());
                    int row = 0;
                    int slot = 0;
                    for (int j = 0; j < page.size(); ++j) {
                        JsonObject jsonObject = page.get(j);
                        if (j % 9 == 0 && j > 0) {
                            slot = 0;
                            ++row;
                        }
                        int x = inventoryX - this.guiLeft + 8 + slot * 18;
                        int y = 91 + row * 18;
                        ++slot;
                        if (jsonObject == null) continue;
                        ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(jsonObject, false);
                        if (mouseX >= this.guiLeft + x && mouseX <= this.guiLeft + x + 16 && mouseY >= this.guiTop + y && mouseY <= this.guiTop + y + 16) {
                            this.getInstance().tooltipToDisplay = itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                        }
                        this.renderItem(itemStack, x, y, this.guiLeft, this.guiTop);
                    }
                }
                break block39;
            }
            if (riftInventory == null || !riftInventory.has("inv_contents")) {
                this.drawErrorMessage();
                return;
            }
            APIDataJson.Rift.RiftInventory.Inventory riftInventory2 = rift.inventory.inv_contents;
            if (riftInventory2 != null && (inventoryContents = riftInventory2.readItems()) != null) {
                ArrayList<JsonObject> hotbar = new ArrayList<JsonObject>();
                for (int i = 0; i < 9; ++i) {
                    hotbar.add(inventoryContents.get(i));
                }
                inventoryContents.removeAll(hotbar);
                int hotbarSlot = 0;
                for (JsonObject jsonObject : hotbar) {
                    if (jsonObject != null) {
                        int drawX = 123 + hotbarSlot * 18;
                        ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(jsonObject, false);
                        if (mouseX >= this.guiLeft + drawX && mouseX <= this.guiLeft + drawX + 16 && mouseY >= this.guiTop + 154 && mouseY <= this.guiTop + 154 + 16) {
                            this.getInstance().tooltipToDisplay = itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                        }
                        this.renderItem(itemStack, drawX, 154, this.guiLeft, this.guiTop);
                    }
                    ++hotbarSlot;
                }
                int row = 1;
                int slot = 0;
                for (int i = 0; i < inventoryContents.size(); ++i) {
                    JsonObject jsonObject = inventoryContents.get(i);
                    if (i % 9 == 0 && i > 0) {
                        slot = 0;
                        ++row;
                    }
                    if (jsonObject != null) {
                        ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(jsonObject, false);
                        int x1 = inventoryX - this.guiLeft + slot * 18 + 8;
                        int y1 = inventoryY - this.guiTop + row * 18;
                        if (mouseX >= this.guiLeft + x1 && mouseX <= this.guiLeft + x1 + 16 && mouseY >= this.guiTop + y1 && mouseY <= this.guiTop + y1 + 16) {
                            this.getInstance().tooltipToDisplay = itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                        }
                        this.renderItem(itemStack, x1, y1, this.guiLeft, this.guiTop);
                    }
                    ++slot;
                }
            }
        }
    }

    private void drawArrows(int page, int maxPages, int x, int y) {
        ArrowPagesUtils.onDraw(this.guiLeft, this.guiTop, new int[]{x, y}, page, maxPages);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseX >= this.guiLeft + 156 - 1 && mouseX <= this.guiLeft + 156 + 20 && mouseY >= this.guiTop + 16 && mouseY <= this.guiTop + 16 + 20) {
            this.inInventory = true;
            Utils.playPressSound();
        }
        ArrowPagesUtils.onPageSwitchMouse(this.guiLeft, this.guiTop, new int[]{190, 77}, this.onPage, this.pages, pageChange -> {
            this.onPage = pageChange;
        });
        if (mouseX >= this.guiLeft + 222 - 1 && mouseX <= this.guiLeft + 222 + 20 && mouseY >= this.guiTop + 16 && mouseY <= this.guiTop + 16 + 20) {
            this.inInventory = false;
            Utils.playPressSound();
        }
        return false;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        if (this.getInstance().playerNameTextField.getFocus()) {
            return;
        }
        switch (keyCode) {
            case 2: {
                this.inInventory = true;
                Utils.playPressSound();
                break;
            }
            case 3: {
                this.inInventory = false;
                Utils.playPressSound();
            }
        }
    }

    public void addInventoryButton(int x, int y, int guiLeft, int guiTop, int mouseX, int mouseY, String title, String internalNameForItem) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
        if (internalNameForItem.equals("CHEST") && this.inInventory) {
            Utils.drawTexturedRect(guiLeft + x, guiTop + y, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
        } else if (internalNameForItem.equals("ENDER_CHEST") && !this.inInventory) {
            Utils.drawTexturedRect(guiLeft + x, guiTop + y, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
        } else {
            Utils.drawTexturedRect(guiLeft + x, guiTop + y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
        }
        this.renderItem(internalNameForItem, x + 2, y + 2, guiLeft, guiTop);
        if (mouseX >= guiLeft + x - 1 && mouseX <= guiLeft + x + 20 && mouseY >= guiTop + y && mouseY <= guiTop + y + 20) {
            this.getInstance().tooltipToDisplay = Collections.singletonList(title);
        }
    }

    public void renderItem(String internalName, int x, int y, int guiLeft, int guiTop) {
        ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(internalName).resolveToItemStack();
        this.renderItem(itemStack, x, y, guiLeft, guiTop);
    }

    public void renderItem(ItemStack itemStack, int x, int y, int guiLeft, int guiTop) {
        GlStateManager.func_179140_f();
        RenderHelper.func_74520_c();
        Utils.drawItemStack(itemStack, guiLeft + x, guiTop + y);
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    public void drawArmorAndEquipment(List<JsonObject> jsonObjects, int guiLeft, int guiTop, int x, int y, int mouseX, int mouseY, boolean reverse2) {
        int i;
        ItemStack[] itemStacks = new ItemStack[4];
        if (reverse2) {
            Collections.reverse(jsonObjects);
        }
        for (i = 0; i < jsonObjects.size(); ++i) {
            JsonObject json = jsonObjects.get(i);
            if (json == null) continue;
            ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(json, false);
            if (itemStack == null) {
                itemStack = this.fillerStack;
            }
            itemStacks[i] = itemStack;
        }
        for (i = 0; i < itemStacks.length; ++i) {
            ItemStack stack = itemStacks[i];
            if (stack == null) continue;
            Utils.drawItemStack(stack, guiLeft + x, guiTop + y + i * 18, true);
            if (stack == this.fillerStack || mouseX < guiLeft + x - 1 || mouseX > guiLeft + x + 16 + 1 || mouseY < guiTop + y + i * 18 || mouseY > guiTop + y + i * 18 + 16) continue;
            this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
    }

    public static List<JsonObject> readBase64(String data) {
        ArrayList<JsonObject> itemStacks = new ArrayList<JsonObject>();
        try {
            NBTTagList items2 = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(data))).func_150295_c("i", 10);
            for (int j = 0; j < items2.func_74745_c(); ++j) {
                JsonObject item = NotEnoughUpdates.INSTANCE.manager.getJsonFromNBTEntry(items2.func_150305_b(j));
                itemStacks.add(item);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return itemStacks;
    }

    public void drawErrorMessage() {
        String message = EnumChatFormatting.RED + "No Rift data available!";
        Utils.drawStringCentered(message, (float)this.guiLeft + 215.5f, (float)(this.guiTop + 61), true, 0);
    }
}

