/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class EventTaskLevel
extends GuiTaskLevel {
    public EventTaskLevel(LevelPage levelPage) {
        super(levelPage);
    }

    @Override
    public void drawTask(JsonObject object, int mouseX, int mouseY, int guiLeft, int guiTop) {
        ArrayList<String> lore = new ArrayList<String>();
        SkyblockProfiles.SkyblockProfile selectedProfile = GuiProfileViewer.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        APIDataJson data = selectedProfile.getAPIDataJson();
        if (data == null) {
            return;
        }
        int sbXpMiningFiesta = 0;
        int sbXpFishingFestival = 0;
        int sbXpSpookyFestival = 0;
        JsonObject constant = this.levelPage.getConstant();
        JsonObject eventTask = constant.getAsJsonObject("event_task");
        if (object.has("leveling")) {
            JsonObject leveling = object.getAsJsonObject("leveling");
            int miningFiestaOresMined = data.leveling.mining_fiesta_ores_mined;
            int fishingFestivalSharksKilled = data.leveling.fishing_festival_sharks_killed;
            sbXpMiningFiesta = this.getCapOrAmount(miningFiestaOresMined, 1000000, 5000);
            sbXpFishingFestival = this.getCapOrAmount(fishingFestivalSharksKilled, 5000, 50);
            if (leveling.has("completed_tasks")) {
                JsonArray completedTasks = leveling.get("completed_tasks").getAsJsonArray();
                JsonObject spookyFestivalXp = eventTask.getAsJsonObject("spooky_festival_xp");
                for (JsonElement completedTask : completedTasks) {
                    String name = completedTask.getAsString();
                    if (!spookyFestivalXp.has(name)) continue;
                    sbXpSpookyFestival += spookyFestivalXp.get(name).getAsInt();
                }
            }
        }
        int sbXpUniqueMedals = Utils.getElementOrDefault(object, "jacobs_contest.unique_brackets.gold", new JsonArray()).getAsJsonArray().size() * eventTask.get("jacob_farming_contest_xp").getAsInt();
        lore.add(this.levelPage.buildLore("Mining Fiesta", sbXpMiningFiesta, eventTask.get("mining_fiesta").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Fishing Festival", sbXpFishingFestival, eventTask.get("fishing_festival").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Jacob's Farming Contest", sbXpUniqueMedals, eventTask.get("jacob_farming_contest").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Spooky Festival", sbXpSpookyFestival, eventTask.get("spooky_festival").getAsInt(), false));
        int totalXp = sbXpMiningFiesta + sbXpSpookyFestival + sbXpFishingFestival + sbXpUniqueMedals;
        this.levelPage.renderLevelBar("Event Task", new ItemStack(Items.field_151113_aN), guiLeft + 299, guiTop + 115, 110, 0.0, totalXp, this.levelPage.getConstant().getAsJsonObject("category_xp").get("event_task").getAsInt(), mouseX, mouseY, true, lore);
    }

    private int getCapOrAmount(int miningFiestaOresMined, int cap, int per) {
        if (miningFiestaOresMined == 0) {
            return 0;
        }
        if (miningFiestaOresMined > cap) {
            return cap / per;
        }
        return miningFiestaOresMined / per;
    }
}

