/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.Panorama;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class PetsPage
extends GuiProfileViewerPage {
    public static final ResourceLocation pv_pets = new ResourceLocation("notenoughupdates:pv_pets.png");
    private static final int COLLS_XCOUNT = 5;
    private static final int COLLS_YCOUNT = 4;
    private static final float COLLS_XPADDING = 15.0f;
    private static final float COLLS_YPADDING = 24.4f;
    private static final Rectangle switchSortingMethodButton = new Rectangle(180, 8, 16, 16);
    private boolean sortPetsAlphabetically = false;
    private List<JsonObject> sortedPets = null;
    private List<ItemStack> sortedPetsStack = null;
    private int selectedPet = -1;
    private int petsPage = 0;

    public PetsPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        JsonObject petsJson = Constants.PETS;
        if (petsJson == null) {
            return;
        }
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        JsonObject petsInfo = selectedProfile.getPetsInfo();
        if (petsInfo == null) {
            return;
        }
        String location = null;
        JsonObject status2 = GuiProfileViewer.getProfile().getPlayerStatus();
        if (status2 != null && status2.has("mode")) {
            location = status2.get("mode").getAsString();
        }
        this.getInstance().backgroundRotation += (float)(this.getInstance().currentTime - this.getInstance().lastTime) / 400.0f;
        this.getInstance().backgroundRotation %= 360.0f;
        String panoramaIdentifier = "day";
        if (SBInfo.getInstance().currentTimeDate != null && (SBInfo.getInstance().currentTimeDate.getHours() <= 6 || SBInfo.getInstance().currentTimeDate.getHours() >= 20)) {
            panoramaIdentifier = "night";
        }
        JsonArray pets = petsInfo.get("pets").getAsJsonArray();
        if (this.sortedPets == null) {
            this.sortPets(pets);
        }
        this.renderSortingButton(guiLeft, guiTop);
        Panorama.drawPanorama(-this.getInstance().backgroundRotation, guiLeft + 212, guiTop + 44, 81, 108, -0.37f, 0.6f, Panorama.getPanoramasForLocation(location == null ? "dynamic" : location, panoramaIdentifier));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_pets);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        Utils.drawStringCentered(EnumChatFormatting.DARK_PURPLE + "Pets", guiLeft + 100, guiTop + 14, true, 0x404040);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        JsonElement activePetElement = petsInfo.get("active_pet");
        if (this.selectedPet == -1 && activePetElement != null && activePetElement.isJsonObject()) {
            JsonObject active = activePetElement.getAsJsonObject();
            for (int i = 0; i < this.sortedPets.size(); ++i) {
                if (this.sortedPets.get(i) != active) continue;
                this.selectedPet = i;
                break;
            }
        }
        boolean leftHovered = false;
        boolean rightHovered = false;
        if (Mouse.isButtonDown((int)0) && mouseY > guiTop + 6 && mouseY < guiTop + 22) {
            if (mouseX > guiLeft + 100 - 20 - 12 && mouseX < guiLeft + 100 - 20) {
                leftHovered = true;
            } else if (mouseX > guiLeft + 100 + 20 && mouseX < guiLeft + 100 + 20 + 12) {
                rightHovered = true;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.resource_packs);
        if (this.petsPage > 0) {
            Utils.drawTexturedRect(guiLeft + 100 - 15 - 12, guiTop + 6, 12.0f, 16.0f, 0.11328125f, 0.20703125f, !leftHovered ? 0.0f : 0.125f, !leftHovered ? 0.125f : 0.25f, 9728);
        }
        if ((double)this.petsPage < Math.ceil((float)pets.size() / 20.0f) - 1.0) {
            Utils.drawTexturedRect(guiLeft + 100 + 15, guiTop + 6, 12.0f, 16.0f, 0.01953125f, 0.11328125f, !rightHovered ? 0.0f : 0.125f, !rightHovered ? 0.125f : 0.25f, 9728);
        }
        for (int i = this.petsPage * 20; i < Math.min(this.petsPage * 20 + 20, Math.min(this.sortedPetsStack.size(), this.sortedPets.size())); ++i) {
            JsonObject pet = this.sortedPets.get(i);
            ItemStack stack = this.sortedPetsStack.get(i);
            if (pet == null) continue;
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_74757_a("DisablePetExp", true);
            stack.func_77982_d(tag);
            int xIndex = i % 20 % 5;
            int yIndex = i % 20 / 5;
            float x = 20.0f + 35.0f * (float)xIndex;
            float y = 31.4f + 44.4f * (float)yIndex;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            if (i == this.selectedPet) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.7254902f, (float)0.0f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Utils.drawTexturedRect((float)guiLeft + x, (float)guiTop + y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
            Utils.drawItemStack(stack, guiLeft + (int)x + 2, guiTop + (int)y + 2, true);
            if (!((float)mouseX > (float)guiLeft + x) || !((float)mouseX < (float)guiLeft + x + 20.0f) || !((float)mouseY > (float)guiTop + y) || !((float)mouseY < (float)guiTop + y + 20.0f)) continue;
            this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        }
        if (this.selectedPet >= 0) {
            ItemStack petStack = this.sortedPetsStack.size() <= this.selectedPet ? ItemUtils.createQuestionMarkSkull("\u00a7cInvalid pet selection") : this.sortedPetsStack.get(this.selectedPet);
            String display = petStack.func_82833_r();
            JsonObject pet = this.sortedPets.get(this.selectedPet);
            int x = guiLeft + 280;
            float y = (float)(guiTop + 67) + 15.0f * (float)Math.sin((double)((float)(this.getInstance().currentTime - this.getInstance().startTime) / 800.0f) % (Math.PI * 2));
            int displayLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(display);
            int halfDisplayLen = displayLen / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GuiScreen.func_73734_a((int)(-halfDisplayLen - 1 - 28), (int)-1, (int)(halfDisplayLen + 1 - 28), (int)8, (int)new Color(0, 0, 0, 100).getRGB());
            Minecraft.func_71410_x().field_71466_p.func_175065_a(display, (float)(-halfDisplayLen - 28), 0.0f, 0, true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)-55.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)3.5f, (float)3.5f, (float)1.0f);
            Utils.drawItemStack(petStack, 0, 0);
            GlStateManager.func_179121_F();
            float level = pet.get("level").getAsFloat();
            float currentLevelRequirement = pet.get("currentLevelRequirement").getAsFloat();
            float percentageToNextLevel = pet.get("percentageToNextLevel").getAsFloat();
            float exp2 = pet.get("exp").getAsFloat();
            float maxXP = pet.get("maxXP").getAsFloat();
            String[] split = display.split("] ");
            String colouredName = split[split.length - 1];
            Utils.renderAlignedString(colouredName, EnumChatFormatting.WHITE + "Level " + (int)Math.floor(level), guiLeft + 319, guiTop + 28, 98);
            this.getInstance().renderBar(guiLeft + 319, guiTop + 38, 98.0f, (float)Math.floor(level) / 100.0f);
            Utils.renderAlignedString(EnumChatFormatting.YELLOW + "To Next LVL", EnumChatFormatting.WHITE.toString() + (int)(percentageToNextLevel * 100.0f) + "%", guiLeft + 319, guiTop + 46, 98);
            this.getInstance().renderBar(guiLeft + 319, guiTop + 56, 98.0f, percentageToNextLevel);
            Utils.renderAlignedString(EnumChatFormatting.YELLOW + "To Max LVL", EnumChatFormatting.WHITE.toString() + Math.min(100, (int)(exp2 / maxXP * 100.0f)) + "%", guiLeft + 319, guiTop + 64, 98);
            this.getInstance().renderBar(guiLeft + 319, guiTop + 74, 98.0f, exp2 / maxXP);
            Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Total XP", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(exp2), guiLeft + 319, guiTop + 125, 98);
            Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Current LVL XP", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(percentageToNextLevel * currentLevelRequirement), guiLeft + 319, guiTop + 143, 98);
            Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Required LVL XP", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(currentLevelRequirement), guiLeft + 319, guiTop + 161, 98);
        }
    }

    private void renderSortingButton(int guiLeft, int guiTop) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
        Utils.drawTexturedRect(switchSortingMethodButton.getX() + guiLeft - 2, switchSortingMethodButton.getY() + guiTop - 2, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
        ItemStack itemStack = new ItemStack((Block)Blocks.field_150438_bZ);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStack, switchSortingMethodButton.getX() + guiLeft, switchSortingMethodButton.getY() + guiTop);
        int mouseX = Utils.getMouseX() - guiLeft;
        int mouseY = Utils.getMouseY() - guiTop;
        if (switchSortingMethodButton.contains(mouseX, mouseY)) {
            this.getInstance().tooltipToDisplay = Arrays.asList(EnumChatFormatting.GREEN + "Sort", "", (this.sortPetsAlphabetically ? EnumChatFormatting.GRAY + " " : EnumChatFormatting.DARK_AQUA + "\u25b6") + " Pet Exp", (!this.sortPetsAlphabetically ? EnumChatFormatting.GRAY + " " : EnumChatFormatting.DARK_AQUA + "\u25b6") + " Alphabetical", "", EnumChatFormatting.YELLOW + "Click to switch!");
        }
    }

    private void sortPets(JsonArray pets) {
        this.sortedPets = new ArrayList<JsonObject>();
        this.sortedPetsStack = new ArrayList<ItemStack>();
        for (int i = 0; i < pets.size(); ++i) {
            this.sortedPets.add(pets.get(i).getAsJsonObject());
        }
        this.sortedPets.sort((pet1, pet2) -> {
            String petType1 = pet1.get("type").getAsString();
            String tier1 = pet1.get("tier").getAsString();
            String tierNum1 = GuiProfileViewer.RARITY_TO_NUM.get(tier1);
            if (tierNum1 == null) {
                return 1;
            }
            int tierNum1I = Integer.parseInt(tierNum1);
            if ("PET_ITEM_TIER_BOOST".equals(Utils.getElementAsString(pet1.get("heldItem"), null))) {
                PetInfoOverlay.Pet parsedPet = new PetInfoOverlay.Pet();
                PetInfoOverlay.Rarity tier = PetInfoOverlay.Rarity.valueOf(pet1.get("tier").getAsString());
                parsedPet.petType = pet1.get("type").getAsString();
                parsedPet.rarity = tier;
                if (Utils.canPetBeTierBoosted(parsedPet, tier.nextRarity())) {
                    ++tierNum1I;
                }
            }
            float exp1 = pet1.get("exp").getAsFloat();
            String petType2 = pet2.get("type").getAsString();
            String tier2 = pet2.get("tier").getAsString();
            String tierNum2 = GuiProfileViewer.RARITY_TO_NUM.get(tier2);
            if (tierNum2 == null) {
                return -1;
            }
            int tierNum2I = Integer.parseInt(tierNum2);
            if ("PET_ITEM_TIER_BOOST".equals(Utils.getElementAsString(pet2.get("heldItem"), null))) {
                PetInfoOverlay.Pet parsedPet = new PetInfoOverlay.Pet();
                PetInfoOverlay.Rarity tier = PetInfoOverlay.Rarity.valueOf(pet2.get("tier").getAsString());
                parsedPet.petType = pet2.get("type").getAsString();
                parsedPet.rarity = tier;
                if (Utils.canPetBeTierBoosted(parsedPet, tier.nextRarity())) {
                    ++tierNum2I;
                }
            }
            float exp2 = pet2.get("exp").getAsFloat();
            if (tierNum1I != tierNum2I) {
                return tierNum2I - tierNum1I;
            }
            if (this.sortPetsAlphabetically && petType1.compareTo(petType2) != 0) {
                return petType1.compareTo(petType2);
            }
            return (int)(exp2 - exp1);
        });
        for (JsonObject pet : this.sortedPets) {
            PetInfoOverlay.Rarity nextRarity;
            PetInfoOverlay.Pet parsedPet = new PetInfoOverlay.Pet();
            parsedPet.petType = pet.get("type").getAsString();
            parsedPet.rarity = PetInfoOverlay.Rarity.valueOf(pet.get("tier").getAsString());
            parsedPet.petItem = Utils.getElementAsString(pet.get("heldItem"), null);
            if ("PET_ITEM_TIER_BOOST".equals(parsedPet.petItem) && Utils.canPetBeTierBoosted(parsedPet, nextRarity = parsedPet.rarity.nextRarity())) {
                parsedPet.rarity = nextRarity;
            }
            parsedPet.petLevel = PetLeveling.getPetLevelingForPet(parsedPet.petType, parsedPet.rarity).getPetLevel(pet.get("exp").getAsFloat());
            parsedPet.petXpType = "unknown";
            parsedPet.skin = Utils.getElementAsString(pet.get("skin"), null);
            parsedPet.candyUsed = pet.get("candyUsed").getAsInt();
            this.sortedPetsStack.add(ItemUtils.createPetItemstackFromPetInfo(parsedPet));
            pet.addProperty("level", parsedPet.petLevel.getCurrentLevel());
            pet.addProperty("currentLevelRequirement", parsedPet.petLevel.getExpRequiredForNextLevel());
            pet.addProperty("maxXP", parsedPet.petLevel.getExpRequiredForMaxLevel());
            pet.addProperty("percentageToNextLevel", Float.valueOf(parsedPet.petLevel.getPercentageToNextLevel()));
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.sortedPets == null) {
            return false;
        }
        for (int i = this.petsPage * 20; i < Math.min(this.petsPage * 20 + 20, this.sortedPets.size()); ++i) {
            int xIndex = i % 20 % 5;
            int yIndex = i % 20 / 5;
            float x = 20.0f + 35.0f * (float)xIndex;
            float y = 31.4f + 44.4f * (float)yIndex;
            int guiLeft = GuiProfileViewer.getGuiLeft();
            int guiTop = GuiProfileViewer.getGuiTop();
            if (!((float)mouseX > (float)guiLeft + x) || !((float)mouseX < (float)guiLeft + x + 20.0f) || !((float)mouseY > (float)guiTop + y) || !((float)mouseY < (float)guiTop + y + 20.0f)) continue;
            this.selectedPet = i;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        if (mouseY > guiTop + 6 && mouseY < guiTop + 22) {
            if (mouseX > guiLeft + 100 - 15 - 12 && mouseX < guiLeft + 100 - 20) {
                if (this.petsPage > 0) {
                    --this.petsPage;
                }
            } else if (mouseX > guiLeft + 100 + 15 && mouseX < guiLeft + 100 + 20 + 12 && this.sortedPets != null && (double)this.petsPage < Math.ceil((float)this.sortedPets.size() / 20.0f) - 1.0) {
                ++this.petsPage;
            }
        }
        if (switchSortingMethodButton.contains(mouseX - guiLeft, mouseY - guiTop)) {
            this.sortPetsAlphabetically = !this.sortPetsAlphabetically;
            this.resetCache();
            Utils.playPressSound();
        }
    }

    @Override
    public void resetCache() {
        this.petsPage = 0;
        this.sortedPets = null;
        this.sortedPetsStack = null;
        this.selectedPet = -1;
    }
}

