/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.CookieWarning;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.miscgui.customtodos.CustomTodoHud;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.options.separatesections.MiscOverlays;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.overlays.TextTabOverlay;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.util.vector.Vector2f;

public class TimersOverlay
extends TextTabOverlay {
    private static final Pattern PATTERN_ACTIVE_EFFECTS = Pattern.compile(" You have a God Potion active! ([1-5][0-9]|[0-9])[\\s|^\\S]?(Seconds|Second|Minutes|Minute|Hours|Hour|Day|Days|h|m|s) ?([1-5][0-9]|[0-9])?([ms])?");
    private static final Pattern CAKE_PATTERN = Pattern.compile("\u00a7r\u00a7d\u00a7l(?:Big )?Yum! \u00a7r\u00a7eYou (?:refresh|gain) \u00a7r\u00a7.+ \u00a7r\u00a7efor \u00a7r\u00a7a48 \u00a7r\u00a7ehours!\u00a7r");
    private static final Pattern PUZZLER_PATTERN = Pattern.compile("\u00a7r\u00a7dPuzzler\u00a7r\u00a76 gave you .+ \u00a7r\u00a76for solving the puzzle!\u00a7r");
    private static final Pattern FETCHUR_PATTERN = Pattern.compile("\u00a7e\\[NPC] Fetchur\u00a7f: \u00a7rthanks thats probably what i needed\u00a7r");
    private static final Pattern FETCHUR2_PATTERN = Pattern.compile("\u00a7e\\[NPC] Fetchur\u00a7f: \u00a7rcome back another time, maybe tmrw\u00a7r");
    private static final Pattern DAILY_MITHRIL_POWDER = Pattern.compile("\u00a7r\u00a79\u1805 \u00a7r\u00a7fYou've earned \u00a7r\u00a72.+ Mithril Powder \u00a7r\u00a7ffrom mining your first Mithril Ore of the day!\u00a7r");
    private static final Pattern DAILY_GEMSTONE_POWDER = Pattern.compile("\u00a7r\u00a79\u1805 \u00a7r\u00a7fYou've earned \u00a7r\u00a7d.+ Gemstone Powder \u00a7r\u00a7ffrom mining your first Gemstone of the day!\u00a7r");
    private static final Pattern DAILY_SHOP_LIMIT = Pattern.compile("\u00a7r\u00a7cYou may only buy up to 6,?400? of this item each day!\u00a7r");
    private static final Pattern GOD_POTION_TIME = Pattern.compile(" God Potion: ([1-5][0-9]|[0-9])([dhms])(:? ([1-5][0-9]|[0-9])([dhms]))?");
    private static ItemStack[] FETCHUR_ICONS = null;
    private static HashMap<String, ItemStack> todoItems;
    boolean hasErrorMessage = false;
    AxisAlignedBB matriarchArea = new AxisAlignedBB(-555.0, 36.0, -904.0, -532.0, 52.0, -870.0);

    public TimersOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    @SubscribeEvent
    public void onClickItem(SlotClickEvent event) {
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        if (event.slot == null || !event.slot.func_75216_d()) {
            return;
        }
        ItemStack itemStack = event.slot.func_75211_c();
        if (itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150398_cm) || itemStack.func_77952_i() != 1) {
            return;
        }
        if (ItemUtils.getLore(itemStack).contains("\u00a7a\u00a7lFREE! \u00a7a(Every 4 hours)")) {
            hidden.lastFreeRiftInfusionApplied = System.currentTimeMillis();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onChatMessageReceived(ClientChatReceivedEvent event) {
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        if (event.type == 0) {
            long currentTime = System.currentTimeMillis();
            Matcher cakeMatcher = CAKE_PATTERN.matcher(event.message.func_150254_d());
            if (cakeMatcher.matches()) {
                hidden.firstCakeAte = currentTime;
                return;
            }
            if ("\u00a7r\u00a7d\u00a7lINFUSED! \u00a7r\u00a77Used your free dimensional infusion!\u00a7r".equals(event.message.func_150254_d())) {
                hidden.lastFreeRiftInfusionApplied = currentTime;
                return;
            }
            Matcher puzzlerMatcher = PUZZLER_PATTERN.matcher(event.message.func_150254_d());
            if (puzzlerMatcher.matches()) {
                hidden.puzzlerCompleted = currentTime;
                return;
            }
            Matcher fetchurMatcher = FETCHUR_PATTERN.matcher(event.message.func_150254_d());
            if (fetchurMatcher.matches()) {
                hidden.fetchurCompleted = currentTime;
                return;
            }
            Matcher fetchur2Matcher = FETCHUR2_PATTERN.matcher(event.message.func_150254_d());
            if (fetchur2Matcher.matches()) {
                hidden.fetchurCompleted = currentTime;
                return;
            }
            Matcher dailyGemstonePowder = DAILY_GEMSTONE_POWDER.matcher(event.message.func_150254_d());
            if (dailyGemstonePowder.matches()) {
                hidden.dailyGemstonePowderCompleted = currentTime;
                return;
            }
            Matcher dailyMithrilPowder = DAILY_MITHRIL_POWDER.matcher(event.message.func_150254_d());
            if (dailyMithrilPowder.matches()) {
                hidden.dailyMithrilPowerCompleted = currentTime;
                return;
            }
            Matcher dailyShopLimit = DAILY_SHOP_LIMIT.matcher(event.message.func_150254_d());
            if (dailyShopLimit.matches()) {
                hidden.dailyShopLimitCompleted = currentTime;
            }
        }
    }

    @Override
    protected Vector2f getSize(List<String> strings) {
        if (NotEnoughUpdates.INSTANCE.config.miscOverlays.todoIcons) {
            return super.getSize(strings).translate(12.0f, 0.0f);
        }
        return super.getSize(strings);
    }

    private static void setupTodoItems() {
        todoItems = new HashMap<String, ItemStack>(){
            {
                this.addItem("Mithril Powder", "INK_SACK-10");
                this.addItem("God Potion", "GOD_POTION_2");
                this.addItem("Crimson Isle Quest", "SIGN");
                this.addItem("Daily Shop Limit", "HOPPER");
                this.addItem("Rift", "DOUBLE_PLANT-1");
                this.addItem("Cakes", "EPOCH_CAKE_PINK");
                this.addItem("Experiments", "ENCHANTED_BOOK");
                this.addItem("Puzzler", "BOOK");
                this.addItem("Commission", "IRON_PICKAXE");
                this.addItem("Heavy Pearls", "HEAVY_PEARL");
                this.addItem("Gemstone Powder", "PERFECT_AMETHYST_GEM");
                this.addItem("Mithril Powder", "MITHRIL_ORE");
                this.addItem("Cookie Buff", "BOOSTER_COOKIE");
            }

            private void addItem(String eventName, String internalName) {
                ItemStack itemStack = new ItemResolutionQuery(NotEnoughUpdates.INSTANCE.manager).withKnownInternalName(internalName).resolveToItemStack();
                if (itemStack == null) {
                    Utils.showOutdatedRepoNotification(internalName);
                    return;
                }
                this.put(eventName, itemStack.func_77946_l());
            }
        };
    }

    @Override
    protected void renderLine(String line, Vector2f position, boolean dummy) {
        String clean;
        String beforeColon;
        if (!NotEnoughUpdates.INSTANCE.config.miscOverlays.todoIcons) {
            return;
        }
        GlStateManager.func_179126_j();
        ItemStack icon = null;
        if (todoItems == null) {
            TimersOverlay.setupTodoItems();
        }
        if ((beforeColon = (clean = Utils.cleanColour(line)).split(":")[0]).startsWith("CUSTOM")) {
            icon = CustomTodoHud.INSTANCE.parseItem(CustomTodoHud.INSTANCE.decodeCustomItem(beforeColon));
        } else {
            switch (beforeColon) {
                case "Cakes": {
                    icon = todoItems.get("Cakes");
                    break;
                }
                case "Puzzler": {
                    icon = todoItems.get("Puzzler");
                    break;
                }
                case "Godpot": {
                    icon = todoItems.get("God Potion");
                    break;
                }
                case "Fetchur": {
                    ZonedDateTime currentTimeEST;
                    long fetchurIndex;
                    if (FETCHUR_ICONS == null) {
                        FETCHUR_ICONS = new ItemStack[]{new ItemStack(Blocks.field_150325_L, 50, 14), new ItemStack((Block)Blocks.field_150399_cn, 20, 4), new ItemStack(Items.field_151111_aL, 1, 0), new ItemStack(Items.field_179563_cD, 20, 0), new ItemStack(Items.field_151152_bP, 1, 0), NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("CHEAP_COFFEE")), new ItemStack(Items.field_179570_aq, 1, 0), new ItemStack(Items.field_179556_br, 3, 0), NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("SUPERBOOM_TNT")), new ItemStack(Blocks.field_150423_aK, 1, 0), new ItemStack(Items.field_151033_d, 1, 0), new ItemStack(Blocks.field_150412_bA, 50, 0)};
                    }
                    if ((fetchurIndex = (long)(((currentTimeEST = ZonedDateTime.now(ZoneId.of("America/Atikokan"))).getDayOfMonth() + 1) % 12 - 1)) < 0L) {
                        fetchurIndex += 12L;
                    }
                    icon = FETCHUR_ICONS[(int)fetchurIndex];
                    break;
                }
                case "Commissions": {
                    icon = todoItems.get("Commission");
                    break;
                }
                case "Experiments": {
                    icon = todoItems.get("Experiments");
                    break;
                }
                case "Cookie Buff": {
                    icon = todoItems.get("Cookie Buff");
                    break;
                }
                case "Mithril Powder": {
                    icon = todoItems.get("Mithril Powder");
                    break;
                }
                case "Gemstone Powder": {
                    icon = todoItems.get("Gemstone Powder");
                    break;
                }
                case "Heavy Pearls": {
                    icon = todoItems.get("Heavy Pearls");
                    break;
                }
                case "Free Rift Infusion": {
                    icon = todoItems.get("Rift");
                    break;
                }
                case "Crimson Isle Quests": {
                    icon = todoItems.get("Crimson Isle Quest");
                    break;
                }
                case "NPC Buy Daily Limit": {
                    icon = todoItems.get("Daily Shop Limit");
                }
            }
        }
        if (icon != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)position.x, (float)position.y, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            Utils.drawItemStack(icon, 0, 0);
            GlStateManager.func_179121_F();
            position.x += 12.0f;
        }
        super.renderLine(line, position, dummy);
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.miscOverlays.todoOverlay2;
    }

    @Override
    public void update() {
        long currentTime = System.currentTimeMillis();
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        long midnightReset = (currentTime - 18000000L) / TimeEnums.DAY.time * TimeEnums.DAY.time + 18000000L;
        long pearlsReset = midnightReset - 18000000L;
        long catacombsReset = currentTime / TimeEnums.DAY.time * TimeEnums.DAY.time;
        long timeDiffMidnightNow = midnightReset + TimeEnums.DAY.time - currentTime;
        long catacombsDiffNow = catacombsReset + TimeEnums.DAY.time - currentTime;
        long fetchurComplete = hidden.fetchurCompleted;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            String containerName = lower2.func_145748_c_().func_150260_c();
            ItemStack stack = lower2.func_70301_a(0);
            block11 : switch (containerName.intern()) {
                case "Dimensional Infusion": {
                    ItemStack freeInfusionSlot;
                    if (lower2.func_70302_i_() != 36 || (freeInfusionSlot = lower2.func_70301_a(13)) == null || freeInfusionSlot.field_77994_a != 1 || freeInfusionSlot.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150398_cm) || freeInfusionSlot.func_77952_i() != 1 || !ItemUtils.getLore(freeInfusionSlot).contains("\u00a7a\u00a7lFREE! \u00a7a(Every 4 hours)")) break;
                    hidden.lastFreeRiftInfusionApplied = 0L;
                    break;
                }
                case "Commissions": {
                    String[] lore;
                    if (lower2.func_70302_i_() < 18) break;
                    if (hidden.commissionsCompleted == 0L || hidden.commissionsCompleted < midnightReset) {
                        hidden.commissionsCompleted = currentTime;
                    }
                    block49: for (int i = 9; i < 18; ++i) {
                        stack = lower2.func_70301_a(i);
                        if (stack == null || !stack.func_77942_o()) continue;
                        for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p())) {
                            if (!line.contains("(Daily")) continue;
                            hidden.commissionsCompleted = 0L;
                            continue block49;
                        }
                    }
                    break;
                }
                case "Experimentation Table": {
                    String string;
                    String cleanText;
                    String[] lore;
                    if (lower2.func_70302_i_() < 36) break;
                    stack = lower2.func_70301_a(31);
                    if (stack != null && stack.func_77973_b() == Items.field_151065_br && hidden.experimentsCompleted == 0L) {
                        hidden.experimentsCompleted = currentTime;
                        return;
                    }
                    ItemStack stackSuperPairs = lower2.func_70301_a(22);
                    if (stackSuperPairs != null && stackSuperPairs.func_77973_b() == Items.field_151144_bL && stackSuperPairs.func_77978_p() != null && (cleanText = Utils.cleanColour(string = (lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stackSuperPairs.func_77978_p()))[lore.length - 1])).equals("Experiments on cooldown!")) {
                        hidden.experimentsCompleted = currentTime;
                        return;
                    }
                    hidden.experimentsCompleted = 0L;
                    break;
                }
                case "Superpairs Rewards": {
                    if (lower2.func_70302_i_() < 27) break;
                    stack = lower2.func_70301_a(13);
                    if (stack != null && Utils.cleanColour(stack.func_82833_r()).equals("Superpairs")) {
                        hidden.experimentsCompleted = currentTime;
                    }
                }
                case "SkyBlock Menu": {
                    if (lower2.func_70302_i_() < 54) break;
                    stack = lower2.func_70301_a(51);
                }
                case "Booster Cookie": {
                    String[] lore;
                    if (lower2.func_70302_i_() < 54) break;
                    if (stack != lower2.func_70301_a(51)) {
                        stack = lower2.func_70301_a(13);
                    }
                    if (stack == null || !Utils.cleanColour(stack.func_82833_r()).equals("Booster Cookie") || stack.func_77978_p() == null) break;
                    for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p())) {
                        if (!line.contains("Duration: ")) continue;
                        String clean = line.replaceAll("(\u00a7.)", "");
                        clean = clean.replaceAll("(\\d)([smhdy])", "$1 $2");
                        String[] cleanSplit = clean.split(" ");
                        String[] removeDuration = Arrays.copyOfRange(cleanSplit, 1, cleanSplit.length);
                        hidden.cookieBuffRemaining = currentTime;
                        int i = 0;
                        while (i + 1 < removeDuration.length) {
                            if (i % 2 != 1) {
                                String number2 = removeDuration[i];
                                String unit = removeDuration[i + 1];
                                try {
                                    long val = Integer.parseInt(number2);
                                    switch (unit) {
                                        case "Years": 
                                        case "Year": 
                                        case "y": {
                                            hidden.cookieBuffRemaining += val * 365L * 24L * 60L * 60L * 1000L;
                                            break;
                                        }
                                        case "Months": 
                                        case "Month": {
                                            hidden.cookieBuffRemaining += val * 30L * 24L * 60L * 60L * 1000L;
                                            break;
                                        }
                                        case "Days": 
                                        case "Day": 
                                        case "d": {
                                            hidden.cookieBuffRemaining += val * 24L * 60L * 60L * 1000L;
                                            break;
                                        }
                                        case "Hours": 
                                        case "Hour": 
                                        case "h": {
                                            hidden.cookieBuffRemaining += val * 60L * 60L * 1000L;
                                            break;
                                        }
                                        case "Minutes": 
                                        case "Minute": 
                                        case "m": {
                                            hidden.cookieBuffRemaining += val * 60L * 1000L;
                                            break;
                                        }
                                        case "Seconds": 
                                        case "Second": 
                                        case "s": {
                                            hidden.cookieBuffRemaining += val * 1000L;
                                        }
                                    }
                                }
                                catch (NumberFormatException e2) {
                                    e2.printStackTrace();
                                    hidden.cookieBuffRemaining = 0L;
                                    if (this.hasErrorMessage) break block11;
                                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Unable to work out your cookie buff timer");
                                    this.hasErrorMessage = true;
                                    break block11;
                                }
                            }
                            ++i;
                        }
                        break block11;
                    }
                    break;
                }
            }
        }
        if (NotEnoughUpdates.INSTANCE.config.miscOverlays.todoOverlayOnlyShowTab && !this.lastTabState) {
            this.overlayStrings = null;
            return;
        }
        boolean foundGodPotText = false;
        boolean foundEffectsText = false;
        if (SBInfo.getInstance().getLocation() != null && !SBInfo.getInstance().getLocation().equals("dungeon") && SBInfo.getInstance().footer != null) {
            List<String> effectsLine = TablistAPI.getOptionalWidgetLines(TablistAPI.WidgetNames.ACTIVE_EFFECTS);
            for (String line : effectsLine) {
                long l;
                String godpotRemainingTimeType;
                block188: {
                    int i;
                    if ((line = Utils.cleanColour(line)).contains("Active Effects")) {
                        foundEffectsText = true;
                    }
                    Matcher activeEffectsMatcher = PATTERN_ACTIVE_EFFECTS.matcher(line);
                    Matcher godPotionMatcher = GOD_POTION_TIME.matcher(line);
                    godpotRemainingTimeType = null;
                    long godpotRemainingTime = 0L;
                    l = 0L;
                    if (activeEffectsMatcher.matches()) {
                        foundGodPotText = true;
                        try {
                            for (i = 1; i < activeEffectsMatcher.groupCount(); i += 2) {
                                if (activeEffectsMatcher.group(i) == null) continue;
                                if (!activeEffectsMatcher.group(i).startsWith(" ")) {
                                    godpotRemainingTime = Integer.parseInt(activeEffectsMatcher.group(i));
                                    godpotRemainingTimeType = activeEffectsMatcher.group(i + 1);
                                    l += CookieWarning.getEffectRemainingInMilliseconds(godpotRemainingTimeType, godpotRemainingTime);
                                    continue;
                                }
                                break block188;
                            }
                            break block188;
                        }
                        catch (Exception e3) {
                            if (this.hasErrorMessage) break;
                            Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Unable to work out your god pot timer");
                            e3.printStackTrace();
                            this.hasErrorMessage = true;
                            break;
                        }
                    }
                    if (godPotionMatcher.matches()) {
                        foundGodPotText = true;
                        try {
                            for (i = 1; i < godPotionMatcher.groupCount(); i += 2) {
                                if (godPotionMatcher.group(i) == null) continue;
                                if (!godPotionMatcher.group(i).startsWith(" ")) {
                                    godpotRemainingTime = Integer.parseInt(godPotionMatcher.group(i));
                                    godpotRemainingTimeType = godPotionMatcher.group(i + 1);
                                    l += CookieWarning.getEffectRemainingInMilliseconds(godpotRemainingTimeType, godpotRemainingTime);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e4) {
                            if (this.hasErrorMessage) break;
                            Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Unable to work out your god pot timer");
                            e4.printStackTrace();
                            this.hasErrorMessage = true;
                            break;
                        }
                    }
                }
                if (godpotRemainingTimeType == null) continue;
                hidden.godPotionDuration = l;
            }
        }
        if (!foundGodPotText && foundEffectsText) {
            hidden.godPotionDuration = 0L;
        }
        if (SBInfo.getInstance().completedQuests != null && SBInfo.getInstance().completedQuests.size() == 5) {
            hidden.questBoardCompleted = currentTime;
        }
        if (!NotEnoughUpdates.INSTANCE.config.miscOverlays.todoOverlay2) {
            this.overlayStrings = null;
            return;
        }
        HashMap<Integer, String> map2 = new HashMap<Integer, String>();
        long cakeEnd = hidden.firstCakeAte + 172800000L - currentTime;
        if (cakeEnd <= 0L) {
            map2.put(0, EnumChatFormatting.DARK_AQUA + "Cakes: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.goneColour] + "Inactive!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cakesDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && cakeEnd < TimeEnums.HOUR.time) {
            map2.put(0, EnumChatFormatting.DARK_AQUA + "Cakes: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(cakeEnd));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cakesDisplay >= DISPLAYTYPE.SOON.ordinal() && cakeEnd < TimeEnums.HALFDAY.time) {
            map2.put(0, EnumChatFormatting.DARK_AQUA + "Cakes: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(cakeEnd));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cakesDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && cakeEnd < TimeEnums.DAY.time) {
            map2.put(0, EnumChatFormatting.DARK_AQUA + "Cakes: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(cakeEnd));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cakesDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(0, EnumChatFormatting.DARK_AQUA + "Cakes: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(cakeEnd));
        }
        if (hidden.cookieBuffRemaining <= 0L) {
            map2.put(1, EnumChatFormatting.DARK_AQUA + "Cookie Buff: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.goneColour] + "Inactive!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cookieBuffDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.cookieBuffRemaining < TimeEnums.HOUR.time) {
            map2.put(1, EnumChatFormatting.DARK_AQUA + "Cookie Buff: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(hidden.cookieBuffRemaining - currentTime));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cookieBuffDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.cookieBuffRemaining < TimeEnums.HALFDAY.time) {
            map2.put(1, EnumChatFormatting.DARK_AQUA + "Cookie Buff: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(hidden.cookieBuffRemaining - currentTime));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cookieBuffDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.cookieBuffRemaining < TimeEnums.DAY.time) {
            map2.put(1, EnumChatFormatting.DARK_AQUA + "Cookie Buff: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(hidden.cookieBuffRemaining - currentTime));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.cookieBuffDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(1, EnumChatFormatting.DARK_AQUA + "Cookie Buff: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(hidden.cookieBuffRemaining - currentTime));
        }
        if (SBInfo.getInstance().getLocation() == null || !SBInfo.getInstance().getLocation().equals("dungeon")) {
            if (hidden.godPotionDuration <= 0L) {
                map2.put(2, EnumChatFormatting.DARK_AQUA + "Godpot: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.goneColour] + "Inactive!");
            } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.godpotDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.godPotionDuration < TimeEnums.HOUR.time) {
                map2.put(2, EnumChatFormatting.DARK_AQUA + "Godpot: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(hidden.godPotionDuration));
            } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.godpotDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.godPotionDuration < TimeEnums.HALFDAY.time) {
                map2.put(2, EnumChatFormatting.DARK_AQUA + "Godpot: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(hidden.godPotionDuration));
            } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.godpotDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.godPotionDuration < TimeEnums.DAY.time) {
                map2.put(2, EnumChatFormatting.DARK_AQUA + "Godpot: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(hidden.godPotionDuration));
            } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.godpotDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
                map2.put(2, EnumChatFormatting.DARK_AQUA + "Godpot: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(hidden.godPotionDuration));
            }
        }
        MiscOverlays miscOverlay = NotEnoughUpdates.INSTANCE.config.miscOverlays;
        long riftAvailableAgainIn = hidden.lastFreeRiftInfusionApplied + 14400000L - currentTime;
        if (riftAvailableAgainIn < 0L) {
            map2.put(12, EnumChatFormatting.DARK_AQUA + "Free Rift Infusion: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (miscOverlay.freeRiftInfusionDisplay == 1 && riftAvailableAgainIn < TimeEnums.HALFANHOUR.time || miscOverlay.freeRiftInfusionDisplay == 2) {
            map2.put(12, EnumChatFormatting.DARK_AQUA + "Free Rift Infusion: " + EnumChatFormatting.values()[riftAvailableAgainIn < TimeEnums.HALFANHOUR.time ? miscOverlay.verySoonColour : miscOverlay.defaultColour] + Utils.prettyTime(riftAvailableAgainIn));
        }
        long puzzlerEnd = hidden.puzzlerCompleted + 86400000L - currentTime;
        if (hidden.puzzlerCompleted + TimeEnums.DAY.time < currentTime) {
            map2.put(3, EnumChatFormatting.DARK_AQUA + "Puzzler: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.puzzlerDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.puzzlerCompleted + (TimeEnums.DAY.time - TimeEnums.HALFANHOUR.time) < currentTime) {
            map2.put(3, EnumChatFormatting.DARK_AQUA + "Puzzler: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(puzzlerEnd));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.puzzlerDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.puzzlerCompleted + (TimeEnums.DAY.time - TimeEnums.HOUR.time) < currentTime) {
            map2.put(3, EnumChatFormatting.DARK_AQUA + "Puzzler: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(puzzlerEnd));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.puzzlerDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.puzzlerCompleted + (TimeEnums.DAY.time - TimeEnums.HOUR.time * 3L) < currentTime) {
            map2.put(3, EnumChatFormatting.DARK_AQUA + "Puzzler: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(puzzlerEnd));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.puzzlerDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(3, EnumChatFormatting.DARK_AQUA + "Puzzler: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(puzzlerEnd));
        }
        if (fetchurComplete < midnightReset) {
            map2.put(4, EnumChatFormatting.DARK_AQUA + "Fetchur: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.fetchurDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && fetchurComplete < midnightReset - TimeEnums.HALFANHOUR.time) {
            map2.put(4, EnumChatFormatting.DARK_AQUA + "Fetchur: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.fetchurDisplay >= DISPLAYTYPE.SOON.ordinal() && fetchurComplete < midnightReset - TimeEnums.HOUR.time) {
            map2.put(4, EnumChatFormatting.DARK_AQUA + "Fetchur: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.fetchurDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && fetchurComplete < midnightReset - TimeEnums.HOUR.time * 3L) {
            map2.put(4, EnumChatFormatting.DARK_AQUA + "Fetchur: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.fetchurDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(4, EnumChatFormatting.DARK_AQUA + "Fetchur: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(timeDiffMidnightNow));
        }
        if (hidden.commissionsCompleted < midnightReset) {
            map2.put(5, EnumChatFormatting.DARK_AQUA + "Commissions: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready! ");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.commissionDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.commissionsCompleted < midnightReset - TimeEnums.HALFANHOUR.time) {
            map2.put(5, EnumChatFormatting.DARK_AQUA + "Commissions: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.commissionDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.commissionsCompleted < midnightReset - TimeEnums.HOUR.time) {
            map2.put(5, EnumChatFormatting.DARK_AQUA + "Commissions: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.commissionDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.commissionsCompleted < midnightReset - TimeEnums.HOUR.time * 3L) {
            map2.put(5, EnumChatFormatting.DARK_AQUA + "Commissions: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.commissionDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(5, EnumChatFormatting.DARK_AQUA + "Commissions: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(timeDiffMidnightNow));
        }
        if (hidden.experimentsCompleted < catacombsReset) {
            map2.put(6, EnumChatFormatting.DARK_AQUA + "Experiments: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.experimentationDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.experimentsCompleted < catacombsReset - TimeEnums.HALFANHOUR.time) {
            map2.put(6, EnumChatFormatting.DARK_AQUA + "Experiments: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.experimentationDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.experimentsCompleted < catacombsReset - TimeEnums.HOUR.time) {
            map2.put(6, EnumChatFormatting.DARK_AQUA + "Experiments: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.experimentationDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.experimentsCompleted < catacombsReset - TimeEnums.HOUR.time * 3L) {
            map2.put(6, EnumChatFormatting.DARK_AQUA + "Experiments: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.experimentationDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(6, EnumChatFormatting.DARK_AQUA + "Experiments: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(catacombsDiffNow));
        }
        if (hidden.dailyMithrilPowerCompleted < catacombsReset) {
            map2.put(7, EnumChatFormatting.DARK_AQUA + "Mithril Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyMithrilPowderDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.dailyMithrilPowerCompleted < catacombsReset - TimeEnums.HALFANHOUR.time) {
            map2.put(7, EnumChatFormatting.DARK_AQUA + "Mithril Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyMithrilPowderDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.dailyMithrilPowerCompleted < catacombsReset - TimeEnums.HOUR.time) {
            map2.put(7, EnumChatFormatting.DARK_AQUA + "Mithril Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyMithrilPowderDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.dailyMithrilPowerCompleted < catacombsReset - TimeEnums.HOUR.time * 3L) {
            map2.put(7, EnumChatFormatting.DARK_AQUA + "Mithril Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyMithrilPowderDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(7, EnumChatFormatting.DARK_AQUA + "Mithril Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(catacombsDiffNow));
        }
        if (hidden.dailyGemstonePowderCompleted < catacombsReset) {
            map2.put(8, EnumChatFormatting.DARK_AQUA + "Gemstone Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyGemstonePowderDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.dailyGemstonePowderCompleted < catacombsReset - TimeEnums.HALFANHOUR.time) {
            map2.put(8, EnumChatFormatting.DARK_AQUA + "Gemstone Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyGemstonePowderDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.dailyGemstonePowderCompleted < catacombsReset - TimeEnums.HOUR.time) {
            map2.put(8, EnumChatFormatting.DARK_AQUA + "Gemstone Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyGemstonePowderDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.dailyGemstonePowderCompleted < catacombsReset - TimeEnums.HOUR.time * 3L) {
            map2.put(8, EnumChatFormatting.DARK_AQUA + "Gemstone Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyGemstonePowderDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(8, EnumChatFormatting.DARK_AQUA + "Gemstone Powder: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(catacombsDiffNow));
        }
        if (hidden.dailyHeavyPearlCompleted < pearlsReset) {
            map2.put(9, EnumChatFormatting.DARK_AQUA + "Heavy Pearls: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyHeavyPearlDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.dailyHeavyPearlCompleted < pearlsReset - TimeEnums.HALFANHOUR.time) {
            map2.put(9, EnumChatFormatting.DARK_AQUA + "Heavy Pearls: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(pearlsReset + 86400000L - currentTime));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyHeavyPearlDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.dailyHeavyPearlCompleted < pearlsReset - TimeEnums.HOUR.time) {
            map2.put(9, EnumChatFormatting.DARK_AQUA + "Heavy Pearls: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(pearlsReset + 86400000L - currentTime));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyHeavyPearlDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.dailyHeavyPearlCompleted < pearlsReset - TimeEnums.HOUR.time * 3L) {
            map2.put(9, EnumChatFormatting.DARK_AQUA + "Heavy Pearls: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(pearlsReset + 86400000L - currentTime));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.dailyHeavyPearlDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(9, EnumChatFormatting.DARK_AQUA + "Heavy Pearls: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(pearlsReset + 86400000L - currentTime));
        }
        if (hidden.questBoardCompleted < midnightReset) {
            map2.put(10, EnumChatFormatting.DARK_AQUA + "Crimson Isle Quests: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + (5 - SBInfo.getInstance().completedQuests.size()) + " left!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.questBoardDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.questBoardCompleted < midnightReset - TimeEnums.HALFANHOUR.time) {
            map2.put(10, EnumChatFormatting.DARK_AQUA + "Crimson Isle Quests: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.questBoardDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.questBoardCompleted < midnightReset - TimeEnums.HOUR.time) {
            map2.put(10, EnumChatFormatting.DARK_AQUA + "Crimson Isle Quests: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.questBoardDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.questBoardCompleted < midnightReset - TimeEnums.HOUR.time * 3L) {
            map2.put(10, EnumChatFormatting.DARK_AQUA + "Crimson Isle Quests: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(timeDiffMidnightNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.questBoardDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(10, EnumChatFormatting.DARK_AQUA + "Crimson Isle Quests: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(timeDiffMidnightNow));
        }
        if (hidden.dailyShopLimitCompleted < catacombsReset) {
            map2.put(11, EnumChatFormatting.DARK_AQUA + "NPC Buy Daily Limit: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.readyColour] + "Ready!");
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.shopLimitDisplay >= DISPLAYTYPE.VERYSOON.ordinal() && hidden.dailyShopLimitCompleted < catacombsReset - TimeEnums.HALFANHOUR.time) {
            map2.put(11, EnumChatFormatting.DARK_AQUA + "NPC Buy Daily Limit: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.verySoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.shopLimitDisplay >= DISPLAYTYPE.SOON.ordinal() && hidden.dailyShopLimitCompleted < catacombsReset - TimeEnums.HOUR.time) {
            map2.put(11, EnumChatFormatting.DARK_AQUA + "NPC Buy Daily Limit: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.soonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.shopLimitDisplay >= DISPLAYTYPE.KINDASOON.ordinal() && hidden.dailyShopLimitCompleted < catacombsReset - TimeEnums.HOUR.time * 3L) {
            map2.put(11, EnumChatFormatting.DARK_AQUA + "NPC Buy Daily Limit: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.kindaSoonColour] + Utils.prettyTime(catacombsDiffNow));
        } else if (NotEnoughUpdates.INSTANCE.config.miscOverlays.shopLimitDisplay >= DISPLAYTYPE.ALWAYS.ordinal()) {
            map2.put(11, EnumChatFormatting.DARK_AQUA + "NPC Buy Daily Limit: " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.miscOverlays.defaultColour] + Utils.prettyTime(catacombsDiffNow));
        }
        this.overlayStrings = new ArrayList();
        for (int index : NotEnoughUpdates.INSTANCE.config.miscOverlays.todoText2) {
            String text;
            if (!map2.containsKey(index) || this.hideBecauseOfBingo(text = (String)map2.get(index))) continue;
            this.overlayStrings.add(text);
        }
        CustomTodoHud.processInto(this.overlayStrings);
        if (this.overlayStrings.isEmpty()) {
            this.overlayStrings = null;
        }
    }

    private boolean hideBecauseOfBingo(String text) {
        if (!SBInfo.getInstance().bingo) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.config.miscOverlays.todoOverlayHideAtBingo) {
            return false;
        }
        if (text.contains("Cookie Buff")) {
            return true;
        }
        if (text.contains("Godpot")) {
            return true;
        }
        if (text.contains("Heavy Pearls")) {
            return true;
        }
        return text.contains("Crimson Isle Quests");
    }

    @SubscribeEvent
    public void onMatriarchTick(TickEvent.ClientTickEvent event) {
        NEUConfig.HiddenProfileSpecific profileSpecific;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!"crimson_isle".equals(SBInfo.getInstance().getLocation())) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!this.matriarchArea.func_72318_a(player.func_174791_d())) {
            return;
        }
        List matriarchRelevantArmorStands = Minecraft.func_71410_x().field_71441_e.func_72872_a(EntityArmorStand.class, this.matriarchArea);
        boolean noMorePearlsAvailable = false;
        for (EntityArmorStand entityArmorStand : matriarchRelevantArmorStands) {
            if (!entityArmorStand.func_145818_k_() || !entityArmorStand.func_95999_t().contains("Heavy Pearls Available: 0")) continue;
            noMorePearlsAvailable = true;
            break;
        }
        if (noMorePearlsAvailable && (profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific()) != null) {
            profileSpecific.dailyHeavyPearlCompleted = System.currentTimeMillis();
        }
    }

    private static enum DISPLAYTYPE {
        NOW,
        VERYSOON,
        SOON,
        KINDASOON,
        ALWAYS;

    }

    private static enum TimeEnums {
        DAY(86400000L),
        HALFDAY(43200000L),
        HOUR(3600000L),
        HALFANHOUR(1800000L);

        public final long time;

        private TimeEnums(long time) {
            this.time = time;
        }
    }
}

