/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Vector2f;

public abstract class TextOverlay {
    private final Position position;
    protected Supplier<TextOverlayStyle> styleSupplier;
    public int overlayWidth = -1;
    public int overlayHeight = -1;
    public List<String> overlayStrings = null;
    private final Supplier<List<String>> dummyStrings;
    public boolean shouldUpdateFrequent = false;
    private static final int PADDING_X = 5;
    private static final int PADDING_Y = 5;

    public TextOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        this.position = position;
        this.styleSupplier = styleSupplier;
        this.dummyStrings = dummyStrings == null ? () -> null : dummyStrings;
    }

    public Vector2f getDummySize() {
        List<String> dummyStrings = this.dummyStrings.get();
        if (dummyStrings != null) {
            return this.getSize(dummyStrings);
        }
        return new Vector2f(100.0f, 50.0f);
    }

    public boolean isEnabled() {
        return true;
    }

    public void tick() {
        this.update();
    }

    public void updateFrequent() {
    }

    public abstract void update();

    public void renderDummy() {
        List<String> dummyStrings = this.dummyStrings.get();
        this.render(dummyStrings, true);
    }

    public void render() {
        if (this.shouldUpdateFrequent) {
            this.updateFrequent();
            this.shouldUpdateFrequent = false;
        }
        this.render(this.overlayStrings, false);
    }

    protected Vector2f getSize(List<String> strings) {
        int overlayHeight = 0;
        int overlayWidth = 0;
        for (String s : strings) {
            if (s == null) {
                overlayHeight += 3;
                continue;
            }
            if (s.startsWith("CUSTOM")) {
                s = s.substring(s.indexOf(58) + 1);
            }
            for (String s2 : s.split("\n")) {
                int sWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(s2);
                if (sWidth > overlayWidth) {
                    overlayWidth = sWidth;
                }
                overlayHeight += 10;
            }
        }
        overlayHeight -= 2;
        int paddingX = 0;
        int paddingY = 0;
        if (this.styleSupplier.get() == TextOverlayStyle.BACKGROUND) {
            paddingX = 5;
            paddingY = 5;
        }
        return new Vector2f((float)(overlayWidth + paddingX * 2), (float)(overlayHeight + paddingY * 2));
    }

    protected Vector2f getTextOffset() {
        return new Vector2f();
    }

    protected Vector2f getPosition(int overlayWidth, int overlayHeight, boolean scaled) {
        GlStateManager.func_179094_E();
        ScaledResolution scaledResolution = !scaled ? new ScaledResolution(Minecraft.func_71410_x()) : Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
        int x = this.position.getAbsX(scaledResolution, overlayWidth);
        int y = this.position.getAbsY(scaledResolution, overlayHeight);
        GlStateManager.func_179121_F();
        return new Vector2f((float)x, (float)y);
    }

    public Position getPosition() {
        return this.position;
    }

    protected void renderLine(String line, Vector2f position, boolean dummy) {
    }

    private void render(List<String> strings, boolean dummy) {
        if (strings == null) {
            return;
        }
        Vector2f size = this.getSize(strings);
        this.overlayHeight = (int)size.y;
        this.overlayWidth = (int)size.x;
        Vector2f position = this.getPosition(this.overlayWidth, this.overlayHeight, !dummy);
        int x = (int)position.x;
        int y = (int)position.y;
        TextOverlayStyle style = this.styleSupplier.get();
        if (style == TextOverlayStyle.BACKGROUND) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + this.overlayWidth), (int)(y + this.overlayHeight), (int)Integer.MIN_VALUE);
        }
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        int paddingX = 0;
        int paddingY = 0;
        if (this.styleSupplier.get() == TextOverlayStyle.BACKGROUND) {
            paddingX = 5;
            paddingY = 5;
        }
        Vector2f textOffset = this.getTextOffset();
        paddingX += (int)textOffset.x;
        paddingY += (int)textOffset.y;
        int yOff = 0;
        for (String s : strings) {
            if (s == null) {
                yOff += 3;
                continue;
            }
            for (String s2 : s.split("\n")) {
                Vector2f pos = new Vector2f((float)(x + paddingX), (float)(y + paddingY + yOff));
                this.renderLine(s2, pos, dummy);
                if (s2.startsWith("CUSTOM")) {
                    s2 = s2.split(":", 2)[1];
                }
                int xPad = (int)pos.x;
                int yPad = (int)pos.y;
                if (style == TextOverlayStyle.FULL_SHADOW) {
                    String clean = Utils.cleanColourNotModifiers(s2);
                    for (int xO = -2; xO <= 2; ++xO) {
                        for (int yO = -2; yO <= 2; ++yO) {
                            if (Math.abs(xO) == Math.abs(yO)) continue;
                            Minecraft.func_71410_x().field_71466_p.func_175065_a(clean, (float)xPad + (float)xO / 2.0f, (float)yPad + (float)yO / 2.0f, new Color(0, 0, 0, 200 / Math.max(Math.abs(xO), Math.abs(yO))).getRGB(), false);
                        }
                    }
                }
                Minecraft.func_71410_x().field_71466_p.func_175065_a(s2, (float)xPad, (float)yPad, 0xFFFFFF, style == TextOverlayStyle.MC_SHADOW);
                yOff += 10;
            }
        }
    }
}

