/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;

public class SlayerOverlay
extends TextOverlay {
    public static boolean slayerQuest;
    public static String RNGMeter;
    public static boolean isSlain;
    public static String slayerLVL;
    public static String slayerXp;
    public static long unloadOverlayTimer;
    public static long timeSinceLastBoss;
    public static long timeSinceLastBoss2;
    public static int slayerTier;
    private static String slayerEXP;
    private static int slayerIntXP;
    private static int differenceFromLastXP;
    private static int untilNextSlayerLevel;
    private static int xpToLevelUp;
    private static boolean useSmallXpNext;
    private static long agvSlayerTime;
    private static boolean isSlayerNine;
    private static boolean slayerXPBuffActive;
    private static int xpPerBoss;
    private static int bossesUntilNextLevel;
    private final HashSet<String> revenantLocations = new HashSet<String>(Arrays.asList("Graveyard", "Coal Mine"));
    private boolean shouldUpdate = true;

    public SlayerOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private boolean shouldUpdate() {
        if (!NotEnoughUpdates.INSTANCE.config.slayerOverlay.onlyShowWhenRelevant || SBInfo.getInstance().stranded) {
            return true;
        }
        String scoreboardLocation = SBInfo.getInstance().location;
        String locrawLocation = SBInfo.getInstance().getLocation();
        if ("None".equals(scoreboardLocation)) {
            scoreboardLocation = SBInfo.getInstance().getLastScoreboardLocation();
        }
        if (locrawLocation == null || scoreboardLocation == null) {
            return true;
        }
        switch (SBInfo.getInstance().slayer) {
            case "Tarantula": {
                if (locrawLocation.equals("combat_1") || locrawLocation.equals("crimson_isle") && scoreboardLocation.equals("Burning Desert")) break;
                return false;
            }
            case "Revenant": {
                if (locrawLocation.equals("hub") && this.revenantLocations.contains(scoreboardLocation) || locrawLocation.equals("crystal_hollows")) break;
                return false;
            }
            case "Sven": {
                if (locrawLocation.equals("hub") && scoreboardLocation.equals("Ruins") || locrawLocation.equals("foraging_1") && scoreboardLocation.equals("Howling Cave")) break;
                return false;
            }
            case "Enderman": {
                if (locrawLocation.equals("combat_3")) break;
                return false;
            }
            case "Blaze": {
                if (locrawLocation.equals("crimson_isle")) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.slayerOverlay.slayerOverlay;
    }

    @Override
    public void update() {
        this.shouldUpdate = this.shouldUpdate();
        if (!this.isEnabled() || !this.shouldUpdate) {
            this.overlayStrings = null;
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!slayerQuest) {
            slayerTier = 0;
        }
        if (slayerXp.equals("maxed")) {
            isSlayerNine = true;
        } else if (!slayerXp.equals("0")) {
            slayerEXP = slayerXp.replace(",", "");
            differenceFromLastXP = slayerIntXP - Integer.parseInt(slayerEXP);
            if (differenceFromLastXP != 0) {
                switch (differenceFromLastXP) {
                    case 6: 
                    case 31: 
                    case 125: 
                    case 625: 
                    case 1875: {
                        slayerXPBuffActive = true;
                        break;
                    }
                    default: {
                        slayerXPBuffActive = false;
                    }
                }
            }
            slayerIntXP = Integer.parseInt(slayerEXP);
            isSlayerNine = false;
        } else {
            slayerIntXP = 0;
            isSlayerNine = false;
        }
        if (SBInfo.getInstance().slayer.equals("Tarantula") || SBInfo.getInstance().slayer.equals("Revenant")) {
            useSmallXpNext = true;
        } else if (SBInfo.getInstance().slayer.equals("Sven") || SBInfo.getInstance().slayer.equals("Enderman") || SBInfo.getInstance().slayer.equals("Blaze")) {
            useSmallXpNext = false;
        }
        switch (slayerLVL) {
            case "9": {
                xpToLevelUp = 2000000;
                break;
            }
            case "8": {
                xpToLevelUp = 1000000;
                break;
            }
            case "7": {
                xpToLevelUp = 400000;
                break;
            }
            case "6": {
                xpToLevelUp = 100000;
                break;
            }
            case "5": {
                xpToLevelUp = 20000;
                break;
            }
            case "4": {
                xpToLevelUp = 5000;
                break;
            }
            case "3": {
                if (useSmallXpNext) {
                    xpToLevelUp = 1000;
                    break;
                }
                xpToLevelUp = 1500;
                break;
            }
            case "2": {
                if (useSmallXpNext) {
                    xpToLevelUp = 200;
                    break;
                }
                xpToLevelUp = 250;
                break;
            }
            case "1": {
                if (SBInfo.getInstance().slayer.equals("Revenant")) {
                    xpToLevelUp = 15;
                    break;
                }
                if (SBInfo.getInstance().slayer.equals("Tarantula")) {
                    xpToLevelUp = 25;
                    break;
                }
                xpToLevelUp = 30;
                break;
            }
            case "0": {
                xpToLevelUp = useSmallXpNext ? 5 : 10;
            }
        }
        xpPerBoss = slayerTier == 5 ? 1500 : (slayerTier == 4 ? 500 : (slayerTier == 3 ? 100 : (slayerTier == 2 ? 25 : (slayerTier == 1 ? 5 : 0))));
        if (slayerXPBuffActive) {
            xpPerBoss = (int)((double)xpPerBoss * 1.25);
        }
        untilNextSlayerLevel = xpToLevelUp - slayerIntXP;
        bossesUntilNextLevel = xpPerBoss != 0 && untilNextSlayerLevel != 0 && xpToLevelUp != 0 ? (int)Math.ceil((float)(xpToLevelUp - untilNextSlayerLevel) / (float)xpPerBoss) : 0;
        agvSlayerTime = (timeSinceLastBoss + timeSinceLastBoss2) / 2L;
    }

    @Override
    public void updateFrequent() {
        super.updateFrequent();
        if (!(slayerQuest && NotEnoughUpdates.INSTANCE.config.slayerOverlay.slayerOverlay && this.shouldUpdate)) {
            this.overlayStrings = null;
        } else {
            HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
            NumberFormat format2 = NumberFormat.getIntegerInstance();
            this.overlayStrings = new ArrayList();
            lineMap.put(0, EnumChatFormatting.YELLOW + "Slayer: " + EnumChatFormatting.DARK_RED + SBInfo.getInstance().slayer + EnumChatFormatting.GREEN + (isSlain ? " (Killed) " : " "));
            if (!RNGMeter.equals("?")) {
                lineMap.put(1, EnumChatFormatting.YELLOW + "RNG Meter: " + EnumChatFormatting.DARK_PURPLE + RNGMeter);
            }
            if (!slayerLVL.equals("-1")) {
                lineMap.put(2, EnumChatFormatting.YELLOW + "Lvl: " + EnumChatFormatting.LIGHT_PURPLE + slayerLVL);
            }
            if (timeSinceLastBoss > 0L) {
                lineMap.put(3, EnumChatFormatting.YELLOW + "Kill time: " + EnumChatFormatting.RED + Utils.prettyTime(System.currentTimeMillis() - timeSinceLastBoss));
            }
            if (slayerIntXP > 0) {
                lineMap.put(4, EnumChatFormatting.YELLOW + "XP: " + EnumChatFormatting.LIGHT_PURPLE + format2.format(untilNextSlayerLevel) + "/" + format2.format(xpToLevelUp));
            } else if (isSlayerNine) {
                lineMap.put(4, EnumChatFormatting.YELLOW + "XP: " + EnumChatFormatting.LIGHT_PURPLE + "MAXED");
            }
            if (xpPerBoss != 0 && slayerIntXP > 0) {
                lineMap.put(5, EnumChatFormatting.YELLOW + "Bosses till next Lvl: " + EnumChatFormatting.LIGHT_PURPLE + (bossesUntilNextLevel > 2000 ? "?" : Integer.valueOf(bossesUntilNextLevel)));
            }
            if (timeSinceLastBoss > 0L && timeSinceLastBoss2 > 0L) {
                lineMap.put(6, EnumChatFormatting.YELLOW + "Average kill time: " + EnumChatFormatting.RED + Utils.prettyTime(System.currentTimeMillis() - agvSlayerTime));
            }
            for (int strIndex : NotEnoughUpdates.INSTANCE.config.slayerOverlay.slayerText) {
                if (lineMap.get(strIndex) == null) continue;
                this.overlayStrings.add(lineMap.get(strIndex));
            }
            if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
                this.overlayStrings = null;
            }
        }
    }

    static {
        RNGMeter = "?";
        isSlain = false;
        slayerLVL = "-1";
        slayerXp = "0";
        unloadOverlayTimer = -1L;
        timeSinceLastBoss = 0L;
        timeSinceLastBoss2 = 0L;
        slayerTier = 0;
        slayerEXP = "0";
        differenceFromLastXP = 0;
        useSmallXpNext = true;
        agvSlayerTime = 0L;
        isSlayerNine = false;
        slayerXPBuffActive = false;
        xpPerBoss = 0;
        bossesUntilNextLevel = 0;
    }
}

