/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import com.google.gson.annotations.Expose;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.guifeatures.SkyMallDisplay;
import io.github.moulberry.notenoughupdates.miscfeatures.GlaciteTunnelWaypoints;
import io.github.moulberry.notenoughupdates.miscfeatures.HotmDesires;
import io.github.moulberry.notenoughupdates.miscfeatures.ItemCooldowns;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.options.separatesections.Mining;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.overlays.TextTabOverlay;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.StarCultCalculator;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.util.vector.Vector2f;

public class MiningOverlay
extends TextTabOverlay {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(?<number>\\d*,?\\d+)(?: |$)");
    public static Map<String, Float> commissionProgress = new LinkedHashMap<String, Float>();
    private static final int MAX_FORGE_SLOTS = 7;
    private static final Pattern timeRemainingForge = Pattern.compile("\\xA77Time Remaining: \\xA7a((?<Completed>Completed!)|(((?<days>[0-9]+)d)? ?((?<hours>[0-9]+)h)? ?((?<minutes>[0-9]+)m)? ?((?<seconds>[0-9]+)s)?))");
    private static final Pattern timeRemainingTab = Pattern.compile(".*[1-5]\\) (?<ItemName>.*): ((?<Ready>Ready!)|(((?<days>[0-9]+)d)? ?((?<hours>[0-9]+)h)? ?((?<minutes>[0-9]+)m)? ?((?<seconds>[0-9]+)s)?))");
    private static final Pattern forgeIntPattern = Pattern.compile("[^)]*([1-7])\\).*");
    private static final HashMap<String, ItemStack> miningOverlayRoughGems = new HashMap<String, ItemStack>(){};
    private static final HashMap<String, ItemStack> miningOverlayPerfectGems = new HashMap<String, ItemStack>(){};
    private static HashMap<String, ItemStack> miningOverlayCommissionItems;

    public MiningOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    @Override
    public void updateFrequent() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            String containerName = lower2.func_145748_c_().func_150260_c();
            if (containerName.equals("Commissions") && lower2.func_70302_i_() >= 27) {
                this.updateCommissions(lower2);
            } else if (containerName.equals("Forge") && lower2.func_70302_i_() >= 36) {
                this.updateForge(lower2);
            }
        }
    }

    private void updateForge(IInventory lower2) {
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        block2: for (int i = 0; i < 7; ++i) {
            String[] lore;
            ItemStack stack = lower2.func_70301_a(i + 11);
            if (stack == null) continue;
            for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p())) {
                ForgeItem newForgeItem3;
                ForgeItem newForgeItem2;
                Matcher matcher = timeRemainingForge.matcher(line);
                if (stack.func_82833_r().matches("\\xA7cSlot #([1-7])")) {
                    newForgeItem2 = new ForgeItem(i, 1, false);
                    MiningOverlay.replaceForgeOrAdd(newForgeItem2, hidden.forgeItems, true);
                    continue;
                }
                if (stack.func_82833_r().matches("\\xA7aSlot #([1-7])")) {
                    newForgeItem2 = new ForgeItem(i, 0, false);
                    MiningOverlay.replaceForgeOrAdd(newForgeItem2, hidden.forgeItems, true);
                    continue;
                }
                if (!matcher.matches()) continue;
                String timeremainingString = matcher.group(1);
                long duration = 0L;
                if (matcher.group("Completed") != null && !matcher.group("Completed").equals("")) {
                    newForgeItem3 = new ForgeItem(Utils.cleanColour(stack.func_82833_r()), 0L, i, false);
                    MiningOverlay.replaceForgeOrAdd(newForgeItem3, hidden.forgeItems, true);
                    continue block2;
                }
                try {
                    if (matcher.group("days") != null && !matcher.group("days").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("days")) * 24L * 60L * 60L * 1000L;
                    }
                    if (matcher.group("hours") != null && !matcher.group("hours").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("hours")) * 60L * 60L * 1000L;
                    }
                    if (matcher.group("minutes") != null && !matcher.group("minutes").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("minutes")) * 60L * 1000L;
                    }
                    if (matcher.group("seconds") != null && !matcher.group("seconds").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("seconds")) * 1000L;
                    }
                }
                catch (Exception newForgeItem3) {
                    // empty catch block
                }
                if (duration <= 0L) continue block2;
                newForgeItem3 = new ForgeItem(Utils.cleanColour(stack.func_82833_r()), System.currentTimeMillis() + duration, i, false);
                MiningOverlay.replaceForgeOrAdd(newForgeItem3, hidden.forgeItems, true);
                continue block2;
            }
        }
    }

    private void updateCommissions(IInventory lower2) {
        String[] lore;
        ItemStack commTypeStack = lower2.func_70301_a(32);
        if (commTypeStack == null || !commTypeStack.func_77942_o()) {
            return;
        }
        String name = Utils.cleanColour(commTypeStack.func_82833_r()).trim();
        if (!name.equals("Filter")) {
            return;
        }
        String commLocation = null;
        for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(commTypeStack.func_77978_p())) {
            if (line == null || !line.contains("\u25b6")) continue;
            String[] cleanLine = Utils.cleanColour(line).replace("\u25b6", "").trim();
            if (cleanLine.equals("Dwarven Mines")) {
                commLocation = "mining_3";
                break;
            }
            if (cleanLine.equals("Crystal Hollows")) {
                commLocation = "crystal_hollows";
                break;
            }
            if (!cleanLine.equals("Glacite Tunnels")) continue;
            commLocation = "mineshaft";
            break;
        }
        if (commLocation == null) {
            return;
        }
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = lower2.func_70301_a(i);
            if (stack == null || !stack.func_77942_o()) continue;
            lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p());
            String commName = null;
            int numberValue = -1;
            for (String line : lore) {
                String textAfter;
                if (commName != null) {
                    String clean = Utils.cleanColour(line).trim();
                    if (clean.isEmpty()) break;
                    Matcher matcher = NUMBER_PATTERN.matcher(clean);
                    if (matcher.find()) {
                        try {
                            numberValue = Integer.parseInt(matcher.group("number").replace(",", ""));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (!line.startsWith("\u00a79") || (textAfter = line.substring(2)).contains("\u00a7") || textAfter.equals("Rewards") || textAfter.equals("Progress")) continue;
                commName = textAfter;
            }
            NEUConfig.HiddenLocationSpecific locationSpecific = NotEnoughUpdates.INSTANCE.config.getLocationSpecific(commLocation);
            if (commName == null || numberValue <= 0) continue;
            locationSpecific.commissionMaxes.put(commName, numberValue);
        }
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.mining.dwarvenOverlay;
    }

    @Nullable
    public NEUConfig.HiddenLocationSpecific getMiningLocationSpecific() {
        String location = SBInfo.getInstance().getLocation();
        if (location == null || location.isEmpty()) {
            return null;
        }
        String sideBarLoc = SBInfo.getInstance().getScoreboardLocation();
        if (location.equals("mining_3") && GlaciteTunnelWaypoints.INSTANCE.getGlaciteTunnelLocations().contains(sideBarLoc)) {
            location = "mineshaft";
        }
        return NotEnoughUpdates.INSTANCE.config.getLocationSpecific(location);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        this.overlayStrings = null;
        NEUConfig.HiddenProfileSpecific profileConfig = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (!NotEnoughUpdates.INSTANCE.config.mining.dwarvenOverlay && NotEnoughUpdates.INSTANCE.config.mining.emissaryWaypoints == 0 && !NotEnoughUpdates.INSTANCE.config.mining.titaniumAlert && NotEnoughUpdates.INSTANCE.config.mining.locWaypoints == 0 && NotEnoughUpdates.INSTANCE.config.mining.tunnelWaypoints.get() != Mining.GlaciteTunnelWaypointBehaviour.NONE && HotmDesires.wantsPowderInfo()) {
            return;
        }
        if (SBInfo.getInstance().getLocation() == null) {
            return;
        }
        if (SBInfo.getInstance().getLocation().equals("mining_3") || SBInfo.getInstance().getLocation().equals("crystal_hollows") || SBInfo.getInstance().getLocation().equals("mineshaft")) {
            commissionProgress.clear();
            String mithrilPowder = "";
            String gemstonePowder = "";
            String glacitePowder = "";
            List<String> powderLines = this.getTabLinesOrAddWarning(1, TablistAPI.WidgetNames.POWDER);
            this.getTabLinesOrAddWarning(2, TablistAPI.WidgetNames.POWDER);
            this.getTabLinesOrAddWarning(6, TablistAPI.WidgetNames.POWDER);
            for (String line : powderLines) {
                if (line.contains("Mithril:")) {
                    mithrilPowder = EnumChatFormatting.DARK_AQUA + Utils.trimWhitespaceAndFormatCodes(line).replaceAll("\u00a7[f|F|r]", "") + HotmDesires.appendDesireForType("Mithril");
                }
                if (line.contains("Gemstone:")) {
                    gemstonePowder = EnumChatFormatting.DARK_AQUA + Utils.trimWhitespaceAndFormatCodes(line).replaceAll("\u00a7[f|F|r]", "") + HotmDesires.appendDesireForType("Gemstone");
                }
                if (!line.contains("Glacite: ")) continue;
                glacitePowder = EnumChatFormatting.DARK_AQUA + Utils.trimWhitespaceAndFormatCodes(line).replaceAll("\u00a7[f|F|r]", "") + HotmDesires.appendDesireForType("Glacite");
            }
            List<String> tabForgeLines = this.getTabLinesOrAddWarning(3, TablistAPI.WidgetNames.FORGE);
            HashSet<Integer> foundForges = new HashSet<Integer>();
            for (String name : tabForgeLines) {
                ForgeItem item;
                String string = StringUtils.cleanColour(name);
                if (!string.startsWith(" ") || profileConfig == null) continue;
                char c = string.trim().charAt(0);
                if (c < '0' || c > '9') break;
                Matcher forgeIntMatcher = forgeIntPattern.matcher(string);
                if (!forgeIntMatcher.matches()) continue;
                int forgeInt = Integer.parseInt(forgeIntMatcher.group(1)) - 1;
                foundForges.add(forgeInt);
                if (name.contains("LOCKED")) {
                    item = new ForgeItem(forgeInt, 1, true);
                    MiningOverlay.replaceForgeOrAdd(item, profileConfig.forgeItems, true);
                    continue;
                }
                if (name.contains("EMPTY")) {
                    item = new ForgeItem(forgeInt, 0, true);
                    MiningOverlay.replaceForgeOrAdd(item, profileConfig.forgeItems, true);
                    continue;
                }
                Matcher matcher = timeRemainingTab.matcher(string);
                if (!matcher.matches()) continue;
                String itemName = matcher.group(1);
                if (matcher.group("Ready") != null && !matcher.group("Ready").equals("")) {
                    ForgeItem item2 = new ForgeItem(Utils.cleanColour(itemName), 0L, forgeInt, true);
                    MiningOverlay.replaceForgeOrAdd(item2, profileConfig.forgeItems, true);
                    continue;
                }
                long duration = 0L;
                try {
                    if (matcher.group("days") != null && !matcher.group("days").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("days")) * 24L * 60L * 60L * 1000L;
                    }
                    if (matcher.group("hours") != null && !matcher.group("hours").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("hours")) * 60L * 60L * 1000L;
                    }
                    if (matcher.group("minutes") != null && !matcher.group("minutes").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("minutes")) * 60L * 1000L;
                    }
                    if (matcher.group("seconds") != null && !matcher.group("seconds").equals("")) {
                        duration += (long)Integer.parseInt(matcher.group("seconds")) * 1000L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (duration <= 0L) continue;
                ForgeItem item3 = new ForgeItem(Utils.cleanColour(itemName), System.currentTimeMillis() + (duration += 4000L), forgeInt, true);
                MiningOverlay.replaceForgeOrAdd(item3, profileConfig.forgeItems, false);
            }
            if (profileConfig != null) {
                for (int i = 0; i < 7; ++i) {
                    if (foundForges.contains(i)) continue;
                    ForgeItem item = new ForgeItem(i, 0, true);
                    MiningOverlay.replaceForgeOrAdd(item, profileConfig.forgeItems, true);
                }
            }
            List<String> tabCommissionLines = this.getTabLinesOrAddWarning(0, TablistAPI.WidgetNames.COMMISSIONS);
            for (String string : tabCommissionLines) {
                String[] split;
                String string2 = StringUtils.cleanColour(string);
                if (!string2.startsWith(" ") || profileConfig == null || (split = string2.trim().split(": ")).length != 2) continue;
                if (split[1].endsWith("%")) {
                    try {
                        float progress = Float.parseFloat(split[1].replace("%", "")) / 100.0f;
                        progress = LerpUtils.clampZeroOne(progress);
                        commissionProgress.put(split[0], Float.valueOf(progress));
                    }
                    catch (Exception progress) {}
                    continue;
                }
                if (!split[1].endsWith("DONE")) continue;
                commissionProgress.put(split[0], Float.valueOf(1.0f));
            }
            if (ItemCooldowns.firstLoadMillis > 0L) {
                ItemCooldowns.pickaxeUseCooldownMillisRemaining = 60000L - (System.currentTimeMillis() - ItemCooldowns.firstLoadMillis);
                ItemCooldowns.firstLoadMillis = 0L;
            }
            if (!NotEnoughUpdates.INSTANCE.config.mining.dwarvenOverlay) {
                this.overlayStrings = null;
                return;
            }
            ArrayList<String> commissionsStrings = new ArrayList<String>();
            for (Map.Entry<String, Float> entry : commissionProgress.entrySet()) {
                if (entry.getValue().floatValue() >= 1.0f) {
                    commissionsStrings.add(EnumChatFormatting.DARK_AQUA + entry.getKey() + ": " + EnumChatFormatting.GREEN + "DONE");
                    continue;
                }
                EnumChatFormatting col = EnumChatFormatting.RED;
                if ((double)entry.getValue().floatValue() >= 0.75) {
                    col = EnumChatFormatting.GREEN;
                } else if ((double)entry.getValue().floatValue() >= 0.5) {
                    col = EnumChatFormatting.YELLOW;
                } else if ((double)entry.getValue().floatValue() >= 0.25) {
                    col = EnumChatFormatting.GOLD;
                }
                String tips = this.getTipPart(entry.getKey());
                boolean newLine = NotEnoughUpdates.INSTANCE.config.mining.commissionTaskTipNewLine;
                String newLineTip = null;
                if (newLine && !tips.isEmpty()) {
                    newLineTip = "  " + tips;
                    tips = "";
                }
                NEUConfig.HiddenLocationSpecific locationSpecific = this.getMiningLocationSpecific();
                int max2 = locationSpecific.commissionMaxes.getOrDefault(entry.getKey(), -1);
                if (-1 != max2) {
                    commissionsStrings.add(EnumChatFormatting.DARK_AQUA + entry.getKey() + ": " + col + Math.round(entry.getValue().floatValue() * (float)max2) + "/" + max2 + tips);
                } else {
                    String valS = Utils.floatToString(entry.getValue().floatValue() * 100.0f, 1);
                    commissionsStrings.add(EnumChatFormatting.DARK_AQUA + entry.getKey() + ": " + col + valS + "%" + tips);
                }
                if (newLineTip == null) continue;
                commissionsStrings.add(newLineTip);
            }
            if (ItemCooldowns.pickaxeUseCooldownMillisRemaining <= 0L) {
                String string = EnumChatFormatting.DARK_AQUA + "Pickaxe CD: \u00a7aReady";
            } else {
                String string = EnumChatFormatting.DARK_AQUA + "Pickaxe CD: \u00a7a" + ItemCooldowns.pickaxeUseCooldownMillisRemaining / 1000L + "s";
            }
            this.overlayStrings = new ArrayList();
            for (int index : NotEnoughUpdates.INSTANCE.config.mining.dwarvenText2) {
                switch (index) {
                    case 0: {
                        this.overlayStrings.addAll(commissionsStrings);
                        break;
                    }
                    case 1: {
                        if (mithrilPowder.isEmpty()) break;
                        this.overlayStrings.add(mithrilPowder);
                        break;
                    }
                    case 2: {
                        if (gemstonePowder.isEmpty()) break;
                        this.overlayStrings.add(gemstonePowder);
                        break;
                    }
                    case 3: {
                        if (profileConfig == null) break;
                        this.overlayStrings.addAll(MiningOverlay.getForgeStrings(profileConfig.forgeItems));
                        break;
                    }
                    case 4: {
                        void var10_21;
                        this.overlayStrings.add(var10_21);
                        break;
                    }
                    case 5: {
                        this.overlayStrings.add(EnumChatFormatting.DARK_AQUA + "Star Cult: " + EnumChatFormatting.GREEN + StarCultCalculator.getNextStarCult());
                        break;
                    }
                    case 6: {
                        this.overlayStrings.add("\u00a73Sky Mall: \u00a7a" + SkyMallDisplay.Companion.getDisplayText());
                        break;
                    }
                    case 7: {
                        if (glacitePowder.isEmpty()) break;
                        this.overlayStrings.add(glacitePowder);
                    }
                }
            }
        } else {
            if (profileConfig == null) {
                return;
            }
            boolean forgeDisplay = false;
            boolean starCultDisplay = false;
            boolean skyMallDisplay = false;
            for (int i = 0; i < NotEnoughUpdates.INSTANCE.config.mining.dwarvenText2.size(); ++i) {
                if (NotEnoughUpdates.INSTANCE.config.mining.dwarvenText2.get(i) == 3) {
                    forgeDisplay = true;
                }
                if (NotEnoughUpdates.INSTANCE.config.mining.dwarvenText2.get(i) == 5) {
                    starCultDisplay = true;
                }
                if (NotEnoughUpdates.INSTANCE.config.mining.dwarvenText2.get(i) != 6) continue;
                skyMallDisplay = true;
            }
            if (starCultDisplay) {
                if (this.overlayStrings == null) {
                    this.overlayStrings = new ArrayList();
                }
                if (!NotEnoughUpdates.INSTANCE.config.mining.starCultDisplayOnlyShowTab || this.lastTabState) {
                    if (NotEnoughUpdates.INSTANCE.config.mining.starCultDisplayEnabledLocations == 1 && !SBInfo.getInstance().isInDungeon) {
                        this.overlayStrings.add(EnumChatFormatting.DARK_AQUA + "Star Cult: " + EnumChatFormatting.GREEN + StarCultCalculator.getNextStarCult());
                    } else if (NotEnoughUpdates.INSTANCE.config.mining.starCultDisplayEnabledLocations == 2) {
                        this.overlayStrings.add(EnumChatFormatting.DARK_AQUA + "Star Cult: " + EnumChatFormatting.GREEN + StarCultCalculator.getNextStarCult());
                    }
                }
            }
            if (forgeDisplay) {
                if (this.overlayStrings == null) {
                    this.overlayStrings = new ArrayList();
                }
                if (!NotEnoughUpdates.INSTANCE.config.mining.forgeDisplayOnlyShowTab || this.lastTabState) {
                    if (NotEnoughUpdates.INSTANCE.config.mining.forgeDisplayEnabledLocations == 1 && !SBInfo.getInstance().isInDungeon) {
                        this.overlayStrings.addAll(MiningOverlay.getForgeStrings(profileConfig.forgeItems));
                    } else if (NotEnoughUpdates.INSTANCE.config.mining.forgeDisplayEnabledLocations == 2) {
                        this.overlayStrings.addAll(MiningOverlay.getForgeStrings(profileConfig.forgeItems));
                    }
                }
            }
            if (skyMallDisplay) {
                if (this.overlayStrings == null) {
                    this.overlayStrings = new ArrayList();
                }
                if (!NotEnoughUpdates.INSTANCE.config.mining.skyMallDisplayOnlyShowTab || this.lastTabState) {
                    if (NotEnoughUpdates.INSTANCE.config.mining.skyMallDisplayEnabledLocations == 1 && !SBInfo.getInstance().isInDungeon) {
                        this.overlayStrings.add(EnumChatFormatting.DARK_AQUA + "Sky Mall: " + EnumChatFormatting.GREEN + SkyMallDisplay.Companion.getDisplayText());
                    } else if (NotEnoughUpdates.INSTANCE.config.mining.skyMallDisplayEnabledLocations == 2) {
                        this.overlayStrings.add(EnumChatFormatting.DARK_AQUA + "Sky Mall: " + EnumChatFormatting.GREEN + SkyMallDisplay.Companion.getDisplayText());
                    }
                }
            }
        }
        if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
            this.overlayStrings = null;
        }
    }

    private List<String> getTabLinesOrAddWarning(int configIndex, TablistAPI.WidgetNames widgetName) {
        List<String> lines;
        if (NotEnoughUpdates.INSTANCE.config.mining.dwarvenText2.contains(configIndex) && NotEnoughUpdates.INSTANCE.config.mining.dwarvenOverlay) {
            lines = TablistAPI.getWidgetLinesWithoutNotification(widgetName);
            if (lines.isEmpty() && (this.overlayStrings == null || !this.overlayStrings.contains("\u00a7l\u00a74One or more tab widgets missing!"))) {
                if (this.overlayStrings == null) {
                    this.overlayStrings = new ArrayList();
                }
                this.overlayStrings.add("\u00a7l\u00a74One or more tab widgets missing!");
                this.overlayStrings.add("\u00a7l\u00a74Enable it in \u00a7b/tab\u00a74!");
            }
        } else {
            lines = TablistAPI.getOptionalWidgetLines(widgetName);
        }
        return lines;
    }

    private String getTipPart(String name) {
        int settings = NotEnoughUpdates.INSTANCE.config.mining.commissionTaskTips;
        if (settings == 0) {
            return "";
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_70093_af() && settings == 1) {
            return "";
        }
        String tip = this.getTip(name);
        if (tip == null) {
            return "  \u00a74???";
        }
        return " \u00a78\u00a7l>\u00a77 " + tip;
    }

    private String getTip(String name) {
        if (SBInfo.getInstance().getLocation().equals("mining_3")) {
            if (name.equals("First Event")) {
                return "Participate in any \u00a76Mining Event";
            }
            if (name.equals("Lucky Raffle")) {
                return "Collect 20 Raffle Tickets during \u00a76Raffle Event";
            }
            if (name.equals("Goblin Raid Slayer")) {
                return "Kill 20 Goblins during \u00a76Goblin Raid Event";
            }
            if (name.equals("Raffle")) {
                return "Participate in \u00a76Raffle Event";
            }
            if (name.equals("Goblin Raid")) {
                return "Participate in \u00a76Goblin Raid event";
            }
            if (name.equals("2x Mithril Powder Collector")) {
                return "Collect 500 Mithril Powder during \u00a762x Powder event";
            }
            if (name.equals("Glacite Walker Slayer")) {
                return "Kill 50 Glacite Walkers \u00a7b(Great Ice Wall)";
            }
            if (name.equals("Goblin Slayer")) {
                return "Kill 100 Goblins \u00a7b(Goblin Burrows)";
            }
            if (name.equals("Golden Goblin Slayer")) {
                return "Kill 1 Golden Goblin (anywhere)";
            }
            if (name.equals("Star Sentry Puncher")) {
                return "Damage Star Sentries 10 times (anywhere)";
            }
            if (name.equals("Treasure Hoarder Puncher")) {
                return "Damage Treasure Hoarders 10 times \u00a7b(Upper Mines)";
            }
            if (name.equals("Mines Slayer")) {
                return "Kill 50 mobs (anywhere)";
            }
            if (name.equals("Mithril Miner")) {
                return "Break 350 Mithril (anywhere)";
            }
            if (name.equals("Titanium Miner")) {
                return "Break 15 Titanium (anywhere)";
            }
            if (name.equals("Cliffside Veins Mithril")) {
                return "Break 250 Mithril \u00a7b(Cliffside Veins)";
            }
            if (name.equals("Royal Mines Mithril")) {
                return "Break 250 Mithril \u00a7b(Royal Mines)";
            }
            if (name.equals("Lava Springs Mithril")) {
                return "Break 250 Mithril \u00a7b(Lava Springs)";
            }
            if (name.equals("Rampart's Quarry Mithril")) {
                return "Break 250 Mithril \u00a7b(Rampart's Quarry)";
            }
            if (name.equals("Upper Mines Mithril")) {
                return "Break 250 Mithril \u00a7b(Upper Mines)";
            }
            if (name.equals("Cliffside Veins Titanium")) {
                return "Break 10 Titanium \u00a7b(Cliffside Veins)";
            }
            if (name.equals("Lava Springs Titanium")) {
                return "Break 10 Titanium \u00a7b(Lava Springs)";
            }
            if (name.equals("Royal Mines Titanium")) {
                return "Break 10 Titanium \u00a7b(Royal Mines)";
            }
            if (name.equals("Rampart's Quarry Titanium")) {
                return "Break 10 Titanium \u00a7b(Rampart's Quarry)";
            }
            if (name.equals("Upper Mines Titanium")) {
                return "Break 10 Titanium \u00a7b(Upper Mines)";
            }
            if (name.equals("Corpse Looter")) {
                return "Find Corpses in a Glacite Mineshaft";
            }
            if (name.equals("Mineshaft Explorer")) {
                return "Discover a Glacite Mineshaft";
            }
            if (name.equals("Scrap Collector")) {
                return "Break non-vanilla Ores and not Hard Stone in a Glacite Mineshaft";
            }
            if (name.equals("Umber Collector")) {
                return "Break red sand/hardened clay";
            }
            if (name.equals("Tungsten Collector")) {
                return "Break cobblestone/clay";
            }
            if (name.equals("Glacite Collector")) {
                return "Break ice";
            }
            if (name.equals("Onyx Gemstone Collector")) {
                return "Break black glass";
            }
            if (name.equals("Aquamarine Gemstone Collector")) {
                return "Break aqua glass";
            }
            if (name.equals("Peridot Gemstone Collector")) {
                return "Break dark green glass";
            }
            if (name.equals("Citrine Gemstone Collector")) {
                return "Break brown glass";
            }
            if (name.equals("Maniac Slayer")) {
                return "Kill mobs in a Glacite Mineshaft";
            }
        } else if (SBInfo.getInstance().getLocation().equals("crystal_hollows")) {
            if (name.equals("Chest Looter")) {
                return "Open 3 chests";
            }
            if (name.equals("Hard Stone Miner")) {
                return "Break 1,000 Hard Stone";
            }
            String jungle = " \u00a7a(Jungle)";
            String goblin = " \u00a76(Goblin Holdout)";
            String mithril = " \u00a7b(Mithril Deposits)";
            String precursor = " \u00a78(Precursor Remenants)";
            String magma = " \u00a7c(Magma Fields)";
            if (name.equals("Goblin Slayer")) {
                return "Kill 13 Goblins" + goblin;
            }
            if (name.equals("Sludge Slayer")) {
                return "Kill 25 Sludges" + jungle;
            }
            if (name.equals("Thyst Slayer")) {
                return "Kill 5 Thysts, when breaking Amethysts" + jungle;
            }
            if (name.equals("Boss Corleone Slayer")) {
                return "Find and kill Corleone" + mithril;
            }
            if (name.equals("Yog Slayer")) {
                return "Kill 13 Yogs" + magma;
            }
            if (name.equals("Automaton Slayer")) {
                return "Kill 13 Automatons" + precursor;
            }
            if (name.equals("Team Treasurite Member Slayer")) {
                return "Kill 13 Team Treasurite Members" + mithril;
            }
            if (name.endsWith("Crystal Hunter")) {
                if (name.startsWith("Amethyst")) {
                    return "Temple Jump & Run" + jungle;
                }
                if (name.startsWith("Jade")) {
                    return "4 weapons from Mines of Divan" + mithril;
                }
                if (name.startsWith("Amber")) {
                    return "King and Queen" + goblin;
                }
                if (name.startsWith("Sapphire")) {
                    return "6 Robot Parts in Precursor City" + precursor;
                }
                if (name.startsWith("Topaz")) {
                    return "Kill Bal" + magma;
                }
            }
            if (name.endsWith("Gemstone Collector")) {
                if (name.startsWith("Amber")) {
                    return "Break orange glass" + goblin;
                }
                if (name.startsWith("Sapphire")) {
                    return "Break blue glass" + precursor;
                }
                if (name.startsWith("Jade")) {
                    return "Break green glass" + mithril;
                }
                if (name.startsWith("Amethyst")) {
                    return "Break purple glass" + jungle;
                }
                if (name.startsWith("Ruby")) {
                    return "Break red glass (anywhere)";
                }
                if (name.startsWith("Topaz")) {
                    return "Break yellow glass" + magma;
                }
            }
        } else if (SBInfo.getInstance().getLocation().equals("mineshaft")) {
            if (name.equals("Corpse Looter")) {
                return "Find Corpses and click them";
            }
            if (name.equals("Mineshaft Explorer")) {
                return "Discover a Glacite Mineshaft";
            }
            if (name.equals("Scrap Collector")) {
                return "Break non-vanilla Ores and not Hard Stone";
            }
            if (name.equals("Umber Collector")) {
                return "Break red sand/hardened clay";
            }
            if (name.equals("Tungsten Collector")) {
                return "Break cobblestone/clay";
            }
            if (name.equals("Glacite Collector")) {
                return "Break ice";
            }
            if (name.equals("Onyx Gemstone Collector")) {
                return "Break black glass";
            }
            if (name.equals("Aquamarine Gemstone Collector")) {
                return "Break aqua glass";
            }
            if (name.equals("Peridot Gemstone Collector")) {
                return "Break dark green glass";
            }
            if (name.equals("Citrine Gemstone Collector")) {
                return "Break brown glass";
            }
        }
        return null;
    }

    private static List<String> getForgeStrings(List<ForgeItem> forgeItems) {
        ArrayList<String> forgeString = new ArrayList<String>();
        long currentTimeMillis = System.currentTimeMillis();
        block0: for (int i = 0; i < 7; ++i) {
            for (ForgeItem item : forgeItems) {
                if (item.forgeID != i) continue;
                if (NotEnoughUpdates.INSTANCE.config.mining.forgeDisplay == 0) {
                    if (item.status != 2 || item.finishTime >= currentTimeMillis) continue;
                    forgeString.add(item.getFormattedString(currentTimeMillis));
                    continue block0;
                }
                if (NotEnoughUpdates.INSTANCE.config.mining.forgeDisplay == 1) {
                    if (item.status != 2) continue;
                    forgeString.add(item.getFormattedString(currentTimeMillis));
                    continue block0;
                }
                if (NotEnoughUpdates.INSTANCE.config.mining.forgeDisplay == 2) {
                    if (item.status != 2 && item.status != 0) continue;
                    forgeString.add(item.getFormattedString(currentTimeMillis));
                    continue block0;
                }
                if (NotEnoughUpdates.INSTANCE.config.mining.forgeDisplay != 3) continue;
                forgeString.add(item.getFormattedString(currentTimeMillis));
                continue block0;
            }
        }
        return forgeString;
    }

    private static void replaceForgeOrAdd(ForgeItem item, List<ForgeItem> forgeItems, boolean overwrite) {
        for (int i = 0; i < forgeItems.size(); ++i) {
            if (forgeItems.get((int)i).forgeID != item.forgeID) continue;
            if (overwrite) {
                forgeItems.set(i, item);
                return;
            }
            ForgeItem currentItem = forgeItems.get(i);
            if (currentItem.status != 2 || item.status != 2) {
                forgeItems.set(i, item);
                return;
            }
            if (currentItem.fromScoreBoard) {
                forgeItems.set(i, item);
                return;
            }
            return;
        }
        forgeItems.add(item);
    }

    @Override
    protected Vector2f getSize(List<String> strings) {
        if (NotEnoughUpdates.INSTANCE.config.mining.dwarvenOverlayIcons) {
            return super.getSize(strings).translate(12.0f, 0.0f);
        }
        return super.getSize(strings);
    }

    @Override
    protected void renderLine(String line, Vector2f position, boolean dummy) {
        if (!NotEnoughUpdates.INSTANCE.config.mining.dwarvenOverlayIcons) {
            return;
        }
        GlStateManager.func_179126_j();
        if (line.contains(">")) {
            return;
        }
        ItemStack icon = null;
        String cleaned = Utils.cleanColour(line);
        String beforeColon = cleaned.split(":")[0];
        if (miningOverlayCommissionItems == null) {
            MiningOverlay.setupMiningOverlayCommissionItems();
        }
        if (miningOverlayCommissionItems.containsKey(beforeColon)) {
            icon = miningOverlayCommissionItems.get(beforeColon);
        } else if (beforeColon.startsWith("Forge")) {
            icon = miningOverlayCommissionItems.get("Forge");
        } else if (beforeColon.contains("Mithril")) {
            icon = miningOverlayCommissionItems.get("Mithril");
        } else if (beforeColon.endsWith(" Gemstone Collector")) {
            String gemName = "ROUGH_" + beforeColon.replace(" Gemstone Collector", "").toUpperCase(Locale.ROOT) + "_GEM";
            if (miningOverlayRoughGems.containsKey(gemName)) {
                icon = miningOverlayRoughGems.get(gemName);
            } else {
                icon = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(gemName));
                miningOverlayRoughGems.put(gemName, icon);
            }
        } else if (beforeColon.endsWith(" Crystal Hunter")) {
            String gemName = "PERFECT_" + beforeColon.replace(" Crystal Hunter", "").toUpperCase(Locale.ROOT) + "_GEM";
            if (miningOverlayPerfectGems.containsKey(gemName)) {
                icon = miningOverlayPerfectGems.get(gemName);
            } else {
                icon = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(gemName));
                miningOverlayPerfectGems.put(gemName, icon);
            }
        } else if (beforeColon.contains("Titanium")) {
            icon = miningOverlayCommissionItems.get("Titanium");
        } else if (beforeColon.contains("Sky Mall")) {
            icon = SkyMallDisplay.Companion.getDisplayItem();
        }
        if (icon != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)position.x, (float)position.y, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            Utils.drawItemStack(icon, 0, 0);
            GlStateManager.func_179121_F();
            position.x += 12.0f;
        }
        super.renderLine(line, position, dummy);
    }

    private static void setupMiningOverlayCommissionItems() {
        miningOverlayCommissionItems = new HashMap<String, ItemStack>(){
            {
                this.addItem("Mithril Powder", "INK_SACK-10");
                this.addItem("Gemstone Powder", "INK_SACK-9");
                this.addItem("Lucky Raffle", "MINING_RAFFLE_TICKET");
                this.addItem("Raffle", "MINING_RAFFLE_TICKET");
                this.addItem("Pickaxe CD", "DIAMOND_PICKAXE");
                this.addItem("Star Cult", "FALLEN_STAR_HAT");
                this.addItem("Thyst Slayer", "THYST_MONSTER");
                this.addItem("Hard Stone Miner", "HARD_STONE");
                this.addItem("Glacite Walker Slayer", "ENCHANTED_ICE");
                this.addItem("Goblin Slayer", "GOBLIN_MONSTER");
                this.addItem("Star Sentry Puncher", "NETHER_STAR");
                this.addItem("Treasure Hoarder Puncher", "TREASURE_HOARDER_MONSTER");
                this.addItem("Mines Slayer", "IRON_SWORD");
                this.addItem("Goblin Raid", "ENCHANTED_GOLD");
                this.addItem("Goblin Raid Slayer", "ENCHANTED_GOLD");
                this.addItem("Golden Goblin Slayer", "GOLD_HELMET");
                this.addItem("2x Mithril Powder Collector", "ENCHANTED_GLOWSTONE_DUST");
                this.addItem("Automaton Slayer", "AUTOMATON_MONSTER");
                this.addItem("Sludge Slayer", "SLUDGE_MONSTER");
                this.addItem("Team Treasurite Member Slayer", "EXECUTIVE_WENDY_MONSTER");
                this.addItem("Yog Slayer", "YOG_MONSTER");
                this.addItem("Boss Corleone Slayer", "BOSS_CORLEONE_BOSS");
                this.addItem("Chest Looter", "CHEST");
                this.addItem("Titanium", "TITANIUM_ORE");
                this.addItem("Mithril", "MITHRIL_ORE");
                this.addItem("Gemstone", "ROCK_GEMSTONE");
                this.addItem("Glacite", "GLACITE");
                this.addItem("Forge", "ANVIL");
                this.addItem("First Event", "FIREWORK");
                this.addItem("Corpse Looter", "MINERAL_HELMET");
                this.addItem("Mineshaft Explorer", "STORAGE_MINECART");
                this.addItem("Scrap Collector", "SUSPICIOUS_SCRAP");
                this.addItem("Umber Collector", "UMBER");
                this.addItem("Tungsten Collector", "TUNGSTEN");
                this.addItem("Glacite Collector", "GLACITE");
                this.addItem("Maniac Slayer", "GLACITE_MUTT_MONSTER");
            }

            private void addItem(String eventName, String internalName) {
                ItemStack itemStack = new ItemResolutionQuery(NotEnoughUpdates.INSTANCE.manager).withKnownInternalName(internalName).resolveToItemStack();
                if (itemStack == null) {
                    Utils.showOutdatedRepoNotification(internalName);
                    return;
                }
                this.put(eventName, itemStack.func_77946_l());
            }
        };
    }

    public static class ForgeItem {
        @Expose
        public String itemName;
        @Expose
        public long finishTime;
        @Expose
        public final int status;
        @Expose
        public final int forgeID;
        @Expose
        public final boolean fromScoreBoard;

        public ForgeItem(String itemName, long finishTime, int forgeID, boolean fromScoreBoard) {
            this.itemName = itemName;
            this.finishTime = finishTime;
            this.status = 2;
            this.forgeID = forgeID;
            this.fromScoreBoard = fromScoreBoard;
        }

        public ForgeItem(int forgeID, int status2, boolean fromScoreBoard) {
            this.forgeID = forgeID;
            this.status = status2;
            this.fromScoreBoard = fromScoreBoard;
        }

        public String getFormattedString(long currentTimeMillis) {
            String returnText = EnumChatFormatting.DARK_AQUA + "Forge " + (this.forgeID + 1) + ": ";
            if (this.status == 0) {
                return returnText + EnumChatFormatting.GRAY + "Empty";
            }
            if (this.status == 1) {
                return returnText + EnumChatFormatting.DARK_RED + "Locked";
            }
            long timeDuration = this.finishTime - currentTimeMillis;
            returnText = returnText + EnumChatFormatting.DARK_PURPLE + this.itemName + ": ";
            int days = (int)(timeDuration / 86400000L);
            int hours = (int)((timeDuration -= (long)(days * 86400000)) / 3600000L % 24L);
            if (days > 0) {
                return returnText + EnumChatFormatting.AQUA + days + "d " + hours + "h";
            }
            int minutes = (int)((timeDuration -= (long)(hours * 3600000)) / 60000L % 60L);
            if (hours > 0) {
                return returnText + EnumChatFormatting.AQUA + hours + "h " + minutes + "m";
            }
            int seconds = (int)((timeDuration -= (long)(minutes * 60000)) / 1000L) % 60;
            if (minutes > 0) {
                return returnText + EnumChatFormatting.AQUA + minutes + "m " + seconds + "s";
            }
            if (seconds > 0) {
                return returnText + EnumChatFormatting.AQUA + seconds + "s";
            }
            return returnText + EnumChatFormatting.DARK_GREEN + "Done";
        }
    }
}

