/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.XPInformation;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class FishingSkillOverlay
extends TextOverlay {
    private long lastUpdate = -1L;
    private long timer = -1L;
    private int expertiseLast = -1;
    private int expertise = -1;
    private int expertiseTier = -1;
    private String expertiseTierAmount = "1";
    private float fishedPerSecondLast = 0.0f;
    private float fishedPerSecond = 0.0f;
    private final LinkedList<Integer> expertiseQueue = new LinkedList();
    private XPInformation.SkillInfo skillInfo = null;
    private XPInformation.SkillInfo skillInfoLast = null;
    private float lastTotalXp = -1.0f;
    private boolean isFishing = false;
    private final LinkedList<Float> xpGainQueue = new LinkedList();
    private float xpGainHourLast = -1.0f;
    private float xpGainHour = -1.0f;
    private int xpGainTimer = 0;
    private final String skillType = "Fishing";

    public FishingSkillOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private float interp(float now, float last) {
        float interp = now;
        if (last >= 0.0f && last != now) {
            float factor = (float)(System.currentTimeMillis() - this.lastUpdate) / 1000.0f;
            factor = LerpUtils.clampZeroOne(factor);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.skillOverlays.FishingSkillOverlay;
    }

    @Override
    public void update() {
        NBTTagCompound ea;
        NBTTagCompound tag;
        if (!this.isEnabled()) {
            this.expertise = -1;
            this.overlayStrings = null;
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.expertiseLast = this.expertise;
        this.xpGainHourLast = this.xpGainHour;
        this.expertise = -1;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b("ExtraAttributes", 10) && (ea = tag.func_74775_l("ExtraAttributes")).func_150297_b("expertise_kills", 99)) {
            this.expertise = ea.func_74762_e("expertise_kills");
            this.expertiseQueue.add(0, this.expertise);
        }
        if (this.expertise < 50) {
            this.expertiseTier = 1;
        } else if (this.expertise < 100) {
            this.expertiseTier = 2;
        } else if (this.expertise < 250) {
            this.expertiseTier = 3;
        } else if (this.expertise < 500) {
            this.expertiseTier = 4;
        } else if (this.expertise < 1000) {
            this.expertiseTier = 5;
        } else if (this.expertise < 2500) {
            this.expertiseTier = 6;
        } else if (this.expertise < 5500) {
            this.expertiseTier = 7;
        } else if (this.expertise < 10000) {
            this.expertiseTier = 8;
        } else if (this.expertise < 15000) {
            this.expertiseTier = 9;
        } else if (this.expertise > 15000) {
            this.expertiseTier = 10;
        }
        switch (this.expertiseTier) {
            case 1: {
                this.expertiseTierAmount = "50";
                break;
            }
            case 2: {
                this.expertiseTierAmount = "100";
                break;
            }
            case 3: {
                this.expertiseTierAmount = "250";
                break;
            }
            case 4: {
                this.expertiseTierAmount = "500";
                break;
            }
            case 5: {
                this.expertiseTierAmount = "1,000";
                break;
            }
            case 6: {
                this.expertiseTierAmount = "2,500";
                break;
            }
            case 7: {
                this.expertiseTierAmount = "5,500";
                break;
            }
            case 8: {
                this.expertiseTierAmount = "10,000";
                break;
            }
            case 9: {
                this.expertiseTierAmount = "15,000";
                break;
            }
            case 10: {
                this.expertiseTierAmount = "Maxed";
            }
        }
        String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack);
        this.skillInfoLast = this.skillInfo;
        List<Integer> s = NotEnoughUpdates.INSTANCE.config.skillOverlays.fishingText;
        this.skillInfo = XPInformation.getInstance().getSkillInfo("Fishing", s.contains(1) || s.contains(2) || s.contains(3) || s.contains(4) || s.contains(5));
        if (this.skillInfo != null) {
            float totalXp = (float)this.skillInfo.totalXp;
            if (this.lastTotalXp > 0.0f) {
                float f;
                Iterator iterator;
                float totalGain;
                float delta = totalXp - this.lastTotalXp;
                if (delta > 0.0f && delta < 1000.0f) {
                    this.xpGainTimer = NotEnoughUpdates.INSTANCE.config.skillOverlays.fishingPauseTimer;
                    this.xpGainQueue.add(0, Float.valueOf(delta));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    totalGain = 0.0f;
                    iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isFishing = true;
                } else if (this.xpGainTimer > 0) {
                    --this.xpGainTimer;
                    this.xpGainQueue.add(0, Float.valueOf(0.0f));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    totalGain = 0.0f;
                    iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isFishing = true;
                } else if (delta <= 0.0f) {
                    this.isFishing = false;
                }
            }
            this.lastTotalXp = totalXp;
        }
        while (this.expertiseQueue.size() >= 4) {
            this.expertiseQueue.removeLast();
        }
        if (this.expertiseQueue.isEmpty()) {
            this.fishedPerSecond = -1.0f;
            this.fishedPerSecondLast = 0.0f;
        } else {
            this.fishedPerSecondLast = this.fishedPerSecond;
            int last = this.expertiseQueue.getLast();
            int first = this.expertiseQueue.getFirst();
            this.fishedPerSecond = (float)(first - last) / 3.0f;
        }
        this.overlayStrings = this.expertise != -1 ? new ArrayList() : null;
    }

    @Override
    public void updateFrequent() {
        super.updateFrequent();
        if (this.expertise < 0) {
            this.overlayStrings = null;
        } else {
            int counterInterp;
            HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
            this.overlayStrings = new ArrayList();
            NumberFormat format2 = NumberFormat.getIntegerInstance();
            if (this.expertiseTier <= 9) {
                counterInterp = (int)this.interp(this.expertise, this.expertiseLast);
                lineMap.put(0, EnumChatFormatting.AQUA + "Expertise: " + EnumChatFormatting.YELLOW + format2.format(counterInterp) + "/" + this.expertiseTierAmount);
            }
            if (this.expertiseTier == 10) {
                counterInterp = (int)this.interp(this.expertise, this.expertiseLast);
                lineMap.put(0, EnumChatFormatting.AQUA + "Expertise: " + EnumChatFormatting.YELLOW + format2.format(counterInterp) + " " + EnumChatFormatting.RED + this.expertiseTierAmount);
            }
            float xpInterp = this.xpGainHour;
            if (this.xpGainHourLast == this.xpGainHour && this.xpGainHour <= 0.0f) {
                lineMap.put(4, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + "N/A");
            } else {
                xpInterp = this.interp(this.xpGainHour, this.xpGainHourLast);
                lineMap.put(4, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + format2.format(xpInterp) + (this.isFishing ? "" : EnumChatFormatting.RED + " (PAUSED)"));
            }
            if (this.skillInfo != null && this.skillInfo.level < 50) {
                StringBuilder levelStr = new StringBuilder(EnumChatFormatting.AQUA + "Fishing" + ": ");
                levelStr.append(EnumChatFormatting.YELLOW).append(this.skillInfo.level).append(EnumChatFormatting.GRAY).append(" [");
                float progress = (float)(this.skillInfo.currentXp / this.skillInfo.currentXpMax);
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    progress = this.interp(progress, (float)(this.skillInfoLast.currentXp / this.skillInfoLast.currentXpMax));
                }
                float lines = 25.0f;
                int i = 0;
                while ((float)i < lines) {
                    if ((float)i / lines < progress) {
                        levelStr.append(EnumChatFormatting.YELLOW);
                    } else {
                        levelStr.append(EnumChatFormatting.DARK_GRAY);
                    }
                    levelStr.append('|');
                    ++i;
                }
                levelStr.append(EnumChatFormatting.GRAY).append("] ").append(EnumChatFormatting.YELLOW).append((int)(progress * 100.0f)).append("%");
                int current = (int)this.skillInfo.currentXp;
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    current = (int)this.interp(current, (float)this.skillInfoLast.currentXp);
                }
                int remaining = (int)(this.skillInfo.currentXpMax - this.skillInfo.currentXp);
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    remaining = (int)this.interp(remaining, (int)(this.skillInfoLast.currentXpMax - this.skillInfoLast.currentXp));
                }
                lineMap.put(1, levelStr.toString());
                lineMap.put(2, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format2.format(current));
                if (remaining < 0) {
                    lineMap.put(3, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + "MAXED!");
                    lineMap.put(5, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "MAXED!");
                } else {
                    lineMap.put(3, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + format2.format(remaining));
                    if (this.xpGainHour < 1000.0f) {
                        lineMap.put(5, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "N/A");
                    } else {
                        lineMap.put(5, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + Utils.prettyTime((long)remaining * 1000L * 60L * 60L / (long)xpInterp));
                    }
                }
            }
            if (this.skillInfo != null && this.skillInfo.level == 50) {
                int current = (int)this.skillInfo.currentXp;
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    current = (int)this.interp(current, (float)this.skillInfoLast.currentXp);
                }
                lineMap.put(1, EnumChatFormatting.AQUA + "Fishing: " + EnumChatFormatting.YELLOW + "50 " + EnumChatFormatting.RED + "(Maxed)");
                lineMap.put(2, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format2.format(current));
            }
            int key = NotEnoughUpdates.INSTANCE.config.skillOverlays.fishKey;
            PositionedSound sound = new PositionedSound(new ResourceLocation("random.orb")){
                {
                    this.field_147662_b = 50.0f;
                    this.field_147659_g = false;
                    this.field_147665_h = 0;
                    this.field_147666_i = ISound.AttenuationType.NONE;
                }
            };
            int funnyCustomTimer = 1000 * NotEnoughUpdates.INSTANCE.config.skillOverlays.customFishTimer;
            if (KeybindHelper.isKeyPressed(key) && this.timer != 0L && System.currentTimeMillis() - this.timer > 1000L) {
                this.timer = 0L;
            } else if (KeybindHelper.isKeyPressed(key) && this.timer == 0L) {
                this.timer = System.currentTimeMillis();
            }
            if (this.timer >= 1L) {
                lineMap.put(6, EnumChatFormatting.AQUA + "Timer: " + EnumChatFormatting.YELLOW + Utils.prettyTime(System.currentTimeMillis() - this.timer));
            }
            if (this.timer <= 0L) {
                lineMap.put(6, EnumChatFormatting.AQUA + "Timer: " + EnumChatFormatting.RED + "(Stopped)");
            }
            if (System.currentTimeMillis() - this.timer > (long)funnyCustomTimer && System.currentTimeMillis() - this.timer < (long)(funnyCustomTimer + 100) && funnyCustomTimer != 0) {
                float oldLevel = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.PLAYERS);
                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.PLAYERS, 1.0f);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.PLAYERS, oldLevel);
            }
            for (int strIndex : NotEnoughUpdates.INSTANCE.config.skillOverlays.fishingText) {
                if (lineMap.get(strIndex) == null) continue;
                this.overlayStrings.add(lineMap.get(strIndex));
            }
            if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
                this.overlayStrings = null;
            }
        }
    }
}

