/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.mixins;

import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class MixinItemStack {
    @Shadow
    private NBTTagCompound field_77990_d;

    @Inject(method={"hasEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasEffect(CallbackInfoReturnable<Boolean> cir) {
        if (Utils.getHasEffectOverride()) {
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"getDisplayName"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDisplayName(CallbackInfoReturnable<String> returnable) {
        try {
            String customName;
            if (this.field_77990_d == null || !this.field_77990_d.func_150297_b("ExtraAttributes", 10)) {
                return;
            }
            ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem((ItemStack)this);
            if (data != null && data.customName != null && (customName = data.customName) != null && !customName.equals("")) {
                customName = Utils.chromaStringByColourCode(customName);
                if (data.customNamePrefix != null) {
                    customName = data.customNamePrefix + customName;
                }
                returnable.setReturnValue((Object)customName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;hasKey(Ljava/lang/String;I)Z", ordinal=2))
    public boolean getTooltip_hasKey2(NBTTagCompound nbttagcompound, String key, int type2) {
        ItemStack stack = (ItemStack)this;
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null && data.customLeatherColour != null && ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
            return true;
        }
        if (data != null && !ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
            return false;
        }
        return nbttagcompound.func_150297_b("color", 3);
    }

    @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Ljava/lang/Integer;toHexString(I)Ljava/lang/String;"))
    public String getTooltip_toHexString(int colour) {
        ItemStack stack = (ItemStack)this;
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null && data.customLeatherColour != null && ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
            int currentColour = ChromaColour.specialToChromaRGB(data.customLeatherColour);
            Color c = new Color(currentColour, false);
            String hex = Integer.toHexString(c.getRGB() & 0xFFFFFF);
            if (hex.length() < 6) {
                hex = hex + "000000".substring(0, 6 - hex.length());
            }
            return hex.length() < 6 ? "0" + hex : hex;
        }
        return Integer.toHexString(colour);
    }
}

