/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.pricegraph;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.GraphDataProvider;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.PriceObject;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/ServerGraphDataProvider;", "Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/GraphDataProvider;", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "loadData", "Ljava/util/concurrent/CompletableFuture;", "", "Ljava/time/Instant;", "Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/PriceObject;", "itemId", "", "NotEnoughUpdates"})
public final class ServerGraphDataProvider
implements GraphDataProvider {
    @NotNull
    public static final ServerGraphDataProvider INSTANCE = new ServerGraphDataProvider();
    private static final Gson gson = new GsonBuilder().create();

    private ServerGraphDataProvider() {
    }

    @Override
    @NotNull
    public CompletableFuture<Map<Instant, PriceObject>> loadData(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        CompletableFuture<Map<Instant, PriceObject>> completableFuture = CompletableFuture.supplyAsync(() -> ServerGraphDataProvider.loadData$lambda$0(itemId));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026yAsync response\n        }");
        return completableFuture;
    }

    private static final Map loadData$lambda$0(String $itemId) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)$itemId, (String)"$itemId");
        JsonObject jsonObject2 = NotEnoughUpdates.INSTANCE.manager.apiUtils.request().url("https://" + NotEnoughUpdates.INSTANCE.config.ahGraph.serverUrl).queryArgument("item", $itemId).requestJson().get();
        JsonObject jsonObject3 = jsonObject = jsonObject2 != null ? jsonObject2.getAsJsonObject() : null;
        if (jsonObject == null) {
            return null;
        }
        JsonObject request = jsonObject;
        Map response = new LinkedHashMap();
        for (Map.Entry<String, JsonElement> element : request.entrySet()) {
            PriceObject priceObject;
            Instant instant;
            Map map2 = response;
            Intrinsics.checkNotNullExpressionValue((Object)Instant.parse(element.getKey()), (String)"parse(element.key)");
            Intrinsics.checkNotNullExpressionValue((Object)gson.fromJson(element.getValue(), PriceObject.class), (String)"gson.fromJson(element.va\u2026 PriceObject::class.java)");
            map2.put(instant, priceObject);
        }
        return response;
    }
}

