/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.render;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.MinionSource;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class MinionHelperTooltips {
    private final MinionHelperManager manager;
    private boolean pressedShiftLast = false;
    private boolean showFullCost = false;

    public MinionHelperTooltips(MinionHelperManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        boolean shift;
        if (!this.manager.inCraftedMinionsInventory()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.tooltip) {
            return;
        }
        if (this.manager.notReady()) {
            return;
        }
        boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (!this.pressedShiftLast && shift) {
            this.showFullCost = !this.showFullCost;
        }
        this.pressedShiftLast = shift;
        ItemStack itemStack = event.itemStack;
        if (itemStack == null) {
            return;
        }
        String displayName = itemStack.func_82833_r();
        if (!displayName.endsWith(" Minion")) {
            return;
        }
        displayName = StringUtils.cleanColour(displayName);
        List<String> lore = ItemUtils.getLore(itemStack);
        if (lore.get(0).equals("\u00a77You haven't crafted this minion.")) {
            return;
        }
        int index = 0;
        for (String line : lore) {
            ++index;
            if (!line.contains("Tier")) continue;
            Minion minion = this.manager.getMinionByName(displayName, index);
            if (minion == null) {
                System.err.println("minion is null for displayName '" + displayName + "' and tier " + index);
                continue;
            }
            MinionSource minionSource = minion.getMinionSource();
            if (minionSource == null) {
                System.err.println("minionSource is null for " + minion.getInternalName());
                continue;
            }
            String format2 = this.manager.getPriceCalculation().calculateUpgradeCostsFormat(minion, !this.showFullCost);
            event.toolTip.set(index, line + " \u00a78- " + format2);
        }
        if (this.showFullCost) {
            event.toolTip.add("\u00a78[Press SHIFT to show upgrade cost]");
        } else {
            event.toolTip.add("\u00a78[Press SHIFT to show full cost]");
        }
    }
}

