/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.repo;

import com.google.common.collect.ArrayListMultimap;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.util.Utils;

public class RecipeBuilder {
    private final MinionHelperManager manager;
    private Minion parent = null;
    private final ArrayListMultimap<String, Integer> items = ArrayListMultimap.create();

    public RecipeBuilder(MinionHelperManager manager) {
        this.manager = manager;
    }

    public Minion getParent() {
        return this.parent;
    }

    public ArrayListMultimap<String, Integer> getItems() {
        return this.items;
    }

    public void addLine(Minion minion, String rawString) {
        String[] split = rawString.split(":");
        String itemName = split[0];
        boolean isParent = false;
        if (itemName.contains("_GENERATOR_")) {
            Minion recipeMinion;
            String minionInternalName = minion.getInternalName();
            boolean same = StringUtils.removeLastWord(itemName, "_").equals(StringUtils.removeLastWord(minionInternalName, "_"));
            if (same && (recipeMinion = this.manager.getMinionById(itemName)).getTier() == minion.getTier() - 1) {
                this.parent = recipeMinion;
                if (this.parent == null && NotEnoughUpdates.INSTANCE.config.hidden.dev) {
                    Utils.addChatMessage("Parent is null for minion " + minionInternalName);
                }
                isParent = true;
            }
        }
        if (!isParent) {
            if (split.length != 2) {
                this.items.put((Object)"AIR", (Object)0);
                return;
            }
            int amount = Integer.parseInt(split[1]);
            this.items.put((Object)itemName, (Object)amount);
        }
    }
}

