/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MinionHelperChatLoader {
    private final MinionHelperManager manager;
    private final Pattern PATTERN_OWN_MINION = Pattern.compile("\u00a7r\u00a7aYou crafted a \u00a7eTier (\\S+) (.+) Minion\u00a7a! That's a new one!(\\r\\n|\\r|\\n)(.*)");
    private final Pattern PATTERN_COOP_MINION = Pattern.compile("(.+)\u00a7f \u00a7acrafted a \u00a7eTier (\\S+) (.+) Minion\u00a7a!(\u00a7r)?(\\r\\n|\\r|\\n)?(.*)?");

    public MinionHelperChatLoader(MinionHelperManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onChat(ClientChatReceivedEvent event) {
        if (event.type != 0) {
            return;
        }
        String message = event.message.func_150254_d();
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            return;
        }
        try {
            Matcher coopMatcher;
            Matcher ownMatcher = this.PATTERN_OWN_MINION.matcher(message);
            if (ownMatcher.matches()) {
                String rawTier = ownMatcher.group(1);
                int tier = Utils.parseRomanNumeral(rawTier);
                String name = ownMatcher.group(2) + " Minion";
                name = Utils.cleanColour(name);
                this.setCrafted(this.manager.getMinionByName(name, tier));
            }
            if ((coopMatcher = this.PATTERN_COOP_MINION.matcher(message)).matches()) {
                String rawTier = coopMatcher.group(2);
                int tier = Utils.parseRomanNumeral(rawTier);
                String name = coopMatcher.group(3) + " Minion";
                this.setCrafted(this.manager.getMinionByName(name, tier));
                this.manager.getOverlay().resetCache();
            }
            if (message.startsWith("\u00a7r\u00a77Switching to profile ")) {
                this.manager.getApi().prepareProfileSwitch();
            }
        }
        catch (Exception e2) {
            Utils.addChatMessage("\u00a7c[NEU] Minion Helper failed reading the minion upgrade message. See the logs for more info!");
            e2.printStackTrace();
        }
    }

    private void setCrafted(Minion minion) {
        this.manager.setCrafted(minion);
    }
}

