/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper;

import com.google.common.collect.ArrayListMultimap;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.auction.APIManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.renderables.OverviewLine;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.MinionRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.CraftingSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.CustomSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.MinionSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.NpcSource;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Minion
extends OverviewLine {
    private final String internalName;
    private final int tier;
    private String displayName;
    private MinionSource minionSource;
    private CustomSource customSource;
    private Minion parent;
    private final List<MinionRequirement> requirements = new ArrayList<MinionRequirement>();
    private boolean crafted = false;
    private final int xpGain;
    private boolean meetRequirements = false;

    public Minion(String internalName, int tier, int xpGain) {
        this.internalName = internalName;
        this.tier = tier;
        this.xpGain = xpGain;
    }

    public MinionSource getMinionSource() {
        return this.minionSource;
    }

    public void setMinionSource(MinionSource minionSource) {
        this.minionSource = minionSource;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isCrafted() {
        return this.crafted;
    }

    public void setCrafted(boolean crafted) {
        this.crafted = crafted;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setParent(Minion parent) {
        this.parent = parent;
    }

    public Minion getParent() {
        return this.parent;
    }

    public int getTier() {
        return this.tier;
    }

    public List<MinionRequirement> getRequirements() {
        return this.requirements;
    }

    public boolean doesMeetRequirements() {
        return this.meetRequirements;
    }

    public void setMeetRequirements(boolean meetRequirements) {
        this.meetRequirements = meetRequirements;
    }

    public int getXpGain() {
        return this.xpGain;
    }

    @Override
    public void onClick() {
        if (Mouse.getEventButton() != 0 || !Keyboard.isKeyDown((int)29)) {
            NotEnoughUpdates.INSTANCE.manager.displayGuiItemRecipe(this.internalName);
        } else {
            ArrayListMultimap<String, Integer> items2;
            HashMap<String, Integer> counts;
            if (this.minionSource instanceof CraftingSource) {
                CraftingSource craftingSource = (CraftingSource)this.minionSource;
                counts = new HashMap<String, Integer>();
                items2 = craftingSource.getItems();
                Minion.openBazaar(items2, counts);
            }
            if (this.minionSource instanceof NpcSource) {
                NpcSource npcSource = (NpcSource)this.minionSource;
                counts = new HashMap();
                items2 = npcSource.getItems();
                Minion.openBazaar(items2, counts);
            }
        }
    }

    private static void openBazaar(ArrayListMultimap<String, Integer> items2, Map<String, Integer> counts) {
        for (Map.Entry entry : items2.entries()) {
            counts.compute((String)entry.getKey(), (k, v) -> (v == null ? 0 : v) + (Integer)entry.getValue());
        }
        Optional<Map.Entry> resource = counts.entrySet().stream().filter(it -> !APIManager.hardcodedVanillaItems.contains(it.getKey())).filter(it -> !((String)it.getKey()).startsWith("SKYBLOCK_")).max(Comparator.comparingInt(Map.Entry::getValue));
        if (!resource.isPresent()) {
            return;
        }
        String bazaarName = (String)resource.get().getKey();
        int totalAmount = (Integer)resource.get().getValue();
        Utils.copyToClipboard(String.valueOf(totalAmount));
        ItemStack itemStack = new ItemResolutionQuery(NotEnoughUpdates.INSTANCE.manager).withKnownInternalName(bazaarName).resolveToItemStack();
        if (itemStack != null) {
            String displayName = Utils.cleanColour(itemStack.func_82833_r());
            NotEnoughUpdates.INSTANCE.trySendCommand("/bz " + displayName);
        }
    }

    public void setCustomSource(CustomSource customSource) {
        this.customSource = customSource;
    }

    public CustomSource getCustomSource() {
        return this.customSource;
    }
}

