/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.itemcustomization;

import com.google.common.collect.Lists;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.miscgui.GuiEnchantColour;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.DyeMode;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.GuiItemCustomize;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.GuiType;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class ItemCustomizationUtils {
    public static List<String> customizeColourGuide = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.AQUA + "Set a custom name for the item", EnumChatFormatting.GREEN + "", EnumChatFormatting.GREEN + "Type \"&&\" for \u00b6", EnumChatFormatting.GREEN + "Type \"**\" for \u272a", EnumChatFormatting.GREEN + "Type \"*1-9\" for \u278a-\u2792", EnumChatFormatting.GREEN + "", EnumChatFormatting.GREEN + "Available colour codes:", Utils.chromaString("\u00b6z = Chroma"), EnumChatFormatting.DARK_BLUE + "\u00b61 = Dark Blue", EnumChatFormatting.DARK_GREEN + "\u00b62 = Dark Green", EnumChatFormatting.DARK_AQUA + "\u00b63 = Dark Aqua", EnumChatFormatting.DARK_RED + "\u00b64 = Dark Red", EnumChatFormatting.DARK_PURPLE + "\u00b65 = Dark Purple", EnumChatFormatting.GOLD + "\u00b66 = Gold", EnumChatFormatting.GRAY + "\u00b67 = Gray", EnumChatFormatting.DARK_GRAY + "\u00b68 = Dark Gray", EnumChatFormatting.BLUE + "\u00b69 = Blue", EnumChatFormatting.GREEN + "\u00b6a = Green", EnumChatFormatting.AQUA + "\u00b6b = Aqua", EnumChatFormatting.RED + "\u00b6c = Red", EnumChatFormatting.LIGHT_PURPLE + "\u00b6d = Purple", EnumChatFormatting.YELLOW + "\u00b6e = Yellow", EnumChatFormatting.WHITE + "\u00b6f = White", "\u00a7Z\u00b6Z = SBA Chroma" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " (Requires SBA)", "", EnumChatFormatting.GREEN + "Available formatting codes:", EnumChatFormatting.GRAY + "\u00b6k = " + EnumChatFormatting.OBFUSCATED + "Obfuscated", EnumChatFormatting.GRAY + "\u00b6l = " + EnumChatFormatting.BOLD + "Bold", EnumChatFormatting.GRAY + "\u00b6m = " + EnumChatFormatting.STRIKETHROUGH + "Strikethrough", EnumChatFormatting.GRAY + "\u00b6n = " + EnumChatFormatting.UNDERLINE + "Underline", EnumChatFormatting.GRAY + "\u00b6o = " + EnumChatFormatting.ITALIC + "Italic"});
    public static List<String> resetGuide = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.RED + "" + EnumChatFormatting.BOLD + "This will reset all customisations!!", EnumChatFormatting.GREEN + "", EnumChatFormatting.RED + "Only click if you are sure you want to reset everything for this item"});
    public static List<String> speedGuide = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.AQUA + "This is how fast the dyes will cycle, in ticks", EnumChatFormatting.GRAY + "\u00a76Hypixel \u00a77dyes cycle every 2 ticks", EnumChatFormatting.GRAY + "", EnumChatFormatting.GRAY + "In the \u00a7dgradient mode \u00a77this decides the amount of intermediary colours", EnumChatFormatting.GRAY + "This means if speed is set to 1 it's the same as \u00a7aCycling mode"});
    public static List<String> skullGuide = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.GOLD + "How to use custom skulls", EnumChatFormatting.YELLOW + "1. Search for the skull in the item list", EnumChatFormatting.YELLOW + "2. Middle click on the item in the item list, this should give you the item id", EnumChatFormatting.YELLOW + "3. Copy the item id and put it after \"skull:\". Make sure you remove the \"id:\"", EnumChatFormatting.YELLOW + "", EnumChatFormatting.GREEN + "Examples:", EnumChatFormatting.YELLOW + "skull:YOUNG DRAGON HELMET", EnumChatFormatting.YELLOW + "skull:WITHER_GOGGLES_CELESTIAL"});
    static final ResourceLocation RESET = new ResourceLocation("notenoughupdates:itemcustomize/reset.png");
    static final ResourceLocation CROSS = new ResourceLocation("notenoughupdates:itemcustomize/cross.png");

    public static ItemStack copy(ItemStack stack, GuiItemCustomize instance) {
        ItemStack customStack = stack.func_77946_l();
        if (!instance.textFieldCustomItem.getText().isEmpty()) {
            NBTTagCompound customSkull;
            customStack.func_150996_a(ItemCustomizeManager.getCustomItem(stack, instance.textFieldCustomItem.getText().trim()));
            customStack.func_77964_b(ItemCustomizeManager.getCustomItemDamage(stack));
            NBTTagCompound tagCompound = customStack.func_77978_p();
            if (tagCompound != null && (customSkull = ItemCustomizeManager.getCustomSkull(customStack)) != null) {
                tagCompound.func_82580_o("SkullOwner");
                tagCompound.func_74782_a("SkullOwner", (NBTBase)customSkull);
            }
        }
        return customStack;
    }

    public static int getGlintColour(GuiItemCustomize instance) {
        int col = instance.customGlintColour == null ? ChromaColour.specialToChromaRGB(ItemCustomizeManager.DEFAULT_GLINT_COLOR) : ChromaColour.specialToChromaRGB(instance.customGlintColour);
        return 0xFF000000 | col;
    }

    public static int getLeatherColour(GuiItemCustomize instance) {
        if (!instance.supportCustomLeatherColour) {
            return -16777216;
        }
        String customLeatherColour = instance.customLeatherColour;
        int col = customLeatherColour == null ? ((ItemArmor)instance.customItemStack.func_77973_b()).func_82814_b(instance.customItemStack) : ChromaColour.specialToChromaRGB(customLeatherColour);
        return 0xFF000000 | col;
    }

    public static int getLeatherColour(String colourString) {
        return 0xFF000000 | ChromaColour.specialToChromaRGB(colourString);
    }

    public static String getChromaStrFromLeatherColour(GuiItemCustomize instance) {
        ItemStack customItemStack = instance.customItemStack;
        return ChromaColour.special(0, 255, ((ItemArmor)customItemStack.func_77973_b()).func_82814_b(customItemStack));
    }

    public static void renderFooter(int xCenter, int yTop, GuiType guiType) {
        int xCentreLeft = xCenter - 90;
        int xCentreRight = xCenter;
        Gui.func_73734_a((int)xCentreLeft, (int)yTop, (int)(xCenter + 1), (int)(yTop + 17), (int)-15724522);
        Gui.func_73734_a((int)xCentreLeft, (int)yTop, (int)(xCenter - 1), (int)(yTop + 15), (int)-15724522);
        Gui.func_73734_a((int)(xCentreLeft - 1), (int)(yTop + 1), (int)(xCenter - 2), (int)(yTop + 14), (int)-16711740);
        Utils.renderShadowedString(ItemCustomizationUtils.getButtons(guiType, 0).getDisplay(), xCentreLeft + 44, yTop + 4, xCenter * 2 - xCentreRight);
        Gui.func_73734_a((int)(xCentreLeft += 90), (int)yTop, (int)(xCentreRight += 90), (int)(yTop + 17), (int)0x70000000);
        Gui.func_73734_a((int)xCentreLeft, (int)yTop, (int)xCentreRight, (int)(yTop + 15), (int)-15724522);
        Gui.func_73734_a((int)(xCentreLeft - 1), (int)(yTop + 1), (int)xCentreRight, (int)(yTop + 14), (int)-16646264);
        Utils.renderShadowedString(ItemCustomizationUtils.getButtons(guiType, 1).getDisplay(), xCentreLeft + 45, yTop + 4, xCenter * 2 - xCentreRight);
    }

    public static GuiType getButtons(GuiType guiType, int button) {
        if (button == 0) {
            if (guiType == GuiType.DEFAULT) {
                return GuiType.ANIMATED;
            }
            return GuiType.DEFAULT;
        }
        if (button == 1) {
            if (guiType == GuiType.HYPIXEL) {
                return GuiType.ANIMATED;
            }
            return GuiType.HYPIXEL;
        }
        return GuiType.DEFAULT;
    }

    public static GuiType getButtonClicked(int mouseX, int mouseY, GuiType guiType, float offset) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int xCentreLeft = xCenter - 90;
        int xCentreRight = xCenter;
        for (int i = 0; i < 2; ++i) {
            if (mouseX >= xCentreLeft && mouseX <= xCentreRight && (float)mouseY >= offset - 7.0f && (float)mouseY <= offset + 12.0f) {
                return ItemCustomizationUtils.getButtons(guiType, i);
            }
            xCentreLeft += 90;
            xCentreRight += 90;
        }
        return null;
    }

    public static int getAnimatedDyeColour(String[] dyeColours, int ticks, DyeMode dyeMode) {
        if (dyeMode == DyeMode.GRADIENT) {
            int i = ItemCustomizationUtils.getTicksForList(ticks, dyeColours.length);
            int dyeColour1 = ChromaColour.specialToChromaRGB(dyeColours[i]);
            i = i == dyeColours.length - 1 ? 0 : ++i;
            int dyeColour2 = ChromaColour.specialToChromaRGB(dyeColours[i]);
            return ItemCustomizationUtils.blendColors(dyeColour1, dyeColour2, (float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa % ticks) / (float)ticks);
        }
        return ChromaColour.specialToChromaRGB(dyeColours[ItemCustomizationUtils.getTicksForList(ticks, dyeColours.length)]);
    }

    public static void renderColourBlob(int xCenter, int yTop, int colour, String text, boolean renderReset, boolean renderCross) {
        Gui.func_73734_a((int)(xCenter - 90), (int)yTop, (int)(xCenter + 92), (int)(yTop + 17), (int)0x70000000);
        Gui.func_73734_a((int)(xCenter - 90), (int)yTop, (int)(xCenter + 90), (int)(yTop + 15), (int)-15724522);
        Gui.func_73734_a((int)(xCenter - 89), (int)(yTop + 1), (int)(xCenter + 89), (int)(yTop + 14), (int)(0xFF000000 | colour));
        Utils.renderShadowedString(text, xCenter, yTop + 4, 180);
        if (renderReset) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RESET);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedRect(xCenter + 90 - 12, yTop + 2, 10.0f, 11.0f, 9728);
        }
        if (renderCross) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CROSS);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedRect(xCenter + 90 - 12, yTop + 3, 9.0f, 9.0f, 9728);
        }
    }

    public static void renderTextBox(GuiElementTextField textField, String text, int xOffset, int yOffset, int maxTextSize) {
        if (!textField.getFocus() && textField.getText().isEmpty()) {
            textField.setOptions(128);
            textField.setPrependText(text);
        } else {
            textField.setOptions(130);
            textField.setPrependText("");
        }
        if (!textField.getFocus()) {
            textField.setSize(maxTextSize, 20);
        } else {
            int textSize = Minecraft.func_71410_x().field_71466_p.func_78256_a(textField.getTextDisplay()) + 10;
            textField.setSize(Math.max(textSize, maxTextSize), 20);
        }
        textField.render(xOffset, yOffset);
    }

    public static Color getColourFromHex(String hex) {
        Color color = null;
        try {
            int decode = Integer.decode(hex);
            color = new Color(decode);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return color;
    }

    public static int rgbToInt(Color color) {
        return color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public static void renderPresetButtons(int x, int y, boolean valid, boolean secondValid, String preset) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiEnchantColour.custom_ench_colour);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(x - 88 + 198, y + 2, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawTexturedRect(x - 88 + 198, y + 2 + 24, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawStringCenteredScaledMaxWidth("Load " + preset, x - 44 + 198, y + 8, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("from Clipboard", x - 44 + 198, y + 16, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("Save " + preset, x - 44 + 198, y + 8 + 24, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("to Clipboard", x - 44 + 198, y + 16 + 24, false, 86, 0x404040);
        if (!valid) {
            Gui.func_73734_a((int)(x - 88 + 198), (int)(y + 2), (int)(x + 198), (int)(y + 2 + 20), (int)Integer.MIN_VALUE);
        }
        if (!secondValid) {
            Gui.func_73734_a((int)(x - 88 + 198), (int)(y + 2 + 24), (int)(x + 198), (int)(y + 2 + 20 + 24), (int)Integer.MIN_VALUE);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean validShareContents(String sharePrefix) {
        String base64 = Utils.getClipboard();
        if (base64 == null) {
            return false;
        }
        if (base64.length() <= sharePrefix.length()) {
            return false;
        }
        base64 = base64.trim();
        try {
            return new String(Base64.getDecoder().decode(base64)).startsWith(sharePrefix);
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static void shareContents(String sharePrefix, String jsonObject) {
        String base64String = Base64.getEncoder().encodeToString((sharePrefix + jsonObject).getBytes(StandardCharsets.UTF_8));
        Utils.copyToClipboard(base64String);
    }

    public static String getShareFromClipboard(String sharePrefix) {
        String jsonString;
        String base64 = Utils.getClipboard();
        if (base64 == null) {
            return null;
        }
        if (base64.length() <= sharePrefix.length()) {
            return null;
        }
        base64 = base64.trim();
        try {
            jsonString = new String(Base64.getDecoder().decode(base64));
            if (!jsonString.startsWith(sharePrefix)) {
                return null;
            }
            jsonString = jsonString.substring(sharePrefix.length());
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
        return jsonString;
    }

    public static int blendColors(int startColorInt, int endColorInt, float ratio) {
        Color startColour = new Color(startColorInt);
        Color endColour = new Color(endColorInt);
        int redStart = startColour.getRed();
        int greenStart = startColour.getGreen();
        int blueStart = startColour.getBlue();
        int redEnd = endColour.getRed();
        int greenEnd = endColour.getGreen();
        int blueEnd = endColour.getBlue();
        int red = (int)((float)redStart + (float)(redEnd - redStart) * ratio);
        int green = (int)((float)greenStart + (float)(greenEnd - greenStart) * ratio);
        int blue = (int)((float)blueStart + (float)(blueEnd - blueStart) * ratio);
        return red << 16 | green << 8 | blue;
    }

    public static int getTicksForList(int speedTicks, int listSize) {
        return ItemCustomizationUtils.getTicksForList(speedTicks, listSize, -1);
    }

    public static int getTicksForList(int speedTicks, int listSize, int presetIndex) {
        int animatedIndex = Minecraft.func_71410_x().field_71439_g.field_70173_aa / speedTicks % listSize;
        if (presetIndex >= 0 && presetIndex < listSize) {
            animatedIndex = presetIndex;
        }
        return animatedIndex;
    }
}

