/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.auction.APIManager;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.SlotLocking;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class TradeWindow {
    private static final ResourceLocation location = new ResourceLocation("notenoughupdates", "custom_trade.png");
    private static final int xSize = 176;
    private static final int ySize = 204;
    private static int guiLeft;
    private static int guiTop;
    private static long lastTradeMillis;
    private static final long CHANGE_EXCLAM_MILLIS = 5000L;
    private static Integer[] ourTradeIndexes;
    private static Integer[] theirTradeIndexes;
    private static String[] theirTradeOld;
    private static Long[] theirTradeChangesMillis;

    public static boolean hypixelTradeWindowActive(String containerName) {
        return containerName != null && containerName.trim().startsWith("You     ");
    }

    public static boolean tradeWindowActive(String containerName) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.config.tradeMenu.enableCustomTrade) {
            return false;
        }
        if (TradeWindow.hypixelTradeWindowActive(containerName)) {
            return true;
        }
        if (lastTradeMillis != -99L) {
            lastTradeMillis = -99L;
            ourTradeIndexes = new Integer[16];
            theirTradeIndexes = new Integer[16];
            theirTradeOld = new String[16];
            theirTradeChangesMillis = new Long[16];
        }
        return false;
    }

    private static void drawStringShadow(String str, float x, float y, int len2) {
        for (int xOff = -2; xOff <= 2; ++xOff) {
            for (int yOff = -2; yOff <= 2; ++yOff) {
                if (Math.abs(xOff) == Math.abs(yOff)) continue;
                Utils.drawStringCenteredScaledMaxWidth(Utils.cleanColourNotModifiers(str), x + (float)xOff / 2.0f, y + (float)yOff / 2.0f, false, len2, new Color(20, 20, 20, 100 / Math.max(Math.abs(xOff), Math.abs(yOff))).getRGB());
            }
        }
        Utils.drawStringCenteredScaledMaxWidth(str, x, y, false, len2, new Color(64, 64, 64, 255).getRGB());
    }

    private static long getPrice(String internalName) {
        APIManager.CraftInfo craftCost;
        JsonObject info;
        JsonObject bazaarInfo;
        long pricePer = NotEnoughUpdates.INSTANCE.manager.auctionManager.getLowestBin(internalName);
        if (pricePer == -1L && (bazaarInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(internalName)) != null && bazaarInfo.has("avg_buy")) {
            pricePer = (long)bazaarInfo.get("avg_buy").getAsDouble();
        }
        if (pricePer == -1L && (info = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfo(internalName)) != null && !NotEnoughUpdates.INSTANCE.manager.auctionManager.isVanillaItem(internalName) && info.has("price") && info.has("count")) {
            pricePer = (long)(info.get("price").getAsDouble() / info.get("count").getAsDouble());
        }
        if (pricePer == -1L && (craftCost = NotEnoughUpdates.INSTANCE.manager.auctionManager.getCraftCost(internalName)) != null) {
            pricePer = (int)craftCost.craftCost;
        }
        return pricePer;
    }

    private static long processTopItems(ItemStack stack, Map<Long, Set<String>> topItems, Map<String, ItemStack> topItemsStack, Map<String, Integer> topItemsCount) {
        String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack);
        if (internalname == null) {
            if (stack.func_82833_r().endsWith(" coins")) {
                String clean = Utils.cleanColour(stack.func_82833_r());
                int mult = 1;
                StringBuilder sb = new StringBuilder();
                for (int index = 0; index < clean.length(); ++index) {
                    char c = clean.charAt(index);
                    if ("0123456789.".indexOf(c) < 0) {
                        switch (c) {
                            case 'K': 
                            case 'k': {
                                mult = 1000;
                                break;
                            }
                            case 'M': 
                            case 'm': {
                                mult = 1000000;
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                mult = 1000000000;
                                break;
                            }
                        }
                        break;
                    }
                    sb.append(c);
                }
                try {
                    int coins = (int)(Float.parseFloat(sb.toString()) * (float)mult);
                    topItemsStack.putIfAbsent("TRADE_COINS", stack);
                    long existingPrice = coins;
                    HashSet<Long> toRemove = new HashSet<Long>();
                    for (Map.Entry<Long, Set<String>> entry : topItems.entrySet()) {
                        if (entry.getValue().contains("TRADE_COINS")) {
                            entry.getValue().remove("TRADE_COINS");
                            existingPrice += entry.getKey().longValue();
                        }
                        if (!entry.getValue().isEmpty()) continue;
                        toRemove.add(entry.getKey());
                    }
                    topItems.keySet().removeAll(toRemove);
                    Set items2 = topItems.computeIfAbsent(existingPrice, k -> new HashSet());
                    items2.add("TRADE_COINS");
                    return coins;
                }
                catch (Exception exception) {}
            }
        } else {
            long pricePer = TradeWindow.getPrice(internalname);
            if (pricePer > 0L) {
                Object items3;
                long price;
                topItemsStack.putIfAbsent(internalname, stack);
                long priceInclBackpack = price = pricePer * (long)stack.field_77994_a;
                NBTTagCompound tag = stack.func_77978_p();
                if (tag != null && tag.func_150297_b("ExtraAttributes", 10)) {
                    NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
                    byte[] bytes = null;
                    for (String key : ea.func_150296_c()) {
                        if (!key.endsWith("backpack_data") && !key.equals("new_year_cake_bag_data")) continue;
                        bytes = ea.func_74770_j(key);
                        break;
                    }
                    if (bytes != null) {
                        try {
                            NBTTagCompound contents_nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
                            items3 = contents_nbt.func_150295_c("i", 10);
                            for (int k2 = 0; k2 < items3.func_74745_c(); ++k2) {
                                Item mcItem;
                                if (items3.func_150305_b(k2).func_150296_c().size() <= 0) continue;
                                NBTTagCompound nbt = items3.func_150305_b(k2).func_74775_l("tag");
                                int id2 = items3.func_150305_b(k2).func_74765_d("id");
                                byte count2 = items3.func_150305_b(k2).func_74771_c("Count");
                                short damage2 = items3.func_150305_b(k2).func_74765_d("Damage");
                                if (id2 == 141) {
                                    id2 = 391;
                                }
                                if ((mcItem = Item.func_150899_d((int)id2)) == null) continue;
                                ItemStack stack2 = new ItemStack(mcItem, (int)count2, (int)damage2);
                                stack2.func_77982_d(nbt);
                                priceInclBackpack += TradeWindow.processTopItems(stack2, topItems, topItemsStack, topItemsCount);
                            }
                        }
                        catch (Exception contents_nbt) {
                            // empty catch block
                        }
                    }
                }
                long existingPrice = price;
                HashSet<Long> toRemove = new HashSet<Long>();
                for (Map.Entry<Long, Set<String>> entry : topItems.entrySet()) {
                    if (entry.getValue().contains(internalname)) {
                        entry.getValue().remove(internalname);
                        existingPrice += entry.getKey().longValue();
                    }
                    if (!entry.getValue().isEmpty()) continue;
                    toRemove.add(entry.getKey());
                }
                topItems.keySet().removeAll(toRemove);
                items3 = topItems.computeIfAbsent(existingPrice, k -> new HashSet());
                items3.add(internalname);
                int count = topItemsCount.computeIfAbsent(internalname, l -> 0);
                topItemsCount.put(internalname, count + stack.field_77994_a);
                return priceInclBackpack;
            }
        }
        return 0L;
    }

    private static int getBackpackValue(ItemStack stack) {
        int price = 0;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("ExtraAttributes", 10)) {
            NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
            byte[] bytes = null;
            for (String key : ea.func_150296_c()) {
                if (!key.endsWith("backpack_data") && !key.equals("new_year_cake_bag_data")) continue;
                bytes = ea.func_74770_j(key);
                break;
            }
            if (bytes != null) {
                try {
                    NBTTagCompound contents_nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
                    NBTTagList items2 = contents_nbt.func_150295_c("i", 10);
                    for (int k = 0; k < items2.func_74745_c(); ++k) {
                        long pricePer2;
                        if (items2.func_150305_b(k).func_150296_c().size() <= 0) continue;
                        NBTTagCompound nbt = items2.func_150305_b(k).func_74775_l("tag");
                        String internalname2 = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemNBT(nbt).resolveInternalName();
                        if (internalname2 == null || (pricePer2 = TradeWindow.getPrice(internalname2)) <= 0L) continue;
                        byte count2 = items2.func_150305_b(k).func_74771_c("Count");
                        price = (int)((long)price + pricePer2 * (long)count2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return price;
    }

    public static void render(int mouseX, int mouseY) {
        ItemStack theirConfirmStack;
        String confirmDisplay;
        ItemStack confirmStack;
        int i;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        guiLeft = (scaledResolution.func_78326_a() - 176) / 2;
        guiTop = (scaledResolution.func_78328_b() - 204) / 2;
        List tooltipToDisplay = null;
        ItemStack stackToRender = null;
        int tooltipLen = -1;
        TreeMap<Long, List> ourTradeMap = new TreeMap<Long, List>();
        for (int i2 = 0; i2 < 16; ++i2) {
            TradeWindow.ourTradeIndexes[i2] = -1;
            int x = i2 % 4;
            int y = i2 / 4;
            int containerIndex = y * 9 + x;
            ItemStack stack = (ItemStack)chest.field_147002_h.func_75138_a().get(containerIndex);
            if (stack == null) continue;
            String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack);
            if (internalname == null) {
                if (stack.func_82833_r().endsWith(" coins")) {
                    List list;
                    String clean = Utils.cleanColour(stack.func_82833_r());
                    int mult = 1;
                    StringBuilder sb = new StringBuilder();
                    for (int index = 0; index < clean.length(); ++index) {
                        char c = clean.charAt(index);
                        if ("0123456789.".indexOf(c) < 0) {
                            switch (c) {
                                case 'K': 
                                case 'k': {
                                    mult = 1000;
                                    break;
                                }
                                case 'M': 
                                case 'm': {
                                    mult = 1000000;
                                    break;
                                }
                                case 'B': 
                                case 'b': {
                                    mult = 1000000000;
                                    break;
                                }
                            }
                            break;
                        }
                        sb.append(c);
                    }
                    try {
                        int coins = (int)(Float.parseFloat(sb.toString()) * (float)mult);
                        list = ourTradeMap.computeIfAbsent(Long.valueOf(coins), k -> new ArrayList());
                        list.add(containerIndex);
                    }
                    catch (Exception ignored) {
                        list = ourTradeMap.computeIfAbsent(-1L, k -> new ArrayList());
                        list.add(containerIndex);
                    }
                    continue;
                }
                List list = ourTradeMap.computeIfAbsent(-1L, k -> new ArrayList());
                list.add(containerIndex);
                continue;
            }
            long price = TradeWindow.getPrice(internalname);
            if (price == -1L) {
                price = 0L;
            }
            List list = ourTradeMap.computeIfAbsent(price += (long)TradeWindow.getBackpackValue(stack), k -> new ArrayList());
            list.add(containerIndex);
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<ItemStack[]> theirTradeCurrent = new ArrayList<ItemStack[]>();
        TreeMap<Integer, List> theirTradeMap = new TreeMap<Integer, List>();
        HashMap<String, Integer> displayCountMap = new HashMap<String, Integer>();
        for (int i3 = 0; i3 < 16; ++i3) {
            String internalname;
            ItemStack[] uuid;
            TradeWindow.theirTradeIndexes[i3] = -1;
            if (theirTradeChangesMillis[i3] == null || currentTime - theirTradeChangesMillis[i3] > 5000L) {
                TradeWindow.theirTradeChangesMillis[i3] = -1L;
            }
            int x = i3 % 4;
            int y = i3 / 4;
            int containerIndex = y * 9 + x + 5;
            ItemStack stack = (ItemStack)chest.field_147002_h.func_75138_a().get(containerIndex);
            if (stack == null) continue;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && tag.func_150297_b("ExtraAttributes", 10)) {
                NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
                if (ea.func_150297_b("uuid", 8)) {
                    uuid = ea.func_74779_i("uuid");
                } else {
                    int displayCount = displayCountMap.computeIfAbsent(stack.func_82833_r(), k -> 0);
                    uuid = stack.func_82833_r() + ":" + displayCount;
                    displayCountMap.put(stack.func_82833_r(), displayCount + 1);
                }
            } else {
                int displayCount = displayCountMap.computeIfAbsent(stack.func_82833_r(), k -> 0);
                uuid = stack.func_82833_r() + ":" + displayCount;
                displayCountMap.put(stack.func_82833_r(), displayCount + 1);
            }
            if (uuid != null) {
                theirTradeCurrent.add(uuid);
            }
            if ((internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack)) == null) {
                if (stack.func_82833_r().endsWith(" coins")) {
                    List list;
                    String clean = Utils.cleanColour(stack.func_82833_r());
                    int mult = 1;
                    StringBuilder sb = new StringBuilder();
                    for (int index = 0; index < clean.length(); ++index) {
                        char c = clean.charAt(index);
                        if ("0123456789.".indexOf(c) < 0) {
                            switch (c) {
                                case 'K': 
                                case 'k': {
                                    mult = 1000;
                                    break;
                                }
                                case 'M': 
                                case 'm': {
                                    mult = 1000000;
                                    break;
                                }
                                case 'B': 
                                case 'b': {
                                    mult = 1000000000;
                                    break;
                                }
                            }
                            break;
                        }
                        sb.append(c);
                    }
                    try {
                        int coins = (int)(Float.parseFloat(sb.toString()) * (float)mult);
                        list = theirTradeMap.computeIfAbsent(coins, k -> new ArrayList());
                        list.add(containerIndex);
                    }
                    catch (Exception ignored) {
                        list = theirTradeMap.computeIfAbsent(-1, k -> new ArrayList());
                        list.add(containerIndex);
                    }
                    continue;
                }
                List list = theirTradeMap.computeIfAbsent(-1, k -> new ArrayList());
                list.add(containerIndex);
                continue;
            }
            JsonObject info = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfo(internalname);
            int price = -1;
            if (info != null && info.has("price") && info.has("count")) {
                int auctionPricePer = (int)(info.get("price").getAsFloat() / info.get("count").getAsFloat());
                price = auctionPricePer * stack.field_77994_a;
            } else {
                JsonObject bazaarInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(internalname);
                if (bazaarInfo != null && bazaarInfo.has("avg_buy")) {
                    price = (int)bazaarInfo.get("avg_buy").getAsFloat() * stack.field_77994_a;
                }
            }
            List list = theirTradeMap.computeIfAbsent(price += TradeWindow.getBackpackValue(stack), k -> new ArrayList());
            list.add(containerIndex);
        }
        int ourTradeIndex = 0;
        for (Map.Entry entry : ourTradeMap.descendingMap().entrySet()) {
            for (Integer index : (List)entry.getValue()) {
                TradeWindow.ourTradeIndexes[ourTradeIndex++] = index;
            }
        }
        int maxMissing = 16 - theirTradeCurrent.size();
        int j = 0;
        for (i = 0; i < 16; ++i) {
            while (j <= 15 && j - i < maxMissing && theirTradeChangesMillis[j] >= 0L) {
                ++j;
            }
            j = Math.min(15, j);
            String oldUUID = theirTradeOld[i];
            if (oldUUID != null && !theirTradeCurrent.contains(oldUUID)) {
                TradeWindow.theirTradeChangesMillis[j] = System.currentTimeMillis();
            }
            ++j;
        }
        for (i = 0; i < 16; ++i) {
            TradeWindow.theirTradeOld[i] = null;
        }
        int theirTradeIndex = 0;
        displayCountMap.clear();
        j = 0;
        for (Map.Entry entry : theirTradeMap.descendingMap().entrySet()) {
            for (Integer index : (List)entry.getValue()) {
                String uuid;
                while (j <= 15 && j - theirTradeIndex < maxMissing && theirTradeChangesMillis[j] >= 0L) {
                    ++j;
                }
                j = Math.min(15, j);
                TradeWindow.theirTradeIndexes[j] = index;
                ItemStack stack = (ItemStack)chest.field_147002_h.func_75138_a().get(index);
                if (stack == null) continue;
                NBTTagCompound tag = stack.func_77978_p();
                if (tag != null && tag.func_150297_b("ExtraAttributes", 10)) {
                    NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
                    if (ea.func_150297_b("uuid", 8)) {
                        uuid = ea.func_74779_i("uuid");
                    } else {
                        int displayCount = displayCountMap.computeIfAbsent(stack.func_82833_r(), k -> 0);
                        uuid = stack.func_82833_r() + ":" + displayCount;
                        displayCountMap.put(stack.func_82833_r(), displayCount + 1);
                    }
                } else {
                    int displayCount = displayCountMap.computeIfAbsent(stack.func_82833_r(), k -> 0);
                    uuid = stack.func_82833_r() + ":" + displayCount;
                    displayCountMap.put(stack.func_82833_r(), displayCount + 1);
                }
                TradeWindow.theirTradeOld[theirTradeIndex] = uuid;
                ++j;
                ++theirTradeIndex;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        Utils.drawTexturedRect(guiLeft, guiTop, 176.0f, 204.0f, 0.0f, 0.6875f, 0.0f, 0.796875f, 9728);
        Utils.drawStringF(new ChatComponentTranslation("container.inventory", new Object[0]).func_150260_c(), guiLeft + 8, guiTop + 111, false, 0x404040);
        Utils.drawStringF("You", guiLeft + 8, guiTop + 5, false, 421752);
        String[] split = containerName.split(" ");
        if (split.length >= 1) {
            Utils.drawStringF(split[split.length - 1], guiLeft + 167 - Minecraft.func_71410_x().field_71466_p.func_78256_a(split[split.length - 1]), guiTop + 5, false, 0x404040);
        }
        int index = 0;
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            int x = 8 + 18 * (index % 9);
            int y = 104 + 18 * (index / 9);
            if (index < 9) {
                y = 180;
            }
            ((AccessorGuiContainer)chest).doDrawSlot(new Slot((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by, index, guiLeft + x, guiTop + y));
            int col = -2130706433;
            if (SlotLocking.getInstance().isSlotIndexLocked(index)) {
                col = -2130739072;
            }
            if (mouseX > guiLeft + x - 1 && mouseX < guiLeft + x + 18 && mouseY > guiTop + y - 1 && mouseY < guiTop + y + 18) {
                if (stack != null) {
                    stackToRender = stack;
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                Utils.drawGradientRect(guiLeft + x, guiTop + y, guiLeft + x + 16, guiTop + y + 16, col, col);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            ++index;
        }
        for (int i4 = 0; i4 < 16; ++i4) {
            int x = i4 % 4;
            int y = i4 / 4;
            int containerIndex = ourTradeIndexes[i4];
            ItemStack stack = null;
            if (containerIndex >= 0) {
                stack = (ItemStack)chest.field_147002_h.func_75138_a().get(containerIndex);
                Utils.drawItemStack(stack, guiLeft + 10 + x * 18, guiTop + 15 + y * 18);
            }
            if (mouseX <= guiLeft + 10 + x * 18 - 1 || mouseX >= guiLeft + 10 + x * 18 + 18 || mouseY <= guiTop + 15 + y * 18 - 1 || mouseY >= guiTop + 15 + y * 18 + 18) continue;
            if (stack != null) {
                stackToRender = stack;
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Utils.drawGradientRect(guiLeft + 10 + x * 18, guiTop + 15 + y * 18, guiLeft + 10 + x * 18 + 16, guiTop + 15 + y * 18 + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        ItemStack bidStack = (ItemStack)chest.field_147002_h.func_75138_a().get(36);
        if (bidStack != null) {
            Utils.drawItemStack(bidStack, guiLeft + 10, guiTop + 90);
            if (mouseX > guiLeft + 10 - 1 && mouseX < guiLeft + 10 + 18 && mouseY > guiTop + 90 - 1 && mouseY < guiTop + 90 + 18) {
                tooltipToDisplay = bidStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        }
        if ((confirmStack = (ItemStack)chest.field_147002_h.func_75138_a().get(39)) != null && !(confirmDisplay = confirmStack.func_82833_r()).equals(EnumChatFormatting.GREEN + "Trading!")) {
            if (mouseX > guiLeft + 81 - 51 && mouseX < guiLeft + 81 && mouseY > guiTop + 91 && mouseY < guiTop + 91 + 14) {
                tooltipToDisplay = confirmStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
            Utils.drawTexturedRect(guiLeft + 81 - 51, guiTop + 91, 51.0f, 14.0f, 0.0f, 0.19921875f, 0.796875f, 0.8515625f, 9728);
            Pattern pattern = Pattern.compile(EnumChatFormatting.GRAY + "\\(" + EnumChatFormatting.YELLOW + "([0-9]+)" + EnumChatFormatting.GRAY + "\\)");
            Matcher matcher = pattern.matcher(confirmDisplay);
            if (!confirmDisplay.equals(EnumChatFormatting.YELLOW + "Warning!") && !confirmDisplay.equals(EnumChatFormatting.YELLOW + "Deal!")) {
                lastTradeMillis = -1L;
            }
            if (matcher.find()) {
                String numS = matcher.group(1);
                int num = Integer.parseInt(numS);
                Utils.drawStringCentered(EnumChatFormatting.DARK_RED + "Check " + EnumChatFormatting.BOLD + (char)(9311 + num), guiLeft + 56, guiTop + 99, false, 0x404040);
            } else if (confirmDisplay.equals(EnumChatFormatting.AQUA + "Gift!")) {
                Utils.drawStringCentered(EnumChatFormatting.GREEN + "Accept", guiLeft + 56, guiTop + 99, true, 0x404040);
            } else if (confirmDisplay.equals(EnumChatFormatting.GREEN + "Deal accepted!")) {
                Utils.drawStringCentered(EnumChatFormatting.GREEN + "Accepted", guiLeft + 56, guiTop + 99, true, 0x404040);
            } else if (lastTradeMillis > 0L) {
                long delta = System.currentTimeMillis() - lastTradeMillis;
                if (delta > 2000L) {
                    Utils.drawStringCentered(EnumChatFormatting.GREEN + "Accept", guiLeft + 56, guiTop + 99, true, 0x404040);
                } else {
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Trade " + EnumChatFormatting.BOLD + (char)(9312L + (2000L - delta) / 1000L), guiLeft + 56, guiTop + 99, true, 0x404040);
                }
            } else {
                Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Trade " + EnumChatFormatting.BOLD + '\u2462', guiLeft + 56, guiTop + 99, true, 0x404040);
            }
        }
        if ((theirConfirmStack = (ItemStack)chest.field_147002_h.func_75138_a().get(41)) != null) {
            String confirmDisplay2 = theirConfirmStack.func_82833_r();
            if (mouseX > guiLeft + 95 && mouseX < guiLeft + 95 + 51 && mouseY > guiTop + 91 && mouseY < guiTop + 91 + 14) {
                tooltipToDisplay = theirConfirmStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
            Utils.drawTexturedRect(guiLeft + 95, guiTop + 91, 51.0f, 14.0f, 0.0f, 0.19921875f, 0.796875f, 0.8515625f, 9728);
            if (confirmDisplay2.equals(EnumChatFormatting.YELLOW + "Pending their confirm")) {
                Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Pending", guiLeft + 120, guiTop + 99, true, 0x404040);
            } else if (confirmDisplay2.equals(EnumChatFormatting.YELLOW + "Deal timer...")) {
                Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Pending", guiLeft + 120, guiTop + 99, true, 0x404040);
            } else if (confirmDisplay2.equals(EnumChatFormatting.GREEN + "Other player confirmed!")) {
                Utils.drawStringCentered(EnumChatFormatting.GREEN + "Accepted", guiLeft + 120, guiTop + 99, true, 0x404040);
            }
        }
        for (int i5 = 0; i5 < 16; ++i5) {
            int x = i5 % 4;
            int y = i5 / 4;
            int containerIndex = theirTradeIndexes[i5];
            ItemStack stack = null;
            if (containerIndex >= 0) {
                stack = (ItemStack)chest.field_147002_h.func_75138_a().get(containerIndex);
                Utils.drawItemStack(stack, guiLeft + 96 + x * 18, guiTop + 15 + y * 18);
            }
            if (currentTime % 400L > 200L && theirTradeChangesMillis[i5] != null && theirTradeChangesMillis[i5] > 0L) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
                Utils.drawTexturedRect(guiLeft + 96 + x * 18, guiTop + 15 + y * 18, 16.0f, 16.0f, 0.19921875f, 0.26171875f, 0.796875f, 0.859375f, 9728);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
            }
            if (mouseX <= guiLeft + 96 + x * 18 - 1 || mouseX >= guiLeft + 96 + x * 18 + 18 || mouseY <= guiTop + 15 + y * 18 - 1 || mouseY >= guiTop + 15 + y * 18 + 18) continue;
            if (stack != null) {
                stackToRender = stack;
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Utils.drawGradientRect(guiLeft + 96 + x * 18, guiTop + 15 + y * 18, guiLeft + 96 + x * 18 + 16, guiTop + 15 + y * 18 + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        if (NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePrices) {
            TreeMap<Long, Set<String>> ourTopItems = new TreeMap<Long, Set<String>>();
            TreeMap<String, ItemStack> ourTopItemsStack = new TreeMap<String, ItemStack>();
            TreeMap<String, Integer> ourTopItemsCount = new TreeMap<String, Integer>();
            double ourPrice = 0.0;
            for (int i6 = 0; i6 < 16; ++i6) {
                int x = i6 % 4;
                int y = i6 / 4;
                int containerIndex = y * 9 + x;
                ItemStack stack = (ItemStack)chest.field_147002_h.func_75138_a().get(containerIndex);
                if (stack == null) continue;
                ourPrice += (double)TradeWindow.processTopItems(stack, ourTopItems, ourTopItemsStack, ourTopItemsCount);
            }
            TreeMap<Long, Set<String>> theirTopItems = new TreeMap<Long, Set<String>>();
            TreeMap<String, ItemStack> theirTopItemsStack = new TreeMap<String, ItemStack>();
            TreeMap<String, Integer> theirTopItemsCount = new TreeMap<String, Integer>();
            double theirPrice = 0.0;
            for (int i7 = 0; i7 < 16; ++i7) {
                int x = i7 % 4;
                int y = i7 / 4;
                int containerIndex = y * 9 + x + 5;
                ItemStack stack = (ItemStack)chest.field_147002_h.func_75138_a().get(containerIndex);
                if (stack == null) continue;
                theirPrice += (double)TradeWindow.processTopItems(stack, theirTopItems, theirTopItemsStack, theirTopItemsCount);
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
            Utils.drawTexturedRect(guiLeft - 80 - 3, guiTop, 80.0f, 106.0f, 0.6875f, 1.0f, 0.0f, 0.4140625f, 9728);
            TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + "Total Value", guiLeft - 40 - 3, guiTop + 11, 72);
            TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + StringUtils.formatNumber(ourPrice), guiLeft - 40 - 3, guiTop + 21, 72);
            int ourTopIndex = Math.max(0, 3 - ourTopItemsStack.size());
            block31: for (Map.Entry entry : ourTopItems.descendingMap().entrySet()) {
                for (String ourTopItemInternal : (Set)entry.getValue()) {
                    ItemStack stack = ourTopItemsStack.get(ourTopItemInternal);
                    if (stack == null) continue;
                    if (NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePriceStyle) {
                        String countS = "";
                        if (ourTopItemsCount.containsKey(ourTopItemInternal)) {
                            int count = ourTopItemsCount.get(ourTopItemInternal);
                            countS = count > 999999 ? Math.floor((float)count / 10000.0f) / 100.0 + "m" : (count > 999 ? Math.floor((float)count / 10.0f) / 100.0 + "k" : "" + count);
                        }
                        Utils.drawItemStackWithText(stack, guiLeft - 75 - 3, guiTop + 49 + 18 * ourTopIndex, countS);
                        GlStateManager.func_179140_f();
                        GlStateManager.func_179084_k();
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + StringUtils.formatNumber((Number)entry.getKey()), guiLeft - 29 - 3, guiTop + 57 + 18 * ourTopIndex, 52);
                        GlStateManager.func_179147_l();
                    } else {
                        TradeWindow.drawStringShadow(stack.func_82833_r() + EnumChatFormatting.GRAY + "x" + ourTopItemsCount.get(ourTopItemInternal), guiLeft - 40 - 3, guiTop + 46 + 20 * ourTopIndex, 72);
                        TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + StringUtils.formatNumber((Number)entry.getKey()), guiLeft - 40 - 3, guiTop + 56 + 20 * ourTopIndex, 72);
                    }
                    if (++ourTopIndex < 3) continue;
                    break block31;
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
            Utils.drawTexturedRect(guiLeft + 176 + 3, guiTop, 80.0f, 106.0f, 0.6875f, 1.0f, 0.0f, 0.4140625f, 9728);
            TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + "Total Value", guiLeft + 176 + 3 + 40, guiTop + 11, 72);
            TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + StringUtils.formatNumber(theirPrice), guiLeft + 176 + 3 + 40, guiTop + 21, 72);
            int theirTopIndex = Math.max(0, 3 - theirTopItemsStack.size());
            block33: for (Map.Entry entry : theirTopItems.descendingMap().entrySet()) {
                for (String theirTopItemInternal : (Set)entry.getValue()) {
                    ItemStack stack = theirTopItemsStack.get(theirTopItemInternal);
                    if (stack == null) continue;
                    if (NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePriceStyle) {
                        String countS = "";
                        if (theirTopItemsCount.containsKey(theirTopItemInternal)) {
                            int count = theirTopItemsCount.get(theirTopItemInternal);
                            countS = count > 999999 ? Math.floor((float)count / 10000.0f) / 100.0 + "m" : (count > 999 ? Math.floor((float)count / 10.0f) / 100.0 + "k" : "" + count);
                        }
                        Utils.drawItemStackWithText(stack, guiLeft + 176 + 25 + 3 - 16, guiTop + 49 + 18 * theirTopIndex, countS);
                        GlStateManager.func_179140_f();
                        GlStateManager.func_179084_k();
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + StringUtils.formatNumber((Number)entry.getKey()), guiLeft + 176 + 3 + 51, guiTop + 57 + 18 * theirTopIndex, 52);
                        GlStateManager.func_179147_l();
                    } else {
                        TradeWindow.drawStringShadow(stack.func_82833_r(), guiLeft + 176 + 3 + 40, guiTop + 46 + 20 * theirTopIndex, 72);
                        TradeWindow.drawStringShadow(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + StringUtils.formatNumber((Number)entry.getKey()), guiLeft + 176 + 3 + 40, guiTop + 56 + 20 * theirTopIndex, 72);
                    }
                    if (++theirTopIndex < 3) continue;
                    break block33;
                }
            }
        }
        boolean button1 = NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePriceStyle;
        boolean button2 = NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePrices;
        boolean button3 = NotEnoughUpdates.INSTANCE.config.tradeMenu.enableCustomTrade;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        Utils.drawTexturedRect(guiLeft + 176 + 3, guiTop + 204 - 19, 17.0f, 17.0f, (float)(button3 ? 17 : 0) / 256.0f, (float)(button3 ? 34 : 17) / 256.0f, 0.8515625f, 0.91796875f, 9728);
        Utils.drawTexturedRect(guiLeft + 176 + 3, guiTop + 204 - 38, 17.0f, 17.0f, (float)(button2 ? 17 : 0) / 256.0f, (float)(button2 ? 34 : 17) / 256.0f, 0.8515625f, 0.91796875f, 9728);
        Utils.drawTexturedRect(guiLeft + 176 + 3, guiTop + 204 - 57, 17.0f, 17.0f, (float)(button1 ? 17 : 0) / 256.0f, (float)(button1 ? 34 : 17) / 256.0f, 0.8515625f, 0.91796875f, 9728);
        if (mouseX >= guiLeft + 176 + 3 && mouseX <= guiLeft + 176 + 3 + 17) {
            if (mouseY >= guiTop + 204 - 19 && mouseY <= guiTop + 204 - 19 + 17) {
                tooltipToDisplay = new ArrayList<String>(){
                    {
                        this.add(EnumChatFormatting.GOLD + "Enable Custom Trade Menu");
                        this.add(EnumChatFormatting.GRAY + "Use this menu instead of the default trade window");
                    }
                };
                tooltipLen = 200;
            } else if (mouseY >= guiTop + 204 - 38 && mouseY <= guiTop + 204 - 38 + 17) {
                tooltipToDisplay = new ArrayList<String>(){
                    {
                        this.add(EnumChatFormatting.GOLD + "Price Information");
                        this.add(EnumChatFormatting.GRAY + "Show the price of items on both sides");
                    }
                };
                tooltipLen = 200;
            } else if (mouseY >= guiTop + 204 - 57 && mouseY <= guiTop + 204 - 57 + 17) {
                tooltipToDisplay = new ArrayList<String>(){
                    {
                        this.add(EnumChatFormatting.GOLD + "Trade Prices Style");
                        this.add(EnumChatFormatting.GRAY + "Changes the style of the top item prices");
                    }
                };
                tooltipLen = 200;
            }
        }
        if (stackToRender != null) {
            tooltipToDisplay = stackToRender.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, scaledResolution.func_78326_a(), scaledResolution.func_78328_b(), tooltipLen);
        }
    }

    public static void handleMouseInput() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getEventX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getEventY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        if (Mouse.getEventButtonState() && Mouse.isButtonDown((int)0)) {
            String confirmDisplay;
            int index = 0;
            for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                if (stack == null) {
                    ++index;
                    continue;
                }
                int x = 8 + 18 * (index % 9);
                int y = 104 + 18 * (index / 9);
                if (index < 9) {
                    y = 180;
                }
                if (mouseX > guiLeft + x && mouseX < guiLeft + x + 16 && mouseY > guiTop + y && mouseY < guiTop + y + 16) {
                    Slot slot = chest.field_147002_h.func_75147_a((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by, index);
                    if (!NotEnoughUpdates.INSTANCE.config.slotLocking.lockSlotsInTrade || !SlotLocking.getInstance().isSlotLocked(slot)) {
                        Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, slot.field_75222_d, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    }
                    return;
                }
                ++index;
            }
            for (int i = 0; i < 16; ++i) {
                int x = i % 4;
                int y = i / 4;
                Integer containerIndex = ourTradeIndexes[i];
                if (containerIndex == null || containerIndex < 0 || mouseX <= guiLeft + 10 + x * 18 - 1 || mouseX >= guiLeft + 10 + x * 18 + 18 || mouseY <= guiTop + 15 + y * 18 - 1 || mouseY >= guiTop + 15 + y * 18 + 18) continue;
                Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, containerIndex.intValue(), 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                return;
            }
            if (mouseX > guiLeft + 10 - 1 && mouseX < guiLeft + 10 + 18 && mouseY > guiTop + 90 - 1 && mouseY < guiTop + 90 + 18) {
                Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, 36, 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                return;
            }
            ItemStack confirmStack = (ItemStack)chest.field_147002_h.func_75138_a().get(39);
            if (confirmStack != null && !(confirmDisplay = confirmStack.func_82833_r()).equals(EnumChatFormatting.GREEN + "Trading!") && mouseX > guiLeft + 42 && mouseX < guiLeft + 42 + 40 && mouseY > guiTop + 92 && mouseY < guiTop + 92 + 14) {
                if ((confirmDisplay.equals(EnumChatFormatting.YELLOW + "Warning!") || confirmDisplay.equals(EnumChatFormatting.YELLOW + "Deal!")) && lastTradeMillis < 0L) {
                    lastTradeMillis = System.currentTimeMillis();
                } else if (lastTradeMillis < 0L || System.currentTimeMillis() - lastTradeMillis > 2000L) {
                    Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, 39, 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    return;
                }
            }
            if (mouseX >= guiLeft + 176 + 3 && mouseX <= guiLeft + 176 + 3 + 17) {
                if (mouseY >= guiTop + 204 - 19 && mouseY <= guiTop + 204 - 19 + 17) {
                    NotEnoughUpdates.INSTANCE.config.tradeMenu.enableCustomTrade = !NotEnoughUpdates.INSTANCE.config.tradeMenu.enableCustomTrade;
                } else if (mouseY >= guiTop + 204 - 38 && mouseY <= guiTop + 204 - 38 + 17) {
                    NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePrices = !NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePrices;
                } else if (mouseY >= guiTop + 204 - 57 && mouseY <= guiTop + 204 - 57 + 17) {
                    NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePriceStyle = !NotEnoughUpdates.INSTANCE.config.tradeMenu.customTradePriceStyle;
                }
            }
        }
    }

    public static boolean keyboardInput() {
        if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking && NotEnoughUpdates.INSTANCE.config.slotLocking.lockSlotsInTrade && !Keyboard.isRepeatEvent() && KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockKey)) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getEventX() * width / Minecraft.func_71410_x().field_71443_c;
            int mouseY = height - Mouse.getEventY() * height / Minecraft.func_71410_x().field_71440_d - 1;
            int index = 0;
            for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                if (stack == null) {
                    ++index;
                    continue;
                }
                int x = 8 + 18 * (index % 9);
                int y = 104 + 18 * (index / 9);
                if (index < 9) {
                    y = 180;
                }
                if (mouseX > guiLeft + x && mouseX < guiLeft + x + 16 && mouseY > guiTop + y && mouseY < guiTop + y + 16) {
                    SlotLocking.getInstance().toggleLock(index);
                    return true;
                }
                ++index;
            }
        }
        return Keyboard.getEventKey() != 1;
    }

    static {
        lastTradeMillis = -1L;
        ourTradeIndexes = new Integer[16];
        theirTradeIndexes = new Integer[16];
        theirTradeOld = new String[16];
        theirTradeChangesMillis = new Long[16];
    }
}

