/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NEUOverlay;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.auction.APIManager;
import io.github.moulberry.notenoughupdates.core.util.ArrowPagesUtils;
import io.github.moulberry.notenoughupdates.events.ButtonExclusionZoneEvent;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.PlayerStats;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class AccessoryBagOverlay {
    public static final AccessoryBagOverlay INSTANCE = new AccessoryBagOverlay();
    private static int statsPageActive = 0;
    private static int statsPagesTotal = 0;
    private static int dupePageActive = 0;
    private static int dupePagesTotal = 0;
    private static int missingPageActive = 0;
    private static int missingPagesTotal = 0;
    private static boolean dupe_highlight = true;
    private static boolean dupe_showPersonal = false;
    private static boolean missing_showAllTiers = true;
    private static boolean missing_useMP = true;
    private static List<String> tooltipToDisplay = null;
    private static boolean offsetButtons = false;
    private static final ItemStack[] TAB_STACKS = new ItemStack[]{Utils.createItemStack(Items.field_151100_aR, EnumChatFormatting.DARK_AQUA + "Basic Information", 10, EnumChatFormatting.GREEN + "- Talis count by rarity"), Utils.createItemStack(Items.field_151048_u, EnumChatFormatting.DARK_AQUA + "Total Stat Bonuses", 0, new String[0]), Utils.createItemStack(Items.field_151100_aR, EnumChatFormatting.DARK_AQUA + "Duplicates", 8, new String[0]), Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_180401_cv), EnumChatFormatting.DARK_AQUA + "Missing", 0, new String[0])};
    private static Tabs currentTab = Tabs.TAB_BASIC;
    private static Set<ItemStack> accessoryStacks = new HashSet<ItemStack>();
    private static Set<Integer> pagesVisited = new HashSet<Integer>();
    private static TreeMap<Integer, Integer> talismanCountRarity = null;
    private static PlayerStats.Stats totalStats = null;
    private static Set<ItemStack> duplicates = null;
    private static List<ItemStack> missing = null;
    private static boolean inAccessoryBag = false;

    @SubscribeEvent
    public void onButtonExclusionZones(ButtonExclusionZoneEvent event) {
        if (AccessoryBagOverlay.isInAccessoryBag()) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight(), event.getGuiBaseRect().getTop(), 168 + (offsetButtons ? 24 : 0) + 5, 128), ButtonExclusionZoneEvent.PushDirection.TOWARDS_RIGHT);
        }
    }

    public static boolean mouseClick() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
            String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
            if (!containerName.trim().startsWith("Accessory Bag")) {
                return false;
            }
        } else {
            return false;
        }
        if (!Mouse.getEventButtonState()) {
            return false;
        }
        try {
            AccessorGuiContainer accessor = (AccessorGuiContainer)Minecraft.func_71410_x().field_71462_r;
            int xSize = accessor.getXSize();
            int guiLeft = accessor.getGuiLeft();
            int guiTop = accessor.getGuiTop();
            if (AccessoryBagOverlay.mouseX() < guiLeft + xSize + 3 || AccessoryBagOverlay.mouseX() > guiLeft + xSize + 168 + 28) {
                return false;
            }
            if (AccessoryBagOverlay.mouseY() < guiTop || AccessoryBagOverlay.mouseY() > guiTop + 128) {
                return false;
            }
            if (AccessoryBagOverlay.mouseX() > guiLeft + xSize + 168 + 3 && AccessoryBagOverlay.mouseY() < guiTop + 20 * Tabs.values().length + 22) {
                int tabClicked = (AccessoryBagOverlay.mouseY() - guiTop) / 20;
                tabClicked = Math.min(Math.max(0, tabClicked), Tabs.values().length - 1);
                currentTab = Tabs.values()[tabClicked];
                AccessoryBagOverlay.playPressSound();
            }
            if (currentTab == Tabs.TAB_TOTAL && statsPagesTotal > 1) {
                ArrowPagesUtils.onPageSwitchMouse(guiLeft + xSize + 3, guiTop, new int[]{60, 110}, statsPageActive, statsPagesTotal, integer -> {
                    statsPageActive = integer;
                });
            }
            if (currentTab == Tabs.TAB_DUP) {
                if (dupePagesTotal > 1) {
                    ArrowPagesUtils.onPageSwitchMouse(guiLeft + xSize + 3, guiTop, new int[]{60, 110}, dupePageActive, dupePagesTotal, integer -> {
                        dupePageActive = integer;
                    });
                }
                if (new Rectangle(guiLeft + xSize + 3 + 120, guiTop + 108, 16, 16).contains(AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY())) {
                    dupe_highlight = !dupe_highlight;
                    AccessoryBagOverlay.playPressSound();
                }
                if (new Rectangle(guiLeft + xSize + 3 + 141, guiTop + 108, 16, 16).contains(AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY())) {
                    dupe_showPersonal = !dupe_showPersonal;
                    AccessoryBagOverlay.playPressSound();
                }
            }
            if (currentTab == Tabs.TAB_MISSING) {
                if (missingPagesTotal > 1) {
                    ArrowPagesUtils.onPageSwitchMouse(guiLeft + xSize + 3, guiTop, new int[]{60, 110}, missingPageActive, missingPagesTotal, integer -> {
                        missingPageActive = integer;
                    });
                }
                if (new Rectangle(guiLeft + xSize + 3 + 120, guiTop + 108, 16, 16).contains(AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY())) {
                    missing_useMP = !missing_useMP;
                    missing = null;
                    AccessoryBagOverlay.playPressSound();
                }
                if (new Rectangle(guiLeft + xSize + 3 + 141, guiTop + 108, 16, 16).contains(AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY())) {
                    missing_showAllTiers = !missing_showAllTiers;
                    missing = null;
                    AccessoryBagOverlay.playPressSound();
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static void resetCache() {
        accessoryStacks = new HashSet<ItemStack>();
        pagesVisited = new HashSet<Integer>();
        talismanCountRarity = null;
        totalStats = null;
        duplicates = null;
        missing = null;
    }

    public static void renderVisitOverlay(int x, int y) {
        Utils.drawStringCenteredScaledMaxWidth("Please visit all", x + 80, y + 60, true, 140, -1);
        Utils.drawStringCenteredScaledMaxWidth("pages of the bag", x + 80, y + 72, true, 140, -1);
    }

    public static void renderBasicOverlay(int x, int y) {
        int n;
        if (talismanCountRarity == null) {
            talismanCountRarity = new TreeMap();
            for (ItemStack stack : accessoryStacks) {
                int n2 = AccessoryBagOverlay.getRarity(stack);
                if (n2 < 0) continue;
                talismanCountRarity.put(n2, talismanCountRarity.getOrDefault(n2, 0) + 1);
            }
        }
        AccessoryBagOverlay.drawTitle(x, y, "Total Counts By Rarity");
        int yIndex = 0;
        for (Map.Entry entry : talismanCountRarity.descendingMap().entrySet()) {
            String rarityName = Utils.rarityArrC[(Integer)entry.getKey()];
            Utils.renderAlignedString(rarityName, EnumChatFormatting.WHITE.toString() + entry.getValue(), x + 34, y + 20 + 11 * yIndex, 100);
            ++yIndex;
        }
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        boolean bl = false;
        if (profileSpecific != null) {
            n = profileSpecific.magicalPower;
        }
        Utils.renderAlignedString(EnumChatFormatting.AQUA + "Magical Power", n != 0 ? EnumChatFormatting.WHITE.toString() + n : EnumChatFormatting.RED + "NO DATA, DO /PV", x + 20, y + 25 + 88, 130);
    }

    public static void renderTotalStatsOverlay(int x, int y) {
        if (totalStats == null) {
            totalStats = new PlayerStats.Stats(new PlayerStats.Stats[0]);
            for (ItemStack stack : accessoryStacks) {
                if (stack == null) continue;
                totalStats.add(AccessoryBagOverlay.getStatForItem(stack, PlayerStats.STAT_PATTERN_MAP, true));
            }
        }
        AccessoryBagOverlay.drawTitle(x, y, "Total Stats");
        int yIndex = 0;
        ArrayList<ImmutablePair> statPairs = new ArrayList<ImmutablePair>();
        for (int i = 0; i < PlayerStats.defaultStatNames.length; ++i) {
            String statName = PlayerStats.defaultStatNames[i];
            String statNamePretty = PlayerStats.defaultStatNamesPretty[i];
            int val = Math.round(totalStats.get(statName));
            if (!((double)Math.abs(val) >= 1.0E-5)) continue;
            statPairs.add(new ImmutablePair((Object)statNamePretty, (Object)val));
        }
        statsPageActive = Math.min(statsPageActive, statPairs.size() / 8);
        for (Pair pair : statPairs.subList(statsPageActive * 8, statPairs.size())) {
            Utils.renderAlignedString((String)pair.getKey(), EnumChatFormatting.WHITE.toString() + pair.getValue(), x + 6, y + 20 + 11 * yIndex, 158);
            if (yIndex++ < 7 || statPairs.size() <= 9) continue;
            break;
        }
        statsPagesTotal = (int)Math.ceil((double)statPairs.size() / 8.0);
        if (statPairs.size() > 9) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ArrowPagesUtils.onDraw(x, y, new int[]{60, 110}, statsPageActive, statsPagesTotal);
        }
    }

    public static void renderDuplicatesOverlay(int x, int y) {
        JsonObject misc;
        if (duplicates == null && (misc = Constants.MISC) == null) {
            AccessoryBagOverlay.drawTitle(x, y, "Duplicates: REPO ERROR");
            Utils.showOutdatedRepoNotification("misc.json");
            return;
        }
        if (duplicates.isEmpty()) {
            AccessoryBagOverlay.drawTitle(x, y, "No Duplicates");
        } else {
            AccessoryBagOverlay.drawTitle(x, y, "Duplicates: " + duplicates.size());
            int yIndex = 0;
            List sortedDupes = duplicates.stream().sorted(Comparator.comparing(ItemStack::func_82833_r)).collect(Collectors.toList());
            dupePageActive = Math.min(dupePageActive, duplicates.size() / 8);
            for (ItemStack duplicate : sortedDupes.subList(dupePageActive * 8, sortedDupes.size())) {
                String s = duplicate.func_82833_r();
                Utils.renderShadowedString(s.substring(0, Math.min(s.length(), 35)), x + 84, y + 20 + 11 * yIndex, 158);
                if (++yIndex < 8 || sortedDupes.size() <= 9) continue;
                break;
            }
            dupePagesTotal = (int)Math.ceil((double)sortedDupes.size() / 8.0);
            if (sortedDupes.size() > 9) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ArrowPagesUtils.onDraw(x, y, new int[]{60, 110}, dupePageActive, dupePagesTotal);
            }
        }
        ArrayList<String> highlightTooltip = new ArrayList<String>();
        if (dupe_highlight) {
            highlightTooltip.add("\u00a7aHighlight dupes");
            highlightTooltip.add("\u00a77Will highlight accessories");
            highlightTooltip.add("\u00a77you have duplicates of.");
        } else {
            highlightTooltip.add("\u00a7cDon't highlight dupes");
            highlightTooltip.add("\u00a77Will not highlight accessories");
            highlightTooltip.add("\u00a77you have duplicates of.");
        }
        AccessoryBagOverlay.renderButton(new ItemStack(dupe_highlight ? Items.field_151061_bv : Items.field_151079_bi), x + 120, y + 107, highlightTooltip);
        ArrayList<String> compDeletorTooltip = new ArrayList<String>();
        if (dupe_showPersonal) {
            compDeletorTooltip.add("\u00a7aHighlight Compactors & Deletors");
            compDeletorTooltip.add("\u00a77Will highlight all duplicates.");
        } else {
            compDeletorTooltip.add("\u00a7cDon't highlight Compactors & Deletors");
            compDeletorTooltip.add("\u00a77Duplicates allow you to specify");
            compDeletorTooltip.add("\u00a77more things to compact and delete,");
            compDeletorTooltip.add("\u00a77but they do not give more MP!");
        }
        AccessoryBagOverlay.renderButton(NotEnoughUpdates.INSTANCE.manager.createItem(dupe_showPersonal ? "PERSONAL_DELETOR_4000" : "DISPENSER"), x + 141, y + 107, compDeletorTooltip);
    }

    public static void renderMissingOverlay(int x, int y) {
        if (missing == null) {
            JsonObject misc = Constants.MISC;
            if (misc == null) {
                AccessoryBagOverlay.drawTitle(x, y, "Missing: REPO ERROR");
                Utils.showOutdatedRepoNotification("misc.json");
                return;
            }
            JsonElement talisman_upgrades_element = misc.get("talisman_upgrades");
            if (talisman_upgrades_element == null) {
                AccessoryBagOverlay.drawTitle(x, y, "Missing: REPO ERROR");
                Utils.showOutdatedRepoNotification("misc.json talisman_upgrades");
                return;
            }
            JsonObject talisman_upgrades = talisman_upgrades_element.getAsJsonObject();
            missing = new ArrayList<ItemStack>();
            ArrayList<Object> missingInternal = new ArrayList<Object>();
            ArrayList<String> ignoredTalisman = new ArrayList<String>();
            if (misc.has("ignored_talisman")) {
                for (JsonElement jsonElement : misc.getAsJsonArray("ignored_talisman")) {
                    ignoredTalisman.add(jsonElement.getAsString());
                }
            }
            for (Map.Entry entry : NotEnoughUpdates.INSTANCE.manager.getItemInformation().entrySet()) {
                if (ignoredTalisman.contains(((JsonObject)entry.getValue()).get("internalname").getAsString()) || !((JsonObject)entry.getValue()).has("lore") || AccessoryBagOverlay.checkItemType(((JsonObject)entry.getValue()).get("lore").getAsJsonArray(), "ACCESSORY", "HATCESSORY", "DUNGEON ACCESSORY") < 0) continue;
                missingInternal.add(entry.getKey());
            }
            for (ItemStack itemStack : accessoryStacks) {
                String string = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(itemStack).resolveInternalName();
                missingInternal.remove(string);
                block3: for (Map.Entry<String, JsonElement> talisman_upgrade_element : talisman_upgrades.entrySet()) {
                    JsonArray upgrades = talisman_upgrade_element.getValue().getAsJsonArray();
                    for (int j = 0; j < upgrades.size(); ++j) {
                        String upgrade = upgrades.get(j).getAsString();
                        if (!string.equals(upgrade)) continue;
                        missingInternal.remove(talisman_upgrade_element.getKey());
                        continue block3;
                    }
                }
                if (!string.contains("ABICASE")) continue;
                missingInternal.removeAll(missingInternal.stream().filter(s -> s.contains("ABICASE")).collect(Collectors.toList()));
            }
            missingInternal.sort(AccessoryBagOverlay.getItemComparator(missing_useMP));
            HashSet<String> missingDisplayNames = new HashSet<String>();
            for (String string : missingInternal) {
                ItemStack stack;
                boolean hasDup = false;
                if (talisman_upgrades.has(string)) {
                    JsonArray upgrades = talisman_upgrades.get(string).getAsJsonArray();
                    for (int j = 0; j < upgrades.size(); ++j) {
                        String upgrade = upgrades.get(j).getAsString();
                        if (!missingInternal.contains(upgrade)) continue;
                        hasDup = true;
                        break;
                    }
                }
                if (missingDisplayNames.contains((stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(string), false)).func_82833_r())) continue;
                missingDisplayNames.add(stack.func_82833_r());
                if (hasDup) {
                    if (!missing_showAllTiers) continue;
                    stack.func_151001_c(stack.func_82833_r() + "*");
                }
                missing.add(stack);
            }
        }
        if (missing.isEmpty()) {
            AccessoryBagOverlay.drawTitle(x, y, "No Missing");
        } else {
            AccessoryBagOverlay.drawTitle(x, y, "Missing: " + missing.size());
            int yIndex = 0;
            missingPageActive = Math.min(missingPageActive, missing.size() / 8);
            for (ItemStack missingStack : missing.subList(missingPageActive * 8, missing.size())) {
                String s2 = missingStack.func_82833_r();
                String internal = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(missingStack).resolveInternalName();
                if (internal.equals("RIFT_PRISM") && AccessoryBagOverlay.hasConsumedRiftPrism()) continue;
                double price = AccessoryBagOverlay.getItemPrice(internal);
                Utils.renderAlignedString(s2, price != -1.0 ? "\u00a76" + Utils.shortNumberFormat(price, 0) : "\u00a7cNO DATA", x + 5, y + 20 + 11 * yIndex, 158);
                Rectangle rectangle = new Rectangle(x, y + 20 + 11 * yIndex, 168, 11);
                AccessoryBagOverlay.renderAccessoryHover(rectangle, missingStack);
                if (++yIndex < 8 || missing.size() <= 9) continue;
                break;
            }
            missingPagesTotal = (int)Math.ceil((double)missing.size() / 8.0);
            if (missing.size() > 9) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ArrowPagesUtils.onDraw(x, y, new int[]{60, 110}, missingPageActive, missingPagesTotal);
            }
            ArrayList<String> mpTooltip = new ArrayList<String>();
            if (missing_useMP) {
                mpTooltip.add("\u00a7bSort by Magical Power");
                mpTooltip.add("\u00a77Will sort the accessories");
                mpTooltip.add("\u00a77by the best MP gain.");
            } else {
                mpTooltip.add("\u00a76Sort by Coins");
                mpTooltip.add("\u00a77Will sort the accessories");
                mpTooltip.add("\u00a77by the cheapest options.");
            }
            AccessoryBagOverlay.renderButton(ItemUtils.getCoinItemStack(missing_useMP ? 1.0E7 : 100000.0), x + 120, y + 107, mpTooltip);
            ArrayList<String> tieredTooltip = new ArrayList<String>();
            if (missing_showAllTiers) {
                tieredTooltip.add("\u00a7aShow all tiers");
                tieredTooltip.add("\u00a77Will show all the tiers");
                tieredTooltip.add("\u00a77to get the cheapest options.");
            } else {
                tieredTooltip.add("\u00a76Show highest tier");
                tieredTooltip.add("\u00a77Will show only the highest tier");
                tieredTooltip.add("\u00a77to avoid wasting money on lower ones.");
            }
            AccessoryBagOverlay.renderButton(new ItemStack(missing_showAllTiers ? Items.field_151044_h : Items.field_151045_i), x + 141, y + 107, tieredTooltip);
        }
    }

    private static void drawTitle(int x, int y, String abc) {
        Utils.drawStringCenteredScaledMaxWidth(abc, x + 84, y + 12, false, 158, AccessoryBagOverlay.gray());
    }

    private static int gray() {
        return new Color(80, 80, 80).getRGB();
    }

    private static Comparator<String> getItemComparator(boolean accountMP) {
        return (o1, o2) -> {
            double cost1 = AccessoryBagOverlay.getItemPrice(o1);
            double cost2 = AccessoryBagOverlay.getItemPrice(o2);
            if (accountMP) {
                cost1 /= cost1 != -1.0 ? (double)AccessoryBagOverlay.getMagicalPowerForItem(o1) : -1.0E-99;
                cost2 /= cost2 != -1.0 ? (double)AccessoryBagOverlay.getMagicalPowerForItem(o2) : -1.0E-99;
            }
            if (cost1 == -1.0 && cost2 == -1.0) {
                return o1.compareTo((String)o2);
            }
            if (cost1 == -1.0) {
                return 1;
            }
            if (cost2 == -1.0) {
                return -1;
            }
            if (cost1 < cost2) {
                return -1;
            }
            if (cost1 > cost2) {
                return 1;
            }
            return o1.compareTo((String)o2);
        };
    }

    public static boolean isInAccessoryBag() {
        return inAccessoryBag && NotEnoughUpdates.INSTANCE.config.accessoryBag.enableOverlay;
    }

    public static void renderOverlay() {
        inAccessoryBag = false;
        offsetButtons = false;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
            String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
            if (containerName.trim().startsWith("Accessory Bag") && !containerName.contains("Thaumaturgy") && !containerName.contains("Upgrades")) {
                inAccessoryBag = true;
                try {
                    AccessorGuiContainer accessor = (AccessorGuiContainer)Minecraft.func_71410_x().field_71462_r;
                    int xSize = accessor.getXSize();
                    int guiLeft = accessor.getGuiLeft();
                    int guiTop = accessor.getGuiTop();
                    if (accessoryStacks.isEmpty()) {
                        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                            if (stack == null || !AccessoryBagOverlay.isAccessory(stack)) continue;
                            accessoryStacks.add(stack);
                        }
                    }
                    if (containerName.trim().contains("(")) {
                        String second;
                        String first = containerName.trim().split("\\(")[1].split("/")[0];
                        Integer currentPageNumber = Integer.parseInt(first);
                        boolean hasStack = false;
                        if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerChest) {
                            IInventory inv = ((ContainerChest)Minecraft.func_71410_x().field_71439_g.field_71070_bA).func_85151_d();
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                ItemStack stack = inv.func_70301_a(i);
                                if (stack == null) continue;
                                hasStack = true;
                                if (!AccessoryBagOverlay.isAccessory(stack)) continue;
                                boolean toAdd = true;
                                for (ItemStack accessoryStack : accessoryStacks) {
                                    String s = NEUManager.getUUIDForItem(accessoryStack);
                                    String ss = NEUManager.getUUIDForItem(stack);
                                    if (ss == null || !ss.equals(s)) continue;
                                    toAdd = false;
                                    break;
                                }
                                if (!toAdd) continue;
                                accessoryStacks.add(stack);
                            }
                        }
                        if (hasStack) {
                            pagesVisited.add(currentPageNumber);
                        }
                        if (Integer.parseInt(second = containerName.trim().split("/")[1].split("\\)")[0]) > pagesVisited.size()) {
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.accessory_bag_overlay);
                            GlStateManager.func_179140_f();
                            Utils.drawTexturedRect(guiLeft + xSize + 4, guiTop, 168.0f, 128.0f, 0.0f, 0.85714287f, 0.0f, 1.0f, 9728);
                            AccessoryBagOverlay.renderVisitOverlay(guiLeft + xSize + 3, guiTop);
                            return;
                        }
                    } else if (pagesVisited.isEmpty()) {
                        boolean hasStack = false;
                        if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerChest) {
                            IInventory inv = ((ContainerChest)Minecraft.func_71410_x().field_71439_g.field_71070_bA).func_85151_d();
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                ItemStack stack;
                                stack = inv.func_70301_a(i);
                                if (stack == null) continue;
                                hasStack = true;
                                if (!AccessoryBagOverlay.isAccessory(stack)) continue;
                                accessoryStacks.add(stack);
                            }
                        }
                        if (hasStack) {
                            pagesVisited.add(1);
                        }
                    }
                    GlStateManager.func_179140_f();
                    offsetButtons = true;
                    for (int i = 0; i <= Tabs.values().length - 1; ++i) {
                        if (i == currentTab.ordinal()) continue;
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.accessory_bag_overlay);
                        Utils.drawTexturedRect(guiLeft + xSize + 168, guiTop + 20 * i, 25.0f, 22.0f, 0.85714287f, 0.9846939f, 0.0f, 0.171875f, 9728);
                        RenderHelper.func_74520_c();
                        Utils.drawItemStack(TAB_STACKS[i], guiLeft + xSize + 168 + 5, guiTop + 20 * i + 3);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.accessory_bag_overlay);
                    Utils.drawTexturedRect(guiLeft + xSize + 4, guiTop, 168.0f, 128.0f, 0.0f, 0.85714287f, 0.0f, 1.0f, 9728);
                    if (pagesVisited.isEmpty()) {
                        AccessoryBagOverlay.renderVisitOverlay(guiLeft + xSize + 3, guiTop);
                        return;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.accessory_bag_overlay);
                    Utils.drawTexturedRect(guiLeft + xSize + 168, guiTop + 20 * currentTab.ordinal(), 28.0f, 22.0f, 0.85714287f, 1.0f, 0.171875f, 0.34375f, 9728);
                    RenderHelper.func_74520_c();
                    Utils.drawItemStack(TAB_STACKS[currentTab.ordinal()], guiLeft + xSize + 168 + 8, guiTop + 20 * currentTab.ordinal() + 3);
                    AccessoryBagOverlay.fillDuplicates();
                    switch (currentTab) {
                        case TAB_BASIC: {
                            AccessoryBagOverlay.renderBasicOverlay(guiLeft + xSize + 3, guiTop);
                            break;
                        }
                        case TAB_TOTAL: {
                            AccessoryBagOverlay.renderTotalStatsOverlay(guiLeft + xSize + 3, guiTop);
                            break;
                        }
                        case TAB_DUP: {
                            AccessoryBagOverlay.renderDuplicatesOverlay(guiLeft + xSize + 3, guiTop);
                            break;
                        }
                        case TAB_MISSING: {
                            AccessoryBagOverlay.renderMissingOverlay(guiLeft + xSize + 3, guiTop);
                        }
                    }
                    if (dupe_highlight) {
                        AccessoryBagOverlay.highlightDuplicates();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (tooltipToDisplay != null) {
                    Utils.drawHoveringText(tooltipToDisplay, AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY(), eventGui.field_146294_l, eventGui.field_146295_m, -1);
                    tooltipToDisplay = null;
                }
            }
        }
    }

    private static PlayerStats.Stats getStatForItem(ItemStack stack, HashMap<String, Pattern> patternMap, boolean addExtras) {
        NBTTagCompound display;
        String internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
        NBTTagCompound tag = stack.func_77978_p();
        PlayerStats.Stats stats = new PlayerStats.Stats(new PlayerStats.Stats[0]);
        if (internalname == null) {
            return stats;
        }
        if (tag != null && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList list = display.func_150295_c("Lore", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                float bonus;
                String line = list.func_150307_f(i);
                for (Map.Entry<String, Pattern> entry : patternMap.entrySet()) {
                    Matcher matcher = entry.getValue().matcher(Utils.cleanColour(line));
                    if (!matcher.find()) continue;
                    bonus = Float.parseFloat(matcher.group(1));
                    stats.addStat(entry.getKey(), bonus);
                }
                if (!line.startsWith(EnumChatFormatting.GRAY + "Current Bonus: ")) continue;
                for (Map.Entry<String, Pattern> entry : patternMap.entrySet()) {
                    String prettyStatName = Utils.cleanColour(PlayerStats.defaultStatNamesPretty[Arrays.asList(PlayerStats.defaultStatNames).indexOf(entry.getKey())]);
                    if (!line.contains(prettyStatName)) continue;
                    bonus = Float.parseFloat(line.split(prettyStatName)[0].replaceAll("\u00a77Current Bonus: \u00a7.", ""));
                    stats.addStat(entry.getKey(), bonus);
                }
            }
        }
        if (!addExtras) {
            return stats;
        }
        if (internalname.equals("DAY_CRYSTAL") || internalname.equals("NIGHT_CRYSTAL")) {
            stats.addStat("strength", 2.5f);
            stats.addStat("defence", 2.5f);
        }
        return stats;
    }

    public static int checkItemType(ItemStack stack, boolean contains, String ... typeMatches) {
        NBTTagCompound display;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList list = display.func_150295_c("Lore", 8);
            for (int i = list.func_74745_c() - 1; i >= 0; --i) {
                String line = list.func_150307_f(i);
                for (String rarity : Utils.rarityArr) {
                    for (int j = 0; j < typeMatches.length; ++j) {
                        if (contains) {
                            if (line.trim().contains(rarity + " " + typeMatches[j])) {
                                return j;
                            }
                            if (!line.trim().contains(rarity + " DUNGEON " + typeMatches[j])) continue;
                            return j;
                        }
                        if (line.trim().endsWith(rarity + " " + typeMatches[j])) {
                            return j;
                        }
                        if (!line.trim().endsWith(rarity + " DUNGEON " + typeMatches[j])) continue;
                        return j;
                    }
                }
            }
        }
        return -1;
    }

    private static int checkItemType(JsonArray lore, String ... typeMatches) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = lore.get(i).getAsString();
            for (String rarity : Utils.rarityArr) {
                for (int j = 0; j < typeMatches.length; ++j) {
                    if (!line.trim().endsWith(rarity + " " + typeMatches[j])) continue;
                    return j;
                }
            }
        }
        return -1;
    }

    public static boolean isAccessory(ItemStack stack) {
        return AccessoryBagOverlay.checkItemType(stack, true, "ACCESSORY", "HATCESSORY") >= 0;
    }

    public static int getRarity(ItemStack stack) {
        NBTTagCompound display;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList list = display.func_150295_c("Lore", 8);
            for (int i = list.func_74745_c(); i >= 0; --i) {
                String line = list.func_150307_f(i);
                for (int j = 0; j < Utils.rarityArrC.length; ++j) {
                    if (!line.contains(Utils.rarityArrC[j])) continue;
                    return j;
                }
            }
        }
        return -1;
    }

    public static double getItemPrice(String internal) {
        APIManager.CraftInfo info = NotEnoughUpdates.INSTANCE.manager.auctionManager.getCraftCost(internal);
        double bin = NotEnoughUpdates.INSTANCE.manager.auctionManager.getLowestBin(internal);
        if (info == null) {
            return bin;
        }
        if (bin == -1.0) {
            return info.craftCost;
        }
        return Math.min(info.craftCost, bin);
    }

    public static ScaledResolution getScaledResolution() {
        return new ScaledResolution(Minecraft.func_71410_x());
    }

    public static int mouseX() {
        return Mouse.getX() / AccessoryBagOverlay.getScaledResolution().func_78325_e();
    }

    public static int mouseY() {
        return AccessoryBagOverlay.getScaledResolution().func_78328_b() - Mouse.getY() / AccessoryBagOverlay.getScaledResolution().func_78325_e();
    }

    public static int getMagicalPowerForItem(String internal) {
        int abi = 0;
        JsonObject jsonStack = NotEnoughUpdates.INSTANCE.manager.getJsonForItem(NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(internal).resolveToItemStack());
        int rarity = Utils.getRarityFromLore(jsonStack.get("lore").getAsJsonArray());
        if (internal.equals("HEGEMONY_ARTIFACT")) {
            switch (rarity) {
                case 4: {
                    return 16;
                }
                case 5: {
                    return 22;
                }
            }
        }
        if (internal.contains("ABICASE")) {
            abi = AccessoryBagOverlay.getAbiphoneMagicPower();
        }
        switch (rarity) {
            case 0: 
            case 6: {
                return abi + 3;
            }
            case 1: 
            case 7: {
                return abi + 5;
            }
            case 2: {
                return abi + 8;
            }
            case 3: {
                return abi + 12;
            }
            case 4: {
                return abi + 16;
            }
            case 5: {
                return abi + 22;
            }
        }
        return 0;
    }

    public static void renderButton(ItemStack stack, int x, int y, List<String> tooltip) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.accessory_bag_overlay);
        GlStateManager.func_179140_f();
        Utils.drawTexturedRect(x, y, 17.0f, 17.0f, 0.85714287f, 0.93877554f, 0.875f, 1.0f, 9728);
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, x, y);
        if (new Rectangle(x, y, 16, 16).contains(AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY())) {
            Utils.drawHoveringText(tooltip, AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY(), AccessoryBagOverlay.getScaledResolution().func_78326_a(), AccessoryBagOverlay.getScaledResolution().func_78328_b(), -1);
        }
    }

    public static void highlightDuplicates() {
        AccessorGuiContainer accessor = (AccessorGuiContainer)Minecraft.func_71410_x().field_71462_r;
        int guiLeft = accessor.getGuiLeft();
        int guiTop = accessor.getGuiTop();
        for (Slot slot : Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75151_b) {
            ItemStack stack = slot.func_75211_c();
            if (stack == null || !AccessoryBagOverlay.isAccessory(stack) || !dupe_showPersonal && NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName().matches("PERSONAL_(DELETOR|COMPACTOR)_[0-9]+") || duplicates == null || !duplicates.stream().map(ItemStack::func_82833_r).collect(Collectors.toList()).contains(stack.func_82833_r())) continue;
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
            GuiScreen.func_73734_a((int)(guiLeft + slot.field_75223_e), (int)(guiTop + slot.field_75221_f), (int)(guiLeft + slot.field_75223_e + 16), (int)(guiTop + slot.field_75221_f + 16), (int)-1140916224);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
        }
    }

    public static void fillDuplicates() {
        if (duplicates != null) {
            return;
        }
        JsonObject misc = Constants.MISC;
        JsonElement talisman_upgrades_element = misc.get("talisman_upgrades");
        if (talisman_upgrades_element == null) {
            Utils.showOutdatedRepoNotification("misc.json talisman_upgrades");
            return;
        }
        JsonObject talisman_upgrades = talisman_upgrades_element.getAsJsonObject();
        duplicates = new HashSet<ItemStack>();
        ArrayList<String> duplicatesIDs = new ArrayList<String>();
        HashSet<String> prevInternalnames = new HashSet<String>();
        for (ItemStack stack : accessoryStacks) {
            String internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
            if (prevInternalnames.contains(internalname)) {
                duplicates.add(stack);
                duplicatesIDs.add(internalname);
                continue;
            }
            prevInternalnames.add(internalname);
            if (!talisman_upgrades.has(internalname)) continue;
            JsonArray upgrades = talisman_upgrades.get(internalname).getAsJsonArray();
            for (ItemStack stack2 : accessoryStacks) {
                if (stack == stack2) continue;
                String internalname2 = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack2).resolveInternalName();
                boolean toAdd = false;
                ArrayList<String> upgradeIDs = new ArrayList<String>();
                for (int j = 0; j < upgrades.size(); ++j) {
                    String upgrade = upgrades.get(j).getAsString();
                    upgradeIDs.add(upgrade);
                    if (!internalname2.equals(upgrade)) continue;
                    duplicates.add(stack);
                    toAdd = true;
                }
                if (!toAdd) continue;
                duplicatesIDs.addAll(upgradeIDs);
            }
        }
        for (ItemStack accessoryStack : accessoryStacks) {
            String internalID = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(accessoryStack).resolveInternalName();
            if (!duplicatesIDs.contains(internalID)) continue;
            duplicates.add(accessoryStack);
        }
    }

    public static void renderAccessoryHover(Rectangle rect, ItemStack stack) {
        if (rect.contains(AccessoryBagOverlay.mouseX(), AccessoryBagOverlay.mouseY())) {
            String internal = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
            tooltipToDisplay = Arrays.asList(stack.func_82833_r().replace("*", ""), "", "\u00a7eClick to learn more!", "\u00a7eCtrl+Click to search on ah!");
            AccessoryBagOverlay.handleAccessoryClick(stack, internal);
        }
    }

    public static void handleAccessoryClick(ItemStack stack, String internal) {
        if (Mouse.isButtonDown((int)0) && internal != null) {
            if (!Keyboard.isKeyDown((int)29)) {
                if (!NotEnoughUpdates.INSTANCE.manager.displayGuiItemRecipe(internal)) {
                    NEUOverlay.getTextField().func_146180_a("id:" + internal);
                    NotEnoughUpdates.INSTANCE.overlay.updateSearch();
                    NotEnoughUpdates.INSTANCE.overlay.setSearchBarFocus(true);
                }
            } else {
                String displayname = Utils.cleanColour(stack.func_82833_r());
                NotEnoughUpdates.INSTANCE.trySendCommand("/ahs " + displayname.replace("*", ""));
            }
        }
    }

    public static boolean hasConsumedRiftPrism() {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific == null) {
            return false;
        }
        try {
            JsonObject profileInfo2 = GuiProfileViewer.getSelectedProfile().getProfileJson();
            if (profileInfo2.has("rift") && profileInfo2.getAsJsonObject("rift").has("access")) {
                profileSpecific.hasConsumedRiftPrism = profileInfo2.getAsJsonObject("rift").getAsJsonObject("access").has("consumed_prism");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return profileSpecific.hasConsumedRiftPrism;
    }

    public static int getAbiphoneMagicPower() {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific == null) {
            return 0;
        }
        try {
            JsonObject data;
            JsonObject profileInfo2 = GuiProfileViewer.getSelectedProfile().getProfileJson();
            if (profileInfo2.has("nether_island_player_data") && (data = profileInfo2.get("nether_island_player_data").getAsJsonObject()).has("abiphone") && data.get("abiphone").getAsJsonObject().has("active_contacts")) {
                int contact = data.get("abiphone").getAsJsonObject().get("active_contacts").getAsJsonArray().size();
                profileSpecific.abiphoneMagicPower = contact / 2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return profileSpecific.abiphoneMagicPower;
    }

    private static void playPressSound() {
        if (NotEnoughUpdates.INSTANCE.config.misc.guiButtonClicks) {
            Utils.playPressSound();
        }
    }

    private static enum Tabs {
        TAB_BASIC,
        TAB_TOTAL,
        TAB_DUP,
        TAB_MISSING;

    }
}

