/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.ArrowPagesUtils;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.KotlinJsonUtilsKt;
import io.github.moulberry.notenoughupdates.util.KotlinNumberUtilsKt;
import io.github.moulberry.notenoughupdates.util.KotlinRenderUtils;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.hypixelapi.HypixelItemAPI;
import io.github.moulberry.notenoughupdates.util.kotlin.GsonKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0004XYZ[B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0:2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020AH\u0002J \u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u00020GH\u0016J.\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000f0:\"\u0010\b\u0000\u0010I\u0018\u0001*\b\u0012\u0004\u0012\u0002HI0J2\u0006\u0010K\u001a\u0002HIH\u0082\b\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020CH\u0002J\u0018\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u000f2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020\u000fH\u0002J\u0010\u0010R\u001a\u00020\u00062\u0006\u0010S\u001a\u000204H\u0002J\u001e\u0010T\u001a\u00020A2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\u0006J\u0018\u0010V\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0006H\u0002J\b\u0010W\u001a\u000204H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020,0+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002000+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\n \u0017*\u0004\u0018\u00010404X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00106\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010$\u001a\u0004\b7\u0010\"R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u000f0:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage;", "Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewerPage;", "pvInstance", "Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewer;", "(Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewer;)V", "arrowsHeight", "", "arrowsXPos", "columns", "currentPriceSource", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$PriceSource;", "currentProfile", "Lio/github/moulberry/notenoughupdates/profileviewer/SkyblockProfiles$SkyblockProfile;", "Lio/github/moulberry/notenoughupdates/profileviewer/SkyblockProfiles;", "currentSack", "", "currentSortMode", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$SortMode;", "guiLeft", "guiTop", "itemIconSize", "manager", "Lio/github/moulberry/notenoughupdates/NEUManager;", "kotlin.jvm.PlatformType", "getManager", "()Lio/github/moulberry/notenoughupdates/NEUManager;", "maxPage", "page", "pageSize", "playerRunes", "", "priceSourceButtonRect", "Lio/github/moulberry/notenoughupdates/util/Rectangle;", "getPriceSourceButtonRect", "()Lio/github/moulberry/notenoughupdates/util/Rectangle;", "priceSourceButtonRect$delegate", "Lkotlin/Lazy;", "pv_sacks", "Lnet/minecraft/util/ResourceLocation;", "rows", "sackArrayLeft", "sackArrayTop", "sackContents", "", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$SackInfo;", "sackGridXSize", "sackGridYSize", "sackItems", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$SackItem;", "sackPattern", "Ljava/util/regex/Pattern;", "sackTypes", "Lcom/google/gson/JsonObject;", "sacksJson", "sortButtonRect", "getSortButtonRect", "sortButtonRect$delegate", "tooltipToDisplay", "", "createTooltip", "name", "value", "", "amount", "isSack", "", "drawPage", "", "mouseX", "mouseY", "partialTicks", "", "generateTooltipFromEnum", "T", "", "currentlySelected", "(Ljava/lang/Enum;)Ljava/util/List;", "getData", "getPages", "pageName", "getPrice", "itemName", "getRuneData", "sacksInfo", "mouseClick", "mouseButton", "renderPriceSourceAndSortButtons", "sortSackTypesList", "PriceSource", "SackInfo", "SackItem", "SortMode", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nSacksPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SacksPage.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage\n+ 2 mcaccessor.kt\nio/github/moulberry/notenoughupdates/util/McaccessorKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KotlinStringUtils.kt\nio/github/moulberry/notenoughupdates/util/KotlinStringUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,596:1\n375#1,13:609\n375#1,13:622\n24#2:597\n24#2:598\n24#2:604\n1549#3:599\n1620#3,3:600\n1054#3:603\n1549#3:605\n1620#3,3:606\n1054#3:635\n1855#3,2:636\n33#4:638\n1#5:639\n*S KotlinDebug\n*F\n+ 1 SacksPage.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage\n*L\n353#1:609,13\n369#1:622,13\n107#1:597\n181#1:598\n259#1:604\n232#1:599\n232#1:600,3\n237#1:603\n325#1:605\n325#1:606,3\n549#1:635\n556#1:636,2\n579#1:638\n579#1:639\n*E\n"})
public final class SacksPage
extends GuiProfileViewerPage {
    @NotNull
    private final ResourceLocation pv_sacks;
    private JsonObject sacksJson;
    @NotNull
    private JsonObject sackTypes;
    @NotNull
    private List<String> tooltipToDisplay;
    @Nullable
    private SkyblockProfiles.SkyblockProfile currentProfile;
    @NotNull
    private String currentSack;
    private int page;
    private int maxPage;
    private final int arrowsHeight;
    private final int arrowsXPos;
    private final int columns;
    private final int rows;
    private final int pageSize;
    private int guiLeft;
    private int guiTop;
    private final int sackArrayLeft;
    private final int sackArrayTop;
    private final int sackGridXSize;
    private final int sackGridYSize;
    private final int itemIconSize;
    @NotNull
    private final Lazy priceSourceButtonRect$delegate;
    @NotNull
    private PriceSource currentPriceSource;
    @NotNull
    private final Lazy sortButtonRect$delegate;
    @NotNull
    private SortMode currentSortMode;
    @NotNull
    private Map<String, SackInfo> sackContents;
    @NotNull
    private final Map<String, SackItem> sackItems;
    @NotNull
    private final List<String> playerRunes;
    @NotNull
    private final Pattern sackPattern;

    public SacksPage(@NotNull GuiProfileViewer pvInstance) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)((Object)pvInstance), (String)"pvInstance");
        super(pvInstance);
        this.pv_sacks = new ResourceLocation("notenoughupdates:pv_sacks.png");
        this.sacksJson = Constants.SACKS;
        if (this.sacksJson != null && this.sacksJson.isJsonObject()) {
            jsonObject = this.sacksJson.getAsJsonObject("sacks");
            if (jsonObject == null) {
                jsonObject = new JsonObject();
            }
        } else {
            Utils.showOutdatedRepoNotification("sacks.json");
            jsonObject = new JsonObject();
        }
        this.sackTypes = jsonObject;
        this.tooltipToDisplay = CollectionsKt.emptyList();
        this.currentSack = "All";
        this.arrowsHeight = 180;
        this.arrowsXPos = 110;
        this.columns = 7;
        this.rows = 4;
        this.pageSize = this.columns * this.rows;
        this.guiLeft = GuiProfileViewer.getGuiLeft();
        this.guiTop = GuiProfileViewer.getGuiTop();
        this.sackArrayLeft = 168;
        this.sackArrayTop = 20;
        this.sackGridXSize = 37;
        this.sackGridYSize = 41;
        this.itemIconSize = 20;
        this.priceSourceButtonRect$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Rectangle>(this){
            final /* synthetic */ SacksPage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Rectangle invoke() {
                return new Rectangle(SacksPage.access$getGuiLeft$p(this.this$0) + 54, SacksPage.access$getGuiTop$p(this.this$0) + 155, 20, 20);
            }
        }));
        this.currentPriceSource = PriceSource.Bazaar;
        this.sortButtonRect$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Rectangle>(this){
            final /* synthetic */ SacksPage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Rectangle invoke() {
                return new Rectangle(SacksPage.access$getGuiLeft$p(this.this$0) + 76, SacksPage.access$getGuiTop$p(this.this$0) + 155, 20, 20);
            }
        }));
        this.currentSortMode = SortMode.Value;
        this.sackContents = new LinkedHashMap();
        this.sackItems = new LinkedHashMap();
        this.playerRunes = new ArrayList();
        String string = "^RUNE_(?<name>\\w+)_(?<tier>\\d)$";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(this, flags)");
        this.sackPattern = pattern;
    }

    private final NEUManager getManager() {
        return NotEnoughUpdates.INSTANCE.manager;
    }

    private final Rectangle getPriceSourceButtonRect() {
        Lazy lazy = this.priceSourceButtonRect$delegate;
        return (Rectangle)lazy.getValue();
    }

    private final Rectangle getSortButtonRect() {
        Lazy lazy = this.sortButtonRect$delegate;
        return (Rectangle)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        Object object;
        Object sackData;
        int y;
        int x;
        Object sackItemName;
        this.guiLeft = GuiProfileViewer.getGuiLeft();
        this.guiTop = GuiProfileViewer.getGuiTop();
        boolean $i$f$getMC = false;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.pv_sacks);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        SkyblockProfiles.SkyblockProfile newProfile = this.getSelectedProfile();
        if (newProfile == null) {
            Utils.drawStringCentered("\u00a7cMissing Profile Data", this.guiLeft + 250, this.guiTop + 101, true, 0);
            return;
        }
        if (this.sacksJson == null) {
            Utils.drawStringCentered("\u00a7cMissing Repo Data", this.guiLeft + 250, this.guiTop + 101, true, 0);
            return;
        }
        if (!Intrinsics.areEqual((Object)newProfile, (Object)this.currentProfile)) {
            this.getData();
            this.currentProfile = this.getSelectedProfile();
        }
        SackInfo sackInfo = this.sackContents.get(this.currentSack);
        if (sackInfo == null) {
            SacksPage $this$drawPage_u24lambda_u240 = this;
            boolean bl = false;
            Utils.drawStringCentered("\u00a7cApi Info Missing", $this$drawPage_u24lambda_u240.guiLeft + 250, $this$drawPage_u24lambda_u240.guiTop + 101, true, 0);
            return;
        }
        SackInfo currentSackData = sackInfo;
        String name = Intrinsics.areEqual((Object)this.currentSack, (Object)"All") ? "\u00a72All Sacks" : "\u00a72" + this.currentSack + " Sack";
        Utils.renderShadowedString(name, (float)(this.guiLeft + 78), (float)(this.guiTop + 74), 105);
        Utils.renderAlignedString("\u00a76Value", "\u00a7f" + StringUtils.formatNumber((long)currentSackData.getSackValue()), this.guiLeft + 27, this.guiTop + 91, 102);
        Utils.renderAlignedString("\u00a72Items", "\u00a7f" + StringUtils.formatNumber(currentSackData.getItemCount()), this.guiLeft + 27, this.guiTop + 108, 102);
        GlStateManager.func_179126_j();
        int startIndex = this.page * this.pageSize;
        int endIndex = (this.page + 1) * this.pageSize;
        if (Intrinsics.areEqual((Object)this.currentSack, (Object)"All")) {
            Iterator<Map.Entry<String, JsonElement>> bl = this.sackTypes.entrySet().iterator();
            int n = 0;
            while (bl.hasNext()) {
                JsonObject data;
                int index = n++;
                Map.Entry<String, JsonElement> entrySet = bl.next();
                Intrinsics.checkNotNullExpressionValue(entrySet, (String)"entrySet");
                String sackName = entrySet.getKey();
                JsonElement sackData2 = entrySet.getValue();
                if (index < startIndex || index >= endIndex) continue;
                int adjustedIndex = index - startIndex;
                int xIndex = adjustedIndex % this.columns;
                int yIndex = adjustedIndex / this.columns;
                if (yIndex >= this.rows || !(data = sackData2.getAsJsonObject()).has("item") || !data.get("item").isJsonPrimitive() || !data.get("item").getAsJsonPrimitive().isString()) continue;
                sackItemName = data.get("item").getAsString();
                ItemStack itemStack = this.getManager().createItem((String)sackItemName);
                x = this.guiLeft + this.sackArrayLeft + xIndex * this.sackGridXSize;
                y = this.guiTop + this.sackArrayTop + yIndex * this.sackGridYSize;
                boolean $i$f$getMC2 = false;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                Utils.drawTexturedRect(x, y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                SackInfo sackInfo2 = this.sackContents.get(sackName);
                if (sackInfo2 == null) {
                    sackInfo2 = new SackInfo(0, 0.0);
                }
                SackInfo sackInfo3 = sackInfo2;
                Utils.drawStringCentered("\u00a76" + StringUtils.shortNumberFormat(KotlinNumberUtilsKt.roundToDecimals(sackInfo3.getSackValue(), 0)), x + this.itemIconSize / 2, y - 4, true, 0);
                Utils.drawStringCentered("\u00a77" + StringUtils.shortNumberFormat(sackInfo3.getItemCount()), x + this.itemIconSize / 2, y + 26, true, 0);
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                if (itemStack != null) {
                    Utils.drawItemStack(itemStack, x + 2, y + 2);
                    if (mouseX <= x || mouseX >= x + this.itemIconSize || mouseY <= y || mouseY >= y + this.itemIconSize) continue;
                    this.tooltipToDisplay = this.createTooltip(sackName + " Sack", sackInfo3.getSackValue(), sackInfo3.getItemCount(), true);
                    continue;
                }
                System.out.println((Object)((String)sackItemName + " missing in neu repo"));
            }
        } else {
            void $this$mapTo$iv$iv;
            sackData = this.sackTypes.get(this.currentSack).getAsJsonObject();
            JsonArray sackContents = ((JsonObject)sackData).getAsJsonArray("contents");
            Intrinsics.checkNotNullExpressionValue((Object)sackContents, (String)"sackContents");
            Iterable $this$map$iv = sackContents;
            boolean $i$f$map = false;
            Iterable sackData2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                sackItemName = (JsonElement)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getAsString());
            }
            List sackItemNames = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (Intrinsics.areEqual((Object)this.currentSack, (Object)"Rune")) {
                sackItemNames = this.playerRunes;
            }
            Object $this$sortedByDescending$iv = sackItemNames;
            int $i$f$sortedByDescending = 0;
            sackItemNames = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
                final /* synthetic */ SacksPage this$0;
                {
                    this.this$0 = sacksPage;
                }

                public final int compare(T a, T b) {
                    double d;
                    double d2;
                    String it = (String)b;
                    boolean bl = false;
                    SackItem sackItem = (SackItem)SacksPage.access$getSackItems$p(this.this$0).get(it);
                    if (sackItem == null) {
                        sackItem = new SackItem(0, 0.0);
                    }
                    SackItem sackInfo = sackItem;
                    switch (WhenMappings.$EnumSwitchMapping$0[SacksPage.access$getCurrentSortMode$p(this.this$0).ordinal()]) {
                        case 1: {
                            d2 = sackInfo.getValue();
                            break;
                        }
                        case 2: {
                            d2 = sackInfo.getAmount();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    it = (String)a;
                    Comparable comparable = Double.valueOf(d2);
                    bl = false;
                    SackItem sackItem2 = (SackItem)SacksPage.access$getSackItems$p(this.this$0).get(it);
                    if (sackItem2 == null) {
                        sackItem2 = new SackItem(0, 0.0);
                    }
                    sackInfo = sackItem2;
                    switch (WhenMappings.$EnumSwitchMapping$0[SacksPage.access$getCurrentSortMode$p(this.this$0).ordinal()]) {
                        case 1: {
                            d = sackInfo.getValue();
                            break;
                        }
                        case 2: {
                            d = sackInfo.getAmount();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(d));
                }
            });
            $this$sortedByDescending$iv = sackItemNames.iterator();
            $i$f$sortedByDescending = 0;
            while ($this$sortedByDescending$iv.hasNext()) {
                int index = $i$f$sortedByDescending++;
                String itemName = (String)$this$sortedByDescending$iv.next();
                if (index < startIndex || index >= endIndex) continue;
                int adjustedIndex = index - startIndex;
                int xIndex = adjustedIndex % this.columns;
                int yIndex = adjustedIndex / this.columns;
                if (yIndex >= this.rows) continue;
                SackItem sackItem = this.sackItems.get(itemName);
                if (sackItem == null) {
                    sackItem = new SackItem(0, 0.0);
                }
                SackItem itemInfo = sackItem;
                ItemStack itemStack = this.getManager().createItem(itemName);
                x = this.guiLeft + this.sackArrayLeft + xIndex * this.sackGridXSize;
                y = this.guiTop + this.sackArrayTop + yIndex * this.sackGridYSize;
                boolean $i$f$getMC3 = false;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
                Utils.drawTexturedRect(x, y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                Utils.drawStringCentered("\u00a76" + StringUtils.shortNumberFormat(KotlinNumberUtilsKt.roundToDecimals(itemInfo.getValue(), 0)), x + this.itemIconSize / 2, y - 4, true, 0);
                Utils.drawStringCentered("\u00a77" + StringUtils.shortNumberFormat(itemInfo.getAmount()), x + 10, y + 26, true, 0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (itemStack != null) {
                    String stackName = itemStack.func_82833_r();
                    Utils.drawItemStack(itemStack, x + 2, y + 2);
                    if (mouseX <= x || mouseX >= x + this.itemIconSize || mouseY <= y || mouseY >= y + this.itemIconSize) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)stackName, (String)"stackName");
                    this.tooltipToDisplay = this.createTooltip(stackName, itemInfo.getValue(), itemInfo.getAmount(), false);
                    continue;
                }
                System.out.println((Object)(itemName + " missing in neu repo"));
            }
            Rectangle buttonRect = new Rectangle(this.guiLeft + this.sackArrayLeft, this.guiTop + this.arrowsHeight, 80, 15);
            RenderUtils.drawFloatingRectWithAlpha(buttonRect.getX(), buttonRect.getY(), buttonRect.getWidth(), buttonRect.getHeight(), 100, true);
            Utils.renderShadowedString("\u00a72Back", (float)(this.guiLeft + this.sackArrayLeft + 40), (float)(this.guiTop + this.arrowsHeight + 3), 79);
            if (Mouse.getEventButtonState() && Utils.isWithinRect(mouseX, mouseY, buttonRect)) {
                this.currentSack = "All";
                Utils.playPressSound();
                this.page = 0;
                this.maxPage = this.getPages(this.currentSack, this.sackTypes);
            }
        }
        this.renderPriceSourceAndSortButtons(mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        sackData = new int[2];
        sackData[0] = this.sackArrayLeft + this.arrowsXPos;
        sackData[1] = this.arrowsHeight;
        ArrowPagesUtils.onDraw(this.guiLeft, this.guiTop, (int[])sackData, this.page, this.maxPage + 1);
        if (!((Collection)this.tooltipToDisplay).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            sackData = this.tooltipToDisplay;
            object = this;
            boolean $i$f$map = false;
            void sackItemNames = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String adjustedIndex = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("\u00a77" + (String)it);
            }
            ((SacksPage)object).tooltipToDisplay = (List)destination$iv$iv;
            Utils.drawHoveringText(this.tooltipToDisplay, mouseX, mouseY, this.getInstance().field_146294_l, this.getInstance().field_146295_m, -1);
            this.tooltipToDisplay = CollectionsKt.emptyList();
        }
    }

    private final void renderPriceSourceAndSortButtons(int mouseX, int mouseY) {
        ItemStack itemStack;
        Enum currentlySelected$iv;
        String line$iv;
        List tooltip$iv;
        List list;
        List tooltip;
        ItemStack itemStack2;
        Rectangle rectangle = this.getPriceSourceButtonRect();
        switch (WhenMappings.$EnumSwitchMapping$1[this.currentPriceSource.ordinal()]) {
            case 1: {
                String uuid = "c232e3820897429157619b0ee099fec0628f602fff12b695de54aef11d923ad7";
                itemStack2 = ItemUtils.createSkullItemStack(uuid, uuid, "https://textures.minecraft.net/texture/" + uuid);
                break;
            }
            case 2: {
                itemStack2 = ItemUtils.getCoinItemStack(100000.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"when (currentPriceSource\u2026k(100000.0)\n            }");
        ResourceLocation resourceLocation = GuiProfileViewer.pv_elements;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"pv_elements");
        KotlinRenderUtils.renderItemStackButton(rectangle, itemStack2, resourceLocation);
        if (this.getPriceSourceButtonRect().contains(mouseX, mouseY)) {
            Object object = new String[]{"\u00a76Select price source"};
            tooltip = CollectionsKt.mutableListOf((Object[])object);
            object = this;
            Enum enum_ = this.currentPriceSource;
            list = tooltip;
            boolean $i$f$generateTooltipFromEnum = false;
            tooltip$iv = new ArrayList();
            for (PriceSource priceSource : PriceSource.values()) {
                line$iv = " ";
                line$iv = line$iv + (Intrinsics.areEqual((Object)((Object)priceSource), (Object)currentlySelected$iv) ? "\u00a72> " + priceSource.name() : priceSource.name());
                tooltip$iv.add(line$iv);
            }
            tooltip$iv.add("");
            tooltip$iv.add("\u00a7eClick to switch!");
            list.addAll(tooltip$iv);
            this.tooltipToDisplay = tooltip;
        }
        Rectangle rectangle2 = this.getSortButtonRect();
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentSortMode.ordinal()]) {
            case 1: {
                itemStack = new ItemStack(Items.field_151043_k);
                break;
            }
            case 2: {
                itemStack = new ItemStack((Block)Blocks.field_150438_bZ);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ResourceLocation resourceLocation2 = GuiProfileViewer.pv_elements;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"pv_elements");
        KotlinRenderUtils.renderItemStackButton(rectangle2, itemStack, resourceLocation2);
        if (this.getSortButtonRect().contains(mouseX, mouseY)) {
            Object this_$iv = new String[]{"\u00a76Select sorting mode"};
            tooltip = CollectionsKt.mutableListOf((Object[])this_$iv);
            this_$iv = this;
            currentlySelected$iv = this.currentSortMode;
            list = tooltip;
            boolean $i$f$generateTooltipFromEnum = false;
            tooltip$iv = new ArrayList();
            for (Enum enum_ : SortMode.values()) {
                line$iv = " ";
                line$iv = line$iv + (Intrinsics.areEqual((Object)enum_, (Object)currentlySelected$iv) ? "\u00a72> " + enum_.name() : enum_.name());
                tooltip$iv.add(line$iv);
            }
            tooltip$iv.add("");
            tooltip$iv.add("\u00a7eClick to switch!");
            list.addAll(tooltip$iv);
            this.tooltipToDisplay = tooltip;
        }
    }

    private final /* synthetic */ <T extends Enum<T>> List<String> generateTooltipFromEnum(T currentlySelected) {
        boolean $i$f$generateTooltipFromEnum = false;
        List tooltip = new ArrayList();
        Intrinsics.reifiedOperationMarker((int)5, (String)"T");
        for (Enum enumValue : new Enum[]{}) {
            String line = " ";
            line = line + (Intrinsics.areEqual((Object)enumValue, currentlySelected) ? "\u00a72> " + enumValue.name() : enumValue.name());
            tooltip.add(line);
        }
        tooltip.add("");
        tooltip.add("\u00a7eClick to switch!");
        return tooltip;
    }

    public final boolean mouseClick(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.sacksJson == null || this.sackContents.isEmpty()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.currentSack, (Object)"All")) {
            int startIndex = this.page * this.pageSize;
            int endIndex = (this.page + 1) * this.pageSize;
            Iterator<Map.Entry<String, JsonElement>> iterator = this.sackTypes.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Map.Entry<String, JsonElement> sackData = iterator.next();
                String sackName = sackData.getKey();
                if (index < startIndex || index >= endIndex) continue;
                int adjustedIndex = index - startIndex;
                int xIndex = adjustedIndex % this.columns;
                int yIndex = adjustedIndex / this.columns;
                if (yIndex >= this.rows) continue;
                int x = this.guiLeft + this.sackArrayLeft + xIndex * this.sackGridXSize;
                int y = this.guiTop + this.sackArrayTop + yIndex * this.sackGridYSize;
                if (mouseX <= x || mouseX >= x + this.itemIconSize || mouseY <= y || mouseY >= y + this.itemIconSize) continue;
                Intrinsics.checkNotNullExpressionValue((Object)sackName, (String)"sackName");
                this.currentSack = sackName;
                Utils.playPressSound();
                this.page = 0;
                this.maxPage = this.getPages(this.currentSack, this.sackTypes);
                return true;
            }
        }
        if (this.getPriceSourceButtonRect().contains(mouseX, mouseY)) {
            this.currentPriceSource = PriceSource.values()[(this.currentPriceSource.ordinal() + 1) % PriceSource.values().length];
            Utils.playPressSound();
            this.getData();
        }
        if (this.getSortButtonRect().contains(mouseX, mouseY)) {
            this.currentSortMode = SortMode.values()[(this.currentSortMode.ordinal() + 1) % SortMode.values().length];
            Utils.playPressSound();
            this.getData();
        }
        int[] nArray = new int[]{this.sackArrayLeft + this.arrowsXPos, this.arrowsHeight};
        ArrowPagesUtils.onPageSwitchMouse(this.guiLeft, this.guiTop, nArray, this.page, this.maxPage + 1, arg_0 -> SacksPage.mouseClick$lambda$4(this, arg_0));
        return false;
    }

    private final List<String> createTooltip(String name, double value, int amount, boolean isSack) {
        Object[] objectArray = new String[]{"\u00a72" + name, "Items Stored: \u00a7a" + StringUtils.formatNumber(amount), "Total Value: \u00a76" + StringUtils.formatNumber((long)value)};
        List baseList = CollectionsKt.mutableListOf((Object[])objectArray);
        if (isSack) {
            baseList.add("\u00a7eClick for more details");
        }
        return baseList;
    }

    private final int getPages(String pageName, JsonObject sackTypes) {
        int n;
        String string = pageName;
        if (Intrinsics.areEqual((Object)string, (Object)"All")) {
            n = sackTypes.entrySet().size() / this.pageSize;
        } else if (Intrinsics.areEqual((Object)string, (Object)"Rune")) {
            n = this.playerRunes.size() / this.pageSize;
        } else {
            JsonObject sackData = sackTypes.get(this.currentSack).getAsJsonObject();
            JsonArray sackContents = sackData.getAsJsonArray("contents");
            n = sackContents.size() / this.pageSize;
        }
        return n;
    }

    private final void getData() {
        this.sackContents.clear();
        this.sackItems.clear();
        this.playerRunes.clear();
        if (!this.sacksJson.has("sacks") || !this.sacksJson.get("sacks").isJsonObject()) {
            Utils.showOutdatedRepoNotification("sacks.json");
            return;
        }
        Object object = this.getSelectedProfile();
        if (object == null || (object = ((SkyblockProfiles.SkyblockProfile)object).getProfileJson()) == null) {
            return;
        }
        Object selectedProfile = object;
        JsonObject sacksInfo = Utils.getElementOrDefault((JsonElement)selectedProfile, "inventory.sacks_counts", new JsonObject()).getAsJsonObject();
        double totalValue = 0.0;
        int totalItems = 0;
        for (Map.Entry<String, JsonElement> entry : this.sackTypes.entrySet()) {
            Intrinsics.checkNotNullExpressionValue(entry, (String)"sackTypes.entrySet()");
            String sackName = entry.getKey();
            JsonElement sackData = entry.getValue();
            if (!sackData.isJsonObject()) {
                return;
            }
            JsonObject data = sackData.getAsJsonObject();
            double sackValue = 0.0;
            int sackItemCount = 0;
            if (Intrinsics.areEqual((Object)sackName, (Object)"Rune")) {
                Intrinsics.checkNotNullExpressionValue((Object)sacksInfo, (String)"sacksInfo");
                totalItems += this.getRuneData(sacksInfo);
                continue;
            }
            if (!data.has("contents") || !data.get("contents").isJsonArray()) {
                return;
            }
            JsonArray contents = data.getAsJsonArray("contents");
            for (JsonElement item : contents) {
                if (!item.isJsonPrimitive() || !item.getAsJsonPrimitive().isString()) {
                    return;
                }
                String sackItem = item.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)sackItem, (String)"sackItem");
                String adjustedName = StringsKt.replace$default((String)sackItem, (String)"-", (String)":", (boolean)false, (int)4, null);
                Intrinsics.checkNotNullExpressionValue((Object)sacksInfo, (String)"sacksInfo");
                int itemCount = KotlinJsonUtilsKt.getIntOrValue(sacksInfo, adjustedName, 0);
                double itemValue = (double)itemCount * this.getPrice(sackItem);
                if (!this.sackItems.containsKey(sackItem)) {
                    totalValue += itemValue;
                    totalItems += itemCount;
                }
                this.sackItems.put(sackItem, new SackItem(itemCount, itemValue));
                sackValue += itemValue;
                sackItemCount += itemCount;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sackName, (String)"sackName");
            this.sackContents.put(sackName, new SackInfo(sackItemCount, sackValue));
        }
        this.sackTypes = this.sortSackTypesList();
        for (Map.Entry<String, JsonElement> entry : sacksInfo.entrySet()) {
            CharSequence charSequence;
            Intrinsics.checkNotNullExpressionValue(entry, (String)"sacksInfo.entrySet()");
            String itemName = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)itemName, (String)"itemName");
            String adjustedName = StringsKt.replace$default((String)itemName, (String)":", (String)"-", (boolean)false, (int)4, null);
            if (this.sackItems.containsKey(adjustedName) || new Regex("(RUNE|PERFECT_|FLAWLESS_|MUSHROOM_COLLECTION)").containsMatchIn(charSequence = (CharSequence)adjustedName)) continue;
            System.out.println((Object)(adjustedName + " missing from repo sacks file!"));
        }
        this.sackContents.put("All", new SackInfo(totalItems, totalValue));
    }

    private final JsonObject sortSackTypesList() {
        JsonObject sortedTypes = new JsonObject();
        Set<Map.Entry<String, JsonElement>> set = Constants.SACKS.getAsJsonObject("sacks").entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"SACKS.getAsJsonObject(\"sacks\").entrySet()");
        Iterable $this$sortedByDescending$iv = set;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
            final /* synthetic */ SacksPage this$0;
            {
                this.this$0 = sacksPage;
            }

            public final int compare(T a, T b) {
                double d;
                double d2;
                Map.Entry entry = (Map.Entry)b;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, _)");
                String key = (String)entry.getKey();
                SackInfo sackInfo = (SackInfo)SacksPage.access$getSackContents$p(this.this$0).get(key);
                if (sackInfo == null) {
                    sackInfo = new SackInfo(0, 0.0);
                }
                SackInfo sack = sackInfo;
                switch (WhenMappings.$EnumSwitchMapping$0[SacksPage.access$getCurrentSortMode$p(this.this$0).ordinal()]) {
                    case 1: {
                        d2 = sack.getSackValue();
                        break;
                    }
                    case 2: {
                        d2 = sack.getItemCount();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                entry = (Map.Entry)a;
                Comparable comparable = Double.valueOf(d2);
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, _)");
                key = (String)entry.getKey();
                SackInfo sackInfo2 = (SackInfo)SacksPage.access$getSackContents$p(this.this$0).get(key);
                if (sackInfo2 == null) {
                    sackInfo2 = new SackInfo(0, 0.0);
                }
                sack = sackInfo2;
                switch (WhenMappings.$EnumSwitchMapping$0[SacksPage.access$getCurrentSortMode$p(this.this$0).ordinal()]) {
                    case 1: {
                        d = sack.getSackValue();
                        break;
                    }
                    case 2: {
                        d = sack.getItemCount();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(d));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            GsonKt.set(sortedTypes, key, value);
        }
        return sortedTypes;
    }

    private final double getPrice(String itemName) {
        double d;
        Double d2 = HypixelItemAPI.getNPCSellPrice(itemName);
        double npcPrice = d2 != null ? d2 : 0.0;
        switch (WhenMappings.$EnumSwitchMapping$1[this.currentPriceSource.ordinal()]) {
            case 2: {
                d = npcPrice;
                break;
            }
            case 1: {
                JsonObject jsonObject = this.getManager().auctionManager.getBazaarInfo(itemName);
                if (jsonObject == null) {
                    return npcPrice;
                }
                JsonObject bazaarInfo = jsonObject;
                double buyPrice = KotlinJsonUtilsKt.getDoubleOrValue(bazaarInfo, "curr_buy", 0.0);
                double sellPrice = KotlinJsonUtilsKt.getDoubleOrValue(bazaarInfo, "curr_sell", 0.0);
                d = Math.max(buyPrice, sellPrice);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private final int getRuneData(JsonObject sacksInfo) {
        int sackItemCount = 0;
        for (Map.Entry<String, JsonElement> entry : sacksInfo.entrySet()) {
            void $this$matchMatcher$iv;
            Intrinsics.checkNotNullExpressionValue(entry, (String)"sacksInfo.entrySet()");
            String itemName = entry.getKey();
            JsonElement amount = entry.getValue();
            if (!amount.isJsonPrimitive() || !amount.getAsJsonPrimitive().isNumber()) continue;
            Pattern pattern = this.sackPattern;
            Intrinsics.checkNotNullExpressionValue((Object)itemName, (String)"itemName");
            String text$iv = itemName;
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
            Matcher $this$getRuneData_u24lambda_u247 = it$iv;
            boolean bl2 = false;
            int itemAmount = amount.getAsInt();
            String name = $this$getRuneData_u24lambda_u247.group("name");
            String tier = $this$getRuneData_u24lambda_u247.group("tier");
            String neuInternalName = name + "_RUNE;" + tier;
            sackItemCount += itemAmount;
            this.sackItems.put(neuInternalName, new SackItem(itemAmount, 1.0 * (double)itemAmount));
            this.playerRunes.add(neuInternalName);
        }
        this.sackContents.put("Rune", new SackInfo(sackItemCount, 1.0 * (double)sackItemCount));
        return sackItemCount;
    }

    private static final void mouseClick$lambda$4(SacksPage this$0, Integer pageChange) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)pageChange, (String)"pageChange");
        this$0.page = pageChange;
    }

    public static final /* synthetic */ Map access$getSackItems$p(SacksPage $this) {
        return $this.sackItems;
    }

    public static final /* synthetic */ SortMode access$getCurrentSortMode$p(SacksPage $this) {
        return $this.currentSortMode;
    }

    public static final /* synthetic */ Map access$getSackContents$p(SacksPage $this) {
        return $this.sackContents;
    }

    public static final /* synthetic */ int access$getGuiLeft$p(SacksPage $this) {
        return $this.guiLeft;
    }

    public static final /* synthetic */ int access$getGuiTop$p(SacksPage $this) {
        return $this.guiTop;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$PriceSource;", "", "(Ljava/lang/String;I)V", "Bazaar", "NPC", "NotEnoughUpdates"})
    private static final class PriceSource
    extends Enum<PriceSource> {
        public static final /* enum */ PriceSource Bazaar = new PriceSource();
        public static final /* enum */ PriceSource NPC = new PriceSource();
        private static final /* synthetic */ PriceSource[] $VALUES;

        public static PriceSource[] values() {
            return (PriceSource[])$VALUES.clone();
        }

        public static PriceSource valueOf(String value) {
            return Enum.valueOf(PriceSource.class, value);
        }

        static {
            $VALUES = priceSourceArray = new PriceSource[]{PriceSource.Bazaar, PriceSource.NPC};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$SackInfo;", "", "itemCount", "", "sackValue", "", "(ID)V", "getItemCount", "()I", "getSackValue", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "NotEnoughUpdates"})
    public static final class SackInfo {
        private final int itemCount;
        private final double sackValue;

        public SackInfo(int itemCount, double sackValue) {
            this.itemCount = itemCount;
            this.sackValue = sackValue;
        }

        public final int getItemCount() {
            return this.itemCount;
        }

        public final double getSackValue() {
            return this.sackValue;
        }

        public final int component1() {
            return this.itemCount;
        }

        public final double component2() {
            return this.sackValue;
        }

        @NotNull
        public final SackInfo copy(int itemCount, double sackValue) {
            return new SackInfo(itemCount, sackValue);
        }

        public static /* synthetic */ SackInfo copy$default(SackInfo sackInfo, int n, double d, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = sackInfo.itemCount;
            }
            if ((n2 & 2) != 0) {
                d = sackInfo.sackValue;
            }
            return sackInfo.copy(n, d);
        }

        @NotNull
        public String toString() {
            return "SackInfo(itemCount=" + this.itemCount + ", sackValue=" + this.sackValue + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.itemCount);
            result2 = result2 * 31 + Double.hashCode(this.sackValue);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SackInfo)) {
                return false;
            }
            SackInfo sackInfo = (SackInfo)other;
            if (this.itemCount != sackInfo.itemCount) {
                return false;
            }
            return Double.compare(this.sackValue, sackInfo.sackValue) == 0;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$SackItem;", "", "amount", "", "value", "", "(ID)V", "getAmount", "()I", "getValue", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "NotEnoughUpdates"})
    public static final class SackItem {
        private final int amount;
        private final double value;

        public SackItem(int amount, double value) {
            this.amount = amount;
            this.value = value;
        }

        public final int getAmount() {
            return this.amount;
        }

        public final double getValue() {
            return this.value;
        }

        public final int component1() {
            return this.amount;
        }

        public final double component2() {
            return this.value;
        }

        @NotNull
        public final SackItem copy(int amount, double value) {
            return new SackItem(amount, value);
        }

        public static /* synthetic */ SackItem copy$default(SackItem sackItem, int n, double d, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = sackItem.amount;
            }
            if ((n2 & 2) != 0) {
                d = sackItem.value;
            }
            return sackItem.copy(n, d);
        }

        @NotNull
        public String toString() {
            return "SackItem(amount=" + this.amount + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.amount);
            result2 = result2 * 31 + Double.hashCode(this.value);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SackItem)) {
                return false;
            }
            SackItem sackItem = (SackItem)other;
            if (this.amount != sackItem.amount) {
                return false;
            }
            return Double.compare(this.value, sackItem.value) == 0;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/SacksPage$SortMode;", "", "(Ljava/lang/String;I)V", "Value", "Quantity", "NotEnoughUpdates"})
    private static final class SortMode
    extends Enum<SortMode> {
        public static final /* enum */ SortMode Value = new SortMode();
        public static final /* enum */ SortMode Quantity = new SortMode();
        private static final /* synthetic */ SortMode[] $VALUES;

        public static SortMode[] values() {
            return (SortMode[])$VALUES.clone();
        }

        public static SortMode valueOf(String value) {
            return Enum.valueOf(SortMode.class, value);
        }

        static {
            $VALUES = sortModeArray = new SortMode[]{SortMode.Value, SortMode.Quantity};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SortMode.values().length];
            try {
                nArray[SortMode.Value.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortMode.Quantity.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PriceSource.values().length];
            try {
                nArray[PriceSource.Bazaar.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PriceSource.NPC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

