/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.item.enchants;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.item.enchants.EnchantMatcher;
import io.github.moulberry.notenoughupdates.util.LRUCache;
import io.github.moulberry.notenoughupdates.util.LateBindingChroma;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantStyleCustomizer {
    public static EnchantStyleCustomizer INSTANCE = new EnchantStyleCustomizer();
    LRUCache<String, LateBindingChroma> enchantLineCache = LRUCache.memoize(this::replaceEnchantLine, 1000);
    List<String> lastEnchant = new ArrayList<String>();

    public LateBindingChroma replaceEnchantLine(String originalLine) {
        String line = originalLine;
        HashSet<String> alreadyReplacedEnchants = new HashSet<String>();
        for (String enchantMatcherStr : NotEnoughUpdates.INSTANCE.config.hidden.enchantColours) {
            Matcher matcher;
            Optional enchantMatcherP = (Optional)EnchantMatcher.fromSaveFormatMemoized.apply(enchantMatcherStr);
            if (!enchantMatcherP.isPresent()) continue;
            EnchantMatcher enchantMatcher = (EnchantMatcher)enchantMatcherP.get();
            int matchIterations = 0;
            int last = 0;
            while ((matcher = enchantMatcher.getPatternWithLevels().matcher(line)).find(last) && matchIterations++ < 5) {
                String enchantName = matcher.group("enchantName");
                String levelText = matcher.group("level");
                if (enchantName == null || levelText == null || levelText.isEmpty() || enchantName.isEmpty()) continue;
                String cleanEnchantName = Utils.cleanColour(enchantName);
                if (cleanEnchantName.startsWith(" ")) {
                    last = matcher.end();
                    continue;
                }
                int level = Utils.parseIntOrRomanNumeral(levelText);
                if (!enchantMatcher.doesLevelMatch(level)) {
                    last = matcher.end();
                    continue;
                }
                if (alreadyReplacedEnchants.contains(cleanEnchantName)) continue;
                alreadyReplacedEnchants.add(cleanEnchantName);
                int startMatch = matcher.start();
                int endLevel = matcher.end("level");
                String parsed = line.substring(0, startMatch) + enchantMatcher.getFormatting() + enchantName + " " + levelText;
                line = parsed + (endLevel >= line.length() ? "" : line.substring(endLevel));
                last = parsed.length();
            }
        }
        return LateBindingChroma.of(line);
    }

    public void cacheInvalidate() {
        this.enchantLineCache.clearCache();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt = event.itemStack.func_77978_p();
        if (nbt == null) {
            return;
        }
        NBTTagCompound extraAttributes = nbt.func_74775_l("ExtraAttributes");
        NBTTagCompound enchantments = extraAttributes.func_74775_l("enchantments");
        NBTTagCompound attributes = extraAttributes.func_74775_l("attributes");
        enchantments.func_179237_a(attributes);
        if (enchantments.func_150296_c().isEmpty()) {
            return;
        }
        if (!this.lastEnchant.equals(NotEnoughUpdates.INSTANCE.config.hidden.enchantColours) || !NotEnoughUpdates.INSTANCE.config.misc.cacheItemEnchant) {
            this.cacheInvalidate();
            this.lastEnchant = new ArrayList<String>(NotEnoughUpdates.INSTANCE.config.hidden.enchantColours);
        }
        int lineIndex = 0;
        ListIterator<String> iterator = event.toolTip.listIterator();
        while (iterator.hasNext()) {
            String replacedLine;
            String nextLine = (String)iterator.next();
            if (nextLine.equals(replacedLine = ((LateBindingChroma)this.enchantLineCache.apply(nextLine)).render(lineIndex++))) continue;
            iterator.set(replacedLine);
        }
    }
}

