/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.inventory;

import com.google.gson.Gson;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.GuiContainerBackgroundDrawnEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.inventory.MuseumTooltipManager;
import io.github.moulberry.notenoughupdates.util.KotlinStringUtilsKt;
import io.github.moulberry.notenoughupdates.util.MuseumUtil;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.kotlin.KSerializable;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001eH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\f\u0010\r*\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager;", "", "()V", "donatedStates", "", "Lio/github/moulberry/notenoughupdates/util/MuseumUtil$DonationState;", "file", "Ljava/io/File;", "loadedMuseumData", "Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager$MuseumData;", "getLoadedMuseumData$delegate", "(Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager;)Ljava/lang/Object;", "getLoadedMuseumData", "()Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager$MuseumData;", "loadedMuseumDataDelegate", "Lkotlin/Lazy;", "previousSlots", "Lnet/minecraft/inventory/Slot;", "addItemToDonatedList", "", "itemsToAdd", "", "hasPlayerVisitedMuseum", "", "isItemDonated", "item", "onBackgroundDrawn", "event", "Lio/github/moulberry/notenoughupdates/events/GuiContainerBackgroundDrawnEvent;", "onWorldUnload", "Lnet/minecraftforge/event/world/WorldEvent$Unload;", "MuseumData", "ProfileSpecificMuseumData", "NotEnoughUpdates"})
public final class MuseumTooltipManager {
    @NotNull
    public static final MuseumTooltipManager INSTANCE = new MuseumTooltipManager();
    @NotNull
    private static final Lazy<MuseumData> loadedMuseumDataDelegate = LazyKt.lazy((Function0)loadedMuseumDataDelegate.1.INSTANCE);
    @NotNull
    private static final File file = new File(NotEnoughUpdates.INSTANCE.getNeuDir(), "donated_museum_items.json");
    @NotNull
    private static final List<MuseumUtil.DonationState> donatedStates;
    @NotNull
    private static List<? extends Slot> previousSlots;

    private MuseumTooltipManager() {
    }

    private final MuseumData getLoadedMuseumData() {
        Lazy<MuseumData> lazy = loadedMuseumDataDelegate;
        return (MuseumData)lazy.getValue();
    }

    private static Object getLoadedMuseumData$delegate(MuseumTooltipManager museumTooltipManager) {
        return loadedMuseumDataDelegate;
    }

    private final void addItemToDonatedList(List<String> itemsToAdd) {
        String string = SBInfo.getInstance().currentProfile;
        if (string == null) {
            return;
        }
        String profile = string;
        for (String internalName : itemsToAdd) {
            ProfileSpecificMuseumData profileData;
            this.getLoadedMuseumData().getProfiles().computeIfAbsent(profile, arg_0 -> MuseumTooltipManager.addItemToDonatedList$lambda$0(addItemToDonatedList.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)this.getLoadedMuseumData().getProfiles().get(profile));
            profileData.getDonatedItems().add(internalName);
            profileData.setVisitedOnce(true);
        }
    }

    public final boolean isItemDonated(@NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        String string = SBInfo.getInstance().currentProfile;
        if (string == null) {
            return false;
        }
        String profile = string;
        ProfileSpecificMuseumData profileSpecificMuseumData = this.getLoadedMuseumData().getProfiles().get(profile);
        if (profileSpecificMuseumData == null) {
            return false;
        }
        ProfileSpecificMuseumData profileData = profileSpecificMuseumData;
        return profileData.getDonatedItems().contains(item);
    }

    public final boolean hasPlayerVisitedMuseum() {
        String string = SBInfo.getInstance().currentProfile;
        if (string == null) {
            return false;
        }
        String profile = string;
        if (SBInfo.getInstance().stranded || SBInfo.getInstance().bingo) {
            return true;
        }
        ProfileSpecificMuseumData profileSpecificMuseumData = this.getLoadedMuseumData().getProfiles().get(profile);
        if (profileSpecificMuseumData == null) {
            return false;
        }
        ProfileSpecificMuseumData profileData = profileSpecificMuseumData;
        return profileData.getVisitedOnce();
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerBackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        GuiContainer guiContainer = event.container;
        if (guiContainer == null) {
            return;
        }
        GuiContainer gui = guiContainer;
        Container container = gui.field_147002_h;
        ContainerChest containerChest = container instanceof ContainerChest ? (ContainerChest)container : null;
        if (containerChest == null) {
            return;
        }
        ContainerChest chest = containerChest;
        IInventory iInventory = chest.func_85151_d();
        Intrinsics.checkNotNullExpressionValue((Object)iInventory, (String)"chest.lowerChestInventory");
        if (!MuseumUtil.INSTANCE.isMuseumInventory(iInventory)) {
            return;
        }
        String string = Utils.getOpenChestName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOpenChestName()");
        boolean armor = StringsKt.endsWith$default((String)KotlinStringUtilsKt.stripControlCodes(string), (String)"Armor Sets", (boolean)false, (int)2, null);
        List slots = chest.field_75151_b;
        if (!((Object)slots).equals(previousSlots)) {
            for (int i = 0; i < 54; ++i) {
                MuseumUtil.MuseumItem item;
                Slot slot = (Slot)slots.get(i);
                if (slot == null || slot.func_75211_c() == null) continue;
                ItemStack itemStack = slot.func_75211_c();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"slot.stack");
                if (MuseumUtil.INSTANCE.findMuseumItem(itemStack, armor) == null || !donatedStates.contains((Object)item.getState())) continue;
                this.addItemToDonatedList(item.getSkyblockItemIds());
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)slots, (String)"slots");
        previousSlots = slots;
    }

    @SubscribeEvent
    public final void onWorldUnload(@NotNull WorldEvent.Unload event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (loadedMuseumDataDelegate.isInitialized()) {
            if (!file.exists()) {
                file.createNewFile();
            }
            String string = new Gson().toJson(this.getLoadedMuseumData());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(loadedMuseumData)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
    }

    private static final ProfileSpecificMuseumData addItemToDonatedList$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileSpecificMuseumData)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ File access$getFile$p() {
        return file;
    }

    static {
        MuseumUtil.DonationState[] donationStateArray = new MuseumUtil.DonationState[]{MuseumUtil.DonationState.DONATED_PRESENT, MuseumUtil.DonationState.DONATED_VACANT, MuseumUtil.DonationState.DONATED_PRESENT_PARTIAL};
        donatedStates = CollectionsKt.listOf((Object[])donationStateArray);
        previousSlots = CollectionsKt.emptyList();
    }

    @KSerializable
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager$MuseumData;", "", "profiles", "", "", "Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager$ProfileSpecificMuseumData;", "(Ljava/util/Map;)V", "getProfiles", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "NotEnoughUpdates"})
    public static final class MuseumData {
        @NotNull
        private final Map<String, ProfileSpecificMuseumData> profiles;

        public MuseumData(@NotNull Map<String, ProfileSpecificMuseumData> profiles) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            this.profiles = profiles;
        }

        public /* synthetic */ MuseumData(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = new LinkedHashMap();
            }
            this(map2);
        }

        @NotNull
        public final Map<String, ProfileSpecificMuseumData> getProfiles() {
            return this.profiles;
        }

        @NotNull
        public final Map<String, ProfileSpecificMuseumData> component1() {
            return this.profiles;
        }

        @NotNull
        public final MuseumData copy(@NotNull Map<String, ProfileSpecificMuseumData> profiles) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            return new MuseumData(profiles);
        }

        public static /* synthetic */ MuseumData copy$default(MuseumData museumData, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = museumData.profiles;
            }
            return museumData.copy(map2);
        }

        @NotNull
        public String toString() {
            return "MuseumData(profiles=" + this.profiles + ')';
        }

        public int hashCode() {
            return ((Object)this.profiles).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MuseumData)) {
                return false;
            }
            MuseumData museumData = (MuseumData)other;
            return Intrinsics.areEqual(this.profiles, museumData.profiles);
        }

        public MuseumData() {
            this(null, 1, null);
        }
    }

    @KSerializable
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/inventory/MuseumTooltipManager$ProfileSpecificMuseumData;", "", "donatedItems", "", "", "visitedOnce", "", "(Ljava/util/Set;Z)V", "getDonatedItems", "()Ljava/util/Set;", "getVisitedOnce", "()Z", "setVisitedOnce", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "NotEnoughUpdates"})
    public static final class ProfileSpecificMuseumData {
        @NotNull
        private final Set<String> donatedItems;
        private boolean visitedOnce;

        public ProfileSpecificMuseumData(@NotNull Set<String> donatedItems, boolean visitedOnce) {
            Intrinsics.checkNotNullParameter(donatedItems, (String)"donatedItems");
            this.donatedItems = donatedItems;
            this.visitedOnce = visitedOnce;
        }

        @NotNull
        public final Set<String> getDonatedItems() {
            return this.donatedItems;
        }

        public final boolean getVisitedOnce() {
            return this.visitedOnce;
        }

        public final void setVisitedOnce(boolean bl) {
            this.visitedOnce = bl;
        }

        @NotNull
        public final Set<String> component1() {
            return this.donatedItems;
        }

        public final boolean component2() {
            return this.visitedOnce;
        }

        @NotNull
        public final ProfileSpecificMuseumData copy(@NotNull Set<String> donatedItems, boolean visitedOnce) {
            Intrinsics.checkNotNullParameter(donatedItems, (String)"donatedItems");
            return new ProfileSpecificMuseumData(donatedItems, visitedOnce);
        }

        public static /* synthetic */ ProfileSpecificMuseumData copy$default(ProfileSpecificMuseumData profileSpecificMuseumData, Set set, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                set = profileSpecificMuseumData.donatedItems;
            }
            if ((n & 2) != 0) {
                bl = profileSpecificMuseumData.visitedOnce;
            }
            return profileSpecificMuseumData.copy(set, bl);
        }

        @NotNull
        public String toString() {
            return "ProfileSpecificMuseumData(donatedItems=" + this.donatedItems + ", visitedOnce=" + this.visitedOnce + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.donatedItems).hashCode();
            int n = this.visitedOnce ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProfileSpecificMuseumData)) {
                return false;
            }
            ProfileSpecificMuseumData profileSpecificMuseumData = (ProfileSpecificMuseumData)other;
            if (!Intrinsics.areEqual(this.donatedItems, profileSpecificMuseumData.donatedItems)) {
                return false;
            }
            return this.visitedOnce == profileSpecificMuseumData.visitedOnce;
        }
    }
}

