/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.itemeditor.NEUItemEditor;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;

public class RepoExporters {
    private static final RepoExporters INSTANCE = new RepoExporters();

    public static RepoExporters getInstance() {
        return INSTANCE;
    }

    public void essenceExporter() {
        try {
            GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
            IInventory lower2 = cc.func_85151_d();
            File file = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "config/notenoughupdates/repo/constants/essencecosts.json");
            String fileContent = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)).lines().collect(Collectors.joining(System.lineSeparator()));
            String id = null;
            JsonObject jsonObject = new JsonParser().parse(fileContent).getAsJsonObject();
            JsonObject newEntry = new JsonObject();
            for (int i = 0; i < 54; ++i) {
                int stars;
                ItemStack stack = lower2.func_70301_a(i);
                if (stack.func_82833_r().isEmpty() || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv) || stack.func_77973_b() == Items.field_151032_g || !stack.func_77978_p().func_74775_l("display").func_150297_b("Lore", 9) || (stars = Utils.getNumberOfStars(stack)) == 0) continue;
                NBTTagList lore = stack.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
                int costIndex = 10000;
                id = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
                if (jsonObject.has(id)) {
                    jsonObject.remove(id);
                }
                for (int j = 0; j < lore.func_74745_c(); ++j) {
                    String amountString;
                    String item;
                    String entry = lore.func_150307_f(j);
                    if (entry.equals("\u00a77Cost")) {
                        costIndex = j;
                    }
                    if (j <= costIndex) continue;
                    int index = (entry = entry.trim()).lastIndexOf(120);
                    if (index < 0) {
                        item = entry.trim() + " x1";
                        amountString = "x1";
                    } else {
                        amountString = entry.substring(index);
                        item = entry.substring(0, index).trim();
                    }
                    item = item.substring(0, item.length() - 3);
                    int amount = Integer.parseInt(amountString.trim().replace("x", "").replace(",", ""));
                    if (item.endsWith("Essence")) {
                        int index2 = entry.indexOf("Essence");
                        String typeAndAmount = item.substring(0, index2).trim().substring(2);
                        int whitespaceIndex = typeAndAmount.indexOf(32);
                        int essenceAmount = Integer.parseInt(typeAndAmount.substring(0, whitespaceIndex).replace(",", ""));
                        newEntry.add("type", new JsonPrimitive(typeAndAmount.substring(whitespaceIndex + 1)));
                        if (stars == -1) {
                            newEntry.add("dungeonize", new JsonPrimitive(essenceAmount));
                            continue;
                        }
                        newEntry.add(String.valueOf(stars), new JsonPrimitive(essenceAmount));
                        continue;
                    }
                    if (item.endsWith("Coins")) {
                        int index2 = entry.indexOf("Coins");
                        String coinsAmount = item.substring(0, index2).trim().substring(2);
                        if (!newEntry.has("items")) {
                            newEntry.add("items", new JsonObject());
                        }
                        if (!newEntry.get("items").getAsJsonObject().has(String.valueOf(stars))) {
                            newEntry.get("items").getAsJsonObject().add(String.valueOf(stars), new JsonArray());
                        }
                        newEntry.get("items").getAsJsonObject().get(String.valueOf(stars)).getAsJsonArray().add(new JsonPrimitive("SKYBLOCK_COIN:" + coinsAmount.replace(",", "")));
                        continue;
                    }
                    String itemString = "_";
                    for (Map.Entry<String, JsonObject> itemEntry : NotEnoughUpdates.INSTANCE.manager.getItemInformation().entrySet()) {
                        String name;
                        if (!itemEntry.getValue().has("displayname") || !(name = itemEntry.getValue().get("displayname").getAsString()).equals(item)) continue;
                        itemString = itemEntry.getKey() + ":" + amount;
                    }
                    if (!newEntry.has("items")) {
                        newEntry.add("items", new JsonObject());
                    }
                    if (!newEntry.get("items").getAsJsonObject().has(String.valueOf(stars))) {
                        newEntry.get("items").getAsJsonObject().add(String.valueOf(stars), new JsonArray());
                    }
                    newEntry.get("items").getAsJsonObject().get(String.valueOf(stars)).getAsJsonArray().add(new JsonPrimitive(itemString));
                }
                jsonObject.add(id, newEntry);
            }
            if (jsonObject.get(id).getAsJsonObject().has("items")) {
                JsonObject itemsObj = jsonObject.get(id).getAsJsonObject().get("items").getAsJsonObject();
                jsonObject.get(id).getAsJsonObject().remove("items");
                jsonObject.get(id).getAsJsonObject().add("items", itemsObj);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                writer.write(gson.toJson(jsonObject));
                Utils.addChatMessage(EnumChatFormatting.AQUA + "Parsed and saved: " + EnumChatFormatting.WHITE + id);
            }
            catch (IOException ignored) {
                Utils.addChatMessage(EnumChatFormatting.RED + "Error while writing file.");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Utils.addChatMessage(EnumChatFormatting.RED + "Error while parsing inventory. Try again or check logs for details.");
        }
    }

    public void draconicAlterExporter() {
        try {
            for (int i = 0; i < 54; ++i) {
                File file = null;
                String fileContent = null;
                JsonObject newEntry = new JsonObject();
                JsonObject jsonObject = null;
                String id = null;
                GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
                ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
                IInventory lower2 = cc.func_85151_d();
                ItemStack stack = lower2.func_70301_a(i);
                if (stack == null) continue;
                if (!stack.func_82833_r().isEmpty() && stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_180401_cv) && stack.func_77973_b() != Items.field_151032_g && stack.func_77978_p().func_74775_l("display").func_150297_b("Lore", 9)) {
                    NBTTagList lore = stack.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
                    int costIndex = 10000;
                    id = StringUtils.func_76338_a((String)stack.func_82833_r().replace(" ", "_").toUpperCase(Locale.US));
                    if (!NotEnoughUpdates.INSTANCE.manager.isValidInternalName(id = ItemUtils.fixDraconicId(id))) continue;
                    file = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "config/notenoughupdates/repo/items/" + id + ".json");
                    fileContent = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)).lines().collect(Collectors.joining(System.lineSeparator()));
                    jsonObject = new JsonParser().parse(fileContent).getAsJsonObject();
                    int essence = -1;
                    boolean funny = true;
                    for (int j = 0; j < lore.func_74745_c(); ++j) {
                        String entry = lore.func_150307_f(j);
                        if (entry.equals("\u00a78\u00a7m-----------------")) {
                            costIndex = j;
                        }
                        if (j <= costIndex) continue;
                        if (j == costIndex + 1) {
                            if (entry.startsWith("\u00a77Dragon Essence: \u00a7d")) {
                                essence = Integer.parseInt(entry.substring("\u00a77Dragon Essence: \u00a7d".length()));
                                continue;
                            }
                            funny = false;
                            continue;
                        }
                        if (j == costIndex + 2 && funny) continue;
                        entry = entry.trim();
                        if (!newEntry.has("dragon_items")) {
                            newEntry.add("dragon_items", new JsonArray());
                        }
                        newEntry.get("dragon_items").getAsJsonArray().add(new JsonPrimitive(entry.trim()));
                    }
                    if (essence != -1) {
                        jsonObject.add("dragon_essence", new JsonPrimitive(essence));
                    }
                    jsonObject.add("dragon_items", newEntry.get("dragon_items"));
                }
                if (jsonObject == null) continue;
                if (jsonObject.has("dragon_items")) {
                    JsonArray itemsObj = jsonObject.get("dragon_items").getAsJsonArray();
                    jsonObject.remove("dragon_items");
                    jsonObject.add("dragon_items", itemsObj);
                }
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    writer.write(gson.toJson(jsonObject));
                    Utils.addChatMessage(EnumChatFormatting.AQUA + "Parsed and saved: " + EnumChatFormatting.WHITE + id);
                    continue;
                }
                catch (IOException ignored) {
                    Utils.addChatMessage(EnumChatFormatting.RED + "Error while writing file.");
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Error while parsing inventory. Try again or check logs for details."));
        }
    }

    public void essenceExporter2() {
        GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
        IInventory lower2 = cc.func_85151_d();
        for (int i = 9; i < 45; ++i) {
            ItemStack stack = lower2.func_70301_a(i);
            if (stack == null || stack.func_82833_r().isEmpty() || stack.func_82833_r().equals(" ")) continue;
            String internalName = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack);
            if (internalName == null) {
                Utils.addChatMessage(EnumChatFormatting.RED + "ERROR: Could not get internal name for: " + EnumChatFormatting.AQUA + stack.func_82833_r());
                continue;
            }
            JsonObject itemObject = NotEnoughUpdates.INSTANCE.manager.getJsonForItem(stack);
            JsonArray lore = itemObject.get("lore").getAsJsonArray();
            ArrayList<String> loreList = new ArrayList<String>();
            for (int j = 0; j < lore.size(); ++j) {
                loreList.add(lore.get(j).getAsString());
            }
            if (((String)loreList.get(loreList.size() - 1)).equals("\u00a77\u00a7eClick to view upgrades!")) {
                loreList.remove(loreList.size() - 1);
                loreList.remove(loreList.size() - 1);
            }
            JsonArray newLore = new JsonArray();
            for (String s : loreList) {
                newLore.add(new JsonPrimitive(s));
            }
            itemObject.remove("lore");
            itemObject.add("lore", newLore);
            if (NEUItemEditor.saveOnly(internalName, itemObject)) continue;
            Utils.addChatMessage(EnumChatFormatting.RED + "ERROR: Failed to save item: " + EnumChatFormatting.AQUA + stack.func_82833_r());
        }
        Utils.addChatMessage(EnumChatFormatting.AQUA + "Parsed page: " + lower2.func_145748_c_().func_150260_c());
    }
}

