/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.customblockzones;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class CustomBlockSounds {
    static Gson gson = new Gson();
    static List<CustomSoundEvent> allCustomSoundEvents = new ArrayList<CustomSoundEvent>();
    public static final CustomSoundEvent mithrilBreak = CustomBlockSounds.newCustomSoundEvent("mithril");
    public static final CustomSoundEvent gemstoneBreakRuby = CustomBlockSounds.newCustomSoundEvent("gemstoneRuby");
    public static final CustomSoundEvent gemstoneBreakAmber = CustomBlockSounds.newCustomSoundEvent("gemstoneAmber");
    public static final CustomSoundEvent gemstoneBreakAmethyst = CustomBlockSounds.newCustomSoundEvent("gemstoneAmethyst");
    public static final CustomSoundEvent gemstoneBreakSapphire = CustomBlockSounds.newCustomSoundEvent("gemstoneSapphire");
    public static final CustomSoundEvent gemstoneBreakJade = CustomBlockSounds.newCustomSoundEvent("gemstoneJade");
    public static final CustomSoundEvent gemstoneBreakTopaz = CustomBlockSounds.newCustomSoundEvent("gemstoneTopaz");
    public static final CustomSoundEvent gemstoneBreakJasper = CustomBlockSounds.newCustomSoundEvent("gemstoneJasper");
    public static final CustomSoundEvent titaniumBreak = CustomBlockSounds.newCustomSoundEvent("titanium");

    private static CustomSoundEvent newCustomSoundEvent(String soundEvent) {
        CustomSoundEvent event = new CustomSoundEvent();
        event.soundEvent = new ResourceLocation("notenoughupdates", soundEvent + ".break");
        event.configFile = new ResourceLocation("notenoughupdates", "sounds/" + soundEvent.toLowerCase(Locale.ROOT) + "break.json");
        return event;
    }

    public static class CustomSoundEvent {
        public ResourceLocation soundEvent;
        public ResourceLocation configFile;
        private boolean loaded = false;
        private int timer = 0;
        private long lastReplaced = 0L;

        public CustomSoundEvent() {
            allCustomSoundEvents.add(this);
        }

        public boolean shouldReplace() {
            if (!this.loaded) {
                this.reload();
            }
            if (this.timer < 0) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastReplaced >= (long)this.timer) {
                this.lastReplaced = now;
                return true;
            }
            return false;
        }

        public ISound replaceSoundEvent(ISound sound) {
            return new PositionedSoundRecord(this.soundEvent, sound.func_147655_f(), sound.func_147653_e(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        }

        public void reload() {
            IResource resource;
            this.loaded = true;
            try {
                resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.configFile);
            }
            catch (IOException e2) {
                this.timer = -1;
                return;
            }
            try (InputStreamReader r = new InputStreamReader(resource.func_110527_b(), StandardCharsets.UTF_8);){
                JsonObject jsonObject = gson.fromJson((Reader)r, JsonObject.class);
                this.timer = jsonObject.getAsJsonPrimitive("debouncer").getAsInt() * 1000 / 20;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public static class ReloaderListener
    implements IResourceManagerReloadListener {
        public void func_110549_a(IResourceManager iResourceManager) {
            allCustomSoundEvents.forEach(CustomSoundEvent::reload);
        }
    }
}

