/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.GlaciteTunnelWaypoints;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.options.separatesections.Mining;
import io.github.moulberry.notenoughupdates.overlays.MiningOverlay;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public class DwarvenMinesWaypoints {
    private final HashMap<String, Vector3f> waypointsMap = new HashMap<String, Vector3f>(){
        {
            this.put("Dwarven Village", new Vector3f(-37.0f, 199.0f, -122.0f));
            this.put("Miner's Guild", new Vector3f(-74.0f, 220.0f, -122.0f));
            this.put("Fetchur", new Vector3f(85.0f, 223.0f, -120.0f));
            this.put("Palace Bridge", new Vector3f(129.0f, 186.0f, 8.0f));
            this.put("Royal Palace", new Vector3f(129.0f, 194.0f, 194.0f));
            this.put("Puzzler", new Vector3f(181.0f, 195.0f, 135.0f));
            this.put("Grand Library", new Vector3f(183.0f, 195.0f, 181.0f));
            this.put("Barracks of Heroes", new Vector3f(93.0f, 195.0f, 181.0f));
            this.put("Royal Mines", new Vector3f(178.0f, 149.0f, 71.0f));
            this.put("Cliffside Veins", new Vector3f(40.0f, 136.0f, 17.0f));
            this.put("Forge Basin", new Vector3f(0.0f, 169.0f, -2.0f));
            this.put("The Forge", new Vector3f(0.0f, 148.0f, -69.0f));
            this.put("Rampart's Quarry", new Vector3f(-106.0f, 147.0f, 2.0f));
            this.put("Far Reserve", new Vector3f(-160.0f, 148.0f, 17.0f));
            this.put("Upper Mines", new Vector3f(-123.0f, 170.0f, -71.0f));
            this.put("Goblin Burrows", new Vector3f(-138.0f, 143.0f, 141.0f));
            this.put("Great Ice Wall", new Vector3f(0.0f, 127.0f, 160.0f));
            this.put("Aristocrat Passage", new Vector3f(129.0f, 150.0f, 137.0f));
            this.put("Hanging Court", new Vector3f(91.0f, 186.0f, 129.0f));
            this.put("Divan's Gateway", new Vector3f(0.0f, 127.0f, 87.0f));
            this.put("Lava Springs", new Vector3f(57.0f, 196.0f, -15.0f));
            this.put("The Mist", new Vector3f(0.0f, 75.0f, 82.0f));
        }
    };
    private static final HashSet<String> emissaryNames = new HashSet<String>(){
        {
            this.add(EnumChatFormatting.GOLD + "Emissary Ceanna" + EnumChatFormatting.RESET);
            this.add(EnumChatFormatting.GOLD + "Emissary Carlton" + EnumChatFormatting.RESET);
            this.add(EnumChatFormatting.GOLD + "Emissary Wilson" + EnumChatFormatting.RESET);
            this.add(EnumChatFormatting.GOLD + "Emissary Lilith" + EnumChatFormatting.RESET);
            this.add(EnumChatFormatting.GOLD + "Emissary Frasier" + EnumChatFormatting.RESET);
            this.add(EnumChatFormatting.GOLD + "Emissary Eliza" + EnumChatFormatting.RESET);
            this.add(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + "King" + EnumChatFormatting.RESET);
        }
    };
    private long dynamicMillis = 0L;
    private String dynamicLocation = null;
    private String dynamicName = null;
    private final Pattern ghastRegex = Pattern.compile("\u00a7r\u00a7eFind the \u00a7r\u00a76Powder Ghast\u00a7r\u00a7e near the \u00a7r\u00a7b(.+)!");
    private final Pattern fallenStarRegex = Pattern.compile("\u00a7r\u00a75Fallen Star \u00a7r\u00a7ehas crashed at \u00a7r\u00a7b(.+)\u00a7r\u00a7e!");
    Mining config;
    private boolean commissionFinished;
    private double emissaryRemovedDistSq;

    public DwarvenMinesWaypoints() {
        this.config = NotEnoughUpdates.INSTANCE.config.mining;
        this.commissionFinished = false;
        this.emissaryRemovedDistSq = 0.0;
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        Matcher matcherGhast = this.ghastRegex.matcher(event.message.func_150254_d());
        if (matcherGhast.find() && this.config.powderGhastWaypoint) {
            this.dynamicLocation = Utils.cleanColour(matcherGhast.group(1).trim());
            this.dynamicName = EnumChatFormatting.GOLD + "Powder Ghast";
            this.dynamicMillis = System.currentTimeMillis();
        } else {
            Matcher matcherStar = this.fallenStarRegex.matcher(event.message.func_150254_d());
            if (matcherStar.find() && this.config.fallenStarWaypoint) {
                this.dynamicLocation = Utils.cleanColour(matcherStar.group(1).trim());
                this.dynamicName = EnumChatFormatting.DARK_PURPLE + "Fallen Star";
                this.dynamicMillis = System.currentTimeMillis();
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        this.emissaryRemovedDistSq = -1.0;
        if (SBInfo.getInstance().getLocation() == null) {
            return;
        }
        if (!SBInfo.getInstance().getLocation().equals("mining_3")) {
            return;
        }
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            if (lower2.func_145748_c_().func_150254_d().contains("Commissions")) {
                for (int i = 0; i < lower2.func_70302_i_(); ++i) {
                    String[] lore;
                    ItemStack stack = lower2.func_70301_a(i);
                    if (stack == null || !stack.func_82833_r().equals(EnumChatFormatting.YELLOW + "Commission Milestones")) continue;
                    hidden.commissionMilestone = 5;
                    block15: for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p())) {
                        String clean;
                        switch (clean = Utils.cleanColour(line)) {
                            case "Tier I Rewards:": {
                                hidden.commissionMilestone = 0;
                                continue block15;
                            }
                            case "Tier II Rewards:": {
                                hidden.commissionMilestone = 1;
                                continue block15;
                            }
                            case "Tier III Rewards:": {
                                hidden.commissionMilestone = 2;
                                continue block15;
                            }
                            case "Tier IV Rewards:": {
                                hidden.commissionMilestone = 3;
                                continue block15;
                            }
                            case "Tier V Rewards:": {
                                hidden.commissionMilestone = 4;
                            }
                        }
                    }
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderSpecial(RenderLivingEvent.Specials.Pre<EntityArmorStand> event) {
        if (SBInfo.getInstance().getLocation() == null) {
            return;
        }
        if (!SBInfo.getInstance().getLocation().equals("mining_3")) {
            return;
        }
        if (this.commissionFinished && event.entity instanceof EntityArmorStand) {
            String name = event.entity.func_145748_c_().func_150254_d();
            if (this.emissaryRemovedDistSq > 0.0 && name.equals(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "CLICK" + EnumChatFormatting.RESET)) {
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                double distSq = event.entity.func_70092_e(p.field_70165_t, p.field_70163_u, p.field_70161_v);
                if (Math.abs(distSq - this.emissaryRemovedDistSq) < 1.0) {
                    event.setCanceled(true);
                }
            } else if (emissaryNames.contains(name)) {
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                double distSq = event.entity.func_70092_e(p.field_70165_t, p.field_70163_u, p.field_70161_v);
                if (distSq >= 144.0) {
                    this.emissaryRemovedDistSq = distSq;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (SBInfo.getInstance().getLocation() == null) {
            return;
        }
        if (!SBInfo.getInstance().getLocation().equals("mining_3")) {
            return;
        }
        int locWaypoint = this.config.locWaypoints;
        if (this.dynamicLocation != null && this.dynamicName != null && System.currentTimeMillis() - this.dynamicMillis < 30000L) {
            for (Map.Entry<String, Vector3f> entry : this.waypointsMap.entrySet()) {
                if (!((String)entry.getKey()).equals(this.dynamicLocation)) continue;
                RenderUtils.renderWayPoint(this.dynamicName, new Vector3f((ReadableVector3f)entry.getValue()).translate(0.0f, 15.0f, 0.0f), event.partialTicks);
                break;
            }
        }
        String skyblockLocation = SBInfo.getInstance().location.toLowerCase(Locale.ROOT);
        if (locWaypoint >= 1) {
            for (Map.Entry<String, Vector3f> entry : this.waypointsMap.entrySet()) {
                if (locWaypoint >= 2) {
                    RenderUtils.renderWayPoint(EnumChatFormatting.AQUA + entry.getKey(), entry.getValue(), event.partialTicks);
                    continue;
                }
                String commissionLocation = entry.getKey().toLowerCase(Locale.ROOT);
                for (String commissionName : MiningOverlay.commissionProgress.keySet()) {
                    if (this.config.hideWaypointIfAtLocation && commissionLocation.replace("'", "").equals(skyblockLocation) || !commissionName.toLowerCase(Locale.ROOT).contains(commissionLocation)) continue;
                    if (commissionName.contains("Titanium")) {
                        RenderUtils.renderWayPoint(EnumChatFormatting.WHITE + entry.getKey(), entry.getValue(), event.partialTicks);
                        continue;
                    }
                    RenderUtils.renderWayPoint(EnumChatFormatting.AQUA + entry.getKey(), entry.getValue(), event.partialTicks);
                }
            }
        }
        this.commissionFinished = this.config.emissaryWaypoints >= 2;
        String sideBarLocation = SBInfo.getInstance().getScoreboardLocation();
        if (this.config.emissaryWaypoints == 0) {
            return;
        }
        if (GlaciteTunnelWaypoints.INSTANCE.getGlaciteTunnelLocations().contains(sideBarLocation) && this.config.hideEmissaryWaypointInTunnels) {
            return;
        }
        if (!this.commissionFinished) {
            Emissary[] emissaryArray = MiningOverlay.commissionProgress.values().iterator();
            while (emissaryArray.hasNext()) {
                float f = ((Float)emissaryArray.next()).floatValue();
                if (!(f >= 1.0f)) continue;
                this.commissionFinished = true;
                break;
            }
        }
        if (this.commissionFinished) {
            for (Emissary emissary : Emissary.values()) {
                NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
                if (hidden == null || hidden.commissionMilestone < emissary.minMilestone) continue;
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                double dX = (double)(emissary.loc.x + 0.5f) - p.field_70165_t;
                double dY = (double)(emissary.loc.y + 0.188f) - p.field_70163_u;
                double dZ = (double)(emissary.loc.z + 0.5f) - p.field_70161_v;
                double distSq = dX * dX + dY * dY + dZ * dZ;
                if (!(distSq >= 144.0)) continue;
                RenderUtils.renderWayPoint(EnumChatFormatting.GOLD + emissary.name, new Vector3f((ReadableVector3f)emissary.loc).translate(0.5f, 2.488f, 0.5f), event.partialTicks);
            }
        }
    }

    private static enum Emissary {
        KING("King", 0, new Vector3f(129.0f, 196.0f, 196.0f)),
        CEANNA("Emissary Ceanna", 1, new Vector3f(42.0f, 134.0f, 22.0f)),
        CARLTON("Emissary Carlton", 1, new Vector3f(-73.0f, 153.0f, -11.0f)),
        WILSON("Emissary Wilson", 2, new Vector3f(171.0f, 150.0f, 31.0f)),
        LILITH("Emissary Lilith", 2, new Vector3f(58.0f, 198.0f, -8.0f)),
        FRAISER("Emissary Frasier", 3, new Vector3f(-132.0f, 174.0f, -50.0f)),
        ELIZA("Emissary Eliza", 3, new Vector3f(-37.0f, 200.0f, -131.0f));

        String name;
        int minMilestone;
        Vector3f loc;

        private Emissary(String name, int minMilestone, Vector3f loc) {
            this.name = name;
            this.minMilestone = minMilestone;
            this.loc = loc;
        }
    }
}

