/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.ButtonExclusionZoneEvent;
import io.github.moulberry.notenoughupdates.events.DrawSlotReturnEvent;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class DungeonNpcProfitOverlay {
    private static final ResourceLocation dungeonProfitResource = new ResourceLocation("notenoughupdates:dungeon_chest_worth.png");
    private static final Pattern chestNamePattern = Pattern.compile(".+ Catacombs - Flo.*");
    private static final Pattern essencePattern = Pattern.compile("^\u00a7.(?<essenceType>\\w+) Essence \u00a7.x(?<essenceAmount>\\d+)$");
    private static final Pattern enchantedBookPattern = Pattern.compile("^\u00a7.Enchanted Book \\((?<enchantName>.*)\u00a7.\\)");
    private static final Map<Integer, DungeonChest> chestProfits = new HashMap<Integer, DungeonChest>();
    private static List<DungeonChest> orderedChestProfits = new ArrayList<DungeonChest>();

    public boolean isRendering() {
        return NotEnoughUpdates.INSTANCE.config.dungeons.croesusProfitOverlay && !chestProfits.isEmpty();
    }

    private boolean isChestOverview(IInventory inventory) {
        return chestNamePattern.matcher(StringUtils.cleanColour(inventory.func_145748_c_().func_150260_c())).matches();
    }

    private boolean isChestOverview(GuiChest chest) {
        ContainerChest inventorySlots = (ContainerChest)chest.field_147002_h;
        return this.isChestOverview(inventorySlots.func_85151_d());
    }

    @SubscribeEvent
    public void onDrawSlot(DrawSlotReturnEvent event) {
        if (!(NotEnoughUpdates.INSTANCE.config.dungeons.croesusProfitOverlay && NotEnoughUpdates.INSTANCE.config.dungeons.croesusHighlightHighestProfit && this.isChestOverview(event.getSlot().field_75224_c))) {
            return;
        }
        Slot slot = event.getSlot();
        DungeonChest chestProfit = this.getPotentialChest(slot);
        if (chestProfit == null || !chestProfit.shouldHighlight || slot.field_75222_d != chestProfit.slot) {
            return;
        }
        Gui.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)Color.GREEN.getRGB());
    }

    @SubscribeEvent
    public void onButtonExclusionZones(ButtonExclusionZoneEvent event) {
        if (this.isRendering()) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight(), event.getGuiBaseRect().getTop(), 184, 101), ButtonExclusionZoneEvent.PushDirection.TOWARDS_RIGHT);
        }
    }

    @SubscribeEvent
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.dungeons.croesusProfitOverlay || !(event.gui instanceof GuiChest)) {
            chestProfits.clear();
            return;
        }
        GuiChest guiChest = (GuiChest)event.gui;
        if (!this.isChestOverview(guiChest)) {
            chestProfits.clear();
            return;
        }
        ItemStack stack = ((Slot)guiChest.field_147002_h.field_75151_b.get(11)).func_75211_c();
        if (stack != null && stack.func_77973_b() == Items.field_151098_aY) {
            chestProfits.clear();
            return;
        }
        this.render(guiChest);
    }

    @Nullable
    private DungeonChest getPotentialChest(@Nullable Slot slot) {
        if (slot == null) {
            return null;
        }
        DungeonChest chestProfit = chestProfits.get(slot.field_75222_d);
        if (chestProfit == null) {
            long s = System.currentTimeMillis();
            this.updatePotentialChest(slot.func_75211_c(), slot);
            long d = System.currentTimeMillis() - s;
            if (d > 10L) {
                System.out.println("Finished analyzing slow croesus slot. Took " + d + " ms");
                ItemUtils.getLore(slot.func_75211_c()).forEach(System.out::println);
            }
        }
        return chestProfits.get(slot.field_75222_d);
    }

    private void updatePotentialChest(ItemStack stack, Slot slot) {
        if (stack == null || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
            return;
        }
        DungeonChest dungeonChest = new DungeonChest();
        dungeonChest.slot = slot.field_75222_d;
        List<String> lore = ItemUtils.getLore(stack);
        if (lore.size() == 0 || !"\u00a77Contents".equals(lore.get(0))) {
            return;
        }
        dungeonChest.name = stack.func_82833_r();
        ArrayList<SkyblockItem> items2 = new ArrayList<SkyblockItem>();
        boolean isInCost = false;
        int counter = -1;
        for (String s : lore) {
            ++counter;
            if ("\u00a77Contents".equals(s) || "".equals(s) || "\u00a7cCan't open another chest!".equals(s) || "\u00a7aAlready opened!".equals(s) || "\u00a7eClick to open!".equals(s)) continue;
            if ("\u00a77Cost".equals(s)) {
                isInCost = true;
                continue;
            }
            if (isInCost) {
                JsonObject dungeonChestKey;
                if (s.endsWith(" Coins")) {
                    String coinString = StringUtils.cleanColour(s);
                    int whitespace = coinString.indexOf(32);
                    if (whitespace != -1) {
                        String amountString = coinString.substring(0, whitespace).replace(",", "");
                        dungeonChest.costToOpen = Integer.parseInt(amountString);
                    }
                } else if (s.equals("\u00a7aFREE")) {
                    dungeonChest.costToOpen = 0;
                }
                if (!NotEnoughUpdates.INSTANCE.config.dungeons.useChestKeyCost || lore.size() <= counter) break;
                String nextLore = lore.get(counter + 1);
                if (!s.contains("Dungeon Chest Key") && !nextLore.contains("Dungeon Chest Key") || (dungeonChestKey = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo("DUNGEON_CHEST_KEY")) == null || !dungeonChestKey.has("curr_buy")) break;
                float bazaarPrice = dungeonChestKey.get("curr_buy").getAsFloat();
                DungeonChest dungeonChest2 = dungeonChest;
                dungeonChest2.costToOpen = (int)((float)dungeonChest2.costToOpen + bazaarPrice);
                break;
            }
            SkyblockItem skyblockItem = SkyblockItem.createFromLoreEntry(s);
            if (skyblockItem != null) {
                items2.add(skyblockItem);
                continue;
            }
            System.out.println("Unexpected line " + s + " while analyzing croesus lore");
        }
        dungeonChest.items = items2;
        if (dungeonChest.costToOpen != -1) {
            dungeonChest.calculateProfitAndBuildLore();
            chestProfits.put(slot.field_75222_d, dungeonChest);
        }
        orderedChestProfits = chestProfits.values().stream().sorted(NotEnoughUpdates.INSTANCE.config.dungeons.croesusSortByProfit ? Comparator.comparing(DungeonChest::getProfit).reversed() : Comparator.comparing(DungeonChest::getSlot)).collect(Collectors.toList());
        chestProfits.values().forEach(it -> ((DungeonChest)it).shouldHighlight = false);
        chestProfits.values().stream().max(Comparator.comparing(DungeonChest::getProfit)).ifPresent(it -> ((DungeonChest)it).shouldHighlight = true);
    }

    public void render(GuiChest guiChest) {
        int xSize = ((AccessorGuiContainer)guiChest).getXSize();
        int guiLeft = ((AccessorGuiContainer)guiChest).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)guiChest).getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(dungeonProfitResource);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Utils.drawTexturedRect(guiLeft + xSize + 4, guiTop, 180.0f, 101.0f, 0.0f, 0.703125f, 0.0f, 0.39453125f, 9728);
        for (int i = 0; i < orderedChestProfits.size(); ++i) {
            DungeonChest chestProfit = orderedChestProfits.get(i);
            int x = guiLeft + xSize + 14;
            int y = guiTop + 6 + i * 10;
            Utils.renderAlignedString(chestProfit.name, chestProfit.profit > 0.0 ? EnumChatFormatting.GREEN + Utils.shortNumberFormat(chestProfit.profit, 0) : EnumChatFormatting.RED + "-" + Utils.shortNumberFormat(-chestProfit.profit, 0), x, y, 160);
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Utils.getMouseX();
            int mouseY = Utils.getMouseY();
            if (!Utils.isWithinRect(mouseX, mouseY, x, y, 160, 10)) continue;
            Utils.drawHoveringText(chestProfit.lore, mouseX, mouseY, width, height, -1);
        }
    }

    private static class SkyblockItem {
        private final String internalName;
        private final int amount;

        private SkyblockItem(String internalName, int amount) {
            this.internalName = internalName;
            this.amount = amount;
        }

        @Nullable
        public static SkyblockItem createFromLoreEntry(String line) {
            Matcher essenceMatcher = essencePattern.matcher(line);
            Matcher enchantedBookMatcher = enchantedBookPattern.matcher(line);
            if (enchantedBookMatcher.matches()) {
                String enchantName = ItemResolutionQuery.resolveEnchantmentByName(enchantedBookMatcher.group("enchantName"));
                if (enchantName == null) {
                    return null;
                }
                return new SkyblockItem(enchantName, 1);
            }
            if (essenceMatcher.matches() && NotEnoughUpdates.INSTANCE.config.dungeons.useEssenceCostFromBazaar) {
                String essenceType = essenceMatcher.group("essenceType");
                String essenceAmount = essenceMatcher.group("essenceAmount");
                if (essenceType == null || essenceAmount == null) {
                    return null;
                }
                String internalName = "ESSENCE_" + essenceType.toUpperCase(Locale.ROOT);
                if (!NotEnoughUpdates.INSTANCE.manager.isValidInternalName(internalName)) {
                    return null;
                }
                int amount = Integer.parseInt(essenceAmount);
                return new SkyblockItem(internalName, amount);
            }
            String trimmedLine = line.trim();
            String id = ItemResolutionQuery.filterInternalNameCandidates(ItemResolutionQuery.findInternalNameCandidatesForDisplayName(trimmedLine.replace("Book", "")), trimmedLine, true);
            if (id == null) {
                return null;
            }
            if (id.equals("DUNGEON_CHEST_KEY")) {
                return null;
            }
            return new SkyblockItem(id, 1);
        }

        public double calculateCost() {
            double price = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarOrBin(this.internalName, true);
            if (price != -1.0) {
                return price * (double)this.amount;
            }
            return 0.0;
        }

        public String getDisplayName() {
            JsonObject entry = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(this.internalName).resolveToItemListJson();
            if (entry != null) {
                String displayName = entry.get("displayname").getAsString();
                String cleanedDisplayName = StringUtils.cleanColour(displayName);
                if ("Enchanted Book".equals(cleanedDisplayName)) {
                    return entry.get("lore").getAsJsonArray().get(0).getAsString();
                }
                return entry.get("displayname").getAsString();
            }
            return "ERROR";
        }
    }

    private static class DungeonChest {
        private List<SkyblockItem> items = new ArrayList<SkyblockItem>();
        private List<String> lore;
        private int costToOpen = -1;
        private String name;
        private int slot;
        private boolean shouldHighlight;
        private double profit;

        private DungeonChest() {
        }

        public double getProfit() {
            return this.profit;
        }

        public void calculateProfitAndBuildLore() {
            this.profit = 0.0;
            this.lore = new ArrayList<String>();
            this.lore.add(this.name);
            for (SkyblockItem item : this.items) {
                double cost = item.calculateCost();
                this.profit += cost;
                this.lore.add(EnumChatFormatting.AQUA + " - " + item.getDisplayName() + EnumChatFormatting.RESET + " " + EnumChatFormatting.GREEN + Utils.shortNumberFormat(cost, 0));
            }
            this.lore.add("");
            this.profit -= (double)this.costToOpen;
            this.lore.add(EnumChatFormatting.AQUA + "Cost to open: " + EnumChatFormatting.RED + Utils.shortNumberFormat(this.costToOpen, 0));
            this.lore.add(EnumChatFormatting.AQUA + "Total profit: " + (this.profit > 0.0 ? EnumChatFormatting.GREEN + Utils.shortNumberFormat(this.profit, 0) : EnumChatFormatting.RED + "-" + Utils.shortNumberFormat(-this.profit, 0)));
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

