/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J4\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/CountdownCalculator;", "", "()V", "regex", "Lkotlin/text/Regex;", "onTooltip", "", "event", "Lnet/minecraftforge/event/entity/player/ItemTooltipEvent;", "addTime", "Ljava/time/ZonedDateTime;", "years", "", "days", "hours", "minutes", "seconds", "CountdownTypes", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nCountdownCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountdownCalculator.kt\nio/github/moulberry/notenoughupdates/miscfeatures/CountdownCalculator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,135:1\n1#2:136\n1415#3,14:137\n*S KotlinDebug\n*F\n+ 1 CountdownCalculator.kt\nio/github/moulberry/notenoughupdates/miscfeatures/CountdownCalculator\n*L\n90#1:137,14\n*E\n"})
public final class CountdownCalculator {
    @NotNull
    private final Regex regex = new Regex("(?:(?<years>\\d+)y )?(?:(?<days>\\d+)d)? ?(?:(?<hours>\\d+)h)? ?(?:(?<minutes>\\d+)m)? ?(?:(?<seconds>\\d+)s)?\\b");

    @SubscribeEvent
    public final void onTooltip(@NotNull ItemTooltipEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (NotEnoughUpdates.INSTANCE.config.misc.showWhenCountdownEnds) {
            case 1: {
                string = "EEEE, MMM d h:mm a";
                break;
            }
            case 2: {
                string = "EEEE, MMM d HH:mm";
                break;
            }
            default: {
                return;
            }
        }
        String formatterAsString = string;
        if (event.itemStack != null) {
            EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
            if ((entityPlayerSP != null ? entityPlayerSP.field_71070_bA : null) != null) {
                int i = -1;
                ZonedDateTime lastTimer = null;
                while (++i < event.toolTip.size()) {
                    DateTimeFormatter useFormatter;
                    ZonedDateTime countdownTarget;
                    ZonedDateTime zonedDateTime;
                    Object object;
                    long seconds;
                    Object object2;
                    long minutes;
                    Object object3;
                    long hours;
                    Object object4;
                    long days;
                    MatchResult match2;
                    Object object5;
                    long years;
                    long totalSeconds;
                    Object v3;
                    CountdownTypes countdownTypes;
                    CountdownTypes it;
                    String tooltipLine;
                    block20: {
                        tooltipLine = (String)event.toolTip.get(i);
                        CountdownTypes[] countdownTypesArray = CountdownTypes.values();
                        int n = countdownTypesArray.length;
                        for (int j = 0; j < n; ++j) {
                            CountdownTypes countdownTypes2;
                            it = countdownTypes2 = countdownTypesArray[j];
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)tooltipLine, (String)"tooltipLine");
                            if (!StringsKt.contains$default((CharSequence)tooltipLine, (CharSequence)it.getMatch(), (boolean)false, (int)2, null)) continue;
                            countdownTypes = countdownTypes2;
                            break block20;
                        }
                        countdownTypes = null;
                    }
                    if (countdownTypes == null) continue;
                    CountdownTypes countdownKind = countdownTypes;
                    Intrinsics.checkNotNullExpressionValue((Object)tooltipLine, (String)"tooltipLine");
                    Sequence $this$maxByOrNull$iv = Regex.findAll$default((Regex)this.regex, (CharSequence)tooltipLine, (int)0, (int)2, null);
                    boolean $i$f$maxByOrNull = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v3 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v3 = maxElem$iv;
                        } else {
                            it = (MatchResult)maxElem$iv;
                            boolean bl = false;
                            int maxValue$iv = it.getValue().length();
                            do {
                                Object e$iv = iterator$iv.next();
                                MatchResult it2 = (MatchResult)e$iv;
                                $i$a$-maxByOrNull-CountdownCalculator$onTooltip$match$1 = false;
                                int v$iv = it2.getValue().length();
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v3 = maxElem$iv;
                        }
                    }
                    if ((MatchResult)v3 == null) continue;
                    if (countdownKind == CountdownTypes.CALENDARDETAILS) {
                        String string2 = event.itemStack.func_82833_r();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.itemStack.displayName");
                        if (!StringsKt.startsWith$default((String)string2, (String)"\u00a7aDay ", (boolean)false, (int)2, null)) {
                            return;
                        }
                    }
                    if ((totalSeconds = (years = (object5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"years")) != null && (object5 = object5.getValue()) != null ? Long.parseLong((String)object5) : 0L) * 31536000L + (days = (object4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"days")) != null && (object4 = object4.getValue()) != null ? Long.parseLong((String)object4) : 0L) * 86400L + (hours = (object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"hours")) != null && (object3 = object3.getValue()) != null ? Long.parseLong((String)object3) : 0L) * 3600L + (minutes = (object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"minutes")) != null && (object2 = object2.getValue()) != null ? Long.parseLong((String)object2) : 0L) * 60L + (seconds = (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"seconds")) != null && (object = object.getValue()) != null ? Long.parseLong((String)object) : 0L)) == 0L) continue;
                    if (years != 0L) {
                        formatterAsString = formatterAsString + " yyyy";
                    }
                    Intrinsics.checkNotNull((Object)DateTimeFormatter.ofPattern(formatterAsString));
                    if (countdownKind.isRelative()) {
                        if (lastTimer == null) {
                            event.toolTip.add(++i, "\u00a7r\u00a7cThe above countdown is relative, but I can't find another countdown. [NEU]");
                            continue;
                        }
                        zonedDateTime = this.addTime(lastTimer, years, days, hours, minutes, seconds);
                    } else {
                        ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
                        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now()");
                        zonedDateTime = countdownTarget = this.addTime(zonedDateTime2, years, days, hours, minutes, seconds);
                    }
                    if (NotEnoughUpdates.INSTANCE.config.misc.useEnglishCountdown) {
                        DateTimeFormatter dateTimeFormatter = useFormatter.withLocale(Locale.ENGLISH);
                        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"useFormatter.withLocale(\u2026ENGLISH\n                )");
                        useFormatter = dateTimeFormatter;
                    }
                    String countdownTargetFormatted = useFormatter.format(countdownTarget);
                    event.toolTip.add(++i, "\u00a7r\u00a7b" + countdownKind.getLabel() + ": " + countdownTargetFormatted);
                    lastTimer = countdownTarget;
                }
            }
        }
    }

    private final ZonedDateTime addTime(ZonedDateTime $this$addTime, long years, long days, long hours, long minutes, long seconds) {
        ZonedDateTime zonedDateTime = $this$addTime.plusYears(years).plusDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"this.plusYears(years).pl\u2026tes).plusSeconds(seconds)");
        return zonedDateTime;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/CountdownCalculator$CountdownTypes;", "", "match", "", "label", "isRelative", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Z)V", "()Z", "getLabel", "()Ljava/lang/String;", "getMatch", "STARTING", "STARTS", "INTEREST", "UNTILINTEREST", "ENDS", "REMAINING", "DURATION", "TIMELEFT", "EVENTTIMELEFT", "SHENSUCKS", "TAMINGSIXTYWASAMISTAKE", "CALENDARDETAILS", "COMMUNITYPROJECTSSUCK", "CHOCOLATEFACTORY", "STONKSAUCTION", "LIZSTONKREDEMPTION", "NotEnoughUpdates"})
    private static final class CountdownTypes
    extends Enum<CountdownTypes> {
        @NotNull
        private final String match;
        @NotNull
        private final String label;
        private final boolean isRelative;
        public static final /* enum */ CountdownTypes STARTING = new CountdownTypes("STARTING", 0, "Starting in:", "Starts at", false, 4, null);
        public static final /* enum */ CountdownTypes STARTS = new CountdownTypes("STARTS", 1, "Starts in:", "Starts at", false, 4, null);
        public static final /* enum */ CountdownTypes INTEREST = new CountdownTypes("INTEREST", 2, "Interest in:", "Interest at", false, 4, null);
        public static final /* enum */ CountdownTypes UNTILINTEREST = new CountdownTypes("UNTILINTEREST", 3, "Until interest:", "Interest at", false, 4, null);
        public static final /* enum */ CountdownTypes ENDS = new CountdownTypes("ENDS", 4, "Ends in:", "Ends at", false, 4, null);
        public static final /* enum */ CountdownTypes REMAINING = new CountdownTypes("REMAINING", 5, "Remaining:", "Ends at", false, 4, null);
        public static final /* enum */ CountdownTypes DURATION = new CountdownTypes("DURATION", 6, "Duration:", "Finishes at", false, 4, null);
        public static final /* enum */ CountdownTypes TIMELEFT = new CountdownTypes("TIMELEFT", 7, "Time left:", "Ends at", false, 4, null);
        public static final /* enum */ CountdownTypes EVENTTIMELEFT = new CountdownTypes("Event lasts for", "Ends at", true);
        public static final /* enum */ CountdownTypes SHENSUCKS = new CountdownTypes("SHENSUCKS", 9, "Auction ends in:", "Auction ends at", false, 4, null);
        public static final /* enum */ CountdownTypes TAMINGSIXTYWASAMISTAKE = new CountdownTypes("TAMINGSIXTYWASAMISTAKE", 10, "Ends:", "Finishes at", false, 4, null);
        public static final /* enum */ CountdownTypes CALENDARDETAILS = new CountdownTypes("CALENDARDETAILS", 11, " (\u00a7e", "Starts at", false, 4, null);
        public static final /* enum */ CountdownTypes COMMUNITYPROJECTSSUCK = new CountdownTypes("COMMUNITYPROJECTSSUCK", 12, "Contribute again", "Come back at", false, 4, null);
        public static final /* enum */ CountdownTypes CHOCOLATEFACTORY = new CountdownTypes("CHOCOLATEFACTORY", 13, "Next Charge", "Available at", false, 4, null);
        public static final /* enum */ CountdownTypes STONKSAUCTION = new CountdownTypes("STONKSAUCTION", 14, "Auction ends in", "Ends at", false, 4, null);
        public static final /* enum */ CountdownTypes LIZSTONKREDEMPTION = new CountdownTypes("LIZSTONKREDEMPTION", 15, "Resets in:", "Resets at", false, 4, null);
        private static final /* synthetic */ CountdownTypes[] $VALUES;

        private CountdownTypes(String match2, String label, boolean isRelative) {
            this.match = match2;
            this.label = label;
            this.isRelative = isRelative;
        }

        /* synthetic */ CountdownTypes(String string, int n, String string2, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(string2, string3, bl);
        }

        @NotNull
        public final String getMatch() {
            return this.match;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final boolean isRelative() {
            return this.isRelative;
        }

        public static CountdownTypes[] values() {
            return (CountdownTypes[])$VALUES.clone();
        }

        public static CountdownTypes valueOf(String value) {
            return Enum.valueOf(CountdownTypes.class, value);
        }

        static {
            $VALUES = countdownTypesArray = new CountdownTypes[]{CountdownTypes.STARTING, CountdownTypes.STARTS, CountdownTypes.INTEREST, CountdownTypes.UNTILINTEREST, CountdownTypes.ENDS, CountdownTypes.REMAINING, CountdownTypes.DURATION, CountdownTypes.TIMELEFT, CountdownTypes.EVENTTIMELEFT, CountdownTypes.SHENSUCKS, CountdownTypes.TAMINGSIXTYWASAMISTAKE, CountdownTypes.CALENDARDETAILS, CountdownTypes.COMMUNITYPROJECTSSUCK, CountdownTypes.CHOCOLATEFACTORY, CountdownTypes.STONKSAUCTION, CountdownTypes.LIZSTONKREDEMPTION};
        }
    }
}

