/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.common.collect.Lists;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.EnumChatFormatting;

public class CookieWarning {
    private static boolean hasNotified;
    private static boolean hasErrorMessage;
    private static long cookieEndTime;
    private static boolean hasCookie;
    private static long lastChecked;

    public static void resetNotification() {
        hasNotified = false;
        hasCookie = true;
        NotificationHandler.cancelNotification();
    }

    public static void checkCookie() {
        if (!NotEnoughUpdates.INSTANCE.config.notifications.doBoosterNotif || !NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        String timeLine = CookieWarning.getTimeLine();
        if (!hasCookie) {
            if (!hasNotified) {
                NotificationHandler.displayNotification(Lists.newArrayList((Object[])new String[]{"\u00a7cBooster Cookie Ran Out!", "\u00a77Your Booster Cookie expired!", "\u00a77", "\u00a77Press X on your keyboard to close this notification"}), true, true);
                hasNotified = true;
            }
            return;
        }
        if (timeLine == null) {
            return;
        }
        int minutes = (int)(CookieWarning.getMillisecondsRemaining(timeLine) / 60L / 1000L);
        if (minutes < NotEnoughUpdates.INSTANCE.config.notifications.boosterCookieWarningMins && !hasNotified) {
            NotificationHandler.displayNotification(Lists.newArrayList((Object[])new String[]{"\u00a7cBooster Cookie Running Low!", "\u00a77Your Booster Cookie will expire in " + timeLine, "\u00a77", "\u00a77Press X on your keyboard to close this notification"}), true, true);
            hasNotified = true;
        }
    }

    private static long getMillisecondsRemaining(String timeLine) {
        if ("Less than an hour".equals(timeLine)) {
            return 600000L;
        }
        String clean = timeLine.replaceAll("(\u00a7.)", "");
        clean = clean.replaceAll("(\\d)([smhdMy])", "$1 $2");
        String[] digits = clean.split(" ");
        long ms = 0L;
        try {
            for (int i = 0; i < digits.length; ++i) {
                if (i % 2 == 1) continue;
                String number2 = digits[i];
                String unit = digits[i + 1];
                long val = Integer.parseInt(number2);
                ms += CookieWarning.getEffectRemainingInMilliseconds(unit, val);
            }
        }
        catch (Exception e2) {
            if (!hasErrorMessage) {
                e2.printStackTrace();
                Utils.addChatMessage(EnumChatFormatting.RED + "NEU ran into an issue when retrieving the Booster Cookie Timer. Check the logs for details.");
                hasErrorMessage = true;
            }
            hasNotified = true;
        }
        return ms;
    }

    private static String getTimeLine() {
        List<String> lines = TablistAPI.getOptionalWidgetLines(TablistAPI.WidgetNames.ACTIVE_EFFECTS);
        List<String> lines2 = TablistAPI.getOptionalWidgetLines(TablistAPI.WidgetNames.COOKIE_BUFF);
        lines.addAll(lines2);
        String timeLine = null;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if ((line = Utils.cleanColour(line).trim()).startsWith("Cookie Buff:")) {
                timeLine = line.replace("Cookie Buff: ", "");
                if (timeLine.contains("INACTIVE")) {
                    hasCookie = false;
                    return null;
                }
            } else if (line.startsWith("Cookie Buff")) {
                timeLine = lines.get(i + 1);
                timeLine = Utils.cleanColour(timeLine).trim();
            }
            if (!line.startsWith("Not active! Obtain booster cookies from the")) continue;
            hasCookie = false;
            return null;
        }
        return timeLine;
    }

    public static boolean hasActiveBoosterCookie() {
        long cookieEndTime = CookieWarning.getCookieEndTime();
        return cookieEndTime > System.currentTimeMillis();
    }

    private static long getCookieEndTime() {
        if (lastChecked + 3000L > System.currentTimeMillis()) {
            return cookieEndTime;
        }
        String timeLine = CookieWarning.getTimeLine();
        if (hasCookie && timeLine != null) {
            long ms = CookieWarning.getMillisecondsRemaining(timeLine);
            cookieEndTime = System.currentTimeMillis() + ms;
        } else {
            cookieEndTime = 0L;
        }
        lastChecked = System.currentTimeMillis();
        return cookieEndTime;
    }

    public static void onProfileSwitch() {
        CookieWarning.resetNotification();
        hasErrorMessage = false;
        cookieEndTime = 0L;
        hasCookie = true;
        lastChecked = 0L;
    }

    public static long getEffectRemainingInMilliseconds(String remainingTimeType, long remainingTime) {
        switch (remainingTimeType.replace(",", "")) {
            case "months": 
            case "month": 
            case "mo": 
            case "M": {
                return remainingTime * 24L * 60L * 60L * 1000L * 30L;
            }
        }
        switch (remainingTimeType.toLowerCase(Locale.ROOT).replace(",", "")) {
            case "years": 
            case "year": 
            case "y": {
                return remainingTime * 24L * 60L * 60L * 1000L * 30L * 12L;
            }
            case "months": 
            case "month": 
            case "mo": {
                return remainingTime * 24L * 60L * 60L * 1000L * 30L;
            }
            case "days": 
            case "day": 
            case "d": {
                return remainingTime * 24L * 60L * 60L * 1000L;
            }
            case "hours": 
            case "hour": 
            case "h": {
                return remainingTime * 60L * 60L * 1000L;
            }
            case "minutes": 
            case "minute": 
            case "m": {
                return remainingTime * 60L * 1000L;
            }
            case "seconds": 
            case "second": 
            case "s": {
                return remainingTime * 1000L;
            }
        }
        return remainingTime;
    }

    static {
        cookieEndTime = 0L;
        hasCookie = true;
        lastChecked = 0L;
    }
}

