/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.listener;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.util.Calculator;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class ItemTooltipRngListener {
    private final NotEnoughUpdates neu;
    private boolean showSlayerRngFractions = false;
    private boolean pressedShiftLast = false;
    private int currentSelected = 0;
    private boolean pressedArrowLast = false;
    private boolean repoReloadNeeded = true;
    private final Pattern ODDS_PATTERN = Pattern.compile("\u00a75\u00a7o\u00a77Odds: (.+) \u00a77\\(\u00a77(.*)%\\)");
    private final Pattern ODDS_SELECTED_PATTERN = Pattern.compile("\u00a75\u00a7o\u00a77Odds: (.+) \u00a77\\(\u00a78\u00a7m(.*)%\u00a7r \u00a77(.+)%\\)");
    private final Pattern RUNS_PATTERN = Pattern.compile("\u00a75\u00a7o\u00a77(?:Dungeon Score|Slayer XP): \u00a7d(.*)\u00a75/\u00a7d(.+)");
    private final Pattern RUNS_SELECTED_PATTERN = Pattern.compile("(?:\u00a75\u00a7o)?\u00a7d\u00a7l\u00a7m *(?:\u00a7f\u00a7l\u00a7m *)?\u00a7r \u00a7d([0-9,]+)\u00a75/\u00a7d([0-9kKmM,.]+)");
    private final Pattern SLAYER_INVENTORY_TITLE_PATTERN = Pattern.compile("(.+) RNG Meter");
    private final Pattern TIER_AMOUNT = Pattern.compile("\u00a75\u00a7o\u00a77Tier (.+) amount: \u00a7a(\\d+).*");
    private final Map<String, Integer> dungeonData = new LinkedHashMap<String, Integer>();
    private final Map<String, LinkedHashMap<String, Integer>> slayerData = new LinkedHashMap<String, LinkedHashMap<String, Integer>>();

    public ItemTooltipRngListener(NotEnoughUpdates neu) {
        this.neu = neu;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!this.neu.isOnSkyblock()) {
            return;
        }
        if (event.toolTip == null) {
            return;
        }
        if (!(Utils.getOpenChestName().endsWith(" RNG Meter") || this.slayerData.containsKey(Utils.getOpenChestName()) || ItemUtils.getLore(event.itemStack).contains("\u00a7dRNG Meter"))) {
            return;
        }
        ArrayList<String> newToolTip = new ArrayList<String>();
        boolean nextLineProgress = false;
        for (String line : event.toolTip) {
            if (line.contains("Odds:") && NotEnoughUpdates.INSTANCE.config.tooltipTweaks.rngMeterFractionDisplay) {
                this.fractionDisplay(newToolTip, line);
                continue;
            }
            if (nextLineProgress || line.contains("Dungeon Score:") || line.contains("Slayer XP:")) {
                Matcher matcher = this.RUNS_PATTERN.matcher(line);
                Matcher matcherSelected = this.RUNS_SELECTED_PATTERN.matcher(line);
                Matcher m = null;
                if (matcher.matches()) {
                    m = matcher;
                } else if (matcherSelected.matches()) {
                    m = matcherSelected;
                }
                if (m != null) {
                    String name;
                    String formatCoinsPer;
                    int needed;
                    int having;
                    try {
                        having = Calculator.calculate(m.group(1).replace(",", "").toLowerCase(Locale.ROOT)).intValue();
                    }
                    catch (Calculator.CalculatorException e2) {
                        having = -1;
                    }
                    try {
                        needed = Calculator.calculate(m.group(2).replace(",", "").toLowerCase(Locale.ROOT)).intValue();
                    }
                    catch (Calculator.CalculatorException e3) {
                        needed = -1;
                    }
                    if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.rngMeterRunsNeeded) {
                        this.runsRequired(newToolTip, having, needed, nextLineProgress, event.itemStack);
                    }
                    if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.rngMeterProfitPerUnit && !NotEnoughUpdates.INSTANCE.config.tooltipTweaks.rngMeterRunsNeeded && (formatCoinsPer = this.getFormatCoinsPer(event.itemStack, needed, 1, 1, 0, name = Utils.getOpenChestName().contains("Catacombs") ? "Score" : "XP")) != null) {
                        newToolTip.add(line);
                        newToolTip.add(formatCoinsPer);
                        continue;
                    }
                }
                nextLineProgress = false;
            }
            if (line.contains("Progress:")) {
                nextLineProgress = true;
            }
            newToolTip.add(line);
        }
        event.toolTip.clear();
        event.toolTip.addAll(newToolTip);
    }

    private String getFormatCoinsPer(ItemStack stack, int needed, int multiplier, int amountPerTier, int cost, String label) {
        String internalName = this.neu.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
        double profit = this.neu.manager.auctionManager.getBazaarOrBin(internalName, false) * (double)amountPerTier;
        if (profit <= 0.0) {
            return null;
        }
        double coinsPer = profit / (double)needed * (double)multiplier - (double)cost;
        String format2 = StringUtils.shortNumberFormat(coinsPer);
        EnumChatFormatting profitIndicator = coinsPer >= 0.0 ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        return "\u00a77Coins per " + label + ": " + profitIndicator + format2 + " coins";
    }

    private void fractionDisplay(List<String> newToolTip, String line) {
        String result2;
        boolean shift;
        boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (!this.pressedShiftLast && shift) {
            this.showSlayerRngFractions = !this.showSlayerRngFractions;
        }
        this.pressedShiftLast = shift;
        Matcher matcher = this.ODDS_PATTERN.matcher(line);
        Matcher matcherSelected = this.ODDS_SELECTED_PATTERN.matcher(line);
        if (matcher.matches()) {
            String odds = matcher.group(1);
            int baseChance = this.calculateChance(matcher.group(2));
            String baseFormat = StringUtils.formatNumber(baseChance);
            String fractionFormat = "\u00a77(1/" + baseFormat + ")";
            result2 = odds + " " + fractionFormat;
        } else if (matcherSelected.matches()) {
            String odds = matcherSelected.group(1);
            int baseChance = this.calculateChance(matcherSelected.group(2));
            String baseFormat = StringUtils.formatNumber(baseChance);
            int increasedChance = this.calculateChance(matcherSelected.group(3));
            String increased = StringUtils.formatNumber(increasedChance);
            String fractionFormat = "\u00a77(\u00a78\u00a7m1/" + baseFormat + "\u00a7r \u00a771/" + increased + ")";
            result2 = odds + " " + fractionFormat;
        } else {
            return;
        }
        if (this.showSlayerRngFractions) {
            newToolTip.add("\u00a77Odds: " + result2);
            newToolTip.add("\u00a78[Press SHIFT to show odds as percentages]");
        } else {
            newToolTip.add(line);
            newToolTip.add("\u00a78[Press SHIFT to show odds as fractions]");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRepoReload(RepositoryReloadEvent event) {
        this.repoReloadNeeded = true;
    }

    public void checkUpdateData() {
        if (this.repoReloadNeeded) {
            this.updateRepoData();
        }
    }

    private void updateRepoData() {
        this.slayerData.clear();
        this.dungeonData.clear();
        JsonObject leveling = Constants.LEVELING;
        if (leveling == null) {
            Utils.showOutdatedRepoNotification("leveling.json");
            return;
        }
        if (!(leveling.has("slayer_boss_xp") && leveling.has("slayer_highest_tier") && leveling.has("slayer_tier_colors") && leveling.has("rng_meter_dungeon_score") && leveling.has("fancy_name_to_slayer") && leveling.has("slayer_boss_xp_type"))) {
            Utils.showOutdatedRepoNotification("leveling.json (outdated)");
            return;
        }
        ArrayList<Integer> defaultSlayerExp = new ArrayList<Integer>();
        for (JsonElement element : leveling.get("slayer_boss_xp").getAsJsonArray()) {
            defaultSlayerExp.add(element.getAsInt());
        }
        ArrayList<String> slayerColors = new ArrayList<String>();
        for (JsonElement jsonElement : leveling.get("slayer_tier_colors").getAsJsonArray()) {
            slayerColors.add(jsonElement.getAsString());
        }
        for (Map.Entry entry : leveling.get("slayer_highest_tier").getAsJsonObject().entrySet()) {
            String slayerFancyName = (String)entry.getKey();
            String slayerName = leveling.get("fancy_name_to_slayer").getAsJsonObject().get(slayerFancyName).getAsString();
            int maxTier = ((JsonElement)entry.getValue()).getAsInt();
            LinkedHashMap<String, Integer> singleSlayerData = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < maxTier; ++i) {
                String name = (String)slayerColors.get(i) + "Tier " + (i + 1);
                if (leveling.get("slayer_boss_xp_type").getAsJsonObject().get(slayerName) != null) {
                    singleSlayerData.put(name, leveling.get("slayer_boss_xp_type").getAsJsonObject().get(slayerName).getAsJsonArray().get(i).getAsInt());
                    continue;
                }
                singleSlayerData.put(name, (Integer)defaultSlayerExp.get(i));
            }
            this.slayerData.put(slayerFancyName, singleSlayerData);
        }
        for (Map.Entry entry : leveling.get("rng_meter_dungeon_score").getAsJsonObject().entrySet()) {
            String dungeonScore = (String)entry.getKey();
            int score = ((JsonElement)entry.getValue()).getAsInt();
            this.dungeonData.put(dungeonScore, score);
        }
        this.repoReloadNeeded = false;
    }

    private void runsRequired(List<String> toolTip, int having, int needed, boolean nextLineProgress, ItemStack stack) {
        String formatCoinsPer;
        JsonObject slayerCost;
        String repoCategory;
        String labelSingular;
        String labelPlural;
        Map runsData;
        this.checkUpdateData();
        if (this.repoReloadNeeded) {
            return;
        }
        String openChestName = Utils.getOpenChestName();
        if (openChestName.contains("Catacombs")) {
            runsData = this.dungeonData;
            labelPlural = "Runs";
            labelSingular = "Run";
            repoCategory = "catacombs";
        } else {
            Matcher matcher = this.SLAYER_INVENTORY_TITLE_PATTERN.matcher(openChestName);
            if (!matcher.matches()) {
                return;
            }
            String slayerName = matcher.group(1);
            runsData = this.slayerData.get(slayerName);
            labelPlural = "Bosses";
            labelSingular = "Boss";
            repoCategory = "slayer";
        }
        if (runsData == null) {
            return;
        }
        int repoScore = this.getRepoScore(stack, repoCategory);
        if (repoScore != -1) {
            needed = repoScore;
        }
        this.handleArrowKeys(runsData);
        if (this.currentSelected >= runsData.keySet().size()) {
            this.currentSelected = 0;
        }
        String name = (String)runsData.keySet().toArray()[this.currentSelected];
        int gainPerRun = (Integer)runsData.get(name);
        int runsNeeded = (int)Math.floor((double)needed / (double)gainPerRun);
        int runsHaving = having / gainPerRun;
        String runsNeededFormat = StringUtils.formatNumber(runsNeeded);
        String runsHavingFormat = StringUtils.formatNumber(runsHaving);
        String progressString = null;
        if (nextLineProgress) {
            progressString = toolTip.remove(toolTip.size() - 1);
        }
        toolTip.add("\u00a79Stats for " + name + "\u00a79: [\u00a7l\u00a7m< \u00a79Switch\u00a7l\u27a1\u00a79]");
        toolTip.add("   \u00a77" + labelPlural + " completed: \u00a7e" + runsHavingFormat + " \u00a77(of \u00a7e" + runsNeededFormat + " \u00a77needed)");
        int amountPerTier = this.parseAmountFromTooltip(toolTip);
        int cost = 0;
        if (repoCategory.equals("slayer") && (slayerCost = Constants.MISC).has("slayer_cost")) {
            cost = slayerCost.getAsJsonArray("slayer_cost").get(this.currentSelected).getAsInt();
        }
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.rngMeterProfitPerUnit && (formatCoinsPer = this.getFormatCoinsPer(stack, needed, gainPerRun, amountPerTier, cost, labelSingular)) != null) {
            toolTip.add("   " + formatCoinsPer);
        }
        toolTip.add(" ");
        if (progressString != null) {
            toolTip.add(progressString);
        }
    }

    private int parseAmountFromTooltip(List<String> tooltip) {
        HashMap<Integer, Integer> tierToAmount = new HashMap<Integer, Integer>();
        for (String line : tooltip) {
            Matcher amountMatcher = this.TIER_AMOUNT.matcher(line);
            if (!amountMatcher.matches()) continue;
            try {
                int tier = Utils.parseRomanNumeral(amountMatcher.group(1));
                int lowerBoundDrop = Integer.parseInt(amountMatcher.group(2));
                tierToAmount.put(tier, lowerBoundDrop);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
        }
        return tierToAmount.get(this.currentSelected + 1) == null ? 1 : (Integer)tierToAmount.get(this.currentSelected + 1);
    }

    private int getRepoScore(ItemStack stack, String repoCategory) {
        ItemResolutionQuery query = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).withCurrentGuiContext();
        String internalName = query.resolveInternalName();
        JsonObject jsonObject = Constants.RNGSCORE;
        if (jsonObject == null) {
            Utils.showOutdatedRepoNotification("rngscore.json");
            return -1;
        }
        String repoType = this.grabRepoType(stack);
        if (!jsonObject.has(repoCategory)) {
            return -1;
        }
        JsonObject category = jsonObject.get(repoCategory).getAsJsonObject();
        if (!category.has(repoType)) {
            return -1;
        }
        JsonObject typeObject = category.get(repoType).getAsJsonObject();
        if (!typeObject.has(internalName)) {
            return -1;
        }
        return typeObject.get(internalName).getAsInt();
    }

    private String grabRepoType(ItemStack stack) {
        String openChestName = Utils.getOpenChestName();
        if (openChestName.contains("Catacombs")) {
            if (openChestName.equals("Catacombs RNG Meter")) {
                List<String> list = ItemUtils.getLore(stack);
                String line = list.get(4);
                return line.substring(26, 28);
            }
            if (openChestName.contains("(")) {
                return openChestName.substring(17, 19);
            }
            return openChestName.substring(11, 13);
        }
        return openChestName.substring(0, openChestName.length() - 9);
    }

    private void handleArrowKeys(Map<String, Integer> runsData) {
        boolean left = Keyboard.isKeyDown((int)203);
        boolean right = Keyboard.isKeyDown((int)205);
        if (!this.pressedArrowLast && (left || right)) {
            this.currentSelected = (Utils.getOpenChestName().contains("Catacombs") ? right : left) ? --this.currentSelected : ++this.currentSelected;
            if (this.currentSelected < 0) {
                this.currentSelected = 0;
            }
            if (this.currentSelected >= runsData.size()) {
                this.currentSelected = runsData.size() - 1;
            }
        }
        this.pressedArrowLast = left || right;
    }

    private int calculateChance(String string) {
        return (int)(100.0 / Double.parseDouble(string));
    }
}

