/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.envcheck;

import java.lang.reflect.Field;
import java.util.Objects;
import javax.swing.JOptionPane;

public class EnvironmentScan {
    static boolean shouldCheckOnce = true;

    static Class<?> tryGetClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    static Object tryGetField(Class<?> clazz, Object inst, String name) {
        if (clazz == null) {
            return null;
        }
        try {
            Field declaredField = clazz.getDeclaredField(name);
            return declaredField.get(inst);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    static boolean isAtLeast(Object left, int right) {
        if (left instanceof Integer) {
            return (Integer)left >= right;
        }
        return false;
    }

    public static void checkEnvironmentOnce() {
        if (shouldCheckOnce) {
            EnvironmentScan.checkEnvironment();
        }
    }

    static void checkEnvironment() {
        shouldCheckOnce = false;
        EnvironmentScan.checkForgeEnvironment();
    }

    static void checkForgeEnvironment() {
        Class<?> forgeVersion = EnvironmentScan.tryGetClass("net.minecraftforge.common.ForgeVersion");
        if (!(forgeVersion != null && Objects.equals(EnvironmentScan.tryGetField(forgeVersion, null, "majorVersion"), 11) && Objects.equals(EnvironmentScan.tryGetField(forgeVersion, null, "minorVersion"), 15) && EnvironmentScan.isAtLeast(EnvironmentScan.tryGetField(forgeVersion, null, "revisionVersion"), 1) && Objects.equals(EnvironmentScan.tryGetField(forgeVersion, null, "mcVersion"), "1.8.9"))) {
            System.out.printf("Forge Version : %s%nMajor : %s%nMinor : %s%nRevision : %s%nMinecraft : %s%n", forgeVersion, EnvironmentScan.tryGetField(forgeVersion, null, "majorVersion"), EnvironmentScan.tryGetField(forgeVersion, null, "minorVersion"), EnvironmentScan.tryGetField(forgeVersion, null, "revisionVersion"), EnvironmentScan.tryGetField(forgeVersion, null, "mcVersion"));
            EnvironmentScan.missingOrOutdatedForgeError();
        }
    }

    static void missingOrOutdatedForgeError() {
        EnvironmentScan.showErrorMessage("You just launched NotEnoughUpdates with the wrong (or no) modloader installed.", "", "NotEnoughUpdates only works in Minecraft 1.8.9, with Forge 11.15.1+", "Please relaunch NotEnoughUpdates in the correct environment.", "If you are using Minecraft 1.8.9 with Forge 11.15.1+ installed, please contact support.", "Click OK to launch anyways.");
    }

    public static void showErrorMessage(String ... messages) {
        String message = String.join((CharSequence)"\n", messages);
        System.setProperty("java.awt.headless", "false");
        JOptionPane.showMessageDialog(null, message, "NotEnoughUpdates - Problematic System Configuration", 0);
    }
}

