/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.dungeons;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.NEUResourceManager;
import io.github.moulberry.notenoughupdates.util.SidebarUtil;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec4b;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Matrix4f;

public class DungeonMap {
    private static final ResourceLocation GREEN_CHECK = new ResourceLocation("notenoughupdates:dungeon_map/green_check.png");
    private static final ResourceLocation WHITE_CHECK = new ResourceLocation("notenoughupdates:dungeon_map/white_check.png");
    private static final ResourceLocation QUESTION = new ResourceLocation("notenoughupdates:dungeon_map/question.png");
    private static final ResourceLocation CROSS = new ResourceLocation("notenoughupdates:dungeon_map/cross.png");
    private static final ResourceLocation ROOM_RED = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/red_room.png");
    private static final ResourceLocation ROOM_BROWN = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/brown_room.png");
    private static final ResourceLocation ROOM_GRAY = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/gray_room.png");
    private static final ResourceLocation ROOM_GREEN = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/green_room.png");
    private static final ResourceLocation ROOM_PINK = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/pink_room.png");
    private static final ResourceLocation ROOM_PURPLE = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/purple_room.png");
    private static final ResourceLocation ROOM_YELLOW = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/yellow_room.png");
    private static final ResourceLocation ROOM_ORANGE = new ResourceLocation("notenoughupdates:dungeon_map/rooms_default/orange_room.png");
    private static final ResourceLocation CORRIDOR_RED = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/red_corridor.png");
    private static final ResourceLocation CORRIDOR_BROWN = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/brown_corridor.png");
    private static final ResourceLocation CORRIDOR_GRAY = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/gray_corridor.png");
    private static final ResourceLocation CORRIDOR_GREEN = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/green_corridor.png");
    private static final ResourceLocation CORRIDOR_PINK = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/pink_corridor.png");
    private static final ResourceLocation CORRIDOR_PURPLE = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/purple_corridor.png");
    private static final ResourceLocation CORRIDOR_YELLOW = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/yellow_corridor.png");
    private static final ResourceLocation CORRIDOR_ORANGE = new ResourceLocation("notenoughupdates:dungeon_map/corridors_default/orange_corridor.png");
    private static final ResourceLocation DIVIDER_BROWN = new ResourceLocation("notenoughupdates:dungeon_map/dividers_default/brown_divider.png");
    private static final ResourceLocation CORNER_BROWN = new ResourceLocation("notenoughupdates:dungeon_map/corners_default/brown_corner.png");
    private final HashMap<RoomOffset, Room> roomMap = new HashMap();
    private Color[][] colourMap = new Color[128][128];
    private int startRoomX = -1;
    private int startRoomY = -1;
    private int connectorSize = 5;
    private int roomSize = 0;
    private long lastDecorationsMillis = -1L;
    private long lastLastDecorationsMillis = -1L;
    private final Map<String, MapPosition> playerEntityMapPositions = new HashMap<String, MapPosition>();
    private final Map<String, MapPosition> playerMarkerMapPositions = new HashMap<String, MapPosition>();
    private final Set<MapPosition> rawPlayerMarkerMapPositions = new HashSet<MapPosition>();
    private final Map<String, MapPosition> playerMarkerMapPositionsLast = new HashMap<String, MapPosition>();
    private final HashMap<String, Integer> playerIdMap = new HashMap();
    private final Map<String, ResourceLocation> playerSkinMap = new HashMap<String, ResourceLocation>();
    private static final ResourceLocation mapIcons = new ResourceLocation("textures/map/map_icons.png");
    public static Framebuffer mapFramebuffer1 = null;
    public static Framebuffer mapFramebuffer2 = null;
    public static net.minecraft.util.Matrix4f projectionMatrix = null;
    public static Shader mapShader = null;
    private final HashMap<Integer, Float> borderRadiusCache = new HashMap();
    private boolean isFloorOne = false;
    private boolean isEntrance = false;
    private boolean failMap = false;
    private long lastClearCache = 0L;
    Shader blurShaderHorz = null;
    Framebuffer blurOutputHorz = null;
    Shader blurShaderVert = null;
    Framebuffer blurOutputVert = null;

    private static Framebuffer checkFramebufferSizes(Framebuffer framebuffer, int width, int height) {
        if (framebuffer == null || framebuffer.field_147621_c != width || framebuffer.field_147618_d != height) {
            if (framebuffer == null) {
                framebuffer = new Framebuffer(width, height, true);
            } else {
                framebuffer.func_147613_a(width, height);
            }
            framebuffer.func_147607_a(9728);
        }
        return framebuffer;
    }

    private static void upload(Shader shader, int width, int height, int scale, float radiusSq) {
        if (shader == null) {
            return;
        }
        shader.func_148043_c().func_147984_b("ProjMat").func_148088_a((Matrix4f)projectionMatrix);
        shader.func_148043_c().func_147984_b("InSize").func_148087_a((float)(width * scale), (float)(height * scale));
        shader.func_148043_c().func_147984_b("OutSize").func_148087_a((float)width, (float)height);
        shader.func_148043_c().func_147984_b("ScreenSize").func_148087_a((float)width, (float)height);
        shader.func_148043_c().func_147984_b("radiusSq").func_148090_a(radiusSq);
    }

    public int getRenderRoomSize() {
        double roomSizeOption = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmRoomSize;
        if (roomSizeOption <= 0.0) {
            return 12;
        }
        return 12 + (int)Math.round(roomSizeOption * 4.0);
    }

    public int getRenderConnSize() {
        int roomSizeOption = Math.round(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmRoomSize);
        if (roomSizeOption <= 0) {
            return 3;
        }
        return 3 + roomSizeOption;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getBorderRadius() {
        int borderSizeOption = Math.round(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderSize);
        String sizeId = borderSizeOption == 0 ? "small" : (borderSizeOption == 2 ? "large" : "medium");
        int style = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderStyle;
        if (this.borderRadiusCache.containsKey(style)) {
            return this.borderRadiusCache.get(style).floatValue();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("notenoughupdates:dungeon_map/borders/" + sizeId + "/" + style + ".json")).func_110527_b(), StandardCharsets.UTF_8));){
            JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((Reader)reader, JsonObject.class);
            float radiusSq = json.get("radiusSq").getAsFloat();
            this.borderRadiusCache.put(style, Float.valueOf(radiusSq));
            float f = radiusSq;
            return f;
        }
        catch (Exception exception) {
            this.borderRadiusCache.put(style, Float.valueOf(1.0f));
            return 1.0f;
        }
    }

    public void render(int centerX, int centerY) {
        boolean useFb = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmCompat <= 1 && OpenGlHelper.func_148822_b();
        boolean useShd = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmCompat <= 0 && OpenGlHelper.func_153193_b();
        ScaledResolution scaledResolution = Utils.pushGuiScale(2);
        int minRoomX = 999;
        int minRoomY = 999;
        int maxRoomX = -999;
        int maxRoomY = -999;
        for (RoomOffset offset : this.roomMap.keySet()) {
            minRoomX = Math.min(offset.x, minRoomX);
            minRoomY = Math.min(offset.y, minRoomY);
            maxRoomX = Math.max(offset.x, maxRoomX);
            maxRoomY = Math.max(offset.y, maxRoomY);
        }
        int borderSizeOption = Math.round(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderSize);
        int renderRoomSize = this.getRenderRoomSize();
        int renderConnSize = this.getRenderConnSize();
        MapPosition playerPos = null;
        if (this.playerEntityMapPositions.containsKey(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            playerPos = this.playerEntityMapPositions.get(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        } else if (this.playerMarkerMapPositions.containsKey(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            playerPos = this.playerMarkerMapPositions.get(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        }
        int rotation = 180;
        if (playerPos != null && NotEnoughUpdates.INSTANCE.config.dungeonMap.dmRotatePlayer) {
            rotation = (int)playerPos.rotation;
        }
        int mapSizeX = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderStyle <= 1 ? 80 + Math.round(40.0f * NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderSize) : (borderSizeOption == 0 ? 90 : (borderSizeOption == 1 ? 120 : (borderSizeOption == 2 ? 160 : 240)));
        int mapSizeY = mapSizeX;
        int roomsSizeX = (maxRoomX - minRoomX) * (renderRoomSize + renderConnSize) + renderRoomSize + (this.isFloorOne ? this.getRenderRoomSize() : 0);
        int roomsSizeY = (maxRoomY - minRoomY) * (renderRoomSize + renderConnSize) + renderRoomSize + (this.isEntrance ? this.getRenderRoomSize() : 0);
        int mapCenterX = mapSizeX / 2;
        int mapCenterY = mapSizeY / 2;
        int scaleFactor = 8;
        projectionMatrix = Utils.createProjectionMatrix(mapSizeX * scaleFactor, mapSizeY * scaleFactor);
        mapFramebuffer1 = DungeonMap.checkFramebufferSizes(mapFramebuffer1, mapSizeX * scaleFactor, mapSizeY * scaleFactor);
        mapFramebuffer2 = DungeonMap.checkFramebufferSizes(mapFramebuffer2, mapSizeX * scaleFactor, mapSizeY * scaleFactor);
        DungeonMap.mapFramebuffer1.field_147625_i[1] = 0.0f;
        DungeonMap.mapFramebuffer1.field_147625_i[2] = 0.0f;
        try {
            if (mapShader == null) {
                mapShader = new Shader((IResourceManager)new NEUResourceManager(Minecraft.func_71410_x().func_110442_L()), "dungeonmap", mapFramebuffer1, mapFramebuffer2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Utils.pushGuiScale(-1);
            return;
        }
        int backgroundColour = SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundColour);
        DungeonMap.mapFramebuffer1.field_147625_i[0] = (float)(backgroundColour >> 16 & 0xFF) / 255.0f;
        DungeonMap.mapFramebuffer1.field_147625_i[1] = (float)(backgroundColour >> 8 & 0xFF) / 255.0f;
        DungeonMap.mapFramebuffer1.field_147625_i[2] = (float)(backgroundColour & 0xFF) / 255.0f;
        DungeonMap.mapFramebuffer2.field_147625_i[0] = (float)(backgroundColour >> 16 & 0xFF) / 255.0f;
        DungeonMap.mapFramebuffer2.field_147625_i[1] = (float)(backgroundColour >> 8 & 0xFF) / 255.0f;
        DungeonMap.mapFramebuffer2.field_147625_i[2] = (float)(backgroundColour & 0xFF) / 255.0f;
        try {
            Object room;
            RoomOffset roomOffset;
            if (useFb) {
                mapFramebuffer1.func_147614_f();
                mapFramebuffer2.func_147614_f();
            }
            GlStateManager.func_179094_E();
            if (useFb) {
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179096_D();
                GlStateManager.func_179130_a((double)0.0, (double)(mapSizeX * scaleFactor), (double)(mapSizeY * scaleFactor), (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179096_D();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)1.0f);
                mapFramebuffer1.func_147610_a(true);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
            } else {
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((centerX - mapSizeX / 2) * 2), (int)(Minecraft.func_71410_x().field_71440_d - (centerY + mapSizeY / 2) * 2), (int)(mapSizeX * 2), (int)(mapSizeY * 2));
                GlStateManager.func_179109_b((float)(centerX - mapSizeX / 2), (float)(centerY - mapSizeY / 2), (float)100.0f);
            }
            if ((double)NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur > 0.1 && NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur < 100.0f && NotEnoughUpdates.INSTANCE.config.dungeonMap.dmEnable) {
                GlStateManager.func_179109_b((float)(-centerX + mapSizeX / 2), (float)(-centerY + mapSizeY / 2), (float)0.0f);
                BackgroundBlur.renderBlurredBackground(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur, scaledResolution.func_78326_a(), scaledResolution.func_78328_b(), centerX - mapSizeX / 2, centerY - mapSizeY / 2, mapSizeX, mapSizeY);
                BackgroundBlur.markDirty();
                GlStateManager.func_179109_b((float)(centerX - mapSizeX / 2), (float)(centerY - mapSizeY / 2), (float)0.0f);
            }
            GlStateManager.func_179109_b((float)mapCenterX, (float)mapCenterY, (float)10.0f);
            if (!useFb || (double)NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur > 0.1 && NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur < 100.0f) {
                GlStateManager.func_179147_l();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            Utils.drawRectNoBlend(-mapCenterX, -mapCenterY, mapCenterX, mapCenterY, backgroundColour);
            GlStateManager.func_179114_b((float)(-rotation + 180), (float)0.0f, (float)0.0f, (float)1.0f);
            if (NotEnoughUpdates.INSTANCE.config.dungeonMap.dmCenterPlayer && playerPos != null) {
                float x = playerPos.getRenderX();
                float y = playerPos.getRenderY();
                GlStateManager.func_179109_b((float)(-(x -= (float)(minRoomX * (renderRoomSize + renderConnSize)))), (float)(-(y -= (float)(minRoomY * (renderRoomSize + renderConnSize)))), (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)(-roomsSizeX / 2), (float)(-roomsSizeY / 2), (float)0.0f);
            }
            for (Map.Entry<RoomOffset, Room> entry : this.roomMap.entrySet()) {
                roomOffset = entry.getKey();
                room = entry.getValue();
                int n = (roomOffset.x - minRoomX) * (renderRoomSize + renderConnSize);
                int y = (roomOffset.y - minRoomY) * (renderRoomSize + renderConnSize);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)n, (float)y, (float)0.0f);
                ((Room)room).render(renderRoomSize, renderConnSize);
                GlStateManager.func_179109_b((float)(-n), (float)(-y), (float)0.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179109_b((float)((float)(-mapCenterX) + (float)roomsSizeX / 2.0f), (float)((float)(-mapCenterY) + (float)roomsSizeY / 2.0f), (float)0.0f);
            GlStateManager.func_179109_b((float)mapCenterX, (float)mapCenterY, (float)0.0f);
            GlStateManager.func_179114_b((float)(rotation - 180), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-mapCenterX), (float)(-mapCenterY), (float)0.0f);
            GlStateManager.func_179109_b((float)mapCenterX, (float)mapCenterY, (float)0.0f);
            for (Map.Entry<RoomOffset, Room> entry : this.roomMap.entrySet()) {
                roomOffset = entry.getKey();
                room = entry.getValue();
                float f = (float)((roomOffset.x - minRoomX) * (renderRoomSize + renderConnSize)) - (float)roomsSizeX / 2.0f + (float)renderRoomSize / 2.0f;
                float y = (float)((roomOffset.y - minRoomY) * (renderRoomSize + renderConnSize)) - (float)roomsSizeY / 2.0f + (float)renderRoomSize / 2.0f;
                float x2 = (float)((double)(-f) * Math.cos(Math.toRadians(-rotation)) + (double)y * Math.sin(Math.toRadians(-rotation)));
                float y2 = (float)((double)(-f) * Math.sin(Math.toRadians(-rotation)) - (double)y * Math.cos(Math.toRadians(-rotation)));
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x2, (float)y2, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ((Room)room).renderNoRotate(renderRoomSize, renderConnSize, rotation);
                GlStateManager.func_179109_b((float)(-x2), (float)(-y2), (float)0.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179109_b((float)(-mapCenterX), (float)(-mapCenterY), (float)0.0f);
            GlStateManager.func_179109_b((float)mapCenterX, (float)mapCenterY, (float)0.0f);
            GlStateManager.func_179114_b((float)(-rotation + 180), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-mapCenterX), (float)(-mapCenterY), (float)0.0f);
            GlStateManager.func_179109_b((float)((float)mapCenterX - (float)roomsSizeX / 2.0f), (float)((float)mapCenterY - (float)roomsSizeY / 2.0f), (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer22 = tessellator.func_178180_c();
            int k = 0;
            for (Map.Entry entry : this.playerMarkerMapPositions.entrySet()) {
                float yLast;
                MapPosition last;
                float xLast;
                float distSq;
                String name = (String)entry.getKey();
                MapPosition pos = (MapPosition)entry.getValue();
                float x = pos.getRenderX();
                float y = pos.getRenderY();
                float angle = pos.rotation;
                boolean doInterp = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPlayerInterp;
                if (this.playerEntityMapPositions.containsKey(name)) {
                    MapPosition entityPos = this.playerEntityMapPositions.get(name);
                    angle = entityPos.rotation;
                    float deltaX = entityPos.getRenderX() - pos.getRenderX() + (float)(this.isFloorOne ? this.getRenderRoomSize() : 0);
                    float deltaY = entityPos.getRenderY() - pos.getRenderY() + (float)(this.isEntrance ? this.getRenderRoomSize() : 0);
                    x += deltaX;
                    y += deltaY;
                    doInterp = false;
                }
                float minU = 0.75f;
                float minV = 0.0f;
                if (name.equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                    minU = 0.25f;
                }
                float maxU = minU + 0.25f;
                float maxV = minV + 0.25f;
                if (doInterp && this.playerMarkerMapPositionsLast.containsKey(name) && (distSq = (x - (xLast = (last = this.playerMarkerMapPositionsLast.get(name)).getRenderX())) * (x - xLast) + (y - (yLast = last.getRenderY())) * (y - yLast)) < (float)(renderRoomSize * renderRoomSize) / 4.0f) {
                    float angleLast = last.rotation;
                    if (angle > 180.0f && angleLast < 180.0f) {
                        angleLast += 360.0f;
                    }
                    if (angleLast > 180.0f && angle < 180.0f) {
                        angle += 360.0f;
                    }
                    float interpFactor = (float)Math.round((float)(System.currentTimeMillis() - this.lastDecorationsMillis) * 100.0f) / 100.0f / (float)(this.lastDecorationsMillis - this.lastLastDecorationsMillis);
                    interpFactor = Math.max(0.0f, Math.min(1.0f, interpFactor));
                    x = xLast + (x - xLast) * interpFactor;
                    y = yLast + (y - yLast) * interpFactor;
                    angle = angleLast + (angle - angleLast) * interpFactor;
                    angle %= 360.0f;
                }
                boolean blackBorder = false;
                boolean headLayer = false;
                int pixelWidth = 8;
                int pixelHeight = 8;
                if (renderRoomSize >= 24) {
                    pixelHeight = 12;
                    pixelWidth = 12;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((!NotEnoughUpdates.INSTANCE.config.dungeons.showOwnHeadAsMarker || this.playerMarkerMapPositions.size() < 1 || minU != 0.25f) && NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPlayerHeads >= 1 && this.playerSkinMap.containsKey(entry.getKey())) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.playerSkinMap.get(entry.getKey()));
                    minU = 0.125f;
                    minV = 0.125f;
                    maxU = 0.25f;
                    maxV = 0.25f;
                    headLayer = true;
                    if (NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPlayerHeads >= 2) {
                        blackBorder = true;
                    }
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(mapIcons);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179147_l();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                GlStateManager.func_179109_b((float)(x -= (float)(minRoomX * (renderRoomSize + renderConnSize))), (float)(y -= (float)(minRoomY * (renderRoomSize + renderConnSize))), (float)-0.02f);
                GlStateManager.func_179152_a((float)NotEnoughUpdates.INSTANCE.config.dungeonMap.dmIconScale, (float)NotEnoughUpdates.INSTANCE.config.dungeonMap.dmIconScale, (float)1.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.0f);
                if (blackBorder) {
                    Gui.func_73734_a((int)(-pixelWidth / 2 - 1), (int)(-pixelHeight / 2 - 1), (int)(pixelWidth / 2 + 1), (int)(pixelHeight / 2 + 1), (int)-15658735);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                worldrenderer22.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldrenderer22.func_181662_b((double)((float)(-pixelWidth) / 2.0f), (double)((float)pixelHeight / 2.0f), (double)(30.0f + (float)k * -0.005f)).func_181673_a((double)minU, (double)minV).func_181675_d();
                worldrenderer22.func_181662_b((double)((float)pixelWidth / 2.0f), (double)((float)pixelHeight / 2.0f), (double)(30.0f + (float)k * -0.005f)).func_181673_a((double)maxU, (double)minV).func_181675_d();
                worldrenderer22.func_181662_b((double)((float)pixelWidth / 2.0f), (double)((float)(-pixelHeight) / 2.0f), (double)(30.0f + (float)k * -0.005f)).func_181673_a((double)maxU, (double)maxV).func_181675_d();
                worldrenderer22.func_181662_b((double)((float)(-pixelWidth) / 2.0f), (double)((float)(-pixelHeight) / 2.0f), (double)(30.0f + (float)k * -0.005f)).func_181673_a((double)minU, (double)maxV).func_181675_d();
                tessellator.func_78381_a();
                if (headLayer) {
                    worldrenderer22.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    worldrenderer22.func_181662_b((double)((float)(-pixelWidth) / 2.0f), (double)((float)pixelHeight / 2.0f), (double)(30.0f + (float)k * -0.005f + 0.001f)).func_181673_a((double)(minU + 0.5f), (double)minV).func_181675_d();
                    worldrenderer22.func_181662_b((double)((float)pixelWidth / 2.0f), (double)((float)pixelHeight / 2.0f), (double)(30.0f + (float)k * -0.005f + 0.001f)).func_181673_a((double)(maxU + 0.5f), (double)minV).func_181675_d();
                    worldrenderer22.func_181662_b((double)((float)pixelWidth / 2.0f), (double)((float)(-pixelHeight) / 2.0f), (double)(30.0f + (float)k * -0.005f + 0.001f)).func_181673_a((double)(maxU + 0.5f), (double)maxV).func_181675_d();
                    worldrenderer22.func_181662_b((double)((float)(-pixelWidth) / 2.0f), (double)((float)(-pixelHeight) / 2.0f), (double)(30.0f + (float)k * -0.005f + 0.001f)).func_181673_a((double)(minU + 0.5f), (double)maxV).func_181675_d();
                    tessellator.func_78381_a();
                }
                GlStateManager.func_179121_F();
                --k;
            }
            if (useFb) {
                GlStateManager.func_179147_l();
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            } else {
                GL11.glDisable((int)3089);
            }
            GlStateManager.func_179121_F();
            if (useFb) {
                Framebuffer renderFromBuffer = mapFramebuffer1;
                if (useShd) {
                    GlStateManager.func_179094_E();
                    try {
                        DungeonMap.upload(mapShader, mapSizeX, mapSizeY, scaleFactor, this.getBorderRadius());
                        mapShader.func_148045_a((Matrix4f)projectionMatrix);
                        mapShader.func_148042_a(0.0f);
                        renderFromBuffer = mapFramebuffer2;
                    }
                    catch (Exception worldrenderer22) {
                        // empty catch block
                    }
                    GlStateManager.func_179121_F();
                }
                Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
                Utils.pushGuiScale(2);
                GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)100.0f);
                renderFromBuffer.func_147612_c();
                Utils.drawTexturedRect(-mapSizeX / 2, -mapSizeY / 2, mapSizeX, mapSizeY, 0.0f, 1.0f, 1.0f, 0.0f, 9728);
                GlStateManager.func_179144_i((int)0);
                GlStateManager.func_179109_b((float)(-centerX), (float)(-centerY), (float)-100.0f);
                Utils.pushGuiScale(-1);
            }
            GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)100.0f);
            if (NotEnoughUpdates.INSTANCE.config.dungeonMap.dmChromaBorder) {
                int colour = SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderColour);
                Gui.func_73734_a((int)(-mapCenterX - 2), (int)(-mapCenterY - 2), (int)(-mapCenterX), (int)(-mapCenterY), (int)colour);
                Gui.func_73734_a((int)(-mapCenterX - 2), (int)(mapCenterY + 2), (int)(-mapCenterX), (int)mapCenterY, (int)SpecialColour.rotateHue(colour, -180));
                Gui.func_73734_a((int)mapCenterX, (int)(-mapCenterY - 2), (int)(mapCenterX + 2), (int)mapCenterY, (int)SpecialColour.rotateHue(colour, -180));
                Gui.func_73734_a((int)mapCenterX, (int)mapCenterY, (int)(mapCenterX + 2), (int)(mapCenterY + 2), (int)colour);
                for (int i = 0; i < 20; ++i) {
                    int start1 = SpecialColour.rotateHue(colour, -9 * i);
                    int start2 = SpecialColour.rotateHue(colour, -9 * i - 9);
                    int n = SpecialColour.rotateHue(colour, -180 - 9 * i);
                    int end2 = SpecialColour.rotateHue(colour, -180 - 9 * i - 9);
                    Utils.drawGradientRect(-mapCenterX - 2, -mapCenterY + (int)((float)mapSizeY * ((float)i / 20.0f)), -mapCenterX, -mapCenterY + (int)((float)mapSizeY * ((float)(i + 1) / 20.0f)), start1, start2);
                    Utils.drawGradientRect(mapCenterX, -mapCenterY + (int)((float)mapSizeX * ((float)i / 20.0f)), mapCenterX + 2, -mapCenterY + (int)((float)mapSizeX * ((float)(i + 1) / 20.0f)), n, end2);
                    Utils.drawGradientRectHorz(-mapCenterX + (int)((float)mapSizeX * ((float)i / 20.0f)), -mapCenterY - 2, -mapCenterX + (int)((float)mapSizeX * ((float)(i + 1) / 20.0f)), -mapCenterY, start1, start2);
                    Utils.drawGradientRectHorz(-mapCenterX + (int)((float)mapSizeX * ((float)i / 20.0f)), mapCenterY, -mapCenterX + (int)((float)mapSizeX * ((float)(i + 1) / 20.0f)), mapCenterY + 2, n, end2);
                }
            } else {
                Gui.func_73734_a((int)(-mapCenterX - 2), (int)(-mapCenterY), (int)(-mapCenterX), (int)mapCenterY, (int)SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderColour));
                Gui.func_73734_a((int)mapCenterX, (int)(-mapCenterY), (int)(mapCenterX + 2), (int)mapCenterY, (int)SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderColour));
                Gui.func_73734_a((int)(-mapCenterX - 2), (int)(-mapCenterY - 2), (int)(mapCenterX + 2), (int)(-mapCenterY), (int)SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderColour));
                Gui.func_73734_a((int)(-mapCenterX - 2), (int)mapCenterY, (int)(mapCenterX + 2), (int)(mapCenterY + 2), (int)SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderColour));
            }
            String sizeId = borderSizeOption == 0 ? "small" : (borderSizeOption == 2 ? "large" : "medium");
            ResourceLocation rl = new ResourceLocation("notenoughupdates:dungeon_map/borders/" + sizeId + "/" + NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderStyle + ".png");
            if (Minecraft.func_71410_x().func_110434_K().func_110581_b(rl) != TextureUtil.field_111001_a) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int size = borderSizeOption == 0 ? 165 : (borderSizeOption == 1 ? 220 : (borderSizeOption == 2 ? 300 : 440));
                Utils.drawTexturedRect(-size / 2, -size / 2, size, size, 9728);
            }
            GlStateManager.func_179109_b((float)(-centerX), (float)(-centerY), (float)-100.0f);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
        }
        Utils.pushGuiScale(-1);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179140_f();
    }

    public void updateRoomConnections(RoomOffset roomOffset) {
        if (this.roomMap.containsKey(roomOffset)) {
            Color pixel;
            Room room = this.roomMap.get(roomOffset);
            int otherPixelFilled = 0;
            int otherPixelColour = 0;
            for (int xOff = 0; xOff < this.roomSize; ++xOff) {
                for (int yOff = 0; yOff < this.roomSize; ++yOff) {
                    Color c;
                    int x = this.startRoomX + roomOffset.x * (this.roomSize + this.connectorSize) + xOff;
                    int y = this.startRoomY + roomOffset.y * (this.roomSize + this.connectorSize) + yOff;
                    if (x <= 0 || y <= 0 || x >= this.colourMap.length || y >= this.colourMap[x].length || (c = this.colourMap[x][y]).equals(room.colour)) continue;
                    if (otherPixelColour == c.getRGB()) {
                        ++otherPixelFilled;
                        continue;
                    }
                    if (--otherPixelFilled > 0) continue;
                    otherPixelFilled = 1;
                    otherPixelColour = c.getRGB();
                }
            }
            room.tickColour = 0;
            if ((double)((float)otherPixelFilled / (float)this.roomSize / (float)this.connectorSize) > 0.05) {
                room.tickColour = otherPixelColour;
            }
            for (int k = 0; k < 4; ++k) {
                Color colour = null;
                int totalFilled = 0;
                for (int i = 0; i < this.roomSize; ++i) {
                    for (int j = 1; j <= this.connectorSize; ++j) {
                        Color pixel2;
                        int x = this.startRoomX + roomOffset.x * (this.roomSize + this.connectorSize);
                        int y = this.startRoomY + roomOffset.y * (this.roomSize + this.connectorSize);
                        if (k == 0) {
                            x += i;
                            y -= j;
                        } else if (k == 1) {
                            x += this.roomSize + j - 1;
                            y += i;
                        } else if (k == 2) {
                            x += i;
                            y += this.roomSize + j - 1;
                        } else {
                            x -= j;
                            y += i;
                        }
                        if (x <= 0 || y <= 0 || x >= this.colourMap.length || y >= this.colourMap[x].length || (pixel2 = this.colourMap[x][y]).getAlpha() <= 40) continue;
                        if (colour == null) {
                            colour = pixel2;
                            totalFilled = 1;
                            continue;
                        }
                        if (colour.equals(pixel2)) {
                            ++totalFilled;
                            continue;
                        }
                        if (--totalFilled > 0) continue;
                        colour = pixel2;
                        totalFilled = 1;
                    }
                }
                float proportionFilled = (float)totalFilled / (float)this.roomSize / (float)this.connectorSize;
                RoomConnectionType type2 = RoomConnectionType.WALL;
                if ((double)proportionFilled > 0.8) {
                    type2 = RoomConnectionType.ROOM_DIVIDER;
                } else if ((double)proportionFilled > 0.1) {
                    type2 = RoomConnectionType.CORRIDOR;
                }
                if (k == 0) {
                    room.up = new RoomConnection(type2, colour);
                    continue;
                }
                if (k == 1) {
                    room.right = new RoomConnection(type2, colour);
                    continue;
                }
                if (k == 2) {
                    room.down = new RoomConnection(type2, colour);
                    continue;
                }
                room.left = new RoomConnection(type2, colour);
            }
            int x = this.startRoomX + roomOffset.x * (this.roomSize + this.connectorSize) + this.roomSize + this.connectorSize / 2;
            int y = this.startRoomY + roomOffset.y * (this.roomSize + this.connectorSize) + this.roomSize + this.connectorSize / 2;
            room.fillCorner = false;
            if (x > 0 && y > 0 && x < this.colourMap.length && y < this.colourMap[x].length && (pixel = this.colourMap[x][y]).equals(room.colour)) {
                room.fillCorner = true;
            }
        }
    }

    public void loadNeighbors(RoomOffset room) {
        if (!this.roomMap.containsKey(room)) {
            this.roomMap.put(room, new Room());
        }
        for (RoomOffset neighbor : room.getNeighbors()) {
            if (this.roomMap.containsKey(neighbor)) continue;
            int x = this.startRoomX + neighbor.x * (this.roomSize + this.connectorSize);
            int y = this.startRoomY + neighbor.y * (this.roomSize + this.connectorSize);
            if (x < 0 || y < 0 || x + this.roomSize >= this.colourMap.length || y + this.roomSize >= this.colourMap[x].length || this.colourMap[x][y].getAlpha() <= 100) continue;
            this.roomMap.put(neighbor, new Room());
            this.loadNeighbors(neighbor);
        }
    }

    public void updateRoomColours() {
        for (Map.Entry<RoomOffset, Room> entry : this.roomMap.entrySet()) {
            int x = this.startRoomX + entry.getKey().x * (this.roomSize + this.connectorSize);
            int y = this.startRoomY + entry.getKey().y * (this.roomSize + this.connectorSize);
            try {
                entry.getValue().colour = this.colourMap[x][y];
            }
            catch (Exception exception) {}
        }
    }

    public void renderMap(int centerX, int centerY, Color[][] colourMap, Map<String, Vec4b> mapDecorations, int roomSizeBlocks, Set<String> actualPlayers, boolean usePlayerPositions, float partialTicks) {
        float f;
        Color c;
        int y;
        int x;
        if (!NotEnoughUpdates.INSTANCE.config.dungeonMap.dmEnable) {
            return;
        }
        if (colourMap == null) {
            return;
        }
        if (colourMap.length != 128) {
            return;
        }
        if (colourMap[0].length != 128) {
            return;
        }
        this.colourMap = colourMap;
        boolean searchForPlayers = false;
        if (System.currentTimeMillis() - this.lastClearCache > 1000L) {
            this.roomMap.clear();
            searchForPlayers = true;
            this.startRoomX = -1;
            this.startRoomY = -1;
            this.connectorSize = -1;
            this.roomSize = -1;
            this.borderRadiusCache.clear();
            this.failMap = false;
            this.lastClearCache = System.currentTimeMillis();
            this.isFloorOne = false;
            for (String line : SidebarUtil.readSidebarLines()) {
                if (!line.contains("(F1)") && !line.contains("(E)") && !line.contains("(M1)")) continue;
                this.isFloorOne = true;
                if (!line.contains("(E)")) break;
                this.isEntrance = true;
                break;
            }
        }
        if (this.failMap) {
            return;
        }
        int alphaPixels = 0;
        for (x = 0; x < 128; ++x) {
            for (y = 0; y < 128; ++y) {
                c = colourMap[x][y];
                if (c == null) {
                    return;
                }
                if (c.getAlpha() >= 50) continue;
                ++alphaPixels;
            }
        }
        if (alphaPixels < 1638) {
            this.failMap = true;
            return;
        }
        if (this.startRoomX < 0 || this.startRoomY < 0 || this.roomSize <= 0) {
            for (x = 0; x < colourMap.length; ++x) {
                block4: for (y = 0; y < colourMap[x].length; ++y) {
                    c = colourMap[x][y];
                    if (c.getAlpha() <= 80 || this.startRoomX >= 0 || this.startRoomY >= 0 || c.getRed() != 0 || c.getGreen() != 124 || c.getBlue() != 0) continue;
                    this.roomSize = 0;
                    for (int xd = 0; xd <= 20; ++xd) {
                        for (int yd = 0; yd <= 20; ++yd) {
                            if (x + xd >= colourMap.length || y + yd >= colourMap[x + xd].length) continue;
                            Color c2 = colourMap[x + xd][y + yd];
                            if (c2.getGreen() != 124 || c2.getAlpha() <= 80) {
                                if (xd < 10 && yd < 10) {
                                    continue block4;
                                }
                            } else {
                                this.roomSize = Math.max(this.roomSize, Math.min(xd + 1, yd + 1));
                            }
                            if (xd != 20 || yd != 20) continue;
                            if (this.roomSize == 0) {
                                this.roomSize = 20;
                            }
                            this.startRoomX = x;
                            this.startRoomY = y;
                        }
                    }
                }
            }
        }
        if (this.startRoomX < 0 || this.startRoomY < 0) {
            this.failMap = true;
            return;
        }
        if (this.connectorSize <= 0) {
            for (int i = 0; i < this.roomSize; ++i) {
                block8: for (int k = 0; k < 4; ++k) {
                    for (int j = 1; j < 8; ++j) {
                        int y2;
                        int x2;
                        if (k == 0) {
                            int x22 = this.startRoomX + i;
                            int y22 = this.startRoomY - j;
                        } else if (k == 1) {
                            x2 = this.startRoomX + this.roomSize + j - 1;
                            y2 = this.startRoomY + i;
                        } else if (k == 2) {
                            x2 = this.startRoomX + i;
                            y2 = this.startRoomY + this.roomSize + j - 1;
                        } else {
                            x2 = this.startRoomX - j;
                            y2 = this.startRoomY + i;
                        }
                        if (x2 <= 0 || y2 <= 0 || x2 >= colourMap.length || y2 >= colourMap[x2].length || colourMap[x2][y2].getAlpha() <= 80) continue;
                        if (j == 1) continue block8;
                        this.connectorSize = Math.min(this.connectorSize, j - 1);
                    }
                }
            }
            if (this.connectorSize <= 0) {
                this.connectorSize = 4;
            }
        }
        actualPlayers.add(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        if (searchForPlayers) {
            for (EntityPlayer player : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                AbstractClientPlayer aplayer;
                ResourceLocation skin;
                if (!(player instanceof AbstractClientPlayer) || !actualPlayers.contains(player.func_70005_c_()) || (skin = (aplayer = (AbstractClientPlayer)player).func_110306_p()) == DefaultPlayerSkin.func_177334_a((UUID)aplayer.func_110124_au())) continue;
                this.playerSkinMap.put(player.func_70005_c_(), skin);
                this.playerIdMap.put(player.func_70005_c_(), player.func_145782_y());
            }
        }
        this.playerEntityMapPositions.clear();
        if (usePlayerPositions) {
            for (String playerName : actualPlayers) {
                Entity entity;
                if (!this.playerIdMap.containsKey(playerName) || !((entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.playerIdMap.get(playerName).intValue())) instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                float roomX = (float)(player.field_70165_t + 200.0) / (float)(roomSizeBlocks + 1);
                float roomY = (float)(player.field_70161_v + 200.0) / (float)(roomSizeBlocks + 1);
                float playerRoomOffsetX = (float)Math.floor(roomX);
                float playerConnOffsetX = (float)Math.floor(roomX);
                float playerRoomOffsetY = (float)Math.floor(roomY);
                float playerConnOffsetY = (float)Math.floor(roomY);
                float roomXInBlocks = (float)(player.field_70165_t + 200.0) % (float)(roomSizeBlocks + 1);
                if (roomXInBlocks < 2.0f) {
                    playerConnOffsetX -= 0.4f - roomXInBlocks / 5.0f;
                } else if (roomXInBlocks > (float)(roomSizeBlocks - 2)) {
                    playerRoomOffsetX += 1.0f;
                    playerConnOffsetX += (roomXInBlocks - (float)(roomSizeBlocks - 2)) / 5.0f;
                } else {
                    playerRoomOffsetX += (roomXInBlocks - 2.0f) / (float)(roomSizeBlocks - 4);
                }
                f = (float)(player.field_70161_v + 200.0) % (float)(roomSizeBlocks + 1);
                if (f < 2.0f) {
                    playerConnOffsetY -= 0.4f - f / 5.0f;
                } else if (f > (float)(roomSizeBlocks - 2)) {
                    playerRoomOffsetY += 1.0f;
                    playerConnOffsetY += (f - (float)(roomSizeBlocks - 2)) / 5.0f;
                } else {
                    playerRoomOffsetY += (f - 2.0f) / (float)(roomSizeBlocks - 4);
                }
                MapPosition pos = new MapPosition(playerRoomOffsetX -= (float)(this.startRoomX / (this.roomSize + this.connectorSize)), playerConnOffsetX -= (float)(this.startRoomX / (this.roomSize + this.connectorSize)), playerRoomOffsetY -= (float)(this.startRoomY / (this.roomSize + this.connectorSize)), playerConnOffsetY -= (float)(this.startRoomY / (this.roomSize + this.connectorSize)));
                pos.rotation = (player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks) % 360.0f;
                if (pos.rotation < 0.0f) {
                    pos.rotation += 360.0f;
                }
                this.playerEntityMapPositions.put(player.func_70005_c_(), pos);
            }
        }
        this.loadNeighbors(new RoomOffset(0, 0));
        this.updateRoomColours();
        for (RoomOffset offset : this.roomMap.keySet()) {
            this.updateRoomConnections(offset);
        }
        if (this.roomMap.isEmpty()) {
            this.failMap = true;
            return;
        }
        if (mapDecorations != null && mapDecorations.size() > 0) {
            boolean different;
            ArrayList<MapPosition> positions = new ArrayList<MapPosition>();
            int decorations = 0;
            for (Vec4b vec4b : mapDecorations.values()) {
                byte id = vec4b.func_176110_a();
                if (id != 1 && id != 3) continue;
                float x3 = (float)vec4b.func_176112_b() / 2.0f + 64.0f;
                float y3 = (float)vec4b.func_176113_c() / 2.0f + 64.0f;
                if (x3 < 0.0f || y3 < 0.0f || x3 > 128.0f || y3 > 128.0f) continue;
                float deltaX = x3 - (float)this.startRoomX;
                float deltaY = y3 - (float)this.startRoomY;
                float roomsOffsetX = (int)Math.floor(deltaX / (float)(this.roomSize + this.connectorSize));
                float connOffsetX = (int)Math.floor(deltaX / (float)(this.roomSize + this.connectorSize));
                f = deltaX % (float)(this.roomSize + this.connectorSize);
                if (Math.abs(f) > (float)this.roomSize) {
                    roomsOffsetX += Math.copySign(1.0f, f);
                    connOffsetX += Math.copySign(1.0f, f) * (Math.abs(f) - (float)this.roomSize) / (float)this.connectorSize;
                } else {
                    roomsOffsetX += f / (float)this.roomSize;
                }
                if (deltaX < 0.0f && f != 0.0f) {
                    roomsOffsetX += 1.0f;
                    connOffsetX += 1.0f;
                }
                float roomsOffsetY = (int)Math.floor(deltaY / (float)(this.roomSize + this.connectorSize));
                float connOffsetY = (int)Math.floor(deltaY / (float)(this.roomSize + this.connectorSize));
                float yRemainder = deltaY % (float)(this.roomSize + this.connectorSize);
                if (Math.abs(yRemainder) > (float)this.roomSize) {
                    roomsOffsetY += Math.copySign(1.0f, yRemainder);
                    connOffsetY += Math.copySign(1.0f, yRemainder) * (Math.abs(yRemainder) - (float)this.roomSize) / (float)this.connectorSize;
                } else {
                    roomsOffsetY += yRemainder / (float)this.roomSize;
                }
                if (deltaY < 0.0f && yRemainder != 0.0f) {
                    roomsOffsetY += 1.0f;
                    connOffsetY += 1.0f;
                }
                float angle = (float)(vec4b.func_176111_d() * 360) / 16.0f;
                MapPosition pos = new MapPosition(roomsOffsetX, connOffsetX, roomsOffsetY, connOffsetY);
                pos.rotation = angle % 360.0f;
                if (pos.rotation < 0.0f) {
                    pos.rotation += 360.0f;
                }
                if (decorations++ <= 6) {
                    positions.add(pos);
                }
                this.rawPlayerMarkerMapPositions.add(pos);
            }
            boolean bl = different = this.playerMarkerMapPositions.size() != positions.size();
            if (!different) {
                for (MapPosition pos : this.playerMarkerMapPositions.values()) {
                    if (positions.contains(pos)) continue;
                    different = true;
                    break;
                }
            }
            if (different && positions.size() > 0) {
                this.lastLastDecorationsMillis = this.lastDecorationsMillis;
                this.lastDecorationsMillis = System.currentTimeMillis();
                this.playerMarkerMapPositionsLast.clear();
                for (Map.Entry<String, MapPosition> entry : this.playerMarkerMapPositions.entrySet()) {
                    this.playerMarkerMapPositionsLast.put(entry.getKey(), entry.getValue());
                }
                this.playerMarkerMapPositions.clear();
                HashSet<String> foundPlayers = new HashSet<String>();
                for (Map.Entry<String, MapPosition> entry : this.playerEntityMapPositions.entrySet()) {
                    this.playerMarkerMapPositions.put(entry.getKey(), entry.getValue());
                    this.playerMarkerMapPositionsLast.put(entry.getKey(), entry.getValue());
                    foundPlayers.add(entry.getKey());
                }
                HashMap distanceMap = new HashMap();
                for (Map.Entry<String, MapPosition> entry : this.playerMarkerMapPositionsLast.entrySet()) {
                    HashMap<Integer, Float> deltaDists = new HashMap<Integer, Float>();
                    for (int i = 0; i < positions.size(); ++i) {
                        float dx = entry.getValue().getRenderX() - ((MapPosition)positions.get(i)).getRenderX();
                        float dy = entry.getValue().getRenderY() - ((MapPosition)positions.get(i)).getRenderY();
                        deltaDists.put(i, Float.valueOf(dx * dx + dy * dy));
                    }
                    distanceMap.put(entry.getKey(), deltaDists);
                }
                ArrayList<String> playerList = new ArrayList<String>(this.playerMarkerMapPositionsLast.keySet());
                List<List<String>> playerPermutations = this.permutations(playerList);
                ArrayList finalUsedIndexes = new ArrayList();
                if (playerPermutations.size() > 0) {
                    HashMap<String, Integer> smallestPermutation = null;
                    float smallestTotalDistance = 0.0f;
                    for (List<String> list : playerPermutations) {
                        HashMap<String, Integer> usedIndexes = new HashMap<String, Integer>();
                        float totalDistance = 0.0f;
                        for (String player : list) {
                            int smallestIndex = -1;
                            float smallestDist = 0.0f;
                            for (Map.Entry entry : ((HashMap)distanceMap.get(player)).entrySet()) {
                                if (usedIndexes.containsValue(entry.getKey()) || smallestIndex != -1 && !(((Float)entry.getValue()).floatValue() < smallestDist)) continue;
                                smallestIndex = (Integer)entry.getKey();
                                smallestDist = ((Float)entry.getValue()).floatValue();
                            }
                            if (smallestIndex == -1) continue;
                            usedIndexes.put(player, smallestIndex);
                            totalDistance += smallestDist;
                        }
                        if (smallestPermutation != null && !(totalDistance < smallestTotalDistance)) continue;
                        smallestPermutation = usedIndexes;
                        smallestTotalDistance = totalDistance;
                    }
                    for (Map.Entry entry : smallestPermutation.entrySet()) {
                        finalUsedIndexes.add(entry.getValue());
                        this.playerMarkerMapPositions.put((String)entry.getKey(), (MapPosition)positions.get((Integer)entry.getValue()));
                    }
                }
                ArrayList<Integer> nonUsedIndexes = new ArrayList<Integer>();
                for (int i = 0; i < positions.size(); ++i) {
                    if (finalUsedIndexes.contains(i)) continue;
                    nonUsedIndexes.add(i);
                }
                for (String missingPlayer : actualPlayers) {
                    if (playerList.contains(missingPlayer)) continue;
                    if (!nonUsedIndexes.isEmpty()) {
                        this.playerMarkerMapPositions.put(missingPlayer, (MapPosition)positions.get((Integer)nonUsedIndexes.get(0)));
                        nonUsedIndexes.remove(0);
                        continue;
                    }
                    break;
                }
            }
        } else if (mapDecorations == null) {
            this.playerMarkerMapPositions.clear();
            this.playerMarkerMapPositionsLast.clear();
            for (Map.Entry<String, MapPosition> entry : this.playerEntityMapPositions.entrySet()) {
                this.playerMarkerMapPositions.put(entry.getKey(), entry.getValue());
            }
        }
        if (!this.roomMap.isEmpty() && this.startRoomX >= 0 && this.startRoomY >= 0) {
            this.render(centerX, centerY);
        }
        this.colourMap = colourMap;
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Load event) {
        this.colourMap = null;
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            if (!NotEnoughUpdates.INSTANCE.config.dungeonMap.dmEnable) {
                return;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74330_P || Minecraft.func_71410_x().field_71474_y.field_74321_H.func_151470_d() && (!Minecraft.func_71410_x().func_71387_A() || Minecraft.func_71410_x().field_71439_g.field_71174_a.func_175106_d().size() > 1)) {
                return;
            }
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a[8];
            boolean holdingBow = false;
            if (stack != null) {
                holdingBow |= stack.func_77973_b() == Items.field_151032_g;
                String customname = ItemUtils.getDisplayName(stack.func_77978_p());
                holdingBow |= customname != null && customname.endsWith("Arrow");
            }
            if ((holdingBow &= this.colourMap != null) || stack != null && stack.func_77973_b() instanceof ItemMap) {
                Map decorations = null;
                Color[][] colourMap = new Color[128][128];
                if (holdingBow) {
                    for (int x = 0; x < 128; ++x) {
                        for (int y = 0; y < 128; ++y) {
                            colourMap[x][y] = this.colourMap[x][y] != null ? this.colourMap[x][y] : new Color(0, true);
                        }
                    }
                } else {
                    ItemMap map2 = (ItemMap)stack.func_77973_b();
                    MapData mapData = map2.func_77873_a(stack, (World)Minecraft.func_71410_x().field_71441_e);
                    if (mapData == null) {
                        return;
                    }
                    decorations = mapData.field_76203_h;
                    for (int i = 0; i < 16384; ++i) {
                        int x = i % 128;
                        int y = i / 128;
                        int j = mapData.field_76198_e[i] & 0xFF;
                        Color c = j / 4 == 0 ? new Color((i + i / 128 & 1) * 8 + 16 << 24, true) : new Color(MapColor.field_76281_a[j / 4].func_151643_b(j & 3), true);
                        colourMap[x][y] = c;
                    }
                }
                int roomSizeBlocks = 31;
                HashSet<String> actualPlayers = new HashSet<String>();
                int players = 0;
                for (ScorePlayerTeam team : Minecraft.func_71410_x().field_71439_g.func_96123_co().func_96525_g()) {
                    if (!team.func_96669_c().startsWith("a") || team.func_96670_d().size() != 1) continue;
                    String playerName = (String)Iterables.get((Iterable)team.func_96670_d(), (int)0);
                    boolean foundPlayer = false;
                    for (EntityPlayer player : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                        if (!player.func_70005_c_().equals(playerName) || player != Minecraft.func_71410_x().field_71439_g && player.func_70608_bn()) continue;
                        actualPlayers.add(playerName);
                        foundPlayer = true;
                        break;
                    }
                    if (!foundPlayer) {
                        actualPlayers.add(playerName);
                    }
                    if (++players < 6) continue;
                    break;
                }
                Position pos = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPosition;
                int size = 80 + Math.round(40.0f * NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderSize);
                ScaledResolution scaledResolution = Utils.pushGuiScale(2);
                this.renderMap(pos.getAbsX(scaledResolution, size / 2) + size / 2, pos.getAbsY(scaledResolution, size / 2) + size / 2, colourMap, decorations, roomSizeBlocks, actualPlayers, true, event.partialTicks);
                Utils.pushGuiScale(-1);
            } else if (stack != null && Item.func_150891_b((Item)stack.func_77973_b()) == 399) {
                this.colourMap = null;
            }
        }
    }

    public List<List<String>> permutations(List<String> values) {
        ArrayList<List<String>> permutations = new ArrayList<List<String>>();
        if (values.size() == 1) {
            permutations.add(values);
            return permutations;
        }
        for (String first : values) {
            ArrayList<String> newList = new ArrayList<String>();
            for (String string : values) {
                if (string.equals(first)) continue;
                newList.add(string);
            }
            for (List list : this.permutations(newList)) {
                ArrayList<String> perm = new ArrayList<String>();
                perm.add(first);
                perm.addAll(list);
                permutations.add(perm);
            }
        }
        return permutations;
    }

    private net.minecraft.util.Matrix4f createProjectionMatrix(int width, int height) {
        net.minecraft.util.Matrix4f projMatrix = new net.minecraft.util.Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    private class MapPosition {
        public float roomOffsetX;
        public float connOffsetX;
        public float roomOffsetY;
        public float connOffsetY;
        public float rotation;

        public MapPosition(float roomOffsetX, float connOffsetX, float roomOffsetY, float connOffsetY) {
            this.roomOffsetX = roomOffsetX;
            this.connOffsetX = connOffsetX;
            this.roomOffsetY = roomOffsetY;
            this.connOffsetY = connOffsetY;
        }

        public float getRenderX() {
            return this.roomOffsetX * (float)DungeonMap.this.getRenderRoomSize() + this.connOffsetX * (float)DungeonMap.this.getRenderConnSize();
        }

        public float getRenderY() {
            return this.roomOffsetY * (float)DungeonMap.this.getRenderRoomSize() + this.connOffsetY * (float)DungeonMap.this.getRenderConnSize();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapPosition that = (MapPosition)o;
            return Float.compare(that.roomOffsetX, this.roomOffsetX) == 0 && Float.compare(that.connOffsetX, this.connOffsetX) == 0 && Float.compare(that.roomOffsetY, this.roomOffsetY) == 0 && Float.compare(that.connOffsetY, this.connOffsetY) == 0 && Float.compare(that.rotation, this.rotation) == 0;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.roomOffsetX), Float.valueOf(this.connOffsetX), Float.valueOf(this.roomOffsetY), Float.valueOf(this.connOffsetY), Float.valueOf(this.rotation));
        }
    }

    private class Room {
        Color colour = new Color(0, 0, 0, 0);
        int tickColour = 0;
        boolean fillCorner = false;
        RoomConnection left = new RoomConnection(RoomConnectionType.NONE, new Color(0, true));
        RoomConnection up = new RoomConnection(RoomConnectionType.NONE, new Color(0, true));
        RoomConnection right = new RoomConnection(RoomConnectionType.NONE, new Color(0, true));
        RoomConnection down = new RoomConnection(RoomConnectionType.NONE, new Color(0, true));

        private Room() {
        }

        public void renderNoRotate(int roomSize, int connectorSize, int rotation) {
            if (this.tickColour != 0) {
                Color tick = new Color(this.tickColour, true);
                ResourceLocation indicatorTex = null;
                if (tick.getRed() == 255 && tick.getGreen() == 255 && tick.getBlue() == 255) {
                    indicatorTex = WHITE_CHECK;
                } else if (tick.getRed() == 0 && tick.getGreen() == 124 && tick.getBlue() == 0) {
                    indicatorTex = GREEN_CHECK;
                } else if (tick.getRed() == 13 && tick.getGreen() == 13 && tick.getBlue() == 13) {
                    indicatorTex = QUESTION;
                } else if (tick.getRed() == 255 && tick.getGreen() == 0 && tick.getBlue() == 0) {
                    indicatorTex = CROSS;
                }
                if (indicatorTex != null) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(indicatorTex);
                    float x = 0.0f;
                    float y = 0.0f;
                    if (NotEnoughUpdates.INSTANCE.config.dungeonMap.dmCenterCheck) {
                        if (this.fillCorner) {
                            x = (float)((double)x + (double)((float)(-(roomSize + connectorSize)) / 2.0f) * Math.cos(Math.toRadians(rotation - 45)) * (double)1.414f);
                            y = (float)((double)y + (double)((float)(roomSize + connectorSize) / 2.0f) * Math.sin(Math.toRadians(rotation - 45)) * 1.414);
                        }
                        if (this.down.type == RoomConnectionType.ROOM_DIVIDER && this.right.type != RoomConnectionType.ROOM_DIVIDER) {
                            x = (float)((double)x + (double)((float)(-(roomSize + connectorSize)) / 2.0f) * Math.sin(Math.toRadians(rotation)));
                            y = (float)((double)y + (double)((float)(-(roomSize + connectorSize)) / 2.0f) * Math.cos(Math.toRadians(rotation)));
                        } else if (this.down.type != RoomConnectionType.ROOM_DIVIDER && this.right.type == RoomConnectionType.ROOM_DIVIDER) {
                            x = (float)((double)x + (double)((float)(-(roomSize + connectorSize)) / 2.0f) * Math.cos(Math.toRadians(rotation)));
                            y = (float)((double)y + (double)((float)(roomSize + connectorSize) / 2.0f) * Math.sin(Math.toRadians(rotation)));
                        }
                    }
                    GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                    if (!NotEnoughUpdates.INSTANCE.config.dungeonMap.dmOrientCheck) {
                        GlStateManager.func_179114_b((float)(-rotation + 180), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)NotEnoughUpdates.INSTANCE.config.dungeonMap.dmIconScale, (float)NotEnoughUpdates.INSTANCE.config.dungeonMap.dmIconScale, (float)1.0f);
                    Utils.drawTexturedRect(-5.0f, -5.0f, 10.0f, 10.0f, 9728);
                    GlStateManager.func_179121_F();
                    if (!NotEnoughUpdates.INSTANCE.config.dungeonMap.dmOrientCheck) {
                        GlStateManager.func_179114_b((float)(rotation - 180), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
                }
            }
        }

        public void render(int roomSize, int connectorSize) {
            ResourceLocation roomTex = null;
            if (this.colour.getRed() == 114 && this.colour.getGreen() == 67 && this.colour.getBlue() == 27) {
                roomTex = ROOM_BROWN;
            } else if (this.colour.getRed() == 65 && this.colour.getGreen() == 65 && this.colour.getBlue() == 65) {
                roomTex = ROOM_GRAY;
            } else if (this.colour.getRed() == 0 && this.colour.getGreen() == 124 && this.colour.getBlue() == 0) {
                roomTex = ROOM_GREEN;
            } else if (this.colour.getRed() == 242 && this.colour.getGreen() == 127 && this.colour.getBlue() == 165) {
                roomTex = ROOM_PINK;
            } else if (this.colour.getRed() == 178 && this.colour.getGreen() == 76 && this.colour.getBlue() == 216) {
                roomTex = ROOM_PURPLE;
            } else if (this.colour.getRed() == 255 && this.colour.getGreen() == 0 && this.colour.getBlue() == 0) {
                roomTex = ROOM_RED;
            } else if (this.colour.getRed() == 229 && this.colour.getGreen() == 229 && this.colour.getBlue() == 51) {
                roomTex = ROOM_YELLOW;
            } else if (this.colour.getRed() == 216 && this.colour.getGreen() == 127 && this.colour.getBlue() == 51) {
                roomTex = ROOM_ORANGE;
            }
            if (roomTex != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(roomTex);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(0.0f, 0.0f, roomSize, roomSize, 9729);
            } else {
                Gui.func_73734_a((int)0, (int)0, (int)roomSize, (int)roomSize, (int)this.colour.getRGB());
            }
            if (this.fillCorner) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CORNER_BROWN);
                Utils.drawTexturedRect(roomSize, roomSize, connectorSize, connectorSize, 9728);
            }
            for (int k = 0; k < 2; ++k) {
                RoomConnection connection = this.down;
                if (k == 1) {
                    connection = this.right;
                }
                if (connection.type == RoomConnectionType.NONE || connection.type == RoomConnectionType.WALL) continue;
                ResourceLocation corridorTex = null;
                if (connection.colour.getRed() == 114 && connection.colour.getGreen() == 67 && connection.colour.getBlue() == 27) {
                    corridorTex = connection.type == RoomConnectionType.CORRIDOR ? CORRIDOR_BROWN : DIVIDER_BROWN;
                } else if (connection.colour.getRed() == 65 && connection.colour.getGreen() == 65 && connection.colour.getBlue() == 65) {
                    corridorTex = CORRIDOR_GRAY;
                } else if (connection.colour.getRed() == 0 && connection.colour.getGreen() == 124 && connection.colour.getBlue() == 0) {
                    corridorTex = CORRIDOR_GREEN;
                } else if (connection.colour.getRed() == 242 && connection.colour.getGreen() == 127 && connection.colour.getBlue() == 165) {
                    corridorTex = CORRIDOR_PINK;
                } else if (connection.colour.getRed() == 178 && connection.colour.getGreen() == 76 && connection.colour.getBlue() == 216) {
                    corridorTex = CORRIDOR_PURPLE;
                } else if (connection.colour.getRed() == 255 && connection.colour.getGreen() == 0 && connection.colour.getBlue() == 0) {
                    corridorTex = CORRIDOR_RED;
                } else if (connection.colour.getRed() == 229 && connection.colour.getGreen() == 229 && connection.colour.getBlue() == 51) {
                    corridorTex = CORRIDOR_YELLOW;
                } else if (connection.colour.getRed() == 216 && connection.colour.getGreen() == 127 && connection.colour.getBlue() == 51) {
                    corridorTex = CORRIDOR_ORANGE;
                }
                if (corridorTex == null) {
                    int xOffset = 0;
                    int yOffset = 0;
                    int width = 0;
                    int height = 0;
                    if (connection == this.right) {
                        xOffset = roomSize;
                        width = connectorSize;
                        height = roomSize;
                        if (connection.type == RoomConnectionType.CORRIDOR) {
                            height = 8;
                            yOffset += 4;
                        }
                    } else if (connection == this.down) {
                        yOffset = roomSize;
                        width = roomSize;
                        height = connectorSize;
                        if (connection.type == RoomConnectionType.CORRIDOR) {
                            width = 8;
                            xOffset += 4;
                        }
                    }
                    Gui.func_73734_a((int)xOffset, (int)yOffset, (int)(xOffset + width), (int)(yOffset + height), (int)connection.colour.getRGB());
                    continue;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(corridorTex);
                GlStateManager.func_179094_E();
                if (connection == this.right) {
                    GlStateManager.func_179109_b((float)((float)roomSize / 2.0f), (float)((float)roomSize / 2.0f), (float)0.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)((float)(-roomSize) / 2.0f), (float)((float)(-roomSize) / 2.0f), (float)0.0f);
                }
                Utils.drawTexturedRect(0.0f, roomSize, roomSize, connectorSize, 9728);
                GlStateManager.func_179121_F();
            }
        }
    }

    private static class RoomConnection {
        RoomConnectionType type;
        Color colour;

        public RoomConnection(RoomConnectionType type2, Color colour) {
            this.type = type2;
            this.colour = colour;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoomConnection that = (RoomConnection)o;
            return this.type == that.type && Objects.equals(this.colour, that.colour);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.colour});
        }
    }

    private static enum RoomConnectionType {
        NONE,
        WALL,
        CORRIDOR,
        ROOM_DIVIDER;

    }

    private static class RoomOffset {
        int x;
        int y;

        public RoomOffset(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public RoomOffset left() {
            return new RoomOffset(this.x - 1, this.y);
        }

        public RoomOffset right() {
            return new RoomOffset(this.x + 1, this.y);
        }

        public RoomOffset up() {
            return new RoomOffset(this.x, this.y - 1);
        }

        public RoomOffset down() {
            return new RoomOffset(this.x, this.y + 1);
        }

        public RoomOffset[] getNeighbors() {
            return new RoomOffset[]{this.left(), this.right(), this.up(), this.down()};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoomOffset that = (RoomOffset)o;
            return this.x == that.x && this.y == that.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }
}

