/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.dungeons;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;

public class DungeonBlocks {
    private static Framebuffer framebufferBlocksTo = null;
    private static Framebuffer framebufferBlocksFrom = null;
    private static final HashMap<String, Framebuffer> framebuffersDynamicTo = new HashMap();
    public static HashMap<String, Framebuffer> framebuffersDynamicFrom = new HashMap();
    private static final HashSet<String> dynamicUpdated = new HashSet();
    private static final FloatBuffer projectionMatrixOld = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer modelviewMatrixOld = BufferUtils.createFloatBuffer((int)16);
    private static final HashMap<ResourceLocation, String> dynamicPreloadMap = new HashMap<ResourceLocation, String>(){
        {
            this.put(new ResourceLocation("textures/entity/bat.png"), NotEnoughUpdates.INSTANCE.config.dungeons.dungBatColour);
            this.put(new ResourceLocation("textures/entity/chest/normal.png"), NotEnoughUpdates.INSTANCE.config.dungeons.dungChestColour);
            this.put(new ResourceLocation("textures/entity/chest/normal_double.png"), NotEnoughUpdates.INSTANCE.config.dungeons.dungChestColour);
            this.put(new ResourceLocation("textures/entity/chest/trapped.png"), NotEnoughUpdates.INSTANCE.config.dungeons.dungTrappedChestColour);
            this.put(new ResourceLocation("textures/entity/chest/trapped_double.png"), NotEnoughUpdates.INSTANCE.config.dungeons.dungTrappedChestColour);
        }
    };

    public static boolean textureExists() {
        return framebufferBlocksFrom != null && DungeonBlocks.isOverriding();
    }

    public static void bindTextureIfExists() {
        if (DungeonBlocks.textureExists()) {
            framebufferBlocksFrom.func_147612_c();
        }
    }

    public static boolean isOverriding() {
        return OpenGlHelper.func_148822_b() && NotEnoughUpdates.INSTANCE.config.dungeons.enableDungBlockOverlay && (NotEnoughUpdates.INSTANCE.config.dungeons.dungeonBlocksEverywhere || SBInfo.getInstance().getLocation() != null && SBInfo.getInstance().getLocation().equals("dungeon"));
    }

    public static boolean bindModifiedTexture(ResourceLocation location, int colour) {
        if (!DungeonBlocks.isOverriding()) {
            return false;
        }
        if (Utils.disableCustomDungColours) {
            return false;
        }
        if ((colour >> 24 & 0xFF) < 10) {
            return false;
        }
        String id = location.func_110624_b() + ":" + location.func_110623_a();
        if (dynamicUpdated.contains(id) && framebuffersDynamicFrom.containsKey(id)) {
            framebuffersDynamicFrom.get(id).func_147612_c();
            return true;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        Framebuffer to = DungeonBlocks.checkFramebufferSizes(framebuffersDynamicTo.get(id), w, h);
        dynamicUpdated.add(id);
        try {
            GL11.glGetFloat((int)2983, (FloatBuffer)projectionMatrixOld);
            GL11.glGetFloat((int)2982, (FloatBuffer)modelviewMatrixOld);
            GL11.glPushMatrix();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)w, (double)h, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            to.func_147610_a(true);
            GlStateManager.func_179082_a((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179086_m((int)16384);
            GlStateManager.func_179084_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRectNoBlend(0.0f, 0.0f, w, h, 0.0f, 1.0f, 1.0f, 0.0f, 9729);
            GlStateManager.func_179147_l();
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            Utils.drawRectNoBlend(0, 0, w, h, colour);
            GL11.glPopMatrix();
            to.func_147612_c();
            if (Minecraft.func_71410_x().field_71474_y.field_151442_I >= 0) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)Minecraft.func_71410_x().field_71474_y.field_151442_I);
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                GL11.glTexParameterf((int)3553, (int)33083, (float)Minecraft.func_71410_x().field_71474_y.field_151442_I);
                GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                GL30.glGenerateMipmap((int)3553);
            }
            GlStateManager.func_179128_n((int)5889);
            GL11.glLoadMatrix((FloatBuffer)projectionMatrixOld);
            GlStateManager.func_179128_n((int)5888);
            GL11.glLoadMatrix((FloatBuffer)modelviewMatrixOld);
            Framebuffer from = DungeonBlocks.checkFramebufferSizes(framebuffersDynamicFrom.get(id), w, h);
            framebuffersDynamicFrom.put(id, to);
            framebuffersDynamicTo.put(id, from);
            to.func_147612_c();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            return false;
        }
    }

    public static void tick() {
        if (!DungeonBlocks.isOverriding() || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        dynamicUpdated.clear();
        for (Map.Entry<ResourceLocation, String> entry : dynamicPreloadMap.entrySet()) {
            DungeonBlocks.bindModifiedTexture(entry.getKey(), SpecialColour.specialToChromaRGB(entry.getValue()));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        Framebuffer to = DungeonBlocks.checkFramebufferSizes(framebufferBlocksTo, w, h);
        try {
            GL11.glPushMatrix();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)w, (double)h, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            to.func_147610_a(true);
            GlStateManager.func_179086_m((int)16384);
            GlStateManager.func_179084_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRectNoBlend(0.0f, 0.0f, w, h, 0.0f, 1.0f, 1.0f, 0.0f, 9729);
            HashMap<TextureAtlasSprite, Integer> spriteMap = new HashMap<TextureAtlasSprite, Integer>(){
                {
                    this.put(Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/stonebrick_cracked"), SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeons.dungCrackedColour));
                    this.put(Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/dispenser_front_horizontal"), SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeons.dungDispenserColour));
                    this.put(Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/lever"), SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeons.dungLeverColour));
                    this.put(Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/trip_wire"), SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.dungeons.dungTripWireColour));
                }
            };
            for (Map.Entry entry : spriteMap.entrySet()) {
                if (((Integer)entry.getValue() >> 24 & 0xFF) < 10) continue;
                TextureAtlasSprite tas = (TextureAtlasSprite)entry.getKey();
                Gui.func_73734_a((int)((int)((float)w * tas.func_94209_e())), (int)(h - (int)((float)h * tas.func_94210_h()) - 1), (int)((int)((float)w * tas.func_94212_f()) + 1), (int)(h - (int)((float)h * tas.func_94206_g())), (int)((Integer)entry.getValue()));
            }
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glPopMatrix();
            to.func_147612_c();
            if (Minecraft.func_71410_x().field_71474_y.field_151442_I >= 0) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)Minecraft.func_71410_x().field_71474_y.field_151442_I);
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                GL11.glTexParameterf((int)3553, (int)33083, (float)Minecraft.func_71410_x().field_71474_y.field_151442_I);
                GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                GL30.glGenerateMipmap((int)3553);
            }
            Framebuffer from = DungeonBlocks.checkFramebufferSizes(framebufferBlocksFrom, w, h);
            framebufferBlocksFrom = to;
            framebufferBlocksTo = from;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        GlStateManager.func_179147_l();
    }

    private static Framebuffer checkFramebufferSizes(Framebuffer framebuffer, int width, int height) {
        if (framebuffer == null || framebuffer.field_147621_c != width || framebuffer.field_147618_d != height) {
            if (framebuffer == null) {
                framebuffer = new Framebuffer(width, height, false);
                framebuffer.field_147625_i[0] = 1.0f;
                framebuffer.field_147625_i[1] = 0.0f;
                framebuffer.field_147625_i[2] = 0.0f;
                framebuffer.field_147625_i[3] = 0.0f;
            } else {
                framebuffer.func_147613_a(width, height);
            }
            framebuffer.func_147607_a(9728);
        }
        return framebuffer;
    }
}

