/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate;

import io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate.ExitHookInvoker;
import io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate.UpdateContext;
import io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate.UpdateData;
import io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate.UpdateException;
import io.github.moulberry.notenoughupdates.deps.moe.nea.libautoupdate.UpdateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class PotentialUpdate {
    private final UpdateData update;
    private final UpdateContext context;
    private final UUID updateUUID = UUID.randomUUID();

    public File getUpdateDirectory() {
        return new File(".autoupdates", this.context.getIdentifier() + "/" + this.updateUUID);
    }

    public boolean isUpdateAvailable() {
        if (this.update == null) {
            return false;
        }
        return this.context.getCurrentVersion().isOlderThan(this.update.getVersionNumber());
    }

    private File getFile(String name) {
        this.getUpdateDirectory().mkdirs();
        return new File(this.getUpdateDirectory(), name);
    }

    public File getUpdateJarStorage() {
        return this.getFile("next.jar");
    }

    public String getFileName() throws MalformedURLException {
        String[] split = this.update.getDownloadAsURL().getPath().split("/");
        return split[split.length - 1];
    }

    public void extractUpdater() throws IOException {
        File file = this.getFile("updater.jar");
        try (InputStream from = this.getClass().getResourceAsStream("/updater.jar");
             FileOutputStream to = new FileOutputStream(file);){
            UpdateUtils.connect(from, to);
        }
    }

    public void downloadUpdate() throws IOException {
        try (InputStream from = UpdateUtils.openUrlConnection(this.update.getDownloadAsURL());
             FileOutputStream to = new FileOutputStream(this.getUpdateJarStorage());){
            UpdateUtils.connect(from, to);
        }
        try (FileInputStream check = new FileInputStream(this.getUpdateJarStorage());){
            String updateSha = UpdateUtils.sha256sum(check);
            if (this.update.getSha256() != null && !this.update.getSha256().equalsIgnoreCase(updateSha)) {
                throw new UpdateException("Hash of downloaded file " + this.getUpdateJarStorage() + " (" + updateSha + ") does not match expected hash of " + this.update.getSha256());
            }
        }
    }

    public void prepareUpdate() throws IOException {
        this.extractUpdater();
        this.downloadUpdate();
    }

    public void executeUpdate() throws IOException {
        this.prepareUpdate();
        this.executePreparedUpdate();
    }

    public void executePreparedUpdate() {
        ExitHookInvoker.setExitHook(this.getContext().getIdentifier(), this.getUpdateUUID(), this.getFile("updater.jar"), this.context.getTarget().generateUpdateActions(this));
    }

    public CompletableFuture<Void> launchUpdate() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.executeUpdate();
            }
            catch (IOException e2) {
                throw new CompletionException(e2);
            }
            return null;
        });
    }

    public PotentialUpdate(UpdateData update, UpdateContext context) {
        this.update = update;
        this.context = context;
    }

    public UpdateData getUpdate() {
        return this.update;
    }

    public UpdateContext getContext() {
        return this.context;
    }

    public UUID getUpdateUUID() {
        return this.updateUUID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PotentialUpdate)) {
            return false;
        }
        PotentialUpdate other = (PotentialUpdate)o;
        UpdateData this$update = this.getUpdate();
        UpdateData other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !((Object)this$update).equals(other$update)) {
            return false;
        }
        UpdateContext this$context = this.getContext();
        UpdateContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        UUID this$updateUUID = this.getUpdateUUID();
        UUID other$updateUUID = other.getUpdateUUID();
        return !(this$updateUUID == null ? other$updateUUID != null : !((Object)this$updateUUID).equals(other$updateUUID));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        UpdateData $update = this.getUpdate();
        result2 = result2 * 59 + ($update == null ? 43 : ((Object)$update).hashCode());
        UpdateContext $context = this.getContext();
        result2 = result2 * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        UUID $updateUUID = this.getUpdateUUID();
        result2 = result2 * 59 + ($updateUUID == null ? 43 : ((Object)$updateUUID).hashCode());
        return result2;
    }

    public String toString() {
        return "PotentialUpdate(update=" + this.getUpdate() + ", context=" + this.getContext() + ", updateUUID=" + this.getUpdateUUID() + ")";
    }
}

