/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.GuiTextures;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Warnings {
    public static boolean isDevEnv = false;
    public static boolean shouldWarn = Boolean.getBoolean("moulconfig.warn") || isDevEnv;
    public static Logger logger = LogManager.getLogManager().getLogger("MoulConfig");
    public static String basePackage = GuiTextures.class.getPackage().getName() + ".";
    public static String testPackage = basePackage + "test.";
    public static HashSet<Object> warnedObjects = new HashSet();

    public static void warnOnce(String warningText, Object ... warningBucketEntries) {
        if (!shouldWarn) {
            return;
        }
        List<Object> warningBucket = Arrays.asList(warningBucketEntries);
        if (warnedObjects.contains(warningBucket)) {
            return;
        }
        warnedObjects.add(warningBucket);
        Warnings.warn0(warningText, 3);
    }

    private static void warn0(String warningText, int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        StackTraceElement modCall = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (i++ < depth || stackTraceElement.getClassName().startsWith(basePackage) && !stackTraceElement.getClassName().startsWith(testPackage)) continue;
            modCall = stackTraceElement;
            break;
        }
        logger.warning("Warning: " + warningText + " at " + stackTrace[depth] + " called by " + modCall);
    }

    public static void warn(String warningText) {
        if (shouldWarn) {
            Warnings.warn0(warningText, 3);
        }
    }
}

