/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.component;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IFontRenderer;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.RenderContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiComponent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiImmediateContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.KeyboardEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.MouseEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.observer.GetSetter;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/component/CollapsibleComponent;", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/GuiComponent;", "title", "Ljava/util/function/Supplier;", "body", "collapsedState", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;", "", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;)V", "getBody", "()Ljava/util/function/Supplier;", "getCollapsedState", "()Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;", "getTitle", "getHeight", "", "getWidth", "keyboardEvent", "", "event", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/KeyboardEvent;", "context", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/GuiImmediateContext;", "mouseEvent", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/MouseEvent;", "render", "Companion", "common"})
public final class CollapsibleComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<GuiComponent> title;
    @NotNull
    private final Supplier<GuiComponent> body;
    @NotNull
    private final GetSetter<Boolean> collapsedState;
    @NotNull
    private static final IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
    private static final int padding = 2;
    private static final int trim = 3;
    @NotNull
    private static final String rightTriangle = "\u25b6";
    private static final int rightSize = fr.getStringWidth(rightTriangle);
    @NotNull
    private static final String bottomTriangle = "\u25bc";
    private static final int bottomSize = fr.getStringWidth(bottomTriangle);
    private static final int bottomOffset = RangesKt.coerceAtLeast((int)(rightSize - bottomSize), (int)0) / 2;
    private static final int rightOffset = RangesKt.coerceAtLeast((int)(bottomSize - rightSize), (int)0) / 2;
    private static final int iconWidth = Math.max(rightSize, bottomSize);

    public CollapsibleComponent(@NotNull Supplier<GuiComponent> title, @NotNull Supplier<GuiComponent> body, @NotNull GetSetter<Boolean> collapsedState) {
        Intrinsics.checkNotNullParameter(title, (String)"title");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter(collapsedState, (String)"collapsedState");
        this.title = title;
        this.body = body;
        this.collapsedState = collapsedState;
    }

    public /* synthetic */ CollapsibleComponent(Supplier supplier, Supplier supplier2, GetSetter getSetter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            GetSetter<Boolean> getSetter2 = GetSetter.floating(true);
            Intrinsics.checkNotNullExpressionValue(getSetter2, (String)"floating(true)");
            getSetter = getSetter2;
        }
        this(supplier, supplier2, getSetter);
    }

    @NotNull
    public final Supplier<GuiComponent> getTitle() {
        return this.title;
    }

    @NotNull
    public final Supplier<GuiComponent> getBody() {
        return this.body;
    }

    @NotNull
    public final GetSetter<Boolean> getCollapsedState() {
        return this.collapsedState;
    }

    @Override
    public int getWidth() {
        return Math.max(this.title.get().getWidth() + padding + iconWidth, this.body.get().getWidth());
    }

    @Override
    public int getHeight() {
        Boolean bl = this.collapsedState.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"collapsedState.get()");
        return bl != false ? Math.max(this.title.get().getHeight(), fr.getHeight()) : Math.max(this.title.get().getHeight(), fr.getHeight()) + trim + this.body.get().getHeight();
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Boolean collapsed = this.collapsedState.get();
        RenderContext renderContext = context.getRenderContext();
        Intrinsics.checkNotNullExpressionValue((Object)collapsed, (String)"collapsed");
        renderContext.drawString(fr, collapsed != false ? rightTriangle : bottomTriangle, collapsed != false ? rightOffset : bottomOffset, 0, -1, false);
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(iconWidth, 0.0f, 0.0f);
        this.title.get().render(context.translated(iconWidth, 0, context.getWidth() - iconWidth, barHeight));
        context.getRenderContext().popMatrix();
        if (!collapsed.booleanValue()) {
            context.getRenderContext().drawColoredRect(0.0f, (float)barHeight + 1.0f, context.getWidth(), (float)barHeight + 2.0f, -16777216);
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(0.0f, barHeight, 0.0f);
            this.body.get().render(context.translated(0, barHeight, context.getWidth(), context.getHeight() - barHeight));
            context.getRenderContext().popMatrix();
        }
    }

    @Override
    public void mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        if (mouseEvent instanceof MouseEvent.Click && context.translated(0, 0, context.getWidth(), barHeight).isHovered()) {
            if (((MouseEvent.Click)mouseEvent).getMouseState()) {
                this.collapsedState.set(this.collapsedState.get() == false);
            }
            return;
        }
        this.title.get().mouseEvent(mouseEvent, context.translated(iconWidth, 0, context.getWidth() - iconWidth, barHeight));
        this.body.get().mouseEvent(mouseEvent, context.translated(0, barHeight, context.getWidth(), context.getHeight() - barHeight));
    }

    @Override
    public void keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        this.title.get().keyboardEvent(event, context.translated(iconWidth, 0, context.getWidth() - iconWidth, barHeight));
        this.body.get().keyboardEvent(event, context.translated(0, barHeight, context.getWidth(), context.getHeight() - barHeight));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/component/CollapsibleComponent$Companion;", "", "()V", "bottomOffset", "", "getBottomOffset", "()I", "bottomSize", "getBottomSize", "bottomTriangle", "", "getBottomTriangle", "()Ljava/lang/String;", "fr", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/common/IFontRenderer;", "getFr", "()Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/common/IFontRenderer;", "iconWidth", "getIconWidth", "padding", "getPadding", "rightOffset", "getRightOffset", "rightSize", "getRightSize", "rightTriangle", "getRightTriangle", "trim", "getTrim", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IFontRenderer getFr() {
            return fr;
        }

        public final int getPadding() {
            return padding;
        }

        public final int getTrim() {
            return trim;
        }

        @NotNull
        public final String getRightTriangle() {
            return rightTriangle;
        }

        public final int getRightSize() {
            return rightSize;
        }

        @NotNull
        public final String getBottomTriangle() {
            return bottomTriangle;
        }

        public final int getBottomSize() {
            return bottomSize;
        }

        public final int getBottomOffset() {
            return bottomOffset;
        }

        public final int getRightOffset() {
            return rightOffset;
        }

        public final int getIconWidth() {
            return iconWidth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

