/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.cosmetics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class ShaderManager
implements IResourceManagerReloadListener {
    private final ResourceLocation shaderLocation = new ResourceLocation("notenoughupdates:shaders");
    private final HashMap<String, Shader> shaderMap = new HashMap();
    private static final ShaderManager INSTANCE = new ShaderManager();

    public static ShaderManager getInstance() {
        return INSTANCE;
    }

    public void func_110549_a(IResourceManager iResourceManager) {
        this.shaderMap.values().forEach(it -> GL20.glDeleteProgram((int)it.program));
        this.shaderMap.clear();
    }

    public int getShader(String name) {
        if (!this.shaderMap.containsKey(name)) {
            this.reloadShader(name);
        }
        return this.shaderMap.get((Object)name).program;
    }

    public int loadShader(String name) {
        if (!this.shaderMap.containsKey(name)) {
            this.reloadShader(name);
        }
        GL20.glUseProgram((int)this.shaderMap.get((Object)name).program);
        return this.shaderMap.get((Object)name).program;
    }

    public void loadData(String name, String var, Object value) {
        int location = GL20.glGetUniformLocation((int)this.shaderMap.get((Object)name).program, (CharSequence)var);
        if (value instanceof Integer) {
            GL20.glUniform1i((int)location, (int)((Integer)value));
        } else if (value instanceof Float) {
            GL20.glUniform1f((int)location, (float)((Float)value).floatValue());
        } else if (value instanceof Vector2f) {
            Vector2f vec = (Vector2f)value;
            GL20.glUniform2f((int)location, (float)vec.x, (float)vec.y);
        } else if (value instanceof Vector3f) {
            Vector3f vec = (Vector3f)value;
            GL20.glUniform3f((int)location, (float)vec.x, (float)vec.y, (float)vec.z);
        } else if (value instanceof Vector4f) {
            Vector4f vec = (Vector4f)value;
            GL20.glUniform4f((int)location, (float)vec.x, (float)vec.y, (float)vec.z, (float)vec.w);
        } else {
            throw new UnsupportedOperationException("Failed to load data into shader: Unsupported data type.");
        }
    }

    private void reloadShader(String name) {
        int vertex = -1;
        String sourceVert = this.getShaderSource(name, 35633);
        if (!sourceVert.isEmpty()) {
            vertex = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vertex, (CharSequence)sourceVert);
            GL20.glCompileShader((int)vertex);
            if (GL20.glGetShaderi((int)vertex, (int)35713) == 0) {
                System.err.println(GL20.glGetShaderInfoLog((int)vertex, (int)100));
            }
        }
        int fragment = -1;
        String sourceFrag = this.getShaderSource(name, 35632);
        if (!sourceFrag.isEmpty()) {
            fragment = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fragment, (CharSequence)sourceFrag);
            GL20.glCompileShader((int)fragment);
            if (GL20.glGetShaderi((int)fragment, (int)35713) == 0) {
                System.err.println(GL20.glGetShaderInfoLog((int)fragment, (int)100));
            }
        }
        int compute = -1;
        String sourceCompute = this.getShaderSource(name, 37305);
        if (!sourceCompute.isEmpty()) {
            compute = GL20.glCreateShader((int)37305);
            GL20.glShaderSource((int)compute, (CharSequence)sourceCompute);
            GL20.glCompileShader((int)compute);
            if (GL20.glGetShaderi((int)compute, (int)35713) == 0) {
                System.err.println(GL20.glGetShaderInfoLog((int)compute, (int)100));
            }
        }
        int program = GL20.glCreateProgram();
        if (vertex != -1) {
            GL20.glAttachShader((int)program, (int)vertex);
        }
        if (fragment != -1) {
            GL20.glAttachShader((int)program, (int)fragment);
        }
        if (compute != -1) {
            GL20.glAttachShader((int)program, (int)compute);
        }
        GL20.glLinkProgram((int)program);
        if (vertex != -1) {
            GL20.glDeleteShader((int)vertex);
        }
        if (fragment != -1) {
            GL20.glDeleteShader((int)fragment);
        }
        if (compute != -1) {
            GL20.glDeleteShader((int)compute);
        }
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            System.err.println(GL20.glGetProgramInfoLog((int)program, (int)100));
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35715) == 0) {
            System.err.println(GL20.glGetProgramInfoLog((int)program, (int)100));
        }
        this.shaderMap.put(name, new Shader(program));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getShaderSource(String name, int type2) {
        String ext = "";
        if (type2 == 35633) {
            ext = ".vert";
        } else if (type2 == 35632) {
            ext = ".frag";
        } else {
            if (type2 != 37305) return "";
            ext = ".compute";
        }
        ResourceLocation location = new ResourceLocation(this.shaderLocation.func_110624_b(), this.shaderLocation.func_110623_a() + "/" + name + ext);
        try (InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();){
            String line;
            StringBuilder source = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                source.append(line).append("\n");
            }
            String string = source.toString();
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static class Shader {
        public final int program;

        public Shader(int program) {
            this.program = program;
        }
    }
}

