/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.cosmetics;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.cosmetics.CapeManager;
import io.github.moulberry.notenoughupdates.cosmetics.CapeNode;
import io.github.moulberry.notenoughupdates.cosmetics.ShaderManager;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL43;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class NEUCape {
    private int currentFrame = 0;
    private int displayFrame = 0;
    private String capeName;
    public ResourceLocation[] capeTextures = null;
    private long lastFrameUpdate = 0L;
    private static final int ANIM_MODE_LOOP = 0;
    private static final int ANIM_MODE_PINGPONG = 1;
    private final int animMode = 0;
    private CapeNode[] nodes = null;
    private final Random random = new Random();
    private long eventMillis;
    private float dvdPositionX = 100.0f;
    private float dvdPositionY = 100.0f;
    private float dvdVelocityX = -10.0f;
    private float dvdVelocityY = 10.0f;
    private float eventLength;
    private float eventRandom;
    private static final double vertOffset = 1.4;
    private static final double shoulderLength = 0.24;
    private static final double shoulderWidth = 0.13;
    public static final int HORZ_NODES = 6;
    public static final int VERT_NODES = 22;
    public static float targetDist = 0.05f;
    private EntityPlayer currentPlayer;
    private boolean keepCurrentPlayer = false;
    private String shaderName = "cape";
    long lastRender = 0L;
    private double deltaAngleAccum;
    private double oldPlayerAngle;
    private int crouchTicks = 0;
    long startTime = 0L;
    private int ssbo = -1;
    private static WorldRenderer sphereVBO = null;

    public NEUCape(String capeName) {
        this.setCapeTexture(capeName);
    }

    public void setCapeTexture(String capeName) {
        if (this.capeName != null && this.capeName.equalsIgnoreCase(capeName)) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        boolean defaultBehaviour = true;
        if (NotEnoughUpdates.INSTANCE.config.hidden.disableBrokenCapes && capeName.equals("negative")) {
            defaultBehaviour = false;
            this.capeName = "fade";
            this.shaderName = "fade_cape";
        }
        if (defaultBehaviour) {
            this.capeName = capeName;
            this.shaderName = capeName.equalsIgnoreCase("fade") ? "fade_cape" : (capeName.equalsIgnoreCase("space") ? "space_cape" : (capeName.equalsIgnoreCase("mcworld") ? "mcworld_cape" : (capeName.equalsIgnoreCase("lava") || capeName.equalsIgnoreCase("skyclient") ? "lava_cape" : (capeName.equalsIgnoreCase("lightning") ? "lightning_cape" : (capeName.equalsIgnoreCase("thebakery") ? "biscuit_cape" : (capeName.equalsIgnoreCase("negative") ? "negative" : (capeName.equalsIgnoreCase("void") ? "void" : (capeName.equalsIgnoreCase("tunnel") ? "tunnel" : (capeName.equalsIgnoreCase("planets") ? "planets" : (capeName.equalsIgnoreCase("screensaver") ? "screensaver" : "shiny_cape"))))))))));
        }
        ResourceLocation staticCapeTex = new ResourceLocation("notenoughupdates:capes/" + capeName + ".png");
        this.capeTextures = new ResourceLocation[1];
        this.capeTextures[0] = staticCapeTex;
    }

    private void bindTexture() {
        if (this.capeName.equalsIgnoreCase("negative")) {
            CapeManager.getInstance().updateWorldFramebuffer = true;
            if (CapeManager.getInstance().backgroundFramebuffer != null) {
                CapeManager.getInstance().backgroundFramebuffer.func_147612_c();
            }
        } else if (this.capeTextures != null && this.capeTextures.length > 0) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastFrameUpdate > 100L) {
                this.lastFrameUpdate = currentTime / 100L * 100L;
                ++this.currentFrame;
                this.currentFrame %= this.capeTextures.length;
                this.displayFrame = this.currentFrame;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.capeTextures[this.displayFrame]);
        }
    }

    private CapeNode getNode(int x, int y) {
        return this.nodes[x + y * 6];
    }

    public void createCapeNodes(EntityPlayer player) {
        this.nodes = new CapeNode[132];
        float pX = (float)player.field_70165_t % 7789.0f;
        float pY = (float)player.field_70163_u;
        float pZ = (float)player.field_70161_v % 7789.0f;
        float uMinTop = 0.046875f;
        float uMaxTop = 0.24023438f;
        float uMinBottom = 0.0f;
        float uMaxBottom = 0.2861328f;
        float vMaxSide = 0.39453125f;
        float vMaxCenter = 0.4091797f;
        for (int i = 0; i < 22; ++i) {
            float uMin = uMinTop + (uMinBottom - uMinTop) * (float)i / 21.0f;
            float uMax = uMaxTop + (uMaxBottom - uMaxTop) * (float)i / 21.0f;
            for (int j = 0; j < 6; ++j) {
                float vMin = 0.0f;
                float centerMult = 1.0f - Math.abs((float)j - 2.5f) / 2.5f;
                float vMax = vMaxSide + (vMaxCenter - vMaxSide) * centerMult;
                CapeNode node = new CapeNode(pX, pY, pZ);
                node.texU = uMin + (uMax - uMin) * (float)j / 5.0f;
                node.texV = vMin + (vMax - vMin) * (float)i / 21.0f;
                node.horzDistMult = 2.0f + 1.0f * (float)i / 21.0f;
                if (j == 0 || j == 5) {
                    node.horzSideTexU = 0.39648438f * (float)i / 21.0f;
                    node.horzSideTexVTop = j == 0 ? 0.98046875f : 0.9609375f;
                }
                if (i == 0) {
                    node.vertSideTexU = 0.19335938f * (float)j / 5.0f;
                    node.vertSideTexVTop = 0.94140625f;
                } else if (i == 21) {
                    node.vertSideTexU = 0.29296875f * (float)j / 5.0f;
                    node.vertSideTexVTop = 0.921875f;
                }
                this.nodes[j + i * 6] = node;
            }
        }
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                for (Direction dir : Direction.values()) {
                    for (int i = 1; i <= 2; ++i) {
                        Offset offset = new Offset(dir, i);
                        int xNeighbor = x + offset.getXOffset();
                        int yNeighbor = y + offset.getYOffset();
                        if (xNeighbor < 0 || xNeighbor >= 6 || yNeighbor < 0 || yNeighbor >= 22) continue;
                        CapeNode neighbor = this.nodes[xNeighbor + yNeighbor * 6];
                        node.setNeighbor(offset, neighbor);
                    }
                }
            }
        }
    }

    public void ensureCapeNodesCreated(EntityPlayer player) {
        if (this.nodes == null) {
            this.createCapeNodes(player);
        }
    }

    private void loadShaderUniforms(ShaderManager shaderManager) {
        String shaderId = "capes/" + this.shaderName + "/" + this.shaderName;
        if (this.shaderName.equalsIgnoreCase("fade_cape") || this.shaderName.equalsIgnoreCase("planets")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
        } else if (this.shaderName.equalsIgnoreCase("space_cape")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
            shaderManager.loadData(shaderId, "eventMillis", (int)(System.currentTimeMillis() - this.eventMillis));
            shaderManager.loadData(shaderId, "eventRand", Float.valueOf(this.eventRandom));
        } else if (this.shaderName.equalsIgnoreCase("mcworld_cape")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
        } else if (this.shaderName.equalsIgnoreCase("lava_cape")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
        } else if (this.shaderName.equalsIgnoreCase("tunnel")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
        } else if (this.shaderName.equalsIgnoreCase("biscuit_cape") || this.shaderName.equalsIgnoreCase("shiny_cape")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
            shaderManager.loadData(shaderId, "eventMillis", (int)(System.currentTimeMillis() - this.eventMillis));
        } else if (this.shaderName.equalsIgnoreCase("negative")) {
            shaderManager.loadData(shaderId, "screensize", new Vector2f((float)Minecraft.func_71410_x().field_71443_c, (float)Minecraft.func_71410_x().field_71440_d));
        } else if (this.shaderName.equalsIgnoreCase("void")) {
            shaderManager.loadData(shaderId, "millis", (int)(System.currentTimeMillis() - this.startTime));
            shaderManager.loadData(shaderId, "screensize", new Vector2f((float)Minecraft.func_71410_x().field_71443_c, (float)Minecraft.func_71410_x().field_71440_d));
        } else if (this.shaderName.equalsIgnoreCase("screensaver")) {
            shaderManager.loadData(shaderId, "something", (int)(System.currentTimeMillis() / 4L % 256L));
            shaderManager.loadData(shaderId, "dvdPosition", new Vector2f(this.dvdPositionX, this.dvdPositionY));
        }
    }

    public void onRenderPlayer(RenderPlayerEvent.Post e2) {
        EntityPlayer player = e2.entityPlayer;
        if (this.currentPlayer != null && this.keepCurrentPlayer && this.currentPlayer != player) {
            return;
        }
        if (player.func_70660_b(Potion.field_76441_p) != null) {
            return;
        }
        if (player.func_175149_v() || player.func_82150_aj()) {
            return;
        }
        this.ensureCapeNodesCreated(player);
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = (viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)e2.partialRenderTick) % 7789.0;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)e2.partialRenderTick;
        double viewerZ = (viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)e2.partialRenderTick) % 7789.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.bindTexture();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.shaderName.equals("mcworld_cape")) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        GL11.glTranslatef((float)(-((float)viewerX)), (float)(-((float)viewerY)), (float)(-((float)viewerZ)));
        ShaderManager shaderManager = ShaderManager.getInstance();
        shaderManager.loadShader("capes/" + this.shaderName + "/" + this.shaderName);
        this.loadShaderUniforms(shaderManager);
        this.renderCape(player, e2.partialRenderTick);
        GL11.glTranslatef((float)((float)viewerX), (float)((float)viewerY), (float)((float)viewerZ));
        GL20.glUseProgram((int)0);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        this.lastRender = System.currentTimeMillis();
    }

    public void onTick(EntityPlayer player) {
        if (player == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastRender < 500L) {
            if (this.currentPlayer == null || !this.keepCurrentPlayer) {
                this.keepCurrentPlayer = true;
                this.currentPlayer = player;
            } else if (this.currentPlayer != player) {
                return;
            }
            this.ensureCapeNodesCreated(player);
            for (int y = 0; y < 22; ++y) {
                for (int x = 0; x < 6; ++x) {
                    CapeNode node = this.nodes[x + y * 6];
                    node.lastPosition.x = node.position.x;
                    node.lastPosition.y = node.position.y;
                    node.lastPosition.z = node.position.z;
                }
            }
            this.updateCape(player);
        } else {
            this.keepCurrentPlayer = false;
        }
    }

    private static double interpolateRotation(float a, float b, float amount) {
        double f;
        for (f = (double)(b - a); f < -180.0; f += 360.0) {
        }
        while (f >= 180.0) {
            f -= 360.0;
        }
        return (double)a + (double)amount * f;
    }

    private double getPlayerRenderAngle(EntityPlayer player, float partialRenderTick) {
        double angle = NEUCape.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialRenderTick);
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase && player.field_70154_o.shouldRiderSit()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)player.field_70154_o;
            double head = NEUCape.interpolateRotation(player.field_70758_at, player.field_70759_as, partialRenderTick);
            double wrapped = MathHelper.func_76138_g((double)(head - (angle = NEUCape.interpolateRotation(entitylivingbase.field_70760_ar, entitylivingbase.field_70761_aq, partialRenderTick))));
            if (wrapped < -85.0) {
                wrapped = -85.0;
            }
            if (wrapped >= 85.0) {
                wrapped = 85.0;
            }
            angle = head - wrapped;
            if (wrapped * wrapped > 2500.0) {
                angle += wrapped * (double)0.2f;
            }
        }
        return Math.toRadians(angle);
    }

    private Vector3f updateFixedCapeNodes(EntityPlayer player) {
        double pX = player.field_70165_t % 7789.0;
        double pY = player.field_70163_u;
        double pZ = player.field_70161_v % 7789.0;
        double angle = this.getPlayerRenderAngle(player, 0.0f);
        double vertOffset2 = 1.4 + (double)(player.func_70093_af() ? -0.22f : 0.0f) + (double)(player.func_82169_q(2) != null ? 0.06f : 0.0f);
        double shoulderWidth2 = 0.13 + (double)(player.func_82169_q(2) != null ? 0.08f : 0.0f);
        float xOff = (float)(Math.cos(angle) * 0.24);
        float zOff = (float)(Math.sin(angle) * 0.24);
        float totalDX = 0.0f;
        float totalDY = 0.0f;
        float totalDZ = 0.0f;
        int totalMovements = 0;
        for (int i = 0; i < 6; ++i) {
            float mult = 1.0f - 2.0f * (float)i / 5.0f;
            float widthMult = 1.25f - (1.414f * (float)i / 5.0f - 0.707f) * (1.414f * (float)i / 5.0f - 0.707f);
            CapeNode node = this.nodes[i];
            float x = (float)pX + (float)((double)(xOff * mult) - (double)widthMult * Math.cos(angle + 1.5707963267948966) * shoulderWidth2);
            float y = (float)pY + (float)vertOffset2;
            float z = (float)pZ + (float)((double)(zOff * mult) - (double)widthMult * Math.sin(angle + 1.5707963267948966) * shoulderWidth2);
            totalDX += x - node.position.x;
            totalDY += y - node.position.y;
            totalDZ += z - node.position.z;
            ++totalMovements;
            node.position.x = x;
            node.position.y = y;
            node.position.z = z;
            node.fixed = true;
        }
        float avgDX = totalDX / (float)totalMovements;
        float avgDY = totalDY / (float)totalMovements;
        float avgDZ = totalDZ / (float)totalMovements;
        return new Vector3f(avgDX, avgDY, avgDZ);
    }

    private void updateFixedCapeNodesPartial(EntityPlayer player, float partialRenderTick) {
        double pX = (player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialRenderTick) % 7789.0;
        double pY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialRenderTick;
        double pZ = (player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialRenderTick) % 7789.0;
        double angle = this.getPlayerRenderAngle(player, partialRenderTick);
        double vertOffset2 = 1.4 + (double)(player.func_70093_af() ? -0.22f : 0.0f) + (double)(player.func_82169_q(2) != null ? 0.06f : 0.0f);
        double shoulderWidth2 = 0.13 + (double)(player.func_82169_q(2) != null ? 0.08f : 0.0f);
        float xOff = (float)(Math.cos(angle) * 0.24);
        float zOff = (float)(Math.sin(angle) * 0.24);
        for (int i = 0; i < 6; ++i) {
            float mult = 1.0f - 2.0f * (float)i / 5.0f;
            float widthMult = 1.25f - (1.414f * (float)i / 5.0f - 0.707f) * (1.414f * (float)i / 5.0f - 0.707f);
            CapeNode node = this.nodes[i];
            node.renderPosition.x = (float)pX + (float)((double)(xOff * mult) - (double)widthMult * Math.cos(angle + 1.5707963267948966) * shoulderWidth2);
            node.renderPosition.y = (float)pY + (float)vertOffset2;
            node.renderPosition.z = (float)pZ + (float)((double)(zOff * mult) - (double)widthMult * Math.sin(angle + 1.5707963267948966) * shoulderWidth2);
            node.fixed = true;
        }
    }

    public float deltaYComparedToLine(float x0, float y0, float x1, float y1) {
        float m = (y1 - y0) / (x1 - x0);
        float b = y0 - m * x0;
        float lineAtX = this.dvdPositionX * m + b;
        return this.dvdPositionY - lineAtX;
    }

    public float projectOntoLine(float x0, float y0, float x1, float y1, float x) {
        float m = (y1 - y0) / (x1 - x0);
        float b = y0 - m * x0;
        return x * m + b;
    }

    public void resetNodes() {
        this.nodes = null;
    }

    private void updateCape(EntityPlayer player) {
        int x;
        int y;
        int x2;
        int y2;
        Vector3f lookDir;
        Vector3f lookDirNorm;
        float dot;
        Vector3f capeTranslation = this.updateFixedCapeNodes(player);
        if (this.shaderName.equals("space_cape")) {
            long currentTime = System.currentTimeMillis();
            if ((float)(currentTime - this.startTime) > (float)(this.eventMillis - this.startTime) + this.eventLength) {
                this.eventMillis = currentTime;
                this.eventLength = this.random.nextFloat() * 2000.0f + 4000.0f;
                this.eventRandom = this.random.nextFloat();
            }
        } else if (this.shaderName.equals("biscuit_cape") || this.shaderName.equals("shiny_cape")) {
            long currentTime = System.currentTimeMillis();
            if ((float)(currentTime - this.startTime) > (float)(this.eventMillis - this.startTime) + this.eventLength) {
                this.eventMillis = currentTime;
                this.eventLength = this.random.nextFloat() * 3000.0f + 3000.0f;
            }
        } else if (this.shaderName.equals("screensaver")) {
            this.dvdPositionX += this.dvdVelocityX;
            this.dvdPositionY += this.dvdVelocityY;
            float diskSizeX = 81.0f;
            float diskSizeY = 39.0f;
            if (this.deltaYComparedToLine(0.0f, 404.0f, 47.0f, 0.0f) < 0.0f) {
                this.dvdVelocityX = 10.0f;
                this.dvdPositionX = this.projectOntoLine(404.0f, 0.0f, 0.0f, 47.0f, this.dvdPositionY);
            }
            if (this.deltaYComparedToLine(0.0f, 404.0f - diskSizeY, 292.0f, 404.0f - diskSizeY) > 0.0f) {
                this.dvdVelocityY = -10.0f;
                this.dvdPositionY = 404.0f - diskSizeY;
            }
            if (this.deltaYComparedToLine(47.0f, 0.0f, 246.0f, 0.0f) < 0.0f) {
                this.dvdVelocityY = 10.0f;
                this.dvdPositionY = 0.0f;
            }
            if (this.deltaYComparedToLine(246.0f - diskSizeX, 0.0f, 293.0f - diskSizeX, 404.0f) < 0.0f) {
                this.dvdVelocityX = -10.0f;
                this.dvdPositionX = this.projectOntoLine(0.0f, 246.0f - diskSizeX, 404.0f, 293.0f - diskSizeX, this.dvdPositionY);
            }
        }
        double playerAngle = this.getPlayerRenderAngle(player, 0.0f);
        double deltaAngle = playerAngle - this.oldPlayerAngle;
        if (deltaAngle > Math.PI) {
            deltaAngle = Math.PI * 2 - deltaAngle;
        }
        if (deltaAngle < -Math.PI) {
            deltaAngle = Math.PI * 2 + deltaAngle;
        }
        this.deltaAngleAccum *= 0.5;
        this.deltaAngleAccum += deltaAngle;
        float dX = (float)Math.cos(playerAngle + 1.5707963267948966);
        float dZ = (float)Math.sin(playerAngle + 1.5707963267948966);
        float factor = (float)(this.deltaAngleAccum * this.deltaAngleAccum);
        float capeTransLength = capeTranslation.length();
        float capeTranslationFactor = 0.0f;
        if (capeTransLength > 0.5f) {
            capeTranslationFactor = (capeTransLength - 0.5f) / capeTransLength;
        }
        if ((dot = Vector3f.dot((Vector3f)capeTranslation, (Vector3f)(lookDirNorm = (lookDir = new Vector3f(dX, 0.0f, dZ)).normalise(null)))) < 0.0f) {
            for (y2 = 0; y2 < 22; ++y2) {
                for (x2 = 0; x2 < 6; ++x2) {
                    CapeNode node = this.nodes[x2 + y2 * 6];
                    if (node.fixed) continue;
                    node.position.x += lookDirNorm.x * dot;
                    node.position.y += lookDirNorm.y * dot;
                    node.position.z += lookDirNorm.z * dot;
                }
            }
            factor = 0.05f;
        }
        if (factor > 0.0f) {
            for (y2 = 0; y2 < 22; ++y2) {
                for (x2 = 0; x2 < 6; ++x2) {
                    this.nodes[x2 + y2 * 6].applyForce(-dX * factor, 0.0f, -dZ * factor);
                }
            }
        }
        if (capeTranslationFactor > 0.0f) {
            float capeDX = capeTranslation.x * capeTranslationFactor;
            float capeDY = capeTranslation.y * capeTranslationFactor;
            float capeDZ = capeTranslation.z * capeTranslationFactor;
            for (int y3 = 0; y3 < 22; ++y3) {
                for (int x3 = 0; x3 < 6; ++x3) {
                    CapeNode node = this.nodes[x3 + y3 * 6];
                    if (node.fixed) continue;
                    node.position.x += capeDX;
                    node.position.y += capeDY;
                    node.position.z += capeDZ;
                }
            }
        }
        float currTime = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
        float windRandom = Math.abs((float)(0.5 * Math.sin(0.22f * currTime) + Math.sin(0.44f * currTime) * Math.sin(0.47f * currTime)));
        double windDir = playerAngle + 0.7853981633974483 * Math.sin(0.2f * currTime);
        float windDX = (float)Math.cos(windDir + 1.5707963267948966);
        float windDZ = (float)Math.sin(windDir + 1.5707963267948966);
        for (int y4 = 0; y4 < 22; ++y4) {
            for (int x4 = 0; x4 < 6; ++x4) {
                this.nodes[x4 + y4 * 6].applyForce(-windDX * windRandom * 0.01f, 0.0f, -windDZ * windRandom * 0.01f);
            }
        }
        if (player.func_70093_af()) {
            ++this.crouchTicks;
            float mult = 0.5f;
            if (this.crouchTicks < 5) {
                mult = 2.0f;
            }
            for (y = 0; y < 8; ++y) {
                for (x = 0; x < 6; ++x) {
                    this.nodes[x + y * 6].applyForce(-dX * mult, 0.0f, -dZ * mult);
                }
            }
        } else {
            this.crouchTicks = 0;
        }
        Vector3f avgPosition = this.avgFixedPosition();
        for (y = 0; y < 22; ++y) {
            for (x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                Vector3f delta = Vector3f.sub((Vector3f)node.position, (Vector3f)avgPosition, null);
                if (!(delta.lengthSquared() > 25.0f)) continue;
                Vector3f norm = delta.normalise(null);
                node.position = Vector3f.add((Vector3f)avgPosition, (Vector3f)norm, null);
            }
        }
        this.oldPlayerAngle = playerAngle;
        for (y = 0; y < 22; ++y) {
            for (x = 0; x < 6; ++x) {
                this.nodes[x + y * 6].update();
            }
        }
        int updates = 50;
        for (int i = 0; i < updates; ++i) {
            for (int y5 = 0; y5 < 22; ++y5) {
                for (int x5 = 0; x5 < 6; ++x5) {
                    this.nodes[x5 + y5 * 6].resolveAll(2.0f + 1.0f * (float)y5 / 22.0f, false);
                }
            }
        }
    }

    private void generateSSBO() {
        this.ssbo = GL15.glGenBuffers();
        this.loadSBBO();
    }

    private void loadSBBO() {
        FloatBuffer buff = BufferUtils.createFloatBuffer((int)2640);
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.nodes[x + y * 6].loadIntoBuffer(buff);
            }
        }
        buff.flip();
        GL15.glBindBuffer((int)37074, (int)this.ssbo);
        GL15.glBufferData((int)37074, (FloatBuffer)buff, (int)35048);
        GL15.glBindBuffer((int)37074, (int)0);
    }

    private void resolveAllCompute() {
        if (this.ssbo == -1) {
            this.generateSSBO();
        }
        this.loadSBBO();
        int program = ShaderManager.getInstance().getShader("node");
        int block_index = GL43.glGetProgramResourceIndex((int)program, (int)37606, (CharSequence)"nodes_buffer");
        int ssbo_binding_point_index = 0;
        GL43.glShaderStorageBlockBinding((int)program, (int)block_index, (int)ssbo_binding_point_index);
        int binding_point_index = 0;
        GL30.glBindBufferBase((int)37074, (int)binding_point_index, (int)this.ssbo);
        GL20.glUseProgram((int)program);
        for (int i = 0; i < 30; ++i) {
            GL43.glDispatchCompute((int)22, (int)1, (int)1);
            GL42.glMemoryBarrier((int)8192);
        }
        GL20.glUseProgram((int)0);
        FloatBuffer buff = BufferUtils.createFloatBuffer((int)2640);
        GL15.glBindBuffer((int)37074, (int)this.ssbo);
        GL15.glGetBufferSubData((int)37074, (long)0L, (FloatBuffer)buff);
        GL15.glBindBuffer((int)37074, (int)0);
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.nodes[x + y * 6].readFromBuffer(buff);
            }
        }
    }

    private Vector3f avgRenderPosition() {
        Vector3f accum = new Vector3f();
        int num = 0;
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                Vector3f.add((Vector3f)accum, (Vector3f)node.renderPosition, (Vector3f)accum);
                ++num;
            }
        }
        if (num != 0) {
            accum.scale(1.0f / (float)num);
        }
        return accum;
    }

    private Vector3f avgNormal() {
        Vector3f accum = new Vector3f();
        int num = 0;
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                Vector3f.add((Vector3f)accum, (Vector3f)node.normal(), (Vector3f)accum);
                ++num;
            }
        }
        if (num != 0) {
            accum.scale(1.0f / (float)num);
        }
        return accum;
    }

    private Vector3f avgFixedRenderPosition() {
        Vector3f accum = new Vector3f();
        int numFixed = 0;
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                if (!node.fixed) continue;
                Vector3f.add((Vector3f)accum, (Vector3f)node.renderPosition, (Vector3f)accum);
                ++numFixed;
            }
        }
        if (numFixed != 0) {
            accum.scale(1.0f / (float)numFixed);
        }
        return accum;
    }

    private Vector3f avgFixedPosition() {
        Vector3f accum = new Vector3f();
        int numFixed = 0;
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                if (!node.fixed) continue;
                Vector3f.add((Vector3f)accum, (Vector3f)node.position, (Vector3f)accum);
                ++numFixed;
            }
        }
        if (numFixed != 0) {
            accum.scale(1.0f / (float)numFixed);
        }
        return accum;
    }

    private void renderBackAndDoFrontStencil() {
        int x;
        int y;
        for (y = 0; y < 22; ++y) {
            for (x = 0; x < 6; ++x) {
                this.nodes[x + y * 6].renderNode(6);
            }
        }
        if (!Minecraft.func_71410_x().func_147110_a().isStencilEnabled()) {
            Minecraft.func_71410_x().func_147110_a().enableStencil();
        }
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        GlStateManager.func_179126_j();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        for (y = 0; y < 22; ++y) {
            for (x = 0; x < 6; ++x) {
                this.nodes[x + y * 6].renderNode(1);
            }
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
    }

    private Vector3f getPoint(Vector3f point, Vector3f ... vectors) {
        Vector3f res = new Vector3f((ReadableVector3f)point);
        for (Vector3f vec : vectors) {
            Vector3f.add((Vector3f)res, (Vector3f)vec, (Vector3f)res);
        }
        return res;
    }

    private static void renderVBO(WorldRenderer worldRenderer) {
        if (worldRenderer != null && worldRenderer.func_178989_h() > 0) {
            VertexFormatElement vertexformatelement;
            int index;
            VertexFormat vertexformat = worldRenderer.func_178973_g();
            int stride = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = worldRenderer.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                vertexformatelement.func_177375_c().preDraw(vertexformat, index, stride, bytebuffer);
            }
            GL11.glDrawArrays((int)worldRenderer.func_178979_i(), (int)0, (int)worldRenderer.func_178989_h());
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                vertexformatelement.func_177375_c().postDraw(vertexformat, index, stride, bytebuffer);
            }
        }
    }

    private void renderNodes() {
        if (this.capeName.equalsIgnoreCase("planets")) {
            double nepDelta;
            double jupDelta;
            this.renderBackAndDoFrontStencil();
            Vector3f pointNorm = this.avgNormal();
            Vector3f capeAvgPos = this.avgRenderPosition();
            pointNorm.scale(0.5f / pointNorm.length());
            pointNorm.scale(1.0f - pointNorm.y / 1.3f);
            Vector3f point = Vector3f.sub((Vector3f)capeAvgPos, (Vector3f)pointNorm, null);
            if (sphereVBO == null || Keyboard.isKeyDown((int)37)) {
                int angleI;
                if (sphereVBO != null) {
                    sphereVBO.func_178965_a();
                }
                int arcSegments = 24;
                int rotationSegments = 24;
                double arcAngleDelta = Math.PI / (double)(arcSegments - 1);
                float xScale = 0.95f;
                double diameterUnitArcLen = 0.0;
                double arcAngle = 0.0;
                for (int i = 0; i < arcSegments; ++i) {
                    diameterUnitArcLen += Math.sin(arcAngle);
                    arcAngle += arcAngleDelta;
                }
                double arcLength = 2.0 / diameterUnitArcLen;
                ArrayList arcs = new ArrayList();
                for (int angleI2 = 0; angleI2 < rotationSegments; ++angleI2) {
                    double angle = Math.PI * 2 * (double)angleI2 / (double)rotationSegments;
                    ArrayList<Vector3f> arc = new ArrayList<Vector3f>();
                    Vector3f arcPos = new Vector3f(0.0f, 0.0f, -1.0f);
                    arc.add(arcPos);
                    arcAngle = 0.0;
                    for (int segmentI = 0; segmentI < arcSegments; ++segmentI) {
                        double deltaZ = Math.sin(arcAngle) * arcLength;
                        double deltaY = Math.cos(arcAngle) * Math.cos(angle) * arcLength;
                        double deltaX = Math.cos(arcAngle) * Math.sin(angle) * arcLength * (double)xScale;
                        arcPos = new Vector3f((ReadableVector3f)arcPos);
                        arcPos.z = (float)((double)arcPos.z + deltaZ);
                        arcPos.y = (float)((double)arcPos.y + deltaY);
                        arcPos.x = (float)((double)arcPos.x + deltaX);
                        arcPos.normalise();
                        arc.add(arcPos);
                        arcAngle += arcAngleDelta;
                    }
                    arcs.add(arc);
                }
                sphereVBO = new WorldRenderer(32 * rotationSegments * arcSegments);
                sphereVBO.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                double maxXYRad = 0.0;
                for (angleI = 0; angleI < rotationSegments; ++angleI) {
                    for (int segmentI = 0; segmentI <= arcSegments; ++segmentI) {
                        List thisArc = (List)arcs.get(angleI);
                        Vector3f point1 = (Vector3f)thisArc.get(segmentI);
                        double rad2 = Math.sqrt(point1.x * point1.x + point1.y * point1.y);
                        maxXYRad = Math.max(maxXYRad, rad2);
                    }
                }
                for (angleI = 0; angleI < rotationSegments; ++angleI) {
                    int nextAngleI = angleI + 1;
                    if (angleI == rotationSegments - 1) {
                        nextAngleI = 0;
                    }
                    float v = 0.5f * (float)angleI / (float)rotationSegments;
                    float v2 = 0.5f * (float)(angleI + 1) / (float)rotationSegments;
                    List thisArc = (List)arcs.get(angleI);
                    List nextArc = (List)arcs.get(nextAngleI);
                    for (int segmentI = 1; segmentI <= arcSegments; ++segmentI) {
                        Vector3f point1 = (Vector3f)thisArc.get(segmentI);
                        Vector3f point2 = (Vector3f)thisArc.get(segmentI - 1);
                        Vector3f point3 = (Vector3f)nextArc.get(segmentI - 1);
                        Vector3f point4 = (Vector3f)nextArc.get(segmentI);
                        double u1 = 0.5f * (float)segmentI / (float)arcSegments;
                        double u2 = 0.5f * (float)(segmentI - 1) / (float)arcSegments;
                        sphereVBO.func_181662_b((double)point4.x, (double)point4.y, (double)point4.z).func_181673_a(u1, (double)v2).func_181663_c(-point4.x, -point4.y, -point4.z).func_181675_d();
                        sphereVBO.func_181662_b((double)point3.x, (double)point3.y, (double)point3.z).func_181673_a(u2, (double)v2).func_181663_c(-point3.x, -point3.y, -point3.z).func_181675_d();
                        sphereVBO.func_181662_b((double)point2.x, (double)point2.y, (double)point2.z).func_181673_a(u2, (double)v).func_181663_c(-point2.x, -point2.y, -point2.z).func_181675_d();
                        sphereVBO.func_181662_b((double)point1.x, (double)point1.y, (double)point1.z).func_181673_a(u1, (double)v).func_181663_c(-point1.x, -point1.y, -point1.z).func_181675_d();
                    }
                }
            }
            String shaderId = "capes/" + this.shaderName + "/" + this.shaderName;
            double mercuryAngle = Math.PI * 2 * (double)((float)(System.currentTimeMillis() - this.startTime) / 10000.0f % 1.0f);
            double mercuryX = Math.sin(mercuryAngle) * 0.3;
            double mercuryZ = Math.cos(mercuryAngle) * 0.3;
            double earthAngle = Math.PI * 2 * (double)((float)(System.currentTimeMillis() - this.startTime) / 30000.0f % 1.0f);
            double earthSlant = 0.3141592653589793;
            double earthX = Math.sin(earthAngle) * Math.cos(earthSlant) * 0.6;
            double earthY = Math.sin(earthAngle) * Math.sin(earthSlant) * 0.6;
            double earthZ = Math.cos(earthAngle) * Math.cos(earthSlant) * 0.6;
            float sunDist = Vector3f.sub((Vector3f)point, (Vector3f)capeAvgPos, null).lengthSquared();
            float mercuryDist = Vector3f.sub((Vector3f)new Vector3f(point.x + (float)mercuryX, point.y, point.z + (float)mercuryZ), (Vector3f)capeAvgPos, null).lengthSquared();
            float earthDist = Vector3f.sub((Vector3f)new Vector3f(point.x + (float)earthX, point.y + (float)earthY, point.z + (float)earthZ), (Vector3f)capeAvgPos, null).lengthSquared();
            double jupiterAngle = Math.PI * 2 * (double)((float)(System.currentTimeMillis() - this.startTime) / 200000.0f % 1.0f);
            double jupiterSlant = -0.25132741228718347;
            double jupiterX = Math.sin(jupiterAngle) * Math.cos(jupiterSlant) * 1.5;
            double jupiterY = Math.sin(jupiterAngle) * Math.sin(jupiterSlant) * 1.5;
            double jupiterZ = Math.cos(jupiterAngle) * Math.cos(jupiterSlant) * 1.5;
            float jupiterDist = Vector3f.sub((Vector3f)new Vector3f(point.x + (float)jupiterX, point.y + (float)jupiterY, point.z + (float)jupiterZ), (Vector3f)capeAvgPos, null).lengthSquared();
            double neptuneX = -Math.sin(earthAngle) * Math.cos(earthSlant);
            double neptuneY = -Math.sin(earthAngle) * Math.sin(earthSlant);
            double neptuneZ = -Math.cos(earthAngle) * Math.cos(earthSlant);
            float neptuneDist = Vector3f.sub((Vector3f)new Vector3f(point.x + (float)neptuneX, point.y + (float)neptuneY, point.z + (float)neptuneZ), (Vector3f)capeAvgPos, null).lengthSquared();
            TreeMap<Float, Integer> orbitals = new TreeMap<Float, Integer>();
            orbitals.put(Float.valueOf(sunDist), 0);
            orbitals.put(Float.valueOf(earthDist), 1);
            orbitals.put(Float.valueOf(mercuryDist), 2);
            for (double delta = (double)(Minecraft.func_71410_x().func_175606_aa().func_70079_am() % 360.0f); delta < 0.0; delta += 360.0) {
            }
            for (jupDelta = (delta + Math.toDegrees(jupiterAngle)) % 360.0; jupDelta < 0.0; jupDelta += 360.0) {
            }
            if (jupDelta > 250.0 || jupDelta < 110.0) {
                orbitals.put(Float.valueOf(jupiterDist), 3);
            }
            for (nepDelta = (delta + Math.toDegrees(-earthAngle)) % 360.0; nepDelta < 0.0; nepDelta += 360.0) {
            }
            if (nepDelta > 250.0 || nepDelta < 110.0) {
                orbitals.put(Float.valueOf(neptuneDist), 4);
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179089_o();
            Iterator iterator = orbitals.descendingMap().values().iterator();
            while (iterator.hasNext()) {
                int planetId = (Integer)iterator.next();
                GlStateManager.func_179094_E();
                switch (planetId) {
                    case 0: {
                        GlStateManager.func_179109_b((float)point.x, (float)point.y, (float)point.z);
                        GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
                        break;
                    }
                    case 1: {
                        Vector3f sunVec = new Vector3f((float)earthX, (float)earthY, (float)earthZ);
                        ShaderManager.getInstance().loadData(shaderId, "sunVec", sunVec);
                        GlStateManager.func_179137_b((double)((double)point.x + earthX), (double)((double)point.y + earthY), (double)((double)point.z + earthZ));
                        GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
                        break;
                    }
                    case 2: {
                        Vector3f sunVec = new Vector3f((float)mercuryX, 0.0f, (float)mercuryZ);
                        ShaderManager.getInstance().loadData(shaderId, "sunVec", sunVec);
                        GlStateManager.func_179137_b((double)((double)point.x + mercuryX), (double)point.y, (double)((double)point.z + mercuryZ));
                        GlStateManager.func_179152_a((float)0.05f, (float)0.05f, (float)0.05f);
                        break;
                    }
                    case 3: {
                        Vector3f sunVec = new Vector3f((float)jupiterX, (float)jupiterY, (float)jupiterZ);
                        ShaderManager.getInstance().loadData(shaderId, "sunVec", sunVec);
                        GlStateManager.func_179137_b((double)((double)point.x + jupiterX), (double)((double)point.y + jupiterY), (double)((double)point.z + jupiterZ));
                        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
                        break;
                    }
                    case 4: {
                        Vector3f sunVec = new Vector3f((float)neptuneX, (float)neptuneY, (float)neptuneZ);
                        ShaderManager.getInstance().loadData(shaderId, "sunVec", sunVec);
                        GlStateManager.func_179137_b((double)((double)point.x + neptuneX), (double)((double)point.y + neptuneY), (double)((double)point.z + neptuneZ));
                        GlStateManager.func_179152_a((float)0.15f, (float)0.15f, (float)0.15f);
                        break;
                    }
                }
                ShaderManager.getInstance().loadData(shaderId, "planetType", planetId);
                NEUCape.renderVBO(sphereVBO);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179129_p();
            GlStateManager.func_179126_j();
            GL11.glDisable((int)2960);
        } else if (this.capeName.equalsIgnoreCase("parallax")) {
            this.renderBackAndDoFrontStencil();
            Vector3f pointNorm = this.avgNormal();
            pointNorm.scale(-0.2f / pointNorm.length());
            Vector3f negPointNorm = new Vector3f((ReadableVector3f)pointNorm);
            negPointNorm.scale(-1.0f);
            Vector3f point = Vector3f.add((Vector3f)this.avgRenderPosition(), (Vector3f)pointNorm, null);
            Vector3f fixedPoint = Vector3f.add((Vector3f)this.avgFixedRenderPosition(), (Vector3f)pointNorm, null);
            Vector3f up = Vector3f.sub((Vector3f)fixedPoint, (Vector3f)point, null);
            float halfUp = up.length();
            Vector3f down = new Vector3f((ReadableVector3f)up);
            down.scale(-1.0f);
            Vector3f left = Vector3f.cross((Vector3f)up, (Vector3f)pointNorm, null);
            left.scale(halfUp * 522.0f / 341.0f / left.length());
            Vector3f right = new Vector3f((ReadableVector3f)left);
            right.scale(-1.0f);
            Vector3f point1 = this.getPoint(point, left);
            Vector3f point2 = this.getPoint(point, left, down, down);
            Vector3f point3 = this.getPoint(point, right, down, down);
            Vector3f point4 = this.getPoint(point, right);
            Vector3f point2Edge = this.getPoint(point2, negPointNorm, negPointNorm);
            Vector3f point3Edge = this.getPoint(point3, negPointNorm, negPointNorm);
            GlStateManager.func_179097_i();
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldrenderer.func_181662_b((double)point1.x, (double)point1.y, (double)point1.z).func_181673_a(0.0, 0.9208984375).func_181675_d();
            worldrenderer.func_181662_b((double)point2.x, (double)point2.y, (double)point2.z).func_181673_a(0.2734375, 0.9208984375).func_181675_d();
            worldrenderer.func_181662_b((double)point3.x, (double)point3.y, (double)point3.z).func_181673_a(0.2734375, 0.4111328125).func_181675_d();
            worldrenderer.func_181662_b((double)point4.x, (double)point4.y, (double)point4.z).func_181673_a(0.0, 0.4111328125).func_181675_d();
            tessellator.func_78381_a();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldrenderer.func_181662_b((double)point2.x, (double)point2.y, (double)point2.z).func_181673_a(0.2734375, 0.9208984375).func_181675_d();
            worldrenderer.func_181662_b((double)point2Edge.x, (double)point2Edge.y, (double)point2Edge.z).func_181673_a(0.3330078125, 0.9208984375).func_181675_d();
            worldrenderer.func_181662_b((double)point3Edge.x, (double)point3Edge.y, (double)point3Edge.z).func_181673_a(0.3330078125, 0.4111328125).func_181675_d();
            worldrenderer.func_181662_b((double)point3.x, (double)point3.y, (double)point3.z).func_181673_a(0.2734375, 0.4111328125).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179129_p();
            GlStateManager.func_179126_j();
            GL11.glDisable((int)2960);
        } else if (this.capeName.equalsIgnoreCase("tunnel")) {
            this.renderBackAndDoFrontStencil();
            Vector3f pointNorm = this.avgNormal();
            pointNorm.scale(0.7f / pointNorm.length());
            pointNorm.scale(1.0f - pointNorm.y / 1.3f);
            Vector3f point = Vector3f.sub((Vector3f)this.avgRenderPosition(), (Vector3f)pointNorm, null);
            ArrayList<CapeNode> edgeNodes = new ArrayList<CapeNode>();
            ArrayList<Vector2f> edgeCoords = new ArrayList<Vector2f>();
            for (int y = 0; y < 22; ++y) {
                edgeNodes.add(this.nodes[y * 6]);
                edgeCoords.add(new Vector2f(0.0f, (float)y / 21.0f));
            }
            edgeNodes.add(null);
            edgeCoords.add(null);
            int bottomIndex = 21;
            int botSize = 6;
            for (int x = 0; x < botSize; ++x) {
                edgeNodes.add(this.getNode(x, bottomIndex));
                edgeCoords.add(new Vector2f((float)x / (float)(botSize - 1), 1.0f));
            }
            edgeNodes.add(null);
            edgeCoords.add(null);
            for (int y = 21; y >= 0; --y) {
                edgeNodes.add(this.getNode(5, y));
                edgeCoords.add(new Vector2f(1.0f, (float)y / 22.0f));
            }
            edgeNodes.add(null);
            edgeCoords.add(null);
            int topSize = 6;
            for (int x = topSize - 1; x >= 0; --x) {
                edgeNodes.add(this.getNode(x, 0));
                edgeCoords.add(new Vector2f((float)x / (float)(topSize - 1), 0.0f));
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179089_o();
            CapeNode last = null;
            for (int i = 0; i < edgeNodes.size(); ++i) {
                CapeNode node = (CapeNode)edgeNodes.get(i);
                if (last != null && node != null) {
                    Vector2f lastCoord = (Vector2f)edgeCoords.get(i - 1);
                    Vector2f coord = (Vector2f)edgeCoords.get(i);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    WorldRenderer worldrenderer = tessellator.func_178180_c();
                    worldrenderer.func_181668_a(4, DefaultVertexFormats.field_181710_j);
                    Vector3f lastNodeNorm = last.normal();
                    worldrenderer.func_181662_b((double)(last.renderPosition.x + lastNodeNorm.x * 0.05f), (double)(last.renderPosition.y + lastNodeNorm.y * 0.05f), (double)(last.renderPosition.z + lastNodeNorm.z * 0.05f)).func_181673_a((double)(lastCoord.x * 300.0f / 1024.0f), (double)(lastCoord.y * 420.0f / 1024.0f)).func_181663_c(-lastNodeNorm.x, -lastNodeNorm.y, -lastNodeNorm.z).func_181675_d();
                    Vector3f nodeNorm = node.normal();
                    worldrenderer.func_181662_b((double)(node.renderPosition.x + nodeNorm.x * 0.05f), (double)(node.renderPosition.y + nodeNorm.y * 0.05f), (double)(node.renderPosition.z + nodeNorm.z * 0.05f)).func_181673_a((double)(coord.x * 300.0f / 1024.0f), (double)(coord.y * 420.0f / 1024.0f)).func_181663_c(-nodeNorm.x, -nodeNorm.y, -nodeNorm.z).func_181675_d();
                    worldrenderer.func_181662_b((double)point.x, (double)point.y, (double)point.z).func_181673_a(0.146484375, 0.205078125).func_181663_c(-pointNorm.x, -pointNorm.y, -pointNorm.z).func_181675_d();
                    tessellator.func_78381_a();
                }
                last = node;
            }
            GlStateManager.func_179129_p();
            GlStateManager.func_179126_j();
            GL11.glDisable((int)2960);
        } else {
            for (int y = 0; y < 22; ++y) {
                for (int x = 0; x < 6; ++x) {
                    this.nodes[x + y * 6].renderNode();
                }
            }
        }
    }

    private void renderCape(EntityPlayer player, float partialRenderTick) {
        this.ensureCapeNodesCreated(player);
        Vector3f avgPositionFixedBefore = this.avgFixedRenderPosition();
        this.updateFixedCapeNodesPartial(player, partialRenderTick);
        Vector3f avgPositionFixed = this.avgFixedRenderPosition();
        Vector3f delta = Vector3f.sub((Vector3f)avgPositionFixed, (Vector3f)avgPositionFixedBefore, null);
        if (delta.lengthSquared() > 9.0f) {
            this.updateFixedCapeNodes(player);
            for (int y = 0; y < 22; ++y) {
                for (int x = 0; x < 6; ++x) {
                    CapeNode node = this.nodes[x + y * 6];
                    if (!node.fixed) {
                        Vector3f.add((Vector3f)node.renderPosition, (Vector3f)delta, (Vector3f)node.renderPosition);
                        node.position.set((ReadableVector3f)node.renderPosition);
                        node.lastPosition.set((ReadableVector3f)node.renderPosition);
                        continue;
                    }
                    node.lastPosition.set((ReadableVector3f)node.position);
                }
            }
            this.renderNodes();
            return;
        }
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 6; ++x) {
                CapeNode node = this.nodes[x + y * 6];
                node.resetNormal();
                if (node.fixed) continue;
                Vector3f newPosition = new Vector3f();
                newPosition.x = node.lastPosition.x + (node.position.x - node.lastPosition.x) * partialRenderTick;
                newPosition.y = node.lastPosition.y + (node.position.y - node.lastPosition.y) * partialRenderTick;
                newPosition.z = node.lastPosition.z + (node.position.z - node.lastPosition.z) * partialRenderTick;
                int length = node.oldRenderPosition.length;
                int fps = Minecraft.func_175610_ah();
                if (fps < 50) {
                    length = 2;
                } else if (fps < 100) {
                    length = 2 + (int)((float)(fps - 50) / 50.0f * 3.0f);
                }
                if (node.oldRenderPosition[length - 1] == null) {
                    Arrays.fill(node.oldRenderPosition, Vector3f.sub((Vector3f)newPosition, (Vector3f)avgPositionFixed, null));
                    node.renderPosition = newPosition;
                } else {
                    Vector3f accum = new Vector3f();
                    for (int i = 0; i < length; ++i) {
                        Vector3f.add((Vector3f)accum, (Vector3f)node.oldRenderPosition[i], (Vector3f)accum);
                        Vector3f.add((Vector3f)accum, (Vector3f)avgPositionFixed, (Vector3f)accum);
                    }
                    accum.scale(1.0f / (float)length);
                    float blendFactor = 0.5f + 0.3f * (float)y / 21.0f;
                    accum.scale(blendFactor);
                    newPosition.scale(1.0f - blendFactor);
                    Vector3f.add((Vector3f)accum, (Vector3f)newPosition, (Vector3f)accum);
                    node.renderPosition = accum;
                }
                if (Minecraft.func_71410_x().func_147113_T()) continue;
                for (int i = node.oldRenderPosition.length - 1; i >= 0; --i) {
                    node.oldRenderPosition[i] = i > 0 ? node.oldRenderPosition[i - 1] : Vector3f.sub((Vector3f)node.renderPosition, (Vector3f)avgPositionFixed, null);
                }
            }
        }
        this.renderNodes();
    }

    public static class Offset {
        Direction direction;
        int steps;

        public Offset(Direction direction, int steps) {
            this.direction = direction;
            this.steps = steps;
        }

        public int getXOffset() {
            return this.direction.xOff * this.steps;
        }

        public int getYOffset() {
            return this.direction.yOff * this.steps;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Offset) {
                Offset other = (Offset)obj;
                return other.direction == this.direction && other.steps == this.steps;
            }
            return false;
        }

        public int hashCode() {
            return 13 * this.direction.ordinal() + 7 * this.steps;
        }
    }

    public static enum Direction {
        LEFT(-1, 0),
        UP(0, 1),
        RIGHT(1, 0),
        DOWN(0, -1),
        UPLEFT(-1, 1),
        UPRIGHT(1, 1),
        DOWNLEFT(-1, -1),
        DOWNRIGHT(1, -1);

        int xOff;
        int yOff;

        private Direction(int xOff, int yOff) {
            this.xOff = xOff;
            this.yOff = yOff;
        }

        public Direction rotateRight90() {
            int wantXOff = -this.yOff;
            int wantYOff = this.xOff;
            for (Direction dir : Direction.values()) {
                if (dir.xOff != wantXOff || dir.yOff != wantYOff) continue;
                return dir;
            }
            return this;
        }

        public Direction rotateLeft90() {
            int wantXOff = this.yOff;
            int wantYOff = -this.xOff;
            for (Direction dir : Direction.values()) {
                if (dir.xOff != wantXOff || dir.yOff != wantYOff) continue;
                return dir;
            }
            return this;
        }
    }
}

