/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.util.lerp;

public class LerpingFloat {
    private int timeSpent;
    private long lastMillis;
    private final int timeToReachTarget;
    private float targetValue;
    private float lerpValue;

    public LerpingFloat(float initialValue, int timeToReachTarget) {
        this.targetValue = this.lerpValue = initialValue;
        this.timeToReachTarget = timeToReachTarget;
    }

    public LerpingFloat(int initialValue) {
        this(initialValue, 200);
    }

    public void tick() {
        int lastTimeSpent = this.timeSpent;
        this.timeSpent = (int)((long)this.timeSpent + (System.currentTimeMillis() - this.lastMillis));
        float lastDistPercentToTarget = (float)lastTimeSpent / (float)this.timeToReachTarget;
        float distPercentToTarget = (float)this.timeSpent / (float)this.timeToReachTarget;
        float fac = (1.0f - lastDistPercentToTarget) / lastDistPercentToTarget;
        float startValue = this.lerpValue - (this.targetValue - this.lerpValue) / fac;
        float dist = this.targetValue - startValue;
        if (dist == 0.0f) {
            return;
        }
        float oldLerpValue = this.lerpValue;
        this.lerpValue = distPercentToTarget >= 1.0f ? this.targetValue : startValue + dist * distPercentToTarget;
        if (this.lerpValue == oldLerpValue) {
            this.timeSpent = lastTimeSpent;
        } else {
            this.lastMillis = System.currentTimeMillis();
        }
    }

    public void resetTimer() {
        this.timeSpent = 0;
        this.lastMillis = System.currentTimeMillis();
    }

    public void setTarget(float targetValue) {
        this.targetValue = targetValue;
    }

    public void setValue(float value) {
        this.targetValue = this.lerpValue = value;
    }

    public float getValue() {
        return this.lerpValue;
    }

    public float getTarget() {
        return this.targetValue;
    }
}

