/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.config;

import com.google.gson.annotations.Expose;
import net.minecraft.client.gui.ScaledResolution;

public class Position {
    @Expose
    private int x;
    @Expose
    private int y;
    @Expose
    private boolean centerX;
    @Expose
    private boolean centerY;
    private boolean clicked = false;
    private static final int EDGE_OFFSET = 0;

    public Position(int x, int y) {
        this(x, y, false, false);
    }

    public Position(int x, int y, boolean centerX, boolean centerY) {
        this.x = x;
        this.y = y;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public void set(Position other) {
        this.x = other.x;
        this.y = other.y;
        this.centerX = other.centerX;
        this.centerY = other.centerY;
    }

    public Position clone() {
        return new Position(this.x, this.y, this.centerX, this.centerY);
    }

    public boolean isCenterX() {
        return this.centerX;
    }

    public boolean isCenterY() {
        return this.centerY;
    }

    public int getRawX() {
        return this.x;
    }

    public int getRawY() {
        return this.y;
    }

    public void setClicked(boolean state) {
        this.clicked = state;
    }

    public boolean getClicked() {
        return this.clicked;
    }

    public int getAbsX(ScaledResolution scaledResolution, int objWidth) {
        int width = scaledResolution.func_78326_a();
        if (this.centerX) {
            return width / 2 + this.x;
        }
        int ret = this.x;
        if (this.x < 0) {
            ret = width + this.x - objWidth;
        }
        if (ret < 0) {
            ret = 0;
        }
        if (ret > width - objWidth) {
            ret = width - objWidth;
        }
        return ret;
    }

    public int getAbsY(ScaledResolution scaledResolution, int objHeight) {
        int height = scaledResolution.func_78328_b();
        if (this.centerY) {
            return height / 2 + this.y;
        }
        int ret = this.y;
        if (this.y < 0) {
            ret = height + this.y - objHeight;
        }
        if (ret < 0) {
            ret = 0;
        }
        if (ret > height - objHeight) {
            ret = height - objHeight;
        }
        return ret;
    }

    public int moveX(int deltaX, int objWidth, ScaledResolution scaledResolution) {
        int screenWidth = scaledResolution.func_78326_a();
        boolean wasPositiveX = this.x >= 0;
        this.x += deltaX;
        if (this.centerX) {
            if (wasPositiveX) {
                if (this.x > screenWidth / 2 - objWidth / 2) {
                    deltaX += screenWidth / 2 - objWidth / 2 - this.x;
                    this.x = screenWidth / 2 - objWidth / 2;
                }
            } else if (this.x < -screenWidth / 2 + objWidth / 2) {
                deltaX += -screenWidth / 2 + objWidth / 2 - this.x;
                this.x = -screenWidth / 2 + objWidth / 2;
            }
            return deltaX;
        }
        if (wasPositiveX) {
            if (this.x < 0) {
                deltaX += 0 - this.x;
                this.x = 0;
            }
            if (this.x > screenWidth - 0) {
                deltaX += screenWidth - 0 - this.x;
                this.x = screenWidth - 0;
            }
        } else {
            if (this.x + 1 > 0) {
                deltaX += -1 - this.x;
                this.x = -1;
            }
            if (this.x + screenWidth < 0) {
                deltaX += 0 - screenWidth - this.x;
                this.x = 0 - screenWidth;
            }
        }
        if (this.x >= 0 && this.x + objWidth / 2 > screenWidth / 2) {
            this.x -= screenWidth - objWidth;
        }
        if (this.x < 0 && this.x + objWidth / 2 <= -screenWidth / 2) {
            this.x += screenWidth - objWidth;
        }
        return deltaX;
    }

    public int moveY(int deltaY, int objHeight, ScaledResolution scaledResolution) {
        int screenHeight = scaledResolution.func_78328_b();
        boolean wasPositiveY = this.y >= 0;
        this.y += deltaY;
        if (this.centerY) {
            if (wasPositiveY) {
                if (this.y > screenHeight / 2 - objHeight / 2) {
                    deltaY += screenHeight / 2 - objHeight / 2 - this.y;
                    this.y = screenHeight / 2 - objHeight / 2;
                }
            } else if (this.y < -screenHeight / 2 + objHeight / 2) {
                deltaY += -screenHeight / 2 + objHeight / 2 - this.y;
                this.y = -screenHeight / 2 + objHeight / 2;
            }
            return deltaY;
        }
        if (wasPositiveY) {
            if (this.y < 0) {
                deltaY += 0 - this.y;
                this.y = 0;
            }
            if (this.y > screenHeight - 0) {
                deltaY += screenHeight - 0 - this.y;
                this.y = screenHeight - 0;
            }
        } else {
            if (this.y + 1 > 0) {
                deltaY += -1 - this.y;
                this.y = -1;
            }
            if (this.y + screenHeight < 0) {
                deltaY += 0 - screenHeight - this.y;
                this.y = 0 - screenHeight;
            }
        }
        if (this.y >= 0 && this.y - objHeight / 2 > screenHeight / 2) {
            this.y -= screenHeight - objHeight;
        }
        if (this.y < 0 && this.y - objHeight / 2 <= -screenHeight / 2) {
            this.y += screenHeight - objHeight;
        }
        return deltaY;
    }
}

