/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Matrix4f;

public class BackgroundBlur {
    private static final HashMap<Float, OutputStuff> blurOutput = new HashMap();
    private static final HashMap<Float, Long> lastBlurUse = new HashMap();
    private static long lastBlur = 0L;
    private static final HashSet<Float> requestedBlurs = new HashSet();
    private static int fogColour = 0;
    private static boolean registered = false;
    private static boolean shouldBlur = true;
    private static Framebuffer blurOutputHorz = null;
    private static final double lastBgBlurFactor = -1.0;

    public static void registerListener() {
        if (!registered) {
            registered = true;
            MinecraftForge.EVENT_BUS.register((Object)new BackgroundBlur());
        }
    }

    public static void markDirty() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            shouldBlur = true;
        }
    }

    public static void processBlurs() {
        if (shouldBlur) {
            shouldBlur = false;
            long currentTime = System.currentTimeMillis();
            for (float blur : requestedBlurs) {
                lastBlur = currentTime;
                lastBlurUse.put(Float.valueOf(blur), currentTime);
                int n = Minecraft.func_71410_x().field_71443_c;
                int height = Minecraft.func_71410_x().field_71440_d;
                OutputStuff output = blurOutput.computeIfAbsent(Float.valueOf(blur), k -> {
                    Framebuffer fb = new Framebuffer(width, height, false);
                    fb.func_147607_a(9728);
                    return new OutputStuff(fb, null, null);
                });
                if (output.framebuffer.field_147621_c != n || output.framebuffer.field_147618_d != height) {
                    output.framebuffer.func_147613_a(n, height);
                    if (output.blurShaderHorz != null) {
                        output.blurShaderHorz.func_148045_a((Matrix4f)BackgroundBlur.createProjectionMatrix(n, height));
                    }
                    if (output.blurShaderVert != null) {
                        output.blurShaderVert.func_148045_a((Matrix4f)BackgroundBlur.createProjectionMatrix(n, height));
                    }
                }
                BackgroundBlur.blurBackground(output, blur);
            }
            HashSet<Float> remove2 = new HashSet<Float>();
            for (Map.Entry<Float, Long> entry : lastBlurUse.entrySet()) {
                if (currentTime - entry.getValue() <= 30000L) continue;
                remove2.add(entry.getKey());
            }
            remove2.remove(Float.valueOf(NotEnoughUpdates.INSTANCE.config.itemlist.bgBlurFactor));
            for (Map.Entry<Float, Object> entry : blurOutput.entrySet()) {
                Shader blurShaderVert;
                if (!remove2.contains(entry.getKey())) continue;
                ((OutputStuff)entry.getValue()).framebuffer.func_147608_a();
                Shader blurShaderHorz = ((OutputStuff)entry.getValue()).blurShaderHorz;
                if (blurShaderHorz != null) {
                    blurShaderHorz.func_148044_b();
                }
                if ((blurShaderVert = ((OutputStuff)entry.getValue()).blurShaderVert) == null) continue;
                blurShaderVert.func_148044_b();
            }
            lastBlurUse.keySet().removeAll(remove2);
            blurOutput.keySet().removeAll(remove2);
            requestedBlurs.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScreenRender(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            BackgroundBlur.processBlurs();
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    @SubscribeEvent
    public void onFogColour(EntityViewRenderEvent.FogColors event) {
        fogColour = -16777216;
        fogColour |= ((int)(event.red * 255.0f) & 0xFF) << 16;
        fogColour |= ((int)(event.green * 255.0f) & 0xFF) << 8;
        fogColour |= (int)(event.blue * 255.0f) & 0xFF;
    }

    private static net.minecraft.util.Matrix4f createProjectionMatrix(int width, int height) {
        net.minecraft.util.Matrix4f projMatrix = new net.minecraft.util.Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    private static void blurBackground(OutputStuff output, float blurFactor) {
        if (!OpenGlHelper.func_148822_b() || !OpenGlHelper.func_153193_b()) {
            return;
        }
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        if (blurOutputHorz == null) {
            blurOutputHorz = new Framebuffer(width, height, false);
            blurOutputHorz.func_147607_a(9728);
        }
        if (blurOutputHorz == null || output == null) {
            return;
        }
        if (BackgroundBlur.blurOutputHorz.field_147621_c != width || BackgroundBlur.blurOutputHorz.field_147618_d != height) {
            blurOutputHorz.func_147613_a(width, height);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (output.blurShaderHorz == null) {
            try {
                output.blurShaderHorz = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", output.framebuffer, blurOutputHorz);
                output.blurShaderHorz.func_148043_c().func_147991_a("BlurDir").func_148087_a(1.0f, 0.0f);
                output.blurShaderHorz.func_148045_a((Matrix4f)BackgroundBlur.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (output.blurShaderVert == null) {
            try {
                output.blurShaderVert = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", blurOutputHorz, output.framebuffer);
                output.blurShaderVert.func_148043_c().func_147991_a("BlurDir").func_148087_a(0.0f, 1.0f);
                output.blurShaderVert.func_148045_a((Matrix4f)BackgroundBlur.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (output.blurShaderHorz != null && output.blurShaderVert != null) {
            if (output.blurShaderHorz.func_148043_c().func_147991_a("Radius") == null) {
                return;
            }
            output.blurShaderHorz.func_148043_c().func_147991_a("Radius").func_148090_a(blurFactor);
            output.blurShaderVert.func_148043_c().func_147991_a("Radius").func_148090_a(blurFactor);
            GL11.glPushMatrix();
            GL30.glBindFramebuffer((int)36008, (int)Minecraft.func_71410_x().func_147110_a().field_147616_f);
            GL30.glBindFramebuffer((int)36009, (int)output.framebuffer.field_147616_f);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)output.framebuffer.field_147621_c, (int)output.framebuffer.field_147618_d, (int)16384, (int)9728);
            output.blurShaderHorz.func_148042_a(0.0f);
            output.blurShaderVert.func_148042_a(0.0f);
            GlStateManager.func_179126_j();
            GL11.glPopMatrix();
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    public static void renderBlurredBackground(float blurStrength, int screenWidth, int screenHeight, int x, int y, int blurWidth, int blurHeight) {
        BackgroundBlur.renderBlurredBackground(blurStrength, screenWidth, screenHeight, x, y, blurWidth, blurHeight, false);
    }

    public static void renderBlurredBackground(float blurStrength, int screenWidth, int screenHeight, int x, int y, int blurWidth, int blurHeight, boolean forcedUpdate) {
        if (!OpenGlHelper.func_148822_b() || !OpenGlHelper.func_153193_b()) {
            return;
        }
        if ((double)blurStrength < 0.5) {
            return;
        }
        requestedBlurs.add(Float.valueOf(blurStrength));
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastBlur > 300L) {
            shouldBlur = true;
            if (currentTime - lastBlur > 400L && forcedUpdate) {
                return;
            }
        }
        if (blurOutput.isEmpty()) {
            return;
        }
        OutputStuff out = blurOutput.get(Float.valueOf(blurStrength));
        if (out == null) {
            out = blurOutput.values().iterator().next();
        }
        float uMin = (float)x / (float)screenWidth;
        float uMax = (float)(x + blurWidth) / (float)screenWidth;
        float vMin = (float)(screenHeight - y) / (float)screenHeight;
        float vMax = (float)(screenHeight - y - blurHeight) / (float)screenHeight;
        GlStateManager.func_179132_a((boolean)false);
        Gui.func_73734_a((int)x, (int)y, (int)(x + blurWidth), (int)(y + blurHeight), (int)fogColour);
        out.framebuffer.func_147612_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(x, y, blurWidth, blurHeight, uMin, uMax, vMin, vMax);
        out.framebuffer.func_147606_d();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static class OutputStuff {
        public Framebuffer framebuffer;
        public Shader blurShaderHorz = null;
        public Shader blurShaderVert = null;

        public OutputStuff(Framebuffer framebuffer, Shader blurShaderHorz, Shader blurShaderVert) {
            this.framebuffer = framebuffer;
            this.blurShaderHorz = blurShaderHorz;
            this.blurShaderVert = blurShaderVert;
        }
    }
}

