/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.auction;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.ItemPriceInformation;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.LocalGraphDataProvider;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.ItemShopRecipe;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class APIManager {
    private final NEUManager manager;
    private final int LOWEST_BIN_UPDATE_INTERVAL = 120000;
    private final int AUCTION_AVG_UPDATE_INTERVAL = 300000;
    private final int BAZAAR_UPDATE_INTERVAL = 300000;
    private JsonObject lowestBins = null;
    private JsonObject auctionPricesAvgLowestBinJson = null;
    private JsonObject bazaarJson = null;
    private JsonObject auctionPricesJson = null;
    private final HashMap<String, CraftInfo> craftCost = new HashMap();
    private boolean didFirstUpdate = false;
    private long lastAuctionAvgUpdate = 0L;
    private long lastBazaarUpdate = 0L;
    private long lastLowestBinUpdate = 0L;
    private static final Pattern BAZAAR_ENCHANTMENT_PATTERN = Pattern.compile("ENCHANTMENT_(\\D*)_(\\d+)");
    public static final List<String> hardcodedVanillaItems = Utils.createList("WOOD_AXE", "WOOD_HOE", "WOOD_PICKAXE", "WOOD_SPADE", "WOOD_SWORD", "GOLD_AXE", "GOLD_HOE", "GOLD_PICKAXE", "GOLD_SPADE", "GOLD_SWORD", "ROOKIE_HOE");

    public APIManager(NEUManager manager) {
        this.manager = manager;
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastAuctionAvgUpdate > 300000L) {
            this.lastAuctionAvgUpdate = currentTime - 300000L + 60000L;
            this.updateAvgPrices();
        }
        if (currentTime - this.lastBazaarUpdate > 300000L) {
            this.lastBazaarUpdate = currentTime - 300000L + 60000L;
            this.updateBazaar();
        }
        if (currentTime - this.lastLowestBinUpdate > 120000L) {
            this.lastLowestBinUpdate = currentTime - 120000L + 30000L;
            this.updateLowestBin();
        }
    }

    public Set<String> getLowestBinKeySet() {
        if (this.lowestBins == null) {
            return new HashSet<String>();
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, JsonElement> entry : this.lowestBins.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    public long getLowestBin(String internalName) {
        JsonElement e2;
        if (this.lowestBins != null && this.lowestBins.has(internalName) && (e2 = this.lowestBins.get(internalName)).isJsonPrimitive() && e2.getAsJsonPrimitive().isNumber()) {
            return e2.getAsLong();
        }
        return -1L;
    }

    public void updateLowestBin() {
        this.manager.apiUtils.newMoulberryRequest("lowestbin.json.gz").gunzip().requestJson().thenAcceptAsync(jsonObject -> {
            if (this.lowestBins == null) {
                this.lowestBins = new JsonObject();
            }
            if (!jsonObject.entrySet().isEmpty()) {
                this.lastLowestBinUpdate = System.currentTimeMillis();
            }
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                this.lowestBins.add(entry.getKey(), entry.getValue());
            }
            if (!this.didFirstUpdate) {
                ItemPriceInformation.updateAuctionableItemsList();
                this.didFirstUpdate = true;
            }
            LocalGraphDataProvider.INSTANCE.savePrices(this.lowestBins, false);
        });
    }

    public long getLastLowestBinUpdateTime() {
        return this.lastLowestBinUpdate;
    }

    public String transformHypixelBazaarToNEUItemId(String hypixelId) {
        Matcher matcher = BAZAAR_ENCHANTMENT_PATTERN.matcher(hypixelId);
        if (matcher.matches()) {
            return matcher.group(1) + ";" + matcher.group(2);
        }
        return hypixelId.replace(":", "-");
    }

    public void updateBazaar() {
        this.manager.apiUtils.newAnonymousHypixelApiRequest("skyblock/bazaar").requestJson().thenAcceptAsync(jsonObject -> {
            if (!jsonObject.get("success").getAsBoolean()) {
                return;
            }
            this.craftCost.clear();
            this.bazaarJson = new JsonObject();
            JsonObject products = jsonObject.get("products").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : products.entrySet()) {
                JsonObject sellSummaryFirst;
                if (!entry.getValue().isJsonObject()) continue;
                JsonObject productInfo = new JsonObject();
                JsonObject product = entry.getValue().getAsJsonObject();
                JsonObject quickStatus = product.getAsJsonObject("quick_status");
                if (!APIManager.hasData(quickStatus)) continue;
                productInfo.addProperty("avg_buy", Float.valueOf(quickStatus.get("buyPrice").getAsFloat()));
                productInfo.addProperty("avg_sell", Float.valueOf(quickStatus.get("sellPrice").getAsFloat()));
                float instasellsWeekly = quickStatus.get("sellMovingWeek").getAsFloat();
                float instabuysWeekly = quickStatus.get("buyMovingWeek").getAsFloat();
                productInfo.addProperty("instasells_weekly", Float.valueOf(instasellsWeekly));
                productInfo.addProperty("instabuys_weekly", Float.valueOf(instabuysWeekly));
                productInfo.addProperty("instasells_daily", Float.valueOf(instasellsWeekly / 7.0f));
                productInfo.addProperty("instabuys_daily", Float.valueOf(instabuysWeekly / 7.0f));
                productInfo.addProperty("instasells_hourly", Float.valueOf(instasellsWeekly / 7.0f / 24.0f));
                productInfo.addProperty("instabuys_hourly", Float.valueOf(instabuysWeekly / 7.0f / 24.0f));
                for (JsonElement element : product.get("sell_summary").getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    sellSummaryFirst = element.getAsJsonObject();
                    productInfo.addProperty("curr_sell", Float.valueOf(sellSummaryFirst.get("pricePerUnit").getAsFloat()));
                    break;
                }
                for (JsonElement element : product.get("buy_summary").getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    sellSummaryFirst = element.getAsJsonObject();
                    productInfo.addProperty("curr_buy", Float.valueOf(sellSummaryFirst.get("pricePerUnit").getAsFloat()));
                    break;
                }
                this.bazaarJson.add(this.transformHypixelBazaarToNEUItemId(entry.getKey()), productInfo);
            }
            LocalGraphDataProvider.INSTANCE.savePrices(this.bazaarJson, true);
        });
    }

    private static boolean hasData(JsonObject quickStatus) {
        for (Map.Entry<String, JsonElement> e2 : quickStatus.entrySet()) {
            double value;
            String key = e2.getKey();
            if (key.equals("productId") || (value = e2.getValue().getAsDouble()) == 0.0) continue;
            return true;
        }
        return false;
    }

    public void updateAvgPrices() {
        this.manager.apiUtils.newMoulberryRequest("auction_averages/3day.json.gz").gunzip().requestJson().thenAcceptAsync(jsonObject -> {
            this.craftCost.clear();
            this.auctionPricesJson = jsonObject;
            this.lastAuctionAvgUpdate = System.currentTimeMillis();
        });
        this.manager.apiUtils.newMoulberryRequest("auction_averages_lbin/1day.json.gz").gunzip().requestJson().thenAcceptAsync(jsonObject -> {
            this.auctionPricesAvgLowestBinJson = jsonObject;
        });
    }

    public Set<String> getItemAuctionInfoKeySet() {
        if (this.auctionPricesJson == null) {
            return new HashSet<String>();
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, JsonElement> entry : this.auctionPricesJson.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    public JsonObject getItemAuctionInfo(String internalname) {
        if (this.auctionPricesJson == null) {
            return null;
        }
        JsonElement e2 = this.auctionPricesJson.get(internalname);
        if (e2 == null) {
            return null;
        }
        return e2.getAsJsonObject();
    }

    public double getItemAvgBin(String internalName) {
        if (this.auctionPricesAvgLowestBinJson == null) {
            return -1.0;
        }
        JsonElement e2 = this.auctionPricesAvgLowestBinJson.get(internalName);
        if (e2 == null) {
            return -1.0;
        }
        return Math.round(e2.getAsDouble());
    }

    public Set<String> getBazaarKeySet() {
        if (this.bazaarJson == null) {
            return new HashSet<String>();
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, JsonElement> entry : this.bazaarJson.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    public double getBazaarOrBin(String internalName, boolean useSellingPrice) {
        String curr = useSellingPrice ? "curr_sell" : "curr_buy";
        JsonObject bazaarInfo = this.manager.auctionManager.getBazaarInfo(internalName);
        if (bazaarInfo != null && bazaarInfo.get(curr) != null) {
            return bazaarInfo.get(curr).getAsFloat();
        }
        return this.manager.auctionManager.getLowestBin(internalName);
    }

    public JsonObject getBazaarInfo(String internalName) {
        if (this.bazaarJson == null) {
            return null;
        }
        JsonElement e2 = this.bazaarJson.get(internalName);
        if (e2 == null) {
            return null;
        }
        return e2.getAsJsonObject();
    }

    public boolean isVanillaItem(String internalName) {
        JsonObject json;
        if (hardcodedVanillaItems.contains(internalName)) {
            return true;
        }
        String vanillaName = internalName.split("-")[0];
        if (this.manager.getItemInformation().containsKey(vanillaName) && (json = this.manager.getItemInformation().get(vanillaName)) != null && json.has("vanilla") && json.get("vanilla").getAsBoolean()) {
            return true;
        }
        return Item.field_150901_e.func_82594_a((Object)new ResourceLocation(vanillaName)) != null;
    }

    public CraftInfo getCraftCost(String internalName) {
        return this.getCraftCost(internalName, new HashSet<String>());
    }

    private CraftInfo getCraftCost(String internalName, Set<String> visited) {
        if (this.craftCost.containsKey(internalName)) {
            return this.craftCost.get(internalName);
        }
        if (visited.contains(internalName)) {
            return null;
        }
        visited.add(internalName);
        boolean vanillaItem = this.isVanillaItem(internalName);
        double craftCost = Double.POSITIVE_INFINITY;
        JsonObject auctionInfo = this.getItemAuctionInfo(internalName);
        double lowestBin = this.getLowestBin(internalName);
        JsonObject bazaarInfo = this.getBazaarInfo(internalName);
        if (bazaarInfo != null && bazaarInfo.get("curr_buy") != null) {
            craftCost = bazaarInfo.get("curr_buy").getAsFloat();
        }
        if (!vanillaItem) {
            if (lowestBin > 0.0) {
                craftCost = Math.min(lowestBin, craftCost);
            } else if (auctionInfo != null) {
                float auctionPrice = auctionInfo.get("price").getAsFloat() / (float)auctionInfo.get("count").getAsInt();
                craftCost = Math.min((double)auctionPrice, craftCost);
            }
        }
        Set<NeuRecipe> recipes = this.manager.getRecipesFor(internalName);
        boolean fromRecipe = false;
        if (recipes != null) {
            block0: for (NeuRecipe recipe : recipes) {
                float f;
                if (recipe instanceof ItemShopRecipe && vanillaItem || recipe.hasVariableCost() || !recipe.shouldUseForCraftCost()) continue;
                float craftPrice = 0.0f;
                for (Ingredient ingredient : recipe.getIngredients()) {
                    if (ingredient.isCoins()) {
                        craftPrice = (float)((double)craftPrice + ingredient.getCount());
                        continue;
                    }
                    CraftInfo ingredientCraftCost = this.getCraftCost(ingredient.getInternalItemId(), visited);
                    if (ingredientCraftCost == null) continue block0;
                    craftPrice = (float)((double)craftPrice + ingredientCraftCost.craftCost * ingredient.getCount());
                }
                int resultCount = 0;
                for (Ingredient item : recipe.getOutputs()) {
                    if (!item.getInternalItemId().equals(internalName)) continue;
                    resultCount = (int)((double)resultCount + item.getCount());
                }
                if (resultCount == 0 || !((double)(f = craftPrice / (float)resultCount) < craftCost)) continue;
                fromRecipe = true;
                craftCost = f;
            }
        }
        visited.remove(internalName);
        if (Double.isInfinite(craftCost)) {
            return null;
        }
        CraftInfo craftInfo = new CraftInfo();
        craftInfo.vanillaItem = vanillaItem;
        craftInfo.craftCost = craftCost;
        craftInfo.fromRecipe = fromRecipe;
        this.craftCost.put(internalName, craftInfo);
        return craftInfo;
    }

    public static class CraftInfo {
        public boolean fromRecipe = false;
        public boolean vanillaItem = false;
        public double craftCost = -1.0;
    }
}

