/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.NowikiTag;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class MathTag
extends NowikiTag {
    public MathTag() {
        super("math");
    }

    @Override
    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        if (model.isMathtranRenderer()) {
            String content = this.getBodyString();
            if (content != null && content.length() > 0) {
                String sizeStr = "D=3";
                Map<String, String> tagAtttributes = this.getAttributes();
                String attributeValue = tagAtttributes.get("d");
                if (attributeValue != null) {
                    try {
                        int size = Integer.parseInt(attributeValue);
                        if (size > 0 && size <= 10) {
                            sizeStr = "D=" + size;
                        }
                    }
                    catch (NumberFormatException size) {
                        // empty catch block
                    }
                }
                String texFormula = "http://www.mathtran.org/cgi-bin/mathtran?" + sizeStr + "&amp;tex=" + URLEncoder.encode(content, StandardCharsets.UTF_8.name());
                writer.append("<span class=\"tex\"><img src=\"" + texFormula + "\" alt=\"");
                MathTag.copyMathLTGT(content, writer);
                writer.append("\" /></span>");
            }
        } else {
            String content = this.getBodyString();
            if (content != null && content.length() > 0) {
                writer.append("<span class=\"math\">");
                MathTag.copyMathLTGT(content, writer);
                writer.append("</span>");
            }
        }
    }

    @Override
    public boolean isReduceTokenStack() {
        return true;
    }
}

