/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.dump;

import info.bliki.wiki.dump.InfoBox;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiPatternMatcher {
    private String wikiText = null;
    private List<String> pageCats = null;
    private List<String> pageLinks = null;
    private boolean redirect = false;
    private String redirectString = null;
    private boolean stub = false;
    private boolean disambiguation = false;
    private static final Pattern REDIRECT_PATTERN = Pattern.compile("#REDIRECT\\s+\\[\\[(.*?)\\]\\]");
    private static final Pattern STUB_PATTERN = Pattern.compile("\\-stub\\}\\}");
    private static final Pattern DISAMB_TEMPLATE_PATTERN = Pattern.compile("\\{\\{disambig\\}\\}");
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("\\[\\[Category:(.*?)\\]\\]", 8);
    private static final Pattern LINKS_PATTERN = Pattern.compile("\\[\\[(.*?)\\]\\]", 8);
    private InfoBox infoBox = null;

    public WikiPatternMatcher(String wtext) {
        this.wikiText = wtext;
        Matcher matcher = REDIRECT_PATTERN.matcher(this.wikiText);
        if (matcher.find()) {
            this.redirect = true;
            if (matcher.groupCount() == 1) {
                this.redirectString = matcher.group(1);
            }
        }
        matcher = STUB_PATTERN.matcher(this.wikiText);
        this.stub = matcher.find();
        matcher = DISAMB_TEMPLATE_PATTERN.matcher(this.wikiText);
        this.disambiguation = matcher.find();
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isStub() {
        return this.stub;
    }

    public String getRedirectText() {
        return this.redirectString;
    }

    public String getText() {
        return this.wikiText;
    }

    public List<String> getCategories() {
        if (this.pageCats == null) {
            this.parseCategories();
        }
        return this.pageCats;
    }

    public List<String> getLinks() {
        if (this.pageLinks == null) {
            this.parseLinks();
        }
        return this.pageLinks;
    }

    private void parseCategories() {
        this.pageCats = new ArrayList<String>();
        Matcher matcher = CATEGORY_PATTERN.matcher(this.wikiText);
        while (matcher.find()) {
            String[] temp = matcher.group(1).split("\\|");
            this.pageCats.add(temp[0]);
        }
    }

    private void parseLinks() {
        this.pageLinks = new ArrayList<String>();
        Matcher matcher = LINKS_PATTERN.matcher(this.wikiText);
        while (matcher.find()) {
            String link;
            String[] temp = matcher.group(1).split("\\|");
            if (temp == null || temp.length == 0 || (link = temp[0]).contains(":")) continue;
            this.pageLinks.add(link);
        }
    }

    public String getPlainText() {
        String text = this.wikiText.replaceAll("&gt;", ">");
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("<ref>.*?</ref>", " ");
        text = text.replaceAll("</?.*?>", " ");
        text = text.replaceAll("\\{\\{.*?\\}\\}", " ");
        text = text.replaceAll("\\[\\[.*?:.*?\\]\\]", " ");
        text = text.replaceAll("\\[\\[(.*?)\\]\\]", "$1");
        text = text.replaceAll("\\s(.*?)\\|(\\w+\\s)", " $2");
        text = text.replaceAll("\\[.*?\\]", " ");
        text = text.replaceAll("\\'+", "");
        return text;
    }

    public InfoBox getInfoBox() {
        if (this.infoBox == null) {
            this.infoBox = this.parseInfoBox();
        }
        return this.infoBox;
    }

    private InfoBox parseInfoBox() {
        String INFOBOX_CONST_STR = "{{Infobox";
        int startPos = this.wikiText.indexOf(INFOBOX_CONST_STR);
        if (startPos < 0) {
            return null;
        }
        int bracketCount = 2;
        int endPos = startPos + INFOBOX_CONST_STR.length();
        if (endPos >= this.wikiText.length()) {
            return null;
        }
        while (endPos < this.wikiText.length()) {
            switch (this.wikiText.charAt(endPos)) {
                case '}': {
                    --bracketCount;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    break;
                }
            }
            if (bracketCount == 0) break;
            ++endPos;
        }
        String infoBoxText = endPos >= this.wikiText.length() ? this.wikiText.substring(startPos) : this.wikiText.substring(startPos, endPos + 1);
        infoBoxText = this.stripCite(infoBoxText);
        infoBoxText = infoBoxText.replaceAll("&gt;", ">");
        infoBoxText = infoBoxText.replaceAll("&lt;", "<");
        infoBoxText = infoBoxText.replaceAll("<ref.*?>.*?</ref>", " ");
        infoBoxText = infoBoxText.replaceAll("</?.*?>", " ");
        return new InfoBox(infoBoxText);
    }

    private String stripCite(String text) {
        int endPos;
        String CITE_CONST_STR = "{{cite";
        int startPos = text.indexOf(CITE_CONST_STR);
        if (startPos < 0) {
            return text;
        }
        int bracketCount = 2;
        for (endPos = startPos + CITE_CONST_STR.length(); endPos < text.length(); ++endPos) {
            switch (text.charAt(endPos)) {
                case '}': {
                    --bracketCount;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    break;
                }
            }
            if (bracketCount == 0) break;
        }
        text = text.substring(0, startPos - 1) + text.substring(endPos);
        return this.stripCite(text);
    }

    public boolean isDisambiguationPage() {
        return this.disambiguation;
    }

    public String getTranslatedTitle(String languageCode) {
        Pattern translatePattern = Pattern.compile("^\\[\\[" + languageCode + ":(.*?)\\]\\]$", 8);
        Matcher matcher = translatePattern.matcher(this.wikiText);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

