/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.HtmlCleaner;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.XmlSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class SimpleXmlSerializer
extends XmlSerializer {
    protected SimpleXmlSerializer(Writer writer, HtmlCleaner htmlCleaner) {
        super(writer, htmlCleaner);
    }

    private void serialize(List<Object> nodes, TagNode tagNode) throws IOException {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    List list = (List)item;
                    this.serialize(list, tagNode);
                    continue;
                }
                if (item instanceof ContentToken) {
                    ContentToken contentToken = (ContentToken)item;
                    String content = contentToken.getContent();
                    content = !this.dontEscape(tagNode) ? this.escapeXml(content) : content.replaceAll("]]>", "]]&amp;");
                    this.writer.write(content);
                    continue;
                }
                ((BaseToken)item).serialize(this);
            }
        }
    }

    @Override
    protected void serialize(TagNode tagNode) throws IOException {
        this.serializeOpenTag(tagNode);
        List<Object> tagChildren = tagNode.getChildren();
        if (!tagChildren.isEmpty()) {
            this.serialize(tagChildren, tagNode);
            this.serializeEndTag(tagNode);
        }
    }
}

