/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.CommentToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.HtmlCleaner;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.Utils;
import info.bliki.htmlcleaner.XmlSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PrettyXmlSerializer
extends XmlSerializer {
    private static final String INDENTATION_STRING = "\t";

    protected PrettyXmlSerializer(Writer writer, HtmlCleaner htmlCleaner) {
        super(writer, htmlCleaner);
    }

    @Override
    protected void serialize(TagNode tagNode) throws IOException {
        this.serializePrettyXml(tagNode, 0);
    }

    private String indent(int level) {
        String result2 = "";
        while (level > 0) {
            result2 = result2 + INDENTATION_STRING;
            --level;
        }
        return result2;
    }

    private String getIndentedText(String content, int level) {
        String indent = this.indent(level);
        StringBuffer result2 = new StringBuffer(content.length());
        StringTokenizer tokenizer = new StringTokenizer(content, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if ("".equals(line)) continue;
            result2.append(indent + line + "\n");
        }
        return result2.toString();
    }

    private String getSingleLineOfChildren(List<Object> children) {
        StringBuffer result2 = new StringBuffer();
        Iterator<Object> childrenIt = children.iterator();
        boolean isFirst = true;
        while (childrenIt.hasNext()) {
            Object child = childrenIt.next();
            if (!(child instanceof ContentToken)) {
                return null;
            }
            ContentToken contentToken = (ContentToken)child;
            String content = contentToken.getContent();
            if (isFirst) {
                content = Utils.ltrim(content);
            }
            if (!childrenIt.hasNext()) {
                content = Utils.rtrim(content);
            }
            if (content.indexOf("\n") >= 0 || content.indexOf("\r") >= 0) {
                return null;
            }
            result2.append(content);
            isFirst = false;
        }
        return result2.toString();
    }

    private void serializePrettyXml(List<Object> nodes, int level, boolean dontEscape) throws IOException {
        for (Object child : nodes) {
            String content;
            if (child instanceof TagNode) {
                this.serializePrettyXml((TagNode)child, level + 1);
                continue;
            }
            if (child instanceof ContentToken) {
                ContentToken contentToken = (ContentToken)child;
                content = contentToken.getContent();
                content = !dontEscape ? this.escapeXml(content) : content.replaceAll("]]>", "]]&amp;");
                this.writer.write(this.getIndentedText(content, level + 1));
                continue;
            }
            if (child instanceof CommentToken) {
                CommentToken commentToken = (CommentToken)child;
                content = commentToken.getContent();
                this.writer.write(this.getIndentedText(content, level + 1));
                continue;
            }
            if (!(child instanceof List)) continue;
            List list = (List)child;
            this.serializePrettyXml(list, level, true);
        }
    }

    protected void serializePrettyXml(TagNode tagNode, int level) throws IOException {
        List<Object> tagChildren = tagNode.getChildren();
        String indent = this.indent(level);
        this.writer.write(indent);
        this.serializeOpenTag(tagNode);
        if (!tagChildren.isEmpty()) {
            String singleLine = this.getSingleLineOfChildren(tagChildren);
            boolean dontEscape = this.dontEscape(tagNode);
            if (singleLine != null) {
                if (!this.dontEscape(tagNode)) {
                    this.writer.write(this.escapeXml(singleLine));
                } else {
                    this.writer.write(singleLine.replaceAll("]]>", "]]&amp;"));
                }
            } else {
                this.writer.write("\n");
                this.serializePrettyXml(tagChildren, level, dontEscape);
            }
            if (singleLine == null) {
                this.writer.write(indent);
            }
            this.serializeEndTag(tagNode);
        }
    }
}

