/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua.interfaces;

import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaEngine;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInterface;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class MwUri
implements MwInterface {
    private String wgServer = "//wiki.local";
    private String wgCanonicalServer = "http://wiki.local";
    private boolean wgUsePathInfo = true;
    private String wgScript = "/w/index.php";
    private String wgScriptPath = "/w";
    private String wgArticlePath = "/wiki/$1";

    @Override
    public String name() {
        return "mw.uri";
    }

    @Override
    public LuaTable getInterface() {
        LuaTable iface = new LuaTable();
        iface.set("anchorEncode", this.anchorEncode());
        iface.set("localUrl", this.localUrl());
        iface.set("fullUrl", this.fullUrl());
        iface.set("canonicalUrl", this.canonicalUrl());
        return iface;
    }

    private LuaValue anchorEncode() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                return LuaValue.EMPTYSTRING;
            }
        };
    }

    private LuaValue canonicalUrl() {
        return new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue page, LuaValue query) {
                if (query.isnil()) {
                    return ScribuntoLuaEngine.toLuaString(MwUri.this.wgCanonicalServer + MwUri.this.pagePath(page));
                }
                return ScribuntoLuaEngine.toLuaString(MwUri.this.wgCanonicalServer + MwUri.this.formatQuery(page, query));
            }
        };
    }

    private LuaValue fullUrl() {
        return new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue page, LuaValue query) {
                if (query.isnil()) {
                    return ScribuntoLuaEngine.toLuaString(MwUri.this.wgServer + MwUri.this.pagePath(page));
                }
                return ScribuntoLuaEngine.toLuaString(MwUri.this.wgServer + MwUri.this.formatQuery(page, query));
            }
        };
    }

    private LuaValue localUrl() {
        return new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue page, LuaValue query) {
                if (query.isnil()) {
                    return ScribuntoLuaEngine.toLuaString(MwUri.this.pagePath(page));
                }
                return ScribuntoLuaEngine.toLuaString(MwUri.this.formatQuery(page, query));
            }
        };
    }

    @Override
    public LuaValue getSetupOptions() {
        LuaTable options = new LuaTable();
        return options;
    }

    private String pagePath(LuaValue page) {
        return this.wgArticlePath.replace("$1", page.tojstring());
    }

    private String formatQuery(LuaValue page, LuaValue query) {
        if (query.isstring()) {
            return this.wgScript + "?title=" + page.checkstring() + "&" + query.checkjstring();
        }
        if (query.istable()) {
            LuaTable params = query.checktable();
            String base = this.wgScript + "?title=" + page.checkstring() + "&";
            for (LuaValue key : params.keys()) {
                base = base + key.tojstring() + "=" + params.get(key).tojstring();
            }
            return base;
        }
        throw new AssertionError((Object)("unexpected type: " + query));
    }
}

