/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.util.Arrays;

public class PGPCanonicalizedDataGenerator
implements StreamGenerator {
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private PGPLiteralDataGenerator lGen;
    private boolean oldFormat = false;

    public PGPCanonicalizedDataGenerator() {
    }

    public PGPCanonicalizedDataGenerator(boolean bl) {
        this.oldFormat = bl;
    }

    public OutputStream open(OutputStream outputStream2, char c, String string, Date date) throws IOException {
        if (this.lGen != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.lGen = new PGPLiteralDataGenerator(this.oldFormat);
        return new ArrayCRLFGeneratorStream(outputStream2, this.lGen, c, string, new Date(date.getTime()));
    }

    public OutputStream open(OutputStream outputStream2, char c, String string, Date date, File file2) throws IOException {
        if (this.lGen != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.lGen = new PGPLiteralDataGenerator(this.oldFormat);
        return new FileCRLFGeneratorStream(outputStream2, this.lGen, c, string, new Date(date.getTime()), file2);
    }

    public OutputStream open(OutputStream outputStream2, char c, String string, Date date, byte[] byArray) throws IOException {
        if (this.lGen != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.lGen = new PGPLiteralDataGenerator(this.oldFormat);
        return new IndefiniteCRLFGeneratorStream(outputStream2, this.lGen, c, string, new Date(date.getTime()), byArray);
    }

    public OutputStream open(OutputStream outputStream2, char c, File file2) throws IOException {
        return this.open(outputStream2, c, file2.getName(), new Date(file2.lastModified()));
    }

    @Override
    public void close() throws IOException {
        if (this.lGen != null) {
            this.lGen.close();
            this.lGen = null;
        }
    }

    private static class ArrayCRLFGeneratorStream
    extends CRLFGeneratorStream {
        private final OutputStream out;
        private final PGPLiteralDataGenerator lGen;
        private final char format;
        private final String name;
        private final Date modificationTime;

        public ArrayCRLFGeneratorStream(OutputStream outputStream2, PGPLiteralDataGenerator pGPLiteralDataGenerator, char c, String string, Date date) {
            super(new ErasableOutputStream(), c == 'b');
            this.out = outputStream2;
            this.lGen = pGPLiteralDataGenerator;
            this.format = c;
            this.name = string;
            this.modificationTime = date;
        }

        @Override
        public void close() throws IOException {
            super.close();
            ErasableOutputStream erasableOutputStream = (ErasableOutputStream)this.crlfOut;
            byte[] byArray = erasableOutputStream.getBuf();
            int n = erasableOutputStream.size();
            OutputStream outputStream2 = this.lGen.open(this.out, this.format, this.name, n, this.modificationTime);
            outputStream2.write(byArray, 0, n);
            outputStream2.close();
            erasableOutputStream.erase();
        }
    }

    static class CRLFGeneratorStream
    extends OutputStream {
        protected final OutputStream crlfOut;
        private final boolean isBinary;
        private int lastB = 0;

        public CRLFGeneratorStream(OutputStream outputStream2, boolean bl) {
            this.crlfOut = outputStream2;
            this.isBinary = bl;
        }

        @Override
        public void write(int n) throws IOException {
            if (!this.isBinary) {
                if (n == 10 && this.lastB != 13) {
                    this.crlfOut.write(13);
                } else if (this.lastB == 13 && n != 10) {
                    this.crlfOut.write(10);
                }
                this.lastB = n;
            }
            this.crlfOut.write(n);
        }

        @Override
        public void close() throws IOException {
            if (!this.isBinary && this.lastB == 13) {
                this.crlfOut.write(10);
            }
            this.crlfOut.close();
        }
    }

    private static final class ErasableOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }

        public void erase() {
            Arrays.fill((byte[])this.buf, (byte)0);
            this.reset();
        }
    }

    private static class FileCRLFGeneratorStream
    extends CRLFGeneratorStream {
        private final OutputStream out;
        private final PGPLiteralDataGenerator lGen;
        private final char format;
        private final String name;
        private final Date modificationTime;
        private final File backingFile;

        public FileCRLFGeneratorStream(OutputStream outputStream2, PGPLiteralDataGenerator pGPLiteralDataGenerator, char c, String string, Date date, File file2) throws FileNotFoundException {
            super(new BufferedOutputStream(new FileOutputStream(file2)), c == 'b');
            this.out = outputStream2;
            this.lGen = pGPLiteralDataGenerator;
            this.format = c;
            this.name = string;
            this.modificationTime = date;
            this.backingFile = file2;
        }

        @Override
        public void close() throws IOException {
            super.close();
            OutputStream outputStream2 = this.lGen.open(this.out, this.format, this.name, this.backingFile.length(), this.modificationTime);
            PGPUtil.pipeFileContents(this.backingFile, outputStream2, 32678);
        }
    }

    private static class IndefiniteCRLFGeneratorStream
    extends CRLFGeneratorStream {
        public IndefiniteCRLFGeneratorStream(OutputStream outputStream2, PGPLiteralDataGenerator pGPLiteralDataGenerator, char c, String string, Date date, byte[] byArray) throws IOException {
            super(pGPLiteralDataGenerator.open(outputStream2, c, string, date, byArray), c == 'b');
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

