/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.tweaker;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import gg.skytils.skytilsmod.tweaker.TweakerUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.Security;

public class DependencyLoader {
    private static final String MAVEN_CENTRAL_ROOT = "https://repo1.maven.org/maven2/";
    public static boolean hasNativeBrotli = false;

    public static void loadDependencies() {
        DependencyLoader.loadBrotli();
        if (Security.getProvider("BC") == null) {
            DependencyLoader.loadBCProv();
        }
    }

    public static File loadDependency(String path) throws Throwable {
        File downloadLocation = new File("./libraries/" + path);
        Path downloadPath = downloadLocation.toPath();
        downloadLocation.getParentFile().mkdirs();
        if (!downloadLocation.exists() || Files.size(downloadPath) == 0L) {
            try (InputStream in = new URL(MAVEN_CENTRAL_ROOT + path).openStream();){
                Files.copy(in, downloadPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        System.out.printf("Dependency size for %s: %s%n", path.substring(path.lastIndexOf(47) + 1), Files.size(downloadPath));
        TweakerUtil.addToClasspath(downloadLocation.toURI().toURL());
        return downloadLocation;
    }

    public static void loadBCProv() {
        try {
            DependencyLoader.loadDependency("org/bouncycastle/bcprov-jdk18on/1.78.1/bcprov-jdk18on-1.78.1.jar");
            System.out.println("Bouncy Castle provider loaded");
        }
        catch (Throwable t) {
            System.out.println("Failed to load Bouncy Castle providers");
            t.printStackTrace();
        }
    }

    public static void loadBrotli() {
        if (System.getProperty("skytils.noNativeBrotli") != null) {
            System.out.println("Native Brotli disabled by system property");
            hasNativeBrotli = false;
            return;
        }
        try {
            String brotli4jPlatform = DependencyLoader.getBrotli4jPlatform();
            DependencyLoader.loadDependency(String.format("com/aayushatharva/brotli4j/native-%s/1.16.0/native-%s-1.16.0.jar", brotli4jPlatform, brotli4jPlatform));
            Brotli4jLoader.ensureAvailability();
            hasNativeBrotli = true;
            System.out.println("Native Brotli loaded");
        }
        catch (Throwable t) {
            System.out.println("Failed to load native Brotli");
            t.printStackTrace();
            hasNativeBrotli = false;
        }
    }

    public static String getBrotli4jPlatform() {
        String osName = System.getProperty("os.name");
        String archName = System.getProperty("os.arch");
        if ("Linux".equalsIgnoreCase(osName)) {
            if ("amd64".equalsIgnoreCase(archName)) {
                return "linux-x86_64";
            }
            if ("aarch64".equalsIgnoreCase(archName)) {
                return "linux-aarch64";
            }
            if ("arm".equalsIgnoreCase(archName)) {
                return "linux-armv7";
            }
            if ("s390x".equalsIgnoreCase(archName)) {
                return "linux-s390x";
            }
            if ("ppc64le".equalsIgnoreCase(archName)) {
                return "linux-ppc64le";
            }
            if ("riscv64".equalsIgnoreCase(archName)) {
                return "linux-riscv64";
            }
        } else if (osName.startsWith("Windows")) {
            if ("amd64".equalsIgnoreCase(archName)) {
                return "windows-x86_64";
            }
            if ("aarch64".equalsIgnoreCase(archName)) {
                return "windows-aarch64";
            }
        } else if (osName.startsWith("Mac")) {
            if ("x86_64".equalsIgnoreCase(archName)) {
                return "osx-x86_64";
            }
            if ("aarch64".equalsIgnoreCase(archName)) {
                return "osx-aarch64";
            }
        }
        throw new UnsupportedOperationException("Unsupported OS and Architecture: " + osName + ", " + archName);
    }
}

