/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.lib.antlr.runtime.misc;

import gg.skytils.mixinextras.lib.antlr.runtime.misc.AbstractEqualityComparator;
import gg.skytils.mixinextras.lib.antlr.runtime.misc.MurmurHash;
import gg.skytils.mixinextras.lib.antlr.runtime.misc.ObjectEqualityComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FlexibleHashMap<K, V>
implements Map<K, V> {
    protected final AbstractEqualityComparator<? super K> comparator;
    protected LinkedList<Entry<K, V>>[] buckets;
    protected int n = 0;
    protected int currentPrime = 1;
    protected int threshold;
    protected final int initialCapacity;
    protected final int initialBucketCapacity;

    public FlexibleHashMap(AbstractEqualityComparator<? super K> comparator2) {
        this(comparator2, 16, 8);
    }

    public FlexibleHashMap(AbstractEqualityComparator<? super K> comparator2, int initialCapacity, int initialBucketCapacity) {
        if (comparator2 == null) {
            comparator2 = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = comparator2;
        this.initialCapacity = initialCapacity;
        this.initialBucketCapacity = initialBucketCapacity;
        this.threshold = (int)Math.floor((double)initialCapacity * 0.75);
        this.buckets = FlexibleHashMap.createEntryListArray(initialBucketCapacity);
    }

    private static <K, V> LinkedList<Entry<K, V>>[] createEntryListArray(int length) {
        LinkedList[] result2 = new LinkedList[length];
        return result2;
    }

    protected int getBucket(K key2) {
        int hash = this.comparator.hashCode(key2);
        int b = hash & this.buckets.length - 1;
        return b;
    }

    @Override
    public V get(Object key2) {
        Object typedKey = key2;
        if (key2 == null) {
            return null;
        }
        int b = this.getBucket(typedKey);
        LinkedList<Entry<K, V>> bucket = this.buckets[b];
        if (bucket == null) {
            return null;
        }
        for (Entry entry : bucket) {
            if (!this.comparator.equals(entry.key, typedKey)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public V put(K key2, V value) {
        int b;
        LinkedList<Entry<K, V>> bucket;
        if (key2 == null) {
            return null;
        }
        if (this.n > this.threshold) {
            this.expand();
        }
        if ((bucket = this.buckets[b = this.getBucket(key2)]) == null) {
            this.buckets[b] = new LinkedList();
            bucket = this.buckets[b];
        }
        for (Entry entry : bucket) {
            if (!this.comparator.equals(entry.key, key2)) continue;
            Object prev = entry.value;
            entry.value = value;
            ++this.n;
            return prev;
        }
        bucket.add(new Entry<K, V>(key2, value));
        ++this.n;
        return null;
    }

    @Override
    public V remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        ArrayList a = new ArrayList(this.size());
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                a.add(entry.value);
            }
        }
        return a;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.get(key2) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize();
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            Entry e;
            if (bucket == null) continue;
            Iterator iterator2 = bucket.iterator();
            while (iterator2.hasNext() && (e = (Entry)iterator2.next()) != null) {
                hash = MurmurHash.update(hash, this.comparator.hashCode(e.key));
            }
        }
        hash = MurmurHash.finish(hash, this.size());
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    protected void expand() {
        LinkedList<Entry<K, V>>[] old = this.buckets;
        this.currentPrime += 4;
        int newCapacity = this.buckets.length * 2;
        LinkedList<Entry<K, V>>[] newTable = FlexibleHashMap.createEntryListArray(newCapacity);
        this.buckets = newTable;
        this.threshold = (int)((double)newCapacity * 0.75);
        int oldSize = this.size();
        for (LinkedList<Entry<K, V>> bucket : old) {
            Entry e;
            if (bucket == null) continue;
            Iterator iterator2 = bucket.iterator();
            while (iterator2.hasNext() && (e = (Entry)iterator2.next()) != null) {
                this.put(e.key, e.value);
            }
        }
        this.n = oldSize;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.buckets = FlexibleHashMap.createEntryListArray(this.initialCapacity);
        this.n = 0;
        this.threshold = (int)Math.floor((double)this.initialCapacity * 0.75);
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first2 = true;
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            Entry e;
            if (bucket == null) continue;
            Iterator iterator2 = bucket.iterator();
            while (iterator2.hasNext() && (e = (Entry)iterator2.next()) != null) {
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(", ");
                }
                buf.append(e.toString());
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public static class Entry<K, V> {
        public final K key;
        public V value;

        public Entry(K key2, V value) {
            this.key = key2;
            this.value = value;
        }

        public String toString() {
            return this.key.toString() + ":" + this.value.toString();
        }
    }
}

