/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.ast.expressions;

import gg.skytils.mixinextras.expression.impl.ExpressionSource;
import gg.skytils.mixinextras.expression.impl.ast.expressions.Expression;
import gg.skytils.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import gg.skytils.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.point.ExpressionContext;
import gg.skytils.mixinextras.expression.impl.utils.ExpressionASMUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class CastExpression
extends SimpleExpression {
    public final TypeIdentifier type;
    public final Expression expression;

    public CastExpression(ExpressionSource src, TypeIdentifier type2, Expression expression) {
        super(src);
        this.type = type2;
        this.expression = expression;
    }

    @Override
    public boolean matches(FlowValue node, ExpressionContext ctx) {
        Type castType = this.getCastType(node.getInsn());
        return castType != null && this.type.matches(ctx.pool, castType) && CastExpression.inputsMatch(node, ctx, this.expression);
    }

    @Override
    public void capture(FlowValue node, ExpressionContext ctx) {
        if (node.getInsn().getOpcode() == 192) {
            ctx.decorate(node.getInsn(), "mixinextras_simpleOperationArgs", new Type[]{ExpressionASMUtils.OBJECT_TYPE});
            ctx.decorate(node.getInsn(), "mixinextras_simpleOperationReturnType", node.getType());
            ctx.decorate(node.getInsn(), "mixinextras_simpleOperationParamNames", new String[]{"object"});
        }
        super.capture(node, ctx);
    }

    private Type getCastType(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 192: {
                return Type.getObjectType((String)((TypeInsnNode)insn).desc);
            }
            case 136: 
            case 139: 
            case 142: {
                return Type.INT_TYPE;
            }
            case 145: {
                return Type.BYTE_TYPE;
            }
            case 146: {
                return Type.CHAR_TYPE;
            }
            case 147: {
                return Type.SHORT_TYPE;
            }
            case 134: 
            case 137: 
            case 144: {
                return Type.FLOAT_TYPE;
            }
            case 133: 
            case 140: 
            case 143: {
                return Type.LONG_TYPE;
            }
            case 135: 
            case 138: 
            case 141: {
                return Type.DOUBLE_TYPE;
            }
        }
        return null;
    }
}

