/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.json.internal.AbstractJsonLexer;
import gg.skytils.ktx-serialization.json.internal.JsonDecodingException;
import gg.skytils.ktx-serialization.json.internal.JsonEncodingException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\b\u001a'\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a'\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\t\u0010\u000b\u001a\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0017\u001a\u001f\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a'\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u001d\u0010\u001f\u001a\u00020\u001e*\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001d\u0010!\u001a\u00020\u0015*\u00020\u00152\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b!\u0010\"\u001a\u001b\u0010$\u001a\u00020\u001e*\u00020\u001c2\u0006\u0010#\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006&"}, d2={"", "value", "", "key", "output", "Lgg/skytils/ktx-serialization/json/internal/JsonDecodingException;", "InvalidFloatingPointDecoded", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Lgg/skytils/ktx-serialization/json/internal/JsonDecodingException;", "Lgg/skytils/ktx-serialization/json/internal/JsonEncodingException;", "InvalidFloatingPointEncoded", "(Ljava/lang/Number;Ljava/lang/String;)Lgg/skytils/ktx-serialization/json/internal/JsonEncodingException;", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Lgg/skytils/ktx-serialization/json/internal/JsonEncodingException;", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "keyDescriptor", "InvalidKeyKindException", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)Lgg/skytils/ktx-serialization/json/internal/JsonEncodingException;", "", "offset", "message", "JsonDecodingException", "(ILjava/lang/String;)Lgg/skytils/ktx-serialization/json/internal/JsonDecodingException;", "", "input", "(ILjava/lang/String;Ljava/lang/CharSequence;)Lgg/skytils/ktx-serialization/json/internal/JsonDecodingException;", "UnknownKeyException", "(Ljava/lang/String;Ljava/lang/String;)Lgg/skytils/ktx-serialization/json/internal/JsonDecodingException;", "unexpectedFpErrorMessage", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lgg/skytils/ktx-serialization/json/internal/AbstractJsonLexer;", "entity", "", "invalidTrailingComma", "(Lgg/skytils/ktx-serialization/json/internal/AbstractJsonLexer;Ljava/lang/String;)Ljava/lang/Void;", "minify", "(Ljava/lang/CharSequence;I)Ljava/lang/CharSequence;", "result", "throwInvalidFloatingPointDecoded", "(Lgg/skytils/ktx-serialization/json/internal/AbstractJsonLexer;Ljava/lang/Number;)Ljava/lang/Void;", "kotlinx-serialization-json"})
public final class JsonExceptionsKt {
    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return new JsonDecodingException(offset >= 0 ? "Unexpected JSON token at offset " + offset + ": " + message : message);
    }

    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message, @NotNull CharSequence input2) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(input2, "input");
        return JsonExceptionsKt.JsonDecodingException(offset, message + "\nJSON input: " + JsonExceptionsKt.minify(input2, offset));
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPointEncoded(@NotNull Number value, @NotNull String output2) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(output2, "output");
        return new JsonEncodingException("Unexpected special floating-point value " + value + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output2, 0, 1, null));
    }

    @NotNull
    public static final Void throwInvalidFloatingPointDecoded(@NotNull AbstractJsonLexer $this$throwInvalidFloatingPointDecoded, @NotNull Number result2) {
        Intrinsics.checkNotNullParameter($this$throwInvalidFloatingPointDecoded, "<this>");
        Intrinsics.checkNotNullParameter(result2, "result");
        AbstractJsonLexer.fail$default($this$throwInvalidFloatingPointDecoded, "Unexpected special floating-point value " + result2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public static final Void invalidTrailingComma(@NotNull AbstractJsonLexer $this$invalidTrailingComma, @NotNull String entity) {
        Intrinsics.checkNotNullParameter($this$invalidTrailingComma, "<this>");
        Intrinsics.checkNotNullParameter(entity, "entity");
        $this$invalidTrailingComma.fail("Trailing comma before the end of JSON " + entity, $this$invalidTrailingComma.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingCommas = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string);
    }

    @NotNull
    public static final JsonEncodingException InvalidKeyKindException(@NotNull SerialDescriptor keyDescriptor) {
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + keyDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPointEncoded(@NotNull Number value, @NotNull String key2, @NotNull String output2) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(output2, "output");
        return new JsonEncodingException(JsonExceptionsKt.unexpectedFpErrorMessage(value, key2, output2));
    }

    @NotNull
    public static final JsonDecodingException InvalidFloatingPointDecoded(@NotNull Number value, @NotNull String key2, @NotNull String output2) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(output2, "output");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(value, key2, output2));
    }

    private static final String unexpectedFpErrorMessage(Number value, String key2, String output2) {
        return "Unexpected special floating-point value " + value + " with key " + key2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output2, 0, 1, null);
    }

    @NotNull
    public static final JsonDecodingException UnknownKeyException(@NotNull String key2, @NotNull String input2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(input2, "input");
        return JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + key2 + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.\nCurrent input: " + JsonExceptionsKt.minify$default(input2, 0, 1, null));
    }

    @NotNull
    public static final CharSequence minify(@NotNull CharSequence $this$minify, int offset) {
        Intrinsics.checkNotNullParameter($this$minify, "<this>");
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset == -1) {
            int start2 = $this$minify.length() - 60;
            if (start2 <= 0) {
                return $this$minify;
            }
            CharSequence charSequence = $this$minify;
            int n = charSequence.length();
            return "....." + ((Object)charSequence.subSequence(start2, n)).toString();
        }
        int start3 = offset - 30;
        int end2 = offset + 30;
        String prefix2 = start3 <= 0 ? "" : ".....";
        String suffix = end2 >= $this$minify.length() ? "" : ".....";
        return prefix2 + ((Object)$this$minify.subSequence(RangesKt.coerceAtLeast(start3, 0), RangesKt.coerceAtMost(end2, $this$minify.length()))).toString() + suffix;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

